#ifndef __gthr_brightv_h
#define __gthr_brightv_h

#define __GTHREADS 1

typedef long __gthread_key_t;
typedef long __gthread_once_t;
typedef long __gthread_mutex_t;

extern int (*_thread_once)(long *once_block, void (*init_routine)());
extern int (*_thread_key_create)(long *keyp, void (*destructor)(void *));
extern int (*_thread_key_set)(long key, void *value);
extern int (*_thread_key_get)(long key, void **valuep);
extern int (*_thread_mutex_lock)(long *mutex);
extern int (*_thread_mutex_unlock)(long *mutex);
extern int (*_thread_mutex_init)(long *mutex);

extern void __terminate();	/* libgcc2.c */

/* #define __GTHREAD_MUTEX_INIT */
#define __GTHREAD_ONCE_INIT 0
#define __GTHREAD_MUTEX_INIT_FUNCTION __gthread_mutex_init

#if 0 /* notused */
static inline int
__gthread_active_p ()
{
}
#endif /* notused */

static inline int
__gthread_once (__gthread_once_t *once, void (*func) ())
{
  if (_thread_once == 0)
    return -1;
  if ((*_thread_once)(once, func) < 0)
    __terminate();
  return 0;
}

static inline int
__gthread_key_create (__gthread_key_t *key, void (*dtor) (void *))
{
  if (_thread_key_create == 0) 
    return -1;
  if ((*_thread_key_create)(key, dtor) < 0) 
    __terminate();
  return 0;
}

static inline int
__gthread_key_dtor (__gthread_key_t key, void *ptr)
{
  /* Just reset the key value to zero. */
  if (ptr)
    if (_thread_key_set != 0) 
      (*_thread_key_set)(key, 0);
  return 0;
}

#if 0 /* notused */
static inline int
__gthread_key_delete (__gthread_key_t key)
{
}
#endif

static inline void *
__gthread_getspecific (__gthread_key_t key)
{
  void *value;

  if ((*_thread_key_get)(key, &value) < 0) 
    value = 0;
  return value;
}

static inline int
__gthread_setspecific (__gthread_key_t key, const void *ptr)
{
  if ((*_thread_key_set)(key, (void *)ptr) < 0) 
    return -1;
  return 0;
}

static inline int
__gthread_mutex_lock (__gthread_mutex_t *mutex)
{
  if (_thread_mutex_lock != 0) 
    if ((*_thread_mutex_lock)(mutex) < 0)
      __terminate();
  return 0;
}

#if 0 /* notused */
static inline int
__gthread_mutex_trylock (__gthread_mutex_t *mutex)
{
}
#endif /* notused */

static inline int
__gthread_mutex_unlock (__gthread_mutex_t *mutex)
{
  if (_thread_mutex_unlock != 0) 
    if ((*_thread_mutex_unlock)(mutex) < 0)
      __terminate();
  return 0;
}

static inline void
__gthread_mutex_init(__gthread_mutex_t *mutex)
{
  if (_thread_mutex_init != 0) 
    if ((*_thread_mutex_init)(mutex) < 0)
      __terminate();
}

#endif /* not __gthr_brightv_h */
