/*
 *	@(#)base64.cc (libcpp1) 01-03-20
 *
 *	Base64 Ѵ
 *	(C) Copyright 2000-2001 by Personal Media Corporation
 */

#include "libcpp.h"
#include "cpp/1/misc.h"

namespace LIBCPP1 {

/* ------------------------------------------------------------------------ */
/*
 *	Base64 Ѵ
 *	class BASE64
 */

/*
 * 󥹥ȥ饯
 */
BASE64::BASE64()
{
	reset();
}

/*
 * 󥳡ɷ̾
 */
const UB* BASE64::name()
{
	return (UB*)"base64";
}

/*
 * Ķν
 */
void BASE64::reset()
{
	rem = 0;
	rempos = NULL;
	nchar = 0;
}

/*
 * ĤΥǡ true
 */
bool BASE64::remained()
{
	return rempos != NULL;
}

/*
 * ʸǥ
 */
W BASE64::decodech( UB c )
{
	if ( c >= 'A' && c <= 'Z' ) return c - 'A';
	if ( c >= 'a' && c <= 'z' ) return c - 'a' + 26;
	if ( c >= '0' && c <= '9' ) return c - '0' + 52;
	if ( c == '+' ) return 62;
	if ( c == '/' ) return 63;
	if ( c == '=' ) return 0;
	return -1;
}

/*
 * ǥ
 *	src  len ХȤǥɤơdst غ max Х
 *	ޤǳǼ롣
 *	len ХȤã '\0' ˽вä餽ѴϽ롣
 *	len < 0 ξϡlen ̵뤵롣
 *	ͤ dst سǼХȿ֤
 *	Ѵ̤ max ХȤĶ硢dst ؤ max ХȰ
 *	ŬʶڤޤѴƳǼ롣ΤȤremained() 
 *	true ֤ξϡsrc Ƥѹˡsrc, len 
 *	ƱΤꤷƺ decode() ƤӽФȤǡĤʬ
 *	ѴԤ롣
 *	src κǸѴǤʤҤĤäƤޤäϡϥ
 *	¸롣³ src ꤷƺ decode()
 *	ƤӽФȤǡ³ѴǤ롣
 *
 *	src üû(ͭʸʸ̤)ưʤ礬롣
 *	src, dst ȤĹΨ褤
 */
WERR BASE64::decode( UB *dst, W max, const UB *src, W len )
{
	UB	*dp = dst;
const	UB	*sp, *rp;
	UB	c;
	W	n, i, v;
	UW	data;

	if ( rempos != NULL ) {
		sp = rempos;
		len -= rempos - src;
	} else {
		sp = src;
	}
	rempos = NULL;

	data = 0;
	v = 3;
	for ( i = 0; i < rem; ++i ) {
		n = decodech(c = buf[i]);
		if ( c == '=' ) --v;
		data <<= 6;
		data |= n;
	}
	rem = 0;

	for ( ;; ) {
		rp = sp;
		for ( ; len != 0; --len ) {
			if ( (c = *sp++) == '\0' ) break;
			n = decodech(c);
			if ( n < 0 ) continue;
			if ( c == '=' ) --v;
			data <<= 6;
			data |= n;
			if ( ++i >= 4 ) break;
		}

		if ( i < 4 ) {
			/* ѴλޤҤĤä */
			while ( rem < i ) {
				c = *rp++;
				n = decodech(c);
				if ( n < 0 ) continue;
				buf[rem++] = c;
			}
			break;
		}

		if ( max < v ) {
			/* ϥХåե­ʤ */
			rempos = rp;
			break;
		}

		n = 16;
		while ( --v >= 0 ) {
			*dp++ = (data >> n) & 0xff;
			n -= 8;
			--max;
		}

		data = 0;
		v = 3;
		i = 0;
	}

	return dp - dst;
}

/*
 * ʬΥ󥳡
 */
void BASE64::encodech( UB* &dst, const UB *src, W n, W &max )
{
const	UB	ench[] = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
			 "abcdefghijklmnopqrstuvwxyz"
			 "0123456789+/";
	UW	data;
	W	i, shift;

	if ( nchar + 4 > MaxChar ) {
		/*  */
		if ( (max -= 2) < 0 ) return;
		*dst++ = '\r';
		*dst++ = '\n';
		nchar = 0;
	}

	if ( (max -= 4) < 0 ) return;
	data = ((UW)src[0] << 16) | ((UW)src[1] << 8) | src[2];
	shift = 24;
	for ( i = 0; i <= n; ++i ) {
		shift -= 6;
		*dst++ = ench[(data >> shift) & 0x3f];
	}
	while ( ++i <= 4 ) *dst++ = '='; // ѥǥ
	nchar += 4;
}

/*
 * 󥳡
 *	src  len ХȤ򥨥󥳡ɤơdst غ max Х
 *	ޤǳǼ롣
 *	dst ˳Ǽǡ max Х̤ǤСdst κǸ
 *	'\0' ղä롣
 *	ͤ dst سǼХȿ(Ǹ '\0' ϴޤޤʤ)֤
 *	Ѵ̤ max ХȤĶ硢dst ؤ max ХȰ
 *	ŬʶڤޤѴƳǼ롣ΤȤremained() 
 *	true ֤ξϡsrc Ƥѹˡsrc, len 
 *	ƱΤꤷƺ encode() ƤӽФȤǡĤʬ
 *	ѴԤ롣
 *	src κǸѴǤʤҤĤäƤޤäϡϥ
 *	󥳡¸롣³ src ꤷƺ encode()
 *	ƤӽФȤǡ³ѴǤ롣
 *	Ǹ len = 0 ǸƤӽФȤǡsrc νüǤ뤳Ȥ򼨤
 *	ɬפ롣ˤꡢ󥳡¸ƤҤ
 *	Ѵ롣
 *
 *	dst üûưʤ
 *	̾ϣХȰʾ塢ǸҤνϤǤϣХȰʾɬפǤ롣
 *	src, dst ȤĹΨ褤
 */
WERR BASE64::encode( UB *dst, W max, const UB *src, W len )
{
	UB	*dp  = dst;
	UB	*edp = dst + max;
const	UB	*sp;
const	UB	*esp = src + len;

	if ( rempos == NULL ) {
		sp = src;
	} else {
		sp = rempos;
		rempos = NULL;
	}

	if ( len == 0 ) {
		if ( rem > 0 ) {
			for ( W i = rem; i < 3; ++i ) buf[i] = 0;
			encodech(dp, buf, rem, max);
			if ( max < 0 ) goto skip_end;
			rem = 0;
		}
		if ( nchar > 0 ) {
			/* Ǹβ */
			if ( (max -= 2) < 0 ) goto skip_end;
			*dp++ = '\r';
			*dp++ = '\n';
			nchar = 0;
		}
		goto skip_end;
	}

	if ( rem > 0 ) {
		while ( rem < 3 ) {
			if ( sp >= esp ) goto skip_end;
			buf[rem++] = *sp++;
		}
		encodech(dp, buf, 3, max);
		if ( max >= 0 ) rem = 0;
	}

	while ( sp + 3 <= esp ) {
		encodech(dp, sp, 3, max);
		if ( max < 0 ) break;
		sp += 3;
	}
	if ( max < 0 ) {
		/* src λĤΰ֤Ͽ */
		if ( sp < esp ) rempos = sp;
	} else {
		/* Ҥ¸ */
		rem = 0;
		while ( sp < esp ) buf[rem++] = *sp++;
	}

skip_end:
	if ( dp < edp ) *dp = '\0';

	return dp - dst;
}

/* ------------------------------------------------------------------------ */
} // namespace LIBCPP1
/*
 * for Emacs users
 * Local variables:
 * c-file-style: "linux"
 * End:
 */
