/*
 *	@(#)bqueue.cc (libcpp1) 01-01-29
 *
 *	塼
 *	(C) Copyright 2000-2001 by Personal Media Corporation
 */

#include "libcpp.h"
#include "cpp/1/misc.h"

namespace LIBCPP1 {

/* ------------------------------------------------------------------------ */
/*
 *	塼ܥ饹
 *	class BQUEUE
 */

/*
 * ʬľ q ³
 */
void BQUEUE::insert( BQUEUE *q )
{
	q->prev = prev;
	q->next = this;
	prev->next = q;
	prev = q;
}

/*
 * ʬ򥭥塼ڤΥ
 *	塼ΤȤϲ⤷ʤ
 */
BQUEUE* BQUEUE::remove()
{
	prev->next = next;
	next->prev = prev;

	return this;
}

/*
 * ʬμ򥭥塼ڤΥ
 *	ڤΥ塼֤ͤ
 *	塼ΤȤ NULL ֤
 */
BQUEUE* BQUEUE::removenext()
{
	BQUEUE	*q;

	if ( isempty() ) return NULL;

	q = next;
	next = q->next;
	next->prev = this;

	return q;
}

/* ------------------------------------------------------------------------ */
} // namespace LIBCPP1
