/*
 *	@(#)bstr.cc (libcpp1) 01-01-29
 *
 *	Хʸ
 *	(C) Copyright 2000-2001 by Personal Media Corporation
 */

#include "libcpp.h"
#include "cpp/1/misc.h"

namespace LIBCPP1 {

/* ------------------------------------------------------------------------- */
/*
 *	class BSTR
 *	Хʸ
 */

/*
 * 󥹥ȥ饯
 */
BSTR::BSTR()
{
	next = NULL;
}

/*
 * ǥȥ饯
 *	³(BSTR)ޤƽü(next == NULL)ޤǤ٤ƺ롣
 *	˹Ԥä硢Ԥ next ѹʤա
 */
BSTR::~BSTR()
{
	BSTR	*p, *np;

	/* ñ delete next ȤȺƵƽФˤʤäƤޤ
	   Ƶ򤱤ƺԤ*/
	np = next;
	while ( np != NULL ) {
		p = np;
		np = p->next;
		p->next = NULL;
		delete p;
	}
}

/*
 * ʸǡν񤭹
 *	MemIO θߤΰ֤ buf  size ХȽ񤭹ࡣ
 *	񤭹Хȿ֤ͤ
 *	MemIO θ֤߰Ͻ񤭹ʬʤ롣
 *	Хåեγĥɬפʾˤϡü '\0' ʬ
 *	äƳĥ졢ü '\0' ɲä롣
 */
WERR BSTR::write( const void *buf, W size )
{
	W	sz;
	ERR	err;

	/* 񤭹ߤɬפʥХåե */
	sz = curpos + size + 1;

	if ( sz > cursize ) {
		/* Хåեĥ */
		err = resizebuf(sz);
		if ( err < ER_OK ) goto err_ret;

		/* ü '\0' ɲ */
		membuf[sz - 1] = '\0';
	}

	/* ʸǡν񤭹 */
	err = MemIO::write(buf, size);
	if ( err < ER_OK ) goto err_ret;

	return size;

err_ret:
	DEBUG_PRINT(("BSTR::write err = %d\n", err));
	return err;
}

/*
 * ʸɲ
 *	ʸθ buf ɲä롣
 *	'\0' ޤǤ len ʸ(Х)ޤǤΤ줫ãȤ
 *	ޤǤɲä롣len < 0 ξ len ̵뤵롣
 *	MemIO θ֤߰Ȥϴطʤʸüɲä롣
 *	MemIO θ֤߰Ѳʤ
 */
ERR BSTR::put( const UB *buf, W len )
{
const	UB	*ep;
	W	pos;
	ERR	err;

	/* buf νü */
	for ( ep = buf; len-- != 0 && *ep != '\0'; ++ep );
	len = ep - buf;

	/* ߤνü */
	pos = length();

	/* Хåեĥ */
	err = resizebuf(pos + len + 1);
	if ( err < ER_OK ) goto err_ret;

	/* ʸ񤭹 */
	memcpy(membuf + pos, buf, len);
	membuf[pos + len] = '\0';

	return ER_OK;

err_ret:
	DEBUG_PRINT(("BSTR::put err = %d\n", err));
	return err;
}

/*
 * Ԥ
 *	Ԥμˣ롣
 *	Ԥ new ˤ롣
 *	ͤԤ֤
 *	ǤʤäȤ NULL ֤
 */
BSTR* BSTR::insline()
{
	BSTR	*s;

	/* Ԥ */
	s = new(nothrow) BSTR;
	if ( s == NULL ) goto err_ret;

	/* Ԥ */
	s->next = next;
	next = s;

	return s;

err_ret:
	DEBUG_PRINT(("BSTR::insline err = %d\n", ER_NOMEM));
	return NULL;
}

/* ------------------------------------------------------------------------- */
} // namespace LIBCPP1
