/*
 *	@(#)chcnv.cc (libcpp1) 01-10-30
 *
 *	ʸѴ
 *	(C) Copyright 2000-2001 by Personal Media Corporation
 */

#include "libcpp.h"
#include "cpp/1/misc.h"

namespace LIBCPP1 {

/* ------------------------------------------------------------------------ */
/*
 *	ʸѴ
 * 	class CHCNV
 */

/*
 * 󥹥ȥ饯
 */
CHCNV::CHCNV()
{
	name = NULL;
	ctxinit = false;
}

/*
 * ǥȥ饯
 */
CHCNV::~CHCNV()
{
	close();
	delete[] name;
}

/*
 * ĶΥץ
 */
ERR CHCNV::open()
{
	ERR	err;

	err = tf_open_ctx(&ctx);
	if ( err < ER_OK ) goto err_ret;

	attr = TF_ATTR_START;
	ctxinit = true;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("CHCNV::open err = %d\n", err));
	return err;
}

/*
 * ĶΥ
 */
ERR CHCNV::close()
{
	ERR	err;

	if ( ctxinit ) {
		err = tf_close_ctx(ctx);
		if ( err < ER_OK ) goto err_ret;
		ctxinit = false;
	}

	return ER_OK;

err_ret:
	DEBUG_PRINT(("CHCNV::close err = %d\n", err));
	return err;
}

/*
 * ĶΥץʸåȡѴ
 */
ERR CHCNV::open( const UB *keyword, bool toext )
{
	ERR	err;

	err = open();
	if ( err < ER_OK ) goto err_ret;

	err = charset(keyword, toext);
	if ( err < ER_OK ) goto err_ret;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("CHCNV::open(keyword) err = %d\n", err));
	return err;
}

/*
 * ĶΥץʸåȡѴ
 * (󥳡ǥդ)
 */
ERR CHCNV::open( const UB *chset, const UB *coder, bool toext )
{
	ERR	err;

	err = open();
	if ( err < ER_OK ) goto err_ret;

	err = charset(chset, coder, toext);
	if ( err < ER_OK ) goto err_ret;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("CHCNV::open(chset, coder) err = %d\n", err));
	return err;
}

/*
 * ƥȥ⡼ɤ
 */
void CHCNV::testmode( bool on )
{
	tf_set_options(ctx, tf_to_id(0, "DEBUG_LIBCALL_DUMP"), ( on )? 5: 0);
}

/*
 * ʸåȤѴ
 *	keyword ˤϡTF_ID_PROFSET_CONVERTFROM ޤ
 *	TF_ID_PROFSET_CONVERTTO °륭ɤꤹ뤳ȡ
 */
ERR CHCNV::charset( const UB *keyword, bool toext )
{
	W	type, id, len;
	ERR	err;

	this->toext = toext;

	type = ( toext )? TF_ID_PROFSET_CONVERTTO:
			  TF_ID_PROFSET_CONVERTFROM;

	/* ʸå̾¸ */
	delete[] name;
	len = strlen((char*)keyword);
	name = new(nothrow) UB[len+1];
	if ( name == NULL ) { err = ER_NOMEM; goto err_ret; }
	strcpy((char*)name, (char*)keyword);

	/* TRON code framework νĶ */
	id = tf_to_id(type, (B*)keyword);
	if ( id < ER_OK ) { err = id; goto err_ret; }
	err = tf_set_profile(ctx, id);
	if ( err < ER_OK ) goto err_ret;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("CHCNV::charset(keyword) err = %d\n", err));
	return err;
}

/*
 * ʸåȤѴ
 *	 collect() ˤʸåȽƤɬפ롣
 *	charsetid ǼʸɽǽǤСʸåȤ
 *	ꤵ롣
 *	charsetid ˤϡTF_ID_CHARSET, TF_ID_SETOFCHARSET ° ID
 *	ꤹ뤳ȡ
 *	ͤˡꤵ줿ʸåȤ ID (TF_ID_CHARSET °)
 *	֤ɽǽʸåȤʤ 0 ֤
 */
WERR CHCNV::charset( W charsetid, bool toext )
{
	W	id;
	ERR	err;

	/* ʸåȽ */
	id = tf_query_charset(ctx, charsetid);
	if ( id < ER_OK ) { err = id; goto err_ret; }

	if ( id > 0 ) {
		/* ʸåȤ */
		err = charset((UB*)tf_id_to_str(id), toext);
		if ( err < ER_OK ) goto err_ret;
	}

	return id;

err_ret:
	DEBUG_PRINT(("CHCNV::charset(id) err = %d\n", err));
	return err;
}

/*
 * ʸåȤѴ(󥳡ǥդ)
 *	ƥѥ᡼ϡ ID ̤°륭ɤꤹ롣
 *	chset	TF_ID_CHARSET_CONVERTFROM ޤ
 *		TF_ID_CHARSET_CONVERTTO
 *	coder	TF_ID_DECODER_CONVERTFROM ޤ
 *		TF_ID_ENCODER_CONVERTTO
 *	ʸå̾(name)ˤ chset ¸롣
 *	MIME ξ硢name  "MIME_HEADER" Ȥʤʤա
 */
ERR CHCNV::charset( const UB *chset, const UB *coder, bool toext )
{
	W	type, id, len;
	ERR	err;

	this->toext = toext;

	/* 󥳡ǥλ */
	if ( coder ) {
		type = ( toext )? TF_ID_ENCODER_CONVERTTO:
				  TF_ID_DECODER_CONVERTFROM;

		/* TRON code framework νĶ */
		id = tf_to_id(type, (B*)coder);
		if ( id < ER_OK ) { err = id; goto err_ret; }
		err = tf_set_profile(ctx, id);
		if ( err < ER_OK ) goto err_ret;
	}

	/* ʸåȤλ */
	if ( chset ) {
		type = ( toext )? TF_ID_CHARSET_CONVERTTO:
				  TF_ID_CHARSET_CONVERTFROM;

		/* ʸå̾¸ */
		delete[] name;
		len = strlen((char*)chset);
		name = new(nothrow) UB[len+1];
		if ( name == NULL ) { err = ER_NOMEM; goto err_ret; }
		strcpy((char*)name, (char*)chset);

		/* TRON code framework νĶ */
		id = tf_to_id(type, (B*)chset);
		if ( id < ER_OK ) { err = id; goto err_ret; }
		err = tf_set_profile(ctx, id);
		if ( err < ER_OK ) goto err_ret;
	}

	return ER_OK;

err_ret:
	DEBUG_PRINT(("CHCNV::charset(chset, coder) err = %d\n", err));
	return err;
}

/*
 * ʸåȤѴ(󥳡ǥդ)
 *	 collect() ˤʸåȽƤɬפ롣
 *	charsetid ǼʸɽǽǤСʸåȤ
 *	ꤵ롣
 *	charsetid ˤϡTF_ID_CHARSET, TF_ID_SETOFCHARSET ° ID
 *	ꤹ뤳ȡ
 *	ͤˡꤵ줿ʸåȤ ID (TF_ID_CHARSET °)
 *	֤ɽǽʸåȤʤ 0 ֤
 *	coder ˤϡTF_ID_DECODER_CONVERTFROM ޤ
 *	TF_ID_ENCODER_CONVERTTO  ID ̤°륭ɤꤹ
 *	롣
 */
WERR CHCNV::charset( W charsetid, const UB *coder, bool toext )
{
	W	id;
	ERR	err;

	/* ʸåȽ */
	id = tf_query_charset(ctx, charsetid);
	if ( id < ER_OK ) { err = id; goto err_ret; }

	if ( id > 0 ) {
		/* ʸåȤ */
		err = charset((UB*)tf_id_to_str(id), coder, toext);
		if ( err < ER_OK ) goto err_ret;
	}

	return id;

err_ret:
	DEBUG_PRINT(("CHCNV::charset(id, coder) err = %d\n", err));
	return err;
}

/*
 * ꤵƤʸåȤΥץѥƥμ
 *	keyword ˤϡTF_ID_PROPERTY °륭ɤꤹ롣
 *	val ηϡץѥƥμऴȤ TRON Code Framework
 *	ˤ롣
 */
ERR CHCNV::getproperty( const UB *keyword, VP val )
{
	W	oid, pid;
	ERR	err;

	oid = tf_to_id(TF_ID_CHARSET, (B*)getcharset());
	if ( oid < ER_OK ) { err = oid; goto err_ret; }

	pid = tf_to_id(TF_ID_PROPERTY, (B*)keyword);
	if ( pid < ER_OK ) { err = pid; goto err_ret; }

	err = tf_id_property(oid, pid, val);
	if ( err < ER_OK ) goto err_ret;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("CHCNV::getproperty err = %d\n", err));
	return err;
}

/*
 * ꤵƤʸåȤΥ󥳡ǥμ
 *		0: 7bit
 *		1: quoted-printable
 *		2: base64
 */
WERR CHCNV::getencoding()
{
	W	val;
	ERR	err;

	err = getproperty((UB*)"MIME_TRANSFER_ENCODING", &val);
	if ( err < ER_OK ) goto err_ret;

	return val;

err_ret:
	DEBUG_PRINT(("CHCNV::getencoding err = %d\n", err));
	return err;
}

/*
 * ץ
 *	keyword ˤϡTF_ID_OPT_CONVERT °륭ɤꤹ롣
 *	val ͤϡꤹ륪ץμऴȤ TRON Code Framework
 *	ˤ롣̤Ȥ -1 ǥǥեȤʤ롣
 */
ERR CHCNV::setoption( const UB *keyword, W val )
{
	W	id;
	ERR	err;

	id = tf_to_id(TF_ID_OPT_CONVERT, (B*)keyword);
	if ( id < ER_OK ) { err = id; goto err_ret; }

	err = tf_set_options(ctx, id, val);
	if ( err < ER_OK ) goto err_ret;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("CHCNV::setoption err = %d\n", err));
	return err;
}

/*
 * 䵤̵ͭ
 */
void CHCNV::skipfusen( bool skip )
{
	UW	flg;

	flg = ( toext )? TF_ATTR_IGNORE_FUSEN:
			 TF_ATTR_SUPPRESS_FUSEN;

	if ( skip ) attr |= flg;
	else        attr &= ~flg;
}

/*
 * ѴΥꥻå
 */
void CHCNV::reset()
{
	attr |= TF_ATTR_START;
}

/* ------------------------------------------------------------------------ */
} // namespace LIBCPP1
/*
 * for Emacs users
 * Local variables:
 * c-file-style: "linux"
 * End:
 */
