/*
 *	@(#)chcnv2.cc (libcpp1) 01-03-15
 *
 *	ʸѴ
 *	(C) Copyright 2000-2001 by Personal Media Corporation
 */

#include "libcpp.h"
#include "cpp/1/misc.h"

namespace LIBCPP1 {

/* ------------------------------------------------------------------------ */
/*
 *	ʸѴ
 * 	class CHCNV
 */

/*
 * ʸåȽμ
 *	src  len ʸ(TC)ʸ롣
 *	src Ƭθ lang ˻ꤹ롣
 *	lang = 0 λϡθƽФκǸθƱǤΤȤ롣
 *	θƽл TSC_SYS ǤΤȤ롣
 *	len ʸã TNULL ˽вä餽ǼϽ롣
 *	len < 0 ξϡlen ̵뤵롣
 *	cont = true λ src ˤޤ³ǡ뤳Ȥ򼨤
 */
ERR CHCNV::collect( const TC *src, W lang, W len, bool cont )
{
	UW	a;
	ERR	err;

	if ( (attr & TF_ATTR_START) != 0 ) {
		/* ʸåȽν */
		err = tf_init_charset(ctx);
		if ( err < ER_OK ) goto err_ret;
	}

	if ( lang == 0 && (attr & TF_ATTR_START) != 0 ) lang = TSC_SYS;

	if ( cont ) {
		a = attr | TF_ATTR_CONT;
		attr &= ~TF_ATTR_START;
	} else {
		a = attr;
		attr |= TF_ATTR_START;
	}

	/* ʸμ */
	err = tf_aggregate_charset_tcs(ctx, src, len, lang, a);
	if ( err < ER_OK ) goto err_ret;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("CHCNV::collect(TC) err = %d\n", err));
	return err;
}

/*
 * ʸåȽμ
 *	src ʸ򤹤٤Ƽ롣
 *	src μΥǡ̵뤵롣
 *	ʸϡ޷ǡ(TNEST)
 *	(TVOBJ)
 *	ʸɤȿǤǤʤ(TSEG)
 *	  ŪˤϡȾѡѤ䵰ʳϤ٤̵뤵롣
 *	cont = true λ src ˤޤ³ǡ뤳Ȥ򼨤
 */
ERR CHCNV::collect( TSTR &src, bool cont )
{
	TSTRP		p(src);
	W		c, lang, len;
	const TC	*s;
	TSEG		seg;
	LTADSEG		seghd;
	ERR		err;

	while ( (c = *p) != TNULL ) {
		switch ( TSTR::ttype(c) ) {
		  case TSTR::TChar:
			len = p.get(s, lang);
			p += len;
			err = collect(s, lang, len, cont || *p != TNULL);
			if ( err < ER_OK ) goto err_ret;
			break;

		  case TSTR::TSeg:
			p.get(seg);
			++p;
			seghd.id = seg.id;
			if ( seg.length() < 0xffff ) {
				seghd.len = seg.length();
				len = sizeof(TADSEG) / sizeof(TC);
			} else {
				seghd.len = 0xffff;
				seghd.llen = seg.length();
				len = sizeof(LTADSEG) / sizeof(TC);
			}
			err = collect((TC*)&seghd, 0, len, true);
			if ( err < ER_OK ) goto err_ret;
			err = collect((TC*)seg->body, 0, seg->len / sizeof(TC),
						cont || *p != TNULL);
			if ( err < ER_OK ) goto err_ret;
			break;

		  case TSTR::TNest:
		  case TSTR::TVobj:
			/* ɤФ */
			++p;
			break;
		}
	}

	return ER_OK;

err_ret:
	reset();
	DEBUG_PRINT(("CHCNV::collect(TSTR) err = %d\n", err));
	return err;
}

/* ------------------------------------------------------------------------ */
} // namespace LIBCPP1
/*
 * for Emacs users
 * Local variables:
 * c-file-style: "linux"
 * End:
 */
