/*
 *	@(#)chcnv3.cc (libcpp1) 01-03-15
 *
 *	ʸѴ
 *	(C) Copyright 2000-2001 by Personal Media Corporation
 */

#include "libcpp.h"
#include "cpp/1/misc.h"

namespace LIBCPP1 {

/* ------------------------------------------------------------------------ */
/*
 *	ʸѴ
 * 	class CHCNV
 */

/*
 * ʸ src  TC Ѵ
 *	src  len ХȤѴ dst 롣
 *	len ХȤã '\0' ˽вä餽ѴϽ롣
 *	len < 0 ξϡlen ̵뤵롣
 *	cont = true λ src ˤޤ³ǡ뤳Ȥ򼨤
 */
ERR CHCNV::totc( TADP &dst, const UB *src, W len, bool cont )
{
	TC	buf[BUFLEN];
	UW	a;
	W	dlen, lang, next;
	ERR	err;

	lang = ( (attr & TF_ATTR_START) != 0 )? TSC_SYS: 0;
	if ( cont ) {
		a = attr | TF_ATTR_CONT;
		attr &= ~TF_ATTR_START;
	} else {
		a = attr;
		attr |= TF_ATTR_START;
	}

	do {
		/* ʸѴ */
		dlen = BUFLEN;
		next = tf_strtotcs(ctx, src, len, a, buf, &dlen);
		if ( next < ER_OK ) { err = next; goto err_ret; }

		/* Ѵ̤ TSTR ؽ񤭹 */
		err = dst.instadstr(buf, lang, dlen);
		if ( err < ER_OK ) goto err_ret;

		a &= ~TF_ATTR_START;
		src = NULL;
		lang = 0;

	} while ( next > 0 );

	return ER_OK;

err_ret:
	DEBUG_PRINT(("CHCNV::totc(TADP) err = %d\n", err));
	return err;
}

/*
 * ʸ src  TC Ѵ
 *	src  len ХȤѴ dst 롣
 *	len ХȤã '\0' ˽вä餽ѴϽ롣
 *	len < 0 ξϡlen ̵뤵롣
 *	cont = true λ src ˤޤ³ǡ뤳Ȥ򼨤
 */
ERR CHCNV::totc( TSTRP &dst, const UB *src, W len, bool cont )
{
	TC	buf[BUFLEN];
	UW	a;
	W	dlen, lang, next;
	ERR	err;

	lang = ( (attr & TF_ATTR_START) != 0 )? TSC_SYS: 0;
	if ( cont ) {
		a = attr | TF_ATTR_CONT;
		attr &= ~TF_ATTR_START;
	} else {
		a = attr;
		attr |= TF_ATTR_START;
	}

	do {
		/* ʸѴ */
		dlen = BUFLEN;
		next = tf_strtotcs(ctx, src, len, a, buf, &dlen);
		if ( next < ER_OK ) { err = next; goto err_ret; }

		/* Ѵ̤ TSTR ؽ񤭹 */
		err = dst.instadstr(buf, lang, dlen);
		if ( err < ER_OK ) goto err_ret;

		a &= ~TF_ATTR_START;
		src = NULL;
		lang = 0;

	} while ( next > 0 );

	return ER_OK;

err_ret:
	DEBUG_PRINT(("CHCNV::totc(TSTRP) err = %d\n", err));
	return err;
}

/*
 * ʸ src  TC Ѵ
 *	src  len ХȤѴѴ̤򥻥Ȥޤ
 *	TC  dst ˺ max ʸ(TC)ޤǳǼ롣
 *	ѴĹ max ̤ǤСǸ TNULL ղä롣
 *	len ХȤã '\0' ˽вä餽ѴϽ롣
 *	len < 0 ξϡlen ̵뤵롣
 *	dst ˳ǼĹ(TC)֤ͤTNULL ʬϴޤޤʤ
 *	cont = true λ src ˤޤ³ǡ뤳Ȥ򼨤
 */
WERR CHCNV::totc( TC *dst, W max, const UB *src, W len, bool cont )
{
	UW	a;
	W	dlen;
	ERR	err;

	if ( cont ) {
		a = attr | TF_ATTR_CONT;
		attr &= ~TF_ATTR_START;
	} else {
		a = attr;
		attr |= TF_ATTR_START;
	}

	dlen = max;
	err = tf_strtotcs(ctx, src, len, a, dst, &dlen);
	if ( err < ER_OK ) goto err_ret;

	return dlen;

err_ret:
	DEBUG_PRINT(("CHCNV::totc(TC) err = %d\n", err));
	return err;
}

/* ------------------------------------------------------------------------ */
} // namespace LIBCPP1
/*
 * for Emacs users
 * Local variables:
 * c-file-style: "linux"
 * End:
 */
