/*
 *	@(#)chcnv4.cc (libcpp1) 01-03-15
 *
 *	ʸѴ
 *	(C) Copyright 2000-2001 by Personal Media Corporation
 */

#include "libcpp.h"
#include "cpp/1/misc.h"

namespace LIBCPP1 {

/* ------------------------------------------------------------------------ */
/*
 *	ʸѴ
 * 	class CHCNV
 */

/*
 * TC 鳰ʸɤѴ
 *	src  len ʸ(TC)Ѵdst ؽ񤭽Ф
 *	src Ƭθ lang ˻ꤹ롣
 *	lang = 0 λϡθƽФκǸθƱǤΤȤ롣
 *	θƽл TSC_SYS ǤΤȤ롣
 *	len ʸã TNULL ˽вä餽ѴϽ롣
 *	len < 0 ξϡlen ̵뤵롣
 *	src ˤϡʸꡦȤʤ TAD 򤹤٤ƴޤ뤳
 *	Ǥ뤬β TRON code framework ˰¸Ƥ롣
 *	cont = true λ src ˤޤ³ǡ뤳Ȥ򼨤
 */
ERR CHCNV::toch( BIO &dst, const TC *src, W lang, W len, bool cont )
{
	UB	buf[BUFLEN];
	UW	a;
	W	dlen, next;
	ERR	err;

	if ( lang == 0 && (attr & TF_ATTR_START) != 0 ) lang = TSC_SYS;

	if ( cont ) {
		a = attr | TF_ATTR_CONT;
		attr &= ~TF_ATTR_START;
	} else {
		a = attr;
		attr |= TF_ATTR_START;
	}

	do {
		/* ʸѴ */
		dlen = BUFLEN;
		next = tf_tcstostr(ctx, src, len, lang, a, buf, &dlen);
		if ( next < ER_OK ) { err = next; goto err_ret; }

		/* Ѵ̤񤭹 */
		err = dst.write(buf, dlen);
		if ( err < ER_OK ) goto err_ret;

		a &= ~TF_ATTR_START;
		src = NULL;
		lang = 0;

	} while ( next > 0 );

	return ER_OK;

err_ret:
	DEBUG_PRINT(("CHCNV::toch(BIO, TC) err = %d\n", err));
	return err;
}

/*
 * TC 鳰ʸɤѴ
 *	src 򤹤٤Ѵdst ؽ񤭽Ф
 *	src μΥǡ̵뤵롣
 *	ʸϡ޷ǡ(TNEST)
 *	(TVOBJ)
 *	ʸɤȿǤǤʤ(TSEG)
 *	  ŪˤϡȾѡѤ䵰ʳϤ٤̵뤵롣
 *	cont = true λ src ˤޤ³ǡ뤳Ȥ򼨤
 */
ERR CHCNV::toch( BIO &dst, TSTR &src, bool cont )
{
	TSTRP		p(src);
	W		c, lang, len;
	const TC	*s;
	TSEG		seg;
	LTADSEG		seghd;
	ERR		err;

	while ( (c = *p) != TNULL ) {
		switch ( TSTR::ttype(c) ) {
		  case TSTR::TChar:
			len = p.get(s, lang);
			p += len;

			/* ѴȽ */
			err = toch(dst, s, lang, len, cont || *p != TNULL);
			if ( err < ER_OK ) goto err_ret;
			break;

		  case TSTR::TSeg:
			p.get(seg);
			++p;
			seghd.id = seg.id;
			if ( seg.length() < 0xffff ) {
				seghd.len = seg.length();
				len = sizeof(TADSEG) / sizeof(TC);
			} else {
				seghd.len = 0xffff;
				seghd.llen = seg.length();
				len = sizeof(LTADSEG) / sizeof(TC);
			}

			/* ѴȽ */
			err = toch(dst, (TC*)&seghd, 0, len, true);
			if ( err < ER_OK ) goto err_ret;
			err = toch(dst, (TC*)seg->body, 0, seg->len / sizeof(TC),
						cont || *p != TNULL);
			if ( err < ER_OK ) goto err_ret;
			break;

		  case TSTR::TNest:
		  case TSTR::TVobj:
			/* ɤФ */
			++p;
			break;
		}
	}

	return ER_OK;

err_ret:
	DEBUG_PRINT(("CHCNV::toch(BIO, TSTR) err = %d\n", err));
	return err;
}

/*
 * TC 鳰ʸɤѴ
 *	src 򤹤٤Ѵdst θɲä롣
 *	src μΥǡ̵뤵롣
 *	ʸϡ޷ǡ(TNEST)
 *	(TVOBJ)
 *	ʸɤȿǤǤʤ(TSEG)
 *	  ŪˤϡȾѡѤ䵰ʳϤ٤̵뤵롣
 *	cont = true λ src ˤޤ³ǡ뤳Ȥ򼨤
 */
ERR CHCNV::toch( BSTR &dst, TSTR &src, bool cont )
{
	ERR	err;

	/* dst θ֤߰ü('\0'ΰ)˰ư */
	err = dst.seek(dst.length(), BSTR::SeekSet);
	if ( err < ER_OK ) goto err_ret;

	/* Ѵ */
	err = toch((BIO&)dst, src, cont);
	if ( err < ER_OK ) goto err_ret;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("CHCNV::totc(BSTR, TSTR) err = %d\n", err));
	return err;
}

/* ------------------------------------------------------------------------ */
} // namespace LIBCPP1
/*
 * for Emacs users
 * Local variables:
 * c-file-style: "linux"
 * End:
 */
