/*
 *	@(#)chcnv5.cc (libcpp1) 01-04-04
 *
 *	ʸѴ
 *	(C) Copyright 2000-2001 by Personal Media Corporation
 */

#include "libcpp.h"
#include "cpp/1/misc.h"

namespace LIBCPP1 {

/* ------------------------------------------------------------------------ */
/*
 *	ʸѴ
 * 	class CHCNV
 */

/*
 * ʸɤ EXTC Ѵ
 *	src  len ХȤѴ dst ؽ񤭽Ф
 *	len ХȤã '\0' ˽вä餽ѴϽ롣
 *	len < 0 ξϡlen ̵뤵롣
 *	cont = true λ src ˤޤ³ǡ뤳Ȥ򼨤
 */
ERR CHCNV::toextc( BIO &dst, const UB *src, W len, bool cont )
{
	UB	buf[BUFLEN];
	UW	a;
	W	dlen, next;
	ERR	err;

	if ( cont ) {
		a = attr | TF_ATTR_CONT;
		attr &= ~TF_ATTR_START;
	} else {
		a = attr;
		attr |= TF_ATTR_START;
	}

	do {
		/* ʸѴ */
		dlen = BUFLEN;
		next = tf_strtostr(ctx, src, len, a, buf, &dlen);
		if ( next < ER_OK ) { err = next; goto err_ret; }

		/* Ѵ̤񤭹 */
		err = dst.write(buf, dlen);
		if ( err < ER_OK ) goto err_ret;

		a &= ~TF_ATTR_START;
		src = NULL;

	} while ( next > 0 );

	return ER_OK;

err_ret:
	DEBUG_PRINT(("CHCNV::toextc(BIO) err = %d\n", err));
	return err;
}

/*
 * ʸɤ EXTC Ѵ
 *	src  len ХȤѴ dst θɲä롣
 *	len ХȤã '\0' ˽вä餽ѴϽ롣
 *	len < 0 ξϡlen ̵뤵롣
 *	cont = true λ src ˤޤ³ǡ뤳Ȥ򼨤
 */
ERR CHCNV::toextc( BSTR &dst, const UB *src, W len, bool cont )
{
	ERR	err;

	/* dst θ֤߰ü('\0'ΰ)˰ư */
	err = dst.seek(dst.length(), BSTR::SeekSet);
	if ( err < ER_OK ) goto err_ret;

	/* Ѵ */
	err = toextc((BIO&)dst, src, len, cont);
	if ( err < ER_OK ) goto err_ret;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("CHCNV::toextc(BSTR) err = %d\n", err));
	return err;
}

/* ------------------------------------------------------------------------ */
} // namespace LIBCPP1
/*
 * for Emacs users
 * Local variables:
 * c-file-style: "linux"
 * End:
 */
