/*
 *	@(#)coord.cc (libcpp1) 01-01-29
 *
 *	ɸñѴʤ
 *	(C) Copyright 2000-2001 by Personal Media Corporation
 */

#include "libcpp.h"
#include "cpp/1/tadview.h"

namespace LIBCPP1 {

/* ------------------------------------------------------------------------- */
/*
 *	class COORDUNIT
 *	ɸñ
 */

/*
 * 󥹥ȥ饯
 */
COORDUNIT::COORDUNIT()
{
	v.x = RESOLUTION;
	v.y = RESOLUTION;
}

/*
 * 
 */
void COORDUNIT::set( UNITS h_unit, UNITS v_unit )
{
	if ( h_unit != 0 ) v.x = h_unit;
	if ( v_unit != 0 ) v.y = v_unit;
}

/*
 * ̤Υɥåñ̤ؤѴ(H)
 */
H COORDUNIT::todot_h( H &x )
{
	return x = ( v.x > 0 )? (W)x * DPC / v.x: (W)x * DPI / -v.x;
}
H COORDUNIT::todot_v( H &y )
{
	return y = ( v.y > 0 )? (W)y * DPC / v.y: (W)y * DPI / -v.y;
}

/*
 * ̤Υɥåñ̤ؤѴ(PNT)
 */
PNT& COORDUNIT::todot( PNT &p )
{
	todot_h(p.x);
	todot_v(p.y);
	return p;
}

/*
 * ̤Υɥåñ̤ؤѴ(RECT)
 */
RECT& COORDUNIT::todot( RECT &r )
{
	todot(r.p.lefttop);
	todot(r.p.rightbot);
	return r;
}

/* ------------------------------------------------------------------------- */

/*
 * CHSIZE Ѵ
 */
EXPORT H chsize( COORDUNIT &unit, CHSIZE chsz )
{
	H	sz = chsz & 0x3fff;

	switch ( chsz & 0xc000 ) {
	  case 0x0000:	// unit ñ
		sz = unit.todot_v(sz);
		break;

	  case 0x4000:	// 1/20(1/80mm)ñ
		sz = (W)sz * COORDUNIT::DPC / 800;
		break;

	  case 0x8000:	// 1/20ݥ(1/1440inch)ñ
		sz = (W)sz * COORDUNIT::DPI / 1440;
		break;

	  default:	// ͽ
		sz = sz;
	}

	return sz;
}

/* ------------------------------------------------------------------------- */
} // namespace LIBCPP1
