/*
 *	@(#)drawstr.cc (libcpp1) 01-04-26
 *
 *	TAD ʸ
 *	(C) Copyright 2000-2001 by Personal Media Corporation
 */

#include "libcpp.h"
#include "cpp/1/misc.h"

namespace LIBCPP1 {

/* ------------------------------------------------------------------------- */
/*
 *	class DRAWSTR
 *	TAD ʸ
 */

/*
 * 
 *	bgpat		طʿ
 *	layoutsize	쥤ѻ極
 */
ERR DRAWSTR::init( PAT *bgpat, SIZE &layoutsize )
{
	ERR	err;

	/* 쥤ȴĶν */
	lenv.type  = TAD_TEXT;
	lenv.paper = layoutsize;
	lenv.bgpat = bgpat;

	/* 쥤°ν */
	switch ( mode ) {
	  case Win:	err = latr.setdefault_win(lenv);	break;
	  case Pnl:	err = latr.setdefault_pnl(lenv);	break;
	  default:	err = latr.setdefault(lenv);
	}
	if ( err < ER_OK ) goto err_ret;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("DRAWSTR::init err = %d\n", err));
	return err;
}

/*
 * 
 *	bgpat		طʿ
 *	쥤ѻ極Ϻ(0x7fff x 0x7fff)ꤵ롣
 *	ξ硢֤ϻѤǤʤ
 */
ERR DRAWSTR::init( PAT *bgpat )
{
static	SIZE	layoutsize = { 0x7fff, 0x7fff };

	return init(bgpat, layoutsize);
}

/*
 * ѥͥʸ
 *	gid	оݤĶID
 *	r	ΰ
 *	tstr	ʸ
 */
ERR DRAWSTR::draw( W gid, RECT &r, LTSTR &tstr )
{
	LOSTR	lostr(&tstr, &lenv);
	LATR	atr = latr;
	LVIEW	vi;
	CLPNT	org(0, 0);
	ERR	err;

	/* 쥤 */
	err = lostr.layout(gid, atr);
	if ( err < ER_OK ) goto err_ret;

	vi.viewport = r;
	vi.window.pos(org, r);
	vi.gid = gid;
	org.y -= atr.finfo.height - atr.finfo.base + 1;
	lostr.setorg(org);

	/*  */
	err = lostr.draw(vi, r);
	if ( err < ER_OK ) goto err_ret;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("DRAWSTR::draw err = %d\n", err));
	return err;
}

/* ------------------------------------------------------------------------- */
} // namespace LIBCPP1
