/*
 *	@(#)errpanel.cc (libcpp1) 01-04-26
 *
 *	顼ѥͥ
 *	(C) Copyright 2000-2001 by Personal Media Corporation
 */

#include "libcpp.h"
#include "cpp/1/misc.h"

namespace LIBCPP1 {

/* ------------------------------------------------------------------------- */
/*
 *	class ErrPanel
 *	ܺ٥顼դ顼ѥͥ
 */

ErrPanel* ErrPanel::my;

/*
 * 󥹥ȥ饯
 *	msgtbl	ܺ٥åơֹ֥(ǡܥåֹ)
 */
ErrPanel::ErrPanel( DBXNUM mtbl )
	: drawstr(DRAWSTR::Pnl)
{
	msgtbl = mtbl;
}

/*
 * ѥͥؿ
 */
W ErrPanel::pnlfn( W pnlid, W item, W val )
{
	W	gid, pgid;
	RECT	r;
	ERR	err;

	switch ( item ) {
	  case -1:	/* ѥͥ */
		break;

	  case 0:	/* ѥͥ */
	  case -2:	/* ɽ׵ */

		if ( itemstdpnl(30) > 0 && !errcodestr.empty() ) {
			rectstdpnl(30, &r);

			/* ѥͥĶʣ̤ơ
			   ʣ̤ĶȤä褹 */
			pgid = pget_gid(pnlid);
			if ( pgid < ER_OK ) { err = pgid; goto err_ret1; }
			gid = gnew_env(pgid);
			if ( gid < ER_OK ) { err = gid; goto err_ret1; }

			/* 顼ʸ */
			err = drawstr.draw(gid, r, errcodestr);
			if ( err < ER_OK ) goto err_ret2;

			err = gcls_env(gid);
			if ( err < ER_OK ) goto err_ret1;
		}
		break;

	  default:
		if ( item > 0 ) return item; // λ
	}

	return -1; // ³

err_ret2:
	gcls_env(gid);
err_ret1:
	DEBUG_PRINT(("ErrPanel::pnlfn err = %d\n", err));
	return err;
}

/*
 * ѥͥؿ()
 */
W ErrPanel::pnlfn_entry( W pnlid, W item, W val )
{
	return my->pnlfn(pnlid, item, val);
}

/*
 * ܺ٥顼å
 */
void ErrPanel::seterrmsg( ERR errcode )
{
	MSGTBL	*tbl;

	/* ܺ٥顼åơ֥뤫å򸡺 */
	tbl = (MSGTBL*)getdbox(msgtbl);
	if ( tbl != NULL ) {
		while ( tbl->err < 0 ) {
			if ( tbl->err == errcode
			  || tbl->err == (ERR)(errcode & 0xffff0000) ) {
				_spc_text_ptr = (TC*)ptrdbox(tbl->msg);
				break;
			}
			++tbl;
		}
	}
}

/*
 * 顼ʸ
 */
void ErrPanel::seterrcodestr( ERR errcode )
{
	TSTRP	sp(errcodestr);
	W	i, c;
	ERR	err;

	/* ʸ */
	errcodestr.del();

	/* Ⱦ䵤 */
	err = sp.instadstr(TADS::Han, 0);
	if ( err < ER_OK ) goto err_ret;

	/* (XXXXXXXX) ηǥ顼ɤʸѴ */
	err = sp.ins(TK_LPAR, TSC_SYS);
	if ( err < ER_OK ) goto err_ret;

	for ( i = 0; i < 8; ++i ) {
		errcode = ((UW)errcode >> 28) | ((UW)errcode << 4);
		c = errcode & 0xf;
		c += ( c > 9 )? TK_A - 10: TK_0;
		err = sp.ins(c, TSC_SYS);
		if ( err < ER_OK ) goto err_ret;
	}

	err = sp.ins(TK_RPAR, TSC_SYS);
	if ( err < ER_OK ) goto err_ret;

	return;

err_ret:
	errcodestr.del();
	DEBUG_PRINT(("ErrPanel::seterrcodestr err = %d\n", err));
	return;
}

/*
 * 顼ѥͥɽ
 *	pnl	顼åѥͥ
 *	err	顼
 */
ERR ErrPanel::panel( DBXNUM pnl, ERR errcode )
{
	ErrPanel	*save_my;
	ERR		err;

	save_my = my;
	my = this;

	/* Ԥå */
	waitmsg(-2);

	/* ܺ٥顼å */
	seterrmsg(errcode);

	/* 顼ɤʸѴ */
	seterrcodestr(errcode);

	/* ʸĶν */
	bgpat.get();
	err = drawstr.init(*bgpat);
	if ( err < ER_OK ) errcodestr.del();

	/* ѥͥ */
	err = dostdpnl(pnl, (FUNCP)pnlfn_entry);
	if ( err < ER_OK ) goto err_ret;

	_spc_text_ptr = NULL;
	my = save_my;
	return ER_OK;

err_ret:
	_spc_text_ptr = NULL;
	my = save_my;
	DEBUG_PRINT(("ErrPanel::panel err = %d\n", err));
	return err;
}

/*
 * 顼ѥͥɽ
 *	err & 0x0000ffff	顼åѥͥ(DBXNUM)
 *	err & 0xffff0000	顼
 */
ERR ErrPanel::panel( ERR errcode )
{
	return panel(errcode & 0x0000ffff, errcode & 0xffff0000);
}

/* ------------------------------------------------------------------------- */
} // namespace LIBCPP1
