/*
 *	@(#)fileio.cc (libcpp1) 01-04-18
 *
 *	եϥ饤֥
 *	(C) Copyright 2000-2001 by Personal Media Corporation
 */

#include "libcpp.h"
#include "cpp/1/fileio.h"

namespace LIBCPP1 {

/* ------------------------------------------------------------------------ */
/*
 *	class BIO
 *	ϥ饹
 */

/*
 * 󥹥ȥ饯
 */
BIO::BIO()
{
	mode = 0;
};

/*
 * ǥȥ饯
 */
BIO::~BIO()
{
}

/*
 * ư⡼
 *	or, and  MODE ͤȤ߹碌ƻꤹ롣
 *	Τ褦ꤵ롣
 *		mode = mode & and | or
 *	ͤˡѹư⡼ɤ֤
 */
UW BIO::setmode( UW or, UW and )
{
	UW	oldmode = mode;

	mode = oldmode & and | or;

	return oldmode;
}

/*
 * ʸ(Х)ɤ߽Ф
 *	üǤ -1 ֤
 *	ThroughCR λ꤬ʤ '\r'(CR) ɤФ
 */
WERR BIO::getc()
{
	UB	c;
	ERR	err;

	do {
		err = read(&c, 1);
		if ( err <= 0 ) {
			if ( err < ER_OK ) goto err_ret;
			return -1; // ü
		}
	} while ( c == '\r' && (mode & ThroughCR) == 0 );

	return c;

err_ret:
	DEBUG_PRINT(("BIO::getc err = %d\n", err));
	return err;
}

/*
 * ʸ(Х)񤭹
 *	ThroughCR λ꤬ʤ '\r'(CR) ̵뤷ƽ񤭹ޤʤ
 */
ERR BIO::putc( UB c )
{
	ERR	err;

	if ( c == '\r' && (mode & ThroughCR) == 0 ) return ER_OK;

	err = write(&c, 1);
	if ( err < ER_OK ) goto err_ret;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("BIO::putc err = %d\n", err));
	return err;
}

/*
 * ɤ߽Ф
 *	 max ʸ(Х)ޤɤ߹ࡣ
 *	ɤ߽Фʸ֤ͤ
 *	ɤ߽Фǡ max ̤ǤСǸ '\0' դ
 *	'\n'(LF) Ȥ롣
 *	ThroughCR λ꤬ʤ '\r'(CR) ɤФ
 */
WERR BIO::gets( UB *buf, W max )
{
	W	c, n;

	n = 0;
	while ( n < max ) {
		c = getc();
		if ( c < ER_OK ) {
			if ( c == -1 ) break; // ü
			goto err_ret;
		}
		buf[n++] = c;
		if ( c == '\n' ) break;
	}
	if ( n < max ) buf[n] = '\0';

	return n;

err_ret:
	DEBUG_PRINT(("BIO::gets err = %d\n", c));
	return c;
}

/*
 * ʸ񤭹
 *	buf  '\0' ޤǤ len ʸ(Хȿ)ޤǤΤ줫ã
 *	ޤǤ񤭹ࡣ
 *	len < 0 ξ len ̵뤵롣
 *	ThroughCR λ꤬ʤ '\r'(CR) ̵뤷ƽ񤭹ޤʤ
 *	񤭹ʸ(Хȿ)֤ͤ
 *	̵뤷ƽ񤭹ޤʤäʸ񤭹ʸ˴ޤ롣
 */
WERR BIO::puts( const UB *buf, W len )
{
const	UB	*p = buf;
	ERR	err;

	while ( len-- != 0 && *p != '\0' ) {
		err = putc(*p++);
		if ( err < ER_OK ) goto err_ret;
	}

	return p - buf;

err_ret:
	DEBUG_PRINT(("BIO::puts err = %d\n", err));
	return err;
}

/*
 * 󥯥쥳ɤɤ߽Ф
 *	֤߰Υ󥯥쥳ɤ lnk ɤ߽Ф
 *	֤߰򼡤Υ󥯥쥳ɤؿʤ롣
 * no operation:
 *	lnk ƤϤ٤ƣ֤롣
 */
ERR BIO::read_link( LINK &lnk )
{
	memset(&lnk, 0, sizeof(LINK));
	return ER_OK;
}

/*
 * 󥯥쥳ɤν񤭽Ф
 *	֤߰ lnk Υ󥯥쥳ɤ롣
 *	֤߰򼡤Υ󥯥쥳ɤؿʤ롣
 * no operation:
 *	Ԥʤ
 */
ERR BIO::write_link( LINK &lnk )
{
	return ER_OK;
}

/*
 * 󥯥쥳ɤκ
 *	֤߰Υ󥯥쥳ɤ롣
 *	֤߰ϼΥ󥯥쥳ɤȤʤ롣
 * no operation:
 *	Ԥʤ
 */
ERR BIO::delete_link()
{
	return ER_OK;
}

/*
 * 󥯥쥳ɥθ֤߰ΰư
 *	֤߰򼡤Τ褦˰ư롣
 *	mode = SeekSet : ߰ = offset
 *	mode = SeekCur : ߰ += offset
 *	mode = SeekEnd : ߰ = ü쥳 + offset
 *	֤ϥ쥳ֹǤϤʤƬΥ󥯥쥳ɤ򣰤Ȥ
 *	󥯥쥳ɤΤߤ˽˿äֹǤ롣
 *	ǸϽü쥳ɤȤʤ롣
 * no operation:
 *	Ԥʤ
 */
ERR BIO::seek_linkrec( W offset, SeekMode mode )
{
	return 0;
}

/* ------------------------------------------------------------------------ */
/*
 *	class RecIO
 *	ե(쥳)ϥ饹
 */

/*
 * 󥹥ȥ饯
 */
RecIO::RecIO( W bufsize )
{
	fd = -1;
	iobuf = NULL;
	bufsz = bufsize;
}

/*
 * ǥȥ饯
 */
RecIO::~RecIO()
{
	close();
}

/*
 * 쥳ɥץ
 *	եǥץ fd ΥեΥ쥳ֹ recno 
 *	쥳ɤ򥢥뤿νԤ
 *	recno = -1 ξϡfd θߥ쥳ɤоݤȤʤ롣
 *	쥳ɥץϡfd θߥ쥳ɤưƤϤʤ
 *	쥳ɤΥ֥פ lnksubtype Υ쥳ɤоݤˤʤ롣
 *	lnksubtype = 0 ξϡ٤ƤΥ󥯥쥳ɤоݤˤʤ롣
 */
ERR RecIO::open( W fd, W recno, W lnksubtype )
{
	ERR	err;

	if ( recno >= 0 ) {
		/* 쥳ɤΰư */
		err = see_rec(fd, recno, 1, NULL);
		if ( err < ER_OK ) goto err_ret;
	}

	/* Хåեγ */
	iobuf = (UB*)malloc(bufsz);
	if ( iobuf == NULL ) { err = ER_NOMEM; goto err_ret; }

	this->fd = fd;
	recofs = ofs = end = 0;
	wflg = False;
	lnkrecno = 0;
	this->lnksubtype = lnksubtype;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("RecIO::open err = %d\n", err));
	return err;
}

/*
 * 쥳ɥ
 *	쥳ɤν񤭹ߤԤä硢ޤ񤭽ФƤʤ
 *	ǡФ٤ƽ񤭽Ф롣
 */
ERR RecIO::close()
{
	ERR	err, error = ER_OK;

	if ( iobuf != NULL ) {
		if ( wflg ) {
			/* ХåեΥեå */
			err = flush();
			if ( err < ER_OK ) error = err;
			err = syn_fil(fd);
			if ( err < ER_OK ) error = err;
		}

		/* Хåեβ */
		free(iobuf);

		fd = -1;
		iobuf = NULL;
	}

#ifdef DEBUG
	if ( error < ER_OK ) DEBUG_PRINT(("RecIO::close err = %d\n", error));
#endif
	return error;
}

/*
 * 쥳ɤ߽Ф
 */
WERR RecIO::rearec( W offset, VP buf, W size, W *r_size )
{
	ERR	err;

	err = rea_rec(fd, offset, (B*)buf, size, r_size, NULL);
#ifdef DEBUG
	if ( err < ER_OK ) DEBUG_PRINT(("RecIO::rearec err = %d\n", err));
#endif
	return err;
}

/*
 * 쥳ɽ񤭹
 */
ERR RecIO::wrirec( W offset, VP buf, W size, W *r_size )
{
	ERR	err;

	err = wri_rec(fd, offset, (B*)buf, size, r_size, NULL, 0);
#ifdef DEBUG
	if ( err < ER_OK ) DEBUG_PRINT(("RecIO::wrirec err = %d\n", err));
#endif
	return err;
}

/*
 * Хåեեå
 *	񤭹ߤԤä硢ޤ񤭽ФƤʤǡ
 *	Ф٤ƽ񤭽Ф롣
 */
ERR RecIO::flush()
{
	ERR	err;

	if ( wflg ) {
		/* Хåեν񤭽Ф */
		err = wrirec(recofs, iobuf, end, NULL);
		if ( err < ER_OK ) goto err_ret;

		wflg = False;
	}

	return ER_OK;

err_ret:
	DEBUG_PRINT(("RecIO::flush err = %d\n", err));
	return err;
}

/*
 * ǡɤ߽Ф
 *	ߤΰ֤ size ХȤ buf ɤ߽Ф
 *	size ХȤɤ߽Ф˥ǡνüãϡ
 *	ǡüޤǤɤ߽Ф
 *	ɤ߽ФХȿ֤ͤ
 *	֤߰ɤ߽Фʬʤ롣
 */
WERR RecIO::read( void *buf, W size )
{
	W	sz = size;
	W	n;
	ERR	err;

	while ( sz > 0 ) {
		if ( ofs >= end ) {
			err = flush();  /* Хåե񤭽Ф */
			if ( err < ER_OK ) goto err_ret;

			recofs += ofs;	/* ɤ߽Ф */

			/* Хåեɤ߹ */
			err = rearec(recofs, iobuf, bufsz, &end);
			if ( err < ER_OK ) goto err_ret;
			if ( end <= 0 ) break; /* 쥳ɽü */

			if ( end > bufsz ) end = bufsz;
			ofs = 0;
		}

		/* Хåեɤ߽Ф */
		n = end - ofs;
		if ( n > sz ) n = sz;
		memcpy(buf, iobuf + ofs, n);
		(UB*)buf += n;
		ofs += n;
		sz -= n;
	}

	return size - sz;

err_ret:
	DEBUG_PRINT(("RecIO::read err = %d\n", err));
	return err;
}

/*
 * ʸ(Х)ɤ߽Ф
 *	üǤ -1 ֤
 *	ThroughCR λ꤬ʤ '\r'(CR) ɤФ
 */
WERR RecIO::getc()
{
	UB	c;
	ERR	err;

	do {
		if ( ofs >= end ) {
			err = flush();  /* Хåե񤭽Ф */
			if ( err < ER_OK ) goto err_ret;

			recofs += ofs;	/* ɤ߽Ф */

			/* Хåեɤ߹ */
			err = rearec(recofs, iobuf, bufsz, &end);
			if ( err < ER_OK ) goto err_ret;
			if ( end <= 0 ) return -1; /* 쥳ɽü */

			if ( end > bufsz ) end = bufsz;
			ofs = 0;
		}

		/* Хåեɤ߽Ф */
		c = iobuf[ofs++];

	} while ( c == '\r' && (mode & ThroughCR) == 0 );

	return c;

err_ret:
	DEBUG_PRINT(("RecIO::getc err = %d\n", err));
	return err;
}

/*
 * ǡ񤭹
 *	ߤΰ֤ buf  size ХȽ񤭹ࡣ
 *	񤭹Хȿ֤ͤ
 *	֤߰Ͻ񤭹ʬʤ롣
 */
WERR RecIO::write( const void *buf, W size )
{
	W	sz = size;
	W	n;
	ERR	err;

	while ( sz > 0 ) {
		if ( ofs >= bufsz ) {
			err = flush();  /* Хåե񤭽Ф */
			if ( err < ER_OK ) goto err_ret;

			recofs += ofs;  /* ν񤭽Ф */
			ofs = end = 0;  /* Хåեꥢ */
		}

		/* Хåեؽ񤭽Ф */
		n = bufsz - ofs;
		if ( n > sz ) n = sz;
		memcpy(iobuf + ofs, buf, n);
		(UB*)buf += n;
		ofs += n;
		sz -= n;
		if ( ofs > end ) end = ofs;
		wflg = True;
	}

	return size - sz;

err_ret:
	DEBUG_PRINT(("RecIO::write err = %d\n", err));
	return err;
}

/*
 * ʸ(Х)񤭹
 *	ThroughCR λ꤬ʤ '\r'(CR) ̵뤷ƽ񤭹ޤʤ
 */
ERR RecIO::putc( UB c )
{
	ERR	err;

	if ( c == '\r' && (mode & ThroughCR) == 0 ) return ER_OK;

	if ( ofs >= bufsz ) {
		err = flush();  /* Хåե񤭽Ф */
		if ( err < ER_OK ) goto err_ret;

		recofs += ofs;  /* ν񤭽Ф */
		ofs = end = 0;  /* Хåեꥢ */
	}

	/* Хåեؽ񤭽Ф */
	iobuf[ofs++] = c;
	if ( ofs > end ) end = ofs;
	wflg = True;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("RecIO::putc err = %d\n", err));
	return err;
}

/*
 * ֤߰ΰư
 *	֤߰򼡤Τ褦˰ư롣
 *	ͤ˰ưθ֤֤߰
 *	mode = SeekSet : ߰ = offset
 *	mode = SeekCur : ߰ += offset
 *	mode = SeekEnd : ߰ = ǡü + offset
 */
WERR RecIO::seek( W offset, SeekMode mode )
{
	W	pos, rsz;
	ERR	err;

	/* ߤΥ쥳ɥ */
	err = rearec(0, NULL, 0, &rsz);
	if ( err < ER_OK ) goto err_ret;

	/* ޤ񤭽ФƤʤʬС
	   쥳ɥȿǤ */
	pos = recofs + end;
	if ( rsz < pos ) rsz = pos;

	/* ưΰ */
	switch ( mode ) {
	  case SeekSet:	pos = offset;			break;
	  case SeekCur:	pos = recofs + ofs + offset;	break;
	  case SeekEnd:	pos = rsz + offset;		break;
	}
	if ( pos < 0 || pos > rsz ) { err = ER_PAR; goto err_ret; }

	if ( pos < recofs || pos > recofs + end ) {
		err = flush();  /* Хåե񤭽Ф */
		if ( err < ER_OK ) goto err_ret;

		recofs = pos;
		ofs = end = 0;  /* Хåեꥢ */
	} else {
		ofs = pos - recofs;
	}

	return pos;

err_ret:
	DEBUG_PRINT(("RecIO::seek err = %d\n", err));
	return err;
}

/*
 * ֤߰μ
 */
W RecIO::pos()
{
	return recofs + ofs;
}

/*
 * 󥯥쥳ɤɤ߽Ф
 *	֤߰Υ󥯥쥳ɤ lnk ɤ߽Ф
 *	֤߰򼡤Υ󥯥쥳ɤؿʤ롣
 */
ERR RecIO::read_link( LINK &lnk )
{
	W	datarec, recno;
	ERR	err;

	/* ߥ쥳(ǡ쥳)ΰ֤¸ */
	err = see_rec(fd, 0, 0, &datarec);
	if ( err < ER_OK ) goto err_ret1;

	/* 󥯥쥳ɤΰ֤˰ư */
	err = see_rec(fd, lnkrecno, 1, NULL);
	if ( err < ER_OK ) goto err_ret1;
	err = fnd_lnk(fd, F_FWD, NULL, lnksubtype, &recno);
	if ( err < ER_OK ) goto err_ret2;

	/* 󥯥쥳ɤɤ߽Ф */
	err = rearec(0, &lnk, sizeof(LINK), NULL);
	if ( err < ER_OK ) goto err_ret2;

	/* ߥ쥳ɤ򸵤᤹ */
	err = see_rec(fd, datarec, 1, NULL);
	if ( err < ER_OK ) goto err_ret1;

	lnkrecno = recno + 1;

	return ER_OK;

err_ret2:
	see_rec(fd, datarec, 1, NULL);
err_ret1:
	DEBUG_PRINT(("RecIO::read_link err = %d\n", err));
	return err;
}

/*
 * 󥯥쥳ɤν񤭽Ф
 *	֤߰ lnk Υ󥯥쥳ɤ롣
 *	֤߰򼡤Υ󥯥쥳ɤؿʤ롣
 */
ERR RecIO::write_link( LINK &lnk )
{
	TC		fnm[L_FNM+1];
	F_STATE		sts;
	F_LOCATE	loc;
	F_LINK		ref;
	LINK		lnkfile;
	W		datarec;
	ERR		err;

	/* ߥ쥳(ǡ쥳)ΰ֤¸ */
	err = see_rec(fd, 0, 0, &datarec);
	if ( err < ER_OK ) goto err_ret1;

	/* 󥯥쥳ɤΰ֤˰ư */
	err = see_rec(fd, lnkrecno, 1, NULL);
	if ( err < ER_OK ) goto err_ret1;

	/* 󥯥쥳ɤν񤭽Ф */
	err = ins_rec(fd, (B*)&lnk, sizeof(LINK), RT_LINK, lnksubtype, 0);
	if ( err < ER_OK ) {
		if ( err != ER_REC ) goto err_ret2;

		/* lnk Υե륷ƥबۤʤΤǡ
		 * 󥯥ե
		 */

		/* 󥯥եե륷ƥ */
		err = ofl_sts(fd, NULL, NULL, &loc);
		if ( err < ER_OK ) goto err_ret2;
		tc_strncpy(lnkfile.fs_name, loc.fs_name, L_FSNM);

		/* 󥯥եꤹ */
		err = fil_sts(&lnk, fnm, &sts, &loc);
		if ( err < ER_OK ) goto err_ret2;
		ref.f_id     = lnk.f_id;
		ref.f_atype  = sts.f_atype;
		ref.rf_ctime = sts.f_ctime;
		tc_strncpy(ref.f_name, fnm, L_FNM);
		tc_strncpy(ref.fs_name, loc.fs_name, L_FSNM);
		tc_strncpy(ref.fs_locat, loc.fs_locat, L_DLNM);

		/* 󥯥ե */
		err = cre_lnk(&lnkfile, &ref, F_FLOAT);
		if ( err < ER_OK ) goto err_ret2;

		/* 󥯥쥳ɤν񤭽Ф */
		err = ins_rec(fd, (B*)&lnkfile, sizeof(LINK),
						RT_LINK, lnksubtype, 0);
		if ( err < ER_OK ) goto err_ret2;
	}

	if ( lnkrecno <= datarec ) ++datarec;

	/* ߥ쥳ɤ򸵤᤹ */
	err = see_rec(fd, datarec, 1, NULL);
	if ( err < ER_OK ) goto err_ret1;

	lnkrecno++;

	return ER_OK;

err_ret2:
	see_rec(fd, datarec, 1, NULL);
err_ret1:
	DEBUG_PRINT(("RecIO::write_link err = %d\n", err));
	return err;
}

/*
 * 󥯥쥳ɤκ
 *	֤߰Υ󥯥쥳ɤ롣
 *	֤߰ϼΥ󥯥쥳ɤȤʤ롣
 */
ERR RecIO::delete_link()
{
	W	datarec, rn;
	ERR	err;

	/* ߥ쥳(ǡ쥳)ΰ֤¸ */
	err = see_rec(fd, 0, 0, &datarec);
	if ( err < ER_OK ) goto err_ret1;

	/* 󥯥쥳ɤΰ֤˰ư */
	err = see_rec(fd, lnkrecno, 1, NULL);
	if ( err < ER_OK ) goto err_ret1;
	err = fnd_lnk(fd, F_FWD, NULL, lnksubtype, &rn);
	if ( err < ER_OK ) goto err_ret2;

	/* 󥯥쥳ɤ */
	err = del_rec(fd);
	if ( err < ER_OK ) goto err_ret2;

	if ( rn < datarec ) --datarec;

	/* ߥ쥳ɤ򸵤᤹ */
	err = see_rec(fd, datarec, 1, NULL);
	if ( err < ER_OK ) goto err_ret1;

	return ER_OK;

err_ret2:
	see_rec(fd, datarec, 1, NULL);
err_ret1:
	DEBUG_PRINT(("RecIO::delete_link err = %d\n", err));
	return err;
}

/*
 * 󥯥쥳ɥθ֤߰ΰư
 *	֤߰򼡤Τ褦˰ư롣
 *	mode = SeekSet : ߰ = offset
 *	mode = SeekCur : ߰ += offset
 *	mode = SeekEnd : ߰ = ü쥳 + offset
 *	֤ϥ쥳ֹǤϤʤƬΥ󥯥쥳ɤ򣰤Ȥ
 *	󥯥쥳ɤΤߤ˽˿äֹǤ롣
 *	ǸϽü쥳ɤȤʤ롣
 */
ERR RecIO::seek_linkrec( W offset, SeekMode mode )
{
	W	datarec, recno, m;
	ERR	err;

	/* ߥ쥳(ǡ쥳)ΰ֤¸ */
	err = see_rec(fd, 0, 0, &datarec);
	if ( err < ER_OK ) goto err_ret1;

	/* ϰ֤˰ư */
	switch ( mode ) {
	  case SeekSet:	m = 1;	break;
	  case SeekCur:	m = 0;	break;
	  case SeekEnd:	m = -1;	break;
	}
	err = see_rec(fd, ( m == 0 )? lnkrecno: 0, m, &recno);
	if ( err < ER_OK ) goto err_ret1;
	err = fnd_lnk(fd, F_FWD, NULL, lnksubtype, NULL);
	if ( err < ER_OK ) {
		if ( err != ER_REC || offset > 0 ) goto err_ret2;
	}

	/* 󥯥쥳ɤ򸡺 */
	if ( offset >= 0 ) {
		m = F_NFWD;
	} else {
		m = F_NBWD;
		offset = -offset;
	}
	while ( offset-- > 0 ) {
		err = fnd_lnk(fd, m, NULL, lnksubtype, &recno);
		if ( err < ER_OK ) {
			if ( err == ER_REC && offset == 0 && m == F_NFWD ) {
				/* ü쥳ɤ˰ư */
				err = see_rec(fd, 0, -1, &recno);
				if ( err < ER_OK ) goto err_ret2;
				break;
			}
			goto err_ret2;
		}
	}

	/* ߥ쥳ɤ򸵤᤹ */
	err = see_rec(fd, datarec, 1, NULL);
	if ( err < ER_OK ) goto err_ret1;

	lnkrecno = recno;

	return ER_OK;

err_ret2:
	see_rec(fd, datarec, 1, NULL);
err_ret1:
	DEBUG_PRINT(("RecIO::seek_linkrec err = %d\n", err));
	return err;
}

/* ------------------------------------------------------------------------ */
/*
 *	class RRecIO
 *	åԤƻդե(쥳)ϥ饹
 */

/*
 * 쥳ɤ߽Ф
 */
WERR RRecIO::rearec( W offset, VP buf, W size, W *r_size )
{
	W	retry = retry_count;
	ERR	err;

	do {
		err = rea_rec(fd, offset, (B*)buf, size, r_size, NULL);
		if ( err != ER_LOCK ) break;

		dly_tsk(retry_delay);

	} while ( --retry >= 0 );

#ifdef DEBUG
	if ( err < ER_OK ) DEBUG_PRINT(("RRecIO::rearec err = %d\n", err));
#endif
	return err;
}

/*
 * 쥳ɽ񤭹
 */
ERR RRecIO::wrirec( W offset, VP buf, W size, W *r_size )
{
	W	retry = retry_count;
	ERR	err;

	do {
		err = wri_rec(fd, offset, (B*)buf, size, r_size, NULL, 0);
		if ( err != ER_LOCK ) break;

		dly_tsk(retry_delay);

	} while ( --retry >= 0 );

#ifdef DEBUG
	if ( err < ER_OK ) DEBUG_PRINT(("RRecIO::wrirec err = %d\n", err));
#endif
	return err;
}

/* ------------------------------------------------------------------------ */
} // namespace LIBCPP1
