/*
 *	@(#)memio.cc (libcpp1) 01-03-16
 *
 *	꡼Хåե
 *	(C) Copyright 2000-2001 by Personal Media Corporation
 */

#include "libcpp.h"
#include "cpp/1/fileio.h"

namespace LIBCPP1 {

/* ------------------------------------------------------------------------- */
/*
 *	class MemIO
 *	꡼Хåեϥ饹
 */

/*
 * 󥹥ȥ饯
 */
MemIO::MemIO()
{
	membuf = NULL;
	cursize = 0;
	curpos = 0;
}

/*
 * ǥȥ饯
 */
MemIO::~MemIO()
{
	if ( membuf != NULL ) free(membuf);
}

/*
 * Хåեѹ
 *	Хåե size ХȤѹ롣
 *	ʤäϸ̾ʤäʬ
 *	ǡϼΤƤ롣
 *	礭ʤäϸسĥ礭ʤäʬ
 *	ǡȤʤ롣
 *	֤߰꾮ʥѹˤϡ֤߰ϥХåե
 *	üȤʤ롣
 */
ERR MemIO::resizebuf( W size )
{
	W	reqsz;	// ׵᥵
	W	cursz;	// ߥ
	UB	*p;

	reqsz = (size    + (BLKSZ-1)) / BLKSZ * BLKSZ;
	cursz = (cursize + (BLKSZ-1)) / BLKSZ * BLKSZ;

	if ( reqsz != cursz ) {

		if ( reqsz > 0 ) {
			/* Хåեѹ */
			p = (UB*)realloc(membuf, reqsz);
			if ( p == NULL ) goto err_ret;
			membuf = p;
		} else {
			/* Хåե */
			free(membuf);
			membuf = NULL;
		}
	}

	cursize = size;

	/* ߰ */
	if ( curpos > size ) curpos = size;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("MemIO::resizebuf err = %d\n", ER_NOMEM));
	return ER_NOMEM;
}

/*
 * Хåեեå
 *	񤭹ߤԤä硢ޤ񤭽ФƤʤǡ
 *	٤ƽ񤭽Ф롣
 */
ERR MemIO::flush()
{
	/* ⤷ʤ */
	return ER_OK;
}

/*
 * ǡɤ߽Ф
 *	ߤΰ֤ size ХȤ buf ɤ߽Ф
 *	size ХȤɤ߽Ф˥ǡνüãϡ
 *	ǡüޤǤɤ߽Ф
 *	ɤ߽ФХȿ֤ͤ
 *	֤߰ɤ߽Фʬʤ롣
 */
WERR MemIO::read( void *buf, W size )
{
	W	remsz;

	remsz = cursize - curpos;
	if ( size > remsz ) size = remsz;

	if ( size > 0 ) {
		memcpy(buf, membuf + curpos, size);
		curpos += size;
	}

	return size;
}

/*
 * ǡ񤭹
 *	ߤΰ֤ buf  size ХȽ񤭹ࡣ
 *	񤭹Хȿ֤ͤ
 *	֤߰Ͻ񤭹ʬʤ롣
 */
WERR MemIO::write( const void *buf, W size )
{
	W	sz;
	ERR	err;

	sz = curpos + size;
	if ( sz > cursize ) {
		/* Хåեĥ */
		err = resizebuf(sz);
		if ( err < ER_OK ) goto err_ret;
	}

	if ( size > 0 ) {
		memcpy(membuf + curpos, buf, size);
		curpos += size;
	}

	return size;

err_ret:
	DEBUG_PRINT(("MemIO::write err = %d\n", err));
	return err;
}

/*
 * ֤߰ΰư
 *	֤߰򼡤Τ褦˰ư롣
 *	ͤ˰ưθ֤֤߰
 *	mode = SeekSet : ߰ = offset
 *	mode = SeekCur : ߰ += offset
 *	mode = SeekEnd : ߰ = ǡü + offset
 */
WERR MemIO::seek( W offset, SeekMode mode )
{
	W	pos;

	switch ( mode ) {
	  case SeekSet:	pos = offset;		break;
	  case SeekCur:	pos = curpos + offset;	break;
	  case SeekEnd:	pos = cursize + offset;	break;
	}
	if ( pos < 0 || pos > cursize ) goto err_ret;

	return curpos = pos;

err_ret:
	DEBUG_PRINT(("MemIO::seek err = %d\n", ER_PAR));
	return ER_PAR;
}

/*
 * ֤߰μ
 */
W MemIO::pos()
{
	return curpos;
}

/* ------------------------------------------------------------------------- */
} // namespace LIBCPP1
