/*
 *	@(#)panelbg.cc (libcpp1) 01-01-29
 *
 *	ѥͥ饤֥
 *	(C) Copyright 2000-2001 by Personal Media Corporation
 */

#include "libcpp.h"
#include "cpp/1/misc.h"

namespace LIBCPP1 {

/* ------------------------------------------------------------------------- */
/*
 *	class PanelBg
 *	ѥͥطʿ
 */

/*
 * ѥͥطʿμ
 *	ޤɥޥ͡㡼ƤʤȤϡ
 *	ɥޥ͡㡼롣
 *	ɥޥ͡㡼μ˼ԤǤ
 *	Ŭ PAT ֤
 */
PAT* PanelBg::operator * ()
{
static	PAT	defaultpat = { {0, 16, 16, COL_GRAY, COL_GRAY, FILL100} };
	ERR	err;

	if ( bgpat == NULL ) {
		/* ɥޥ͡㡼 */
		err = get();
		if ( err < ER_OK ) goto err_ret;
	}

	return bgpat;

err_ret:
	DEBUG_PRINT(("PanelBg::operator * err = %d\n", err));
	return &defaultpat;
}

/*
 * ɥޥ͡㡼ѥͥطʿ
 */
ERR PanelBg::get()
{
	PAT	*p;
	W	sz;
	ERR	err;

	/* ߤΥѥͥطʿ */
	del();

	/* ɥޥ͡㡼ѥͥطʿ */
	sz = wget_inf(WI_PANELBACK, NULL, 0);
	if ( sz < ER_OK ) { err = sz; goto err_ret1; }

	p = (PAT*)malloc(sz);
	if ( p == NULL ) { err = ER_NOMEM; goto err_ret1; }

	err = wget_inf(WI_PANELBACK, p, sz);
	if ( err < ER_OK ) goto err_ret2;

	bgpat = p;

	return ER_OK;

err_ret2:
	free(p);
err_ret1:
	DEBUG_PRINT(("PanelBg::get err = %d\n", err));
	return err;
}

/*
 * ɥޥ͡㡼ѥͥطʿ
 */
void PanelBg::del()
{
	if ( bgpat != NULL ) free(bgpat);
	bgpat = NULL;
}

/* ------------------------------------------------------------------------- */
} // namespace LIBCPP1
