/*
 *	@(#)qprint.cc (libcpp1) 01-03-22
 *
 *	Quoted Printable Ѵ
 *	(C) Copyright 2000-2001 by Personal Media Corporation
 *
 *	010322	ζ̵뤹ȤͤˤƤʤ
 *		ѾʤȻפ롣
 */

#include "libcpp.h"
#include "cpp/1/misc.h"

namespace LIBCPP1 {

/* ------------------------------------------------------------------------ */
/*
 *	Quoted Printable Ѵ
 *	class QPRINT
 */

/*
 * 󥹥ȥ饯
 */
QPRINT::QPRINT()
{
	reset();
}

/*
 * 󥳡ɷ̾
 */
const UB* QPRINT::name()
{
	return (UB*)"quoted-printable";
}

/*
 * Ķν
 */
void QPRINT::reset()
{
	rem = 0;
	rempos = NULL;
	nchar = 0;
}

/*
 * ĤΥǡ true
 */
bool QPRINT::remained()
{
	return rempos != NULL;
}

/*
 * ʸǥ
 */
W QPRINT::decodech( UB c )
{
	if ( c >= '0' && c <= '9' ) return c - '0';
	if ( c >= 'A' && c <= 'F' ) return c - 'A' + 10;
	if ( c >= 'a' && c <= 'f' ) return c - 'a' + 10;
	if ( c == '=' ) return 0;
	return -1;
}

/*
 * ǥ
 *	src  len ХȤǥɤơdst غ max Х
 *	ޤǳǼ롣
 *	len ХȤã '\0' ˽вä餽ѴϽ롣
 *	len < 0 ξϡlen ̵뤵롣
 *	ͤ dst سǼХȿ֤
 *	Ѵ̤ max ХȤĶ硢dst ؤ max ХȰ
 *	ŬʶڤޤѴƳǼ롣ΤȤremained() 
 *	true ֤ξϡsrc Ƥѹˡsrc, len 
 *	ƱΤꤷƺ decode() ƤӽФȤǡĤʬ
 *	ѴԤ롣
 *	src κǸѴǤʤҤĤäƤޤäϡϥ
 *	¸롣³ src ꤷƺ decode()
 *	ƤӽФȤǡ³ѴǤ롣
 *
 *	src üû(Х̤)ưʤ礬롣
 *	src, dst ȤĹΨ褤
 *	󥳡ɤ줿ǡͿ뤳ȤȤƤꡢ
 *	ʥǡäưɬϤʤ
 */
WERR QPRINT::decode( UB *dst, W max, const UB *src, W len )
{
	UB	*dp = dst;
const	UB	*sp, *rp;
	UB	c;
	W	n, i;
	UW	data;

	if ( rempos != NULL ) {
		sp = rempos;
		len -= rempos - src;
	} else {
		sp = src;
	}
	rempos = NULL;

	data = 0;
	for ( i = 0; i < rem; ++i ) {
		n = decodech(buf[i]);
		data <<= 4;
		data |= n;
	}

	rp = sp;
	for ( ; len != 0; --len ) {
		if ( i > 0 ) {
			if ( (c = *sp++) == '\0' ) break;
			if ( i == 1 ) {
				/* = θ³̵뤹 */
				if ( c == ' ' || c == '\t' || c == '\r' )
								continue;
				/* '\n' ǹԷ³ */
				if ( c == '\n' ) { i = 0; continue; }
			}
			i++;
			n = decodech(c);
			if ( n < 0 ) { i = 0; continue; } // ̵
			data <<= 4;
			data |= n;
			if ( i < 3 ) continue;
			i = 0;
			if ( max < 1 ) {
				/* ϥХåե­ʤ */
				rempos = rp;
				break;
			}
			*dp++ = data;
			--max;
		} else {
			if ( (c = *sp++) == '\0' ) break;
			if ( c == '=' ) {
				rp = sp - 1;
				data = 0;
				++i;
				continue;
			}
			if ( max < 1 ) {
				/* ϥХåե­ʤ */
				rempos = sp - 1;
				break;
			}
			*dp++ = c;
			--max;
		}
	}
	if ( (rem = i) > 0 ) {
		for ( i = 0; i < rem; ++i ) buf[i] = *rp++;
	}

	return dp - dst;
}

/*
 * ʸ󥳡
 */
void QPRINT::encodech( UB* &dst, UB ch, W &max )
{
const	UB	hex[] = "0123456789ABCDEF";

	if ( nchar + 3 >= MaxChar ) {
		/* Է³β */
		if ( (max -= 3) < 0 ) return;
		*dst++ = '=';
		*dst++ = '\r';
		*dst++ = '\n';
		nchar = 0;
	}

	if ( (max -= 3) < 0 ) return;
	*dst++ = '=';
	*dst++ = hex[ch >> 4];
	*dst++ = hex[ch & 0xf];
	nchar += 3;
}

/*
 * 󥳡
 *	src  len ХȤ򥨥󥳡ɤơdst غ max Х
 *	ޤǳǼ롣
 *	dst ˳Ǽǡ max Х̤ǤСdst κǸ
 *	'\0' ղä롣
 *	ͤ dst سǼХȿ(Ǹ '\0' ϴޤޤʤ)֤
 *	Ѵ̤ max ХȤĶ硢dst ؤ max ХȰ
 *	ŬʶڤޤѴƳǼ롣ΤȤremained() 
 *	true ֤ξϡsrc Ƥѹˡsrc, len 
 *	ƱΤꤷƺ encode() ƤӽФȤǡĤʬ
 *	ѴԤ롣
 *	src κǸѴǤʤҤĤäƤޤäϡϥ
 *	󥳡¸롣³ src ꤷƺ encode()
 *	ƤӽФȤǡ³ѴǤ롣
 *	Ǹ len = 0 ǸƤӽФȤǡsrc νüǤ뤳Ȥ򼨤
 *	ɬפ롣ˤꡢ󥳡¸ƤҤ
 *	Ѵ롣
 *
 *	dst üûưʤ礬롣
 *	̾ϣХȰʾ塢ǸҤνϤǤϣХȰʾɬפǤ롣
 *	src, dst ȤĹΨ褤
 */
WERR QPRINT::encode( UB *dst, W max, const UB *src, W len )
{
	UB	*dp  = dst;
	UB	*edp = dst + max;
const	UB	*sp;
const	UB	*esp = src + len;
	UB	c;

	if ( len == 0 ) {
		if ( rem > 0 ) {
			encodech(dp, '\r', max);
			if ( max < 0 ) goto skip_end;
			rem = 0;
		}
		if ( nchar > 0 ) {
			/* Ǹβ */
			if ( (max -= 3) < 0 ) goto skip_end;
			*dp++ = '=';
			*dp++ = '\r';
			*dp++ = '\n';
			nchar = 0;
		}
		goto skip_end;
	}

	for ( sp = ( rempos == NULL )? src: rempos; sp < esp; ++sp ) {
		c = *sp;
		if ( rem > 0 ) {
			if ( c == '\n' ) {
				if ( (max -= 2) < 0 ) break;
				*dp++ = '\r';
				*dp++ = '\n';
				rem = 0;
				nchar = 0;
				continue;
			} else {
				encodech(dp, '\r', max);
				if ( max < 0 ) break;
				rem = 0;
			}
		}

		if ( c == '\r' ) {
			rem = 1;
			continue;
		}

		if ( c >= 0x20 && c <= 0x7e && c != '=' || c == '\t' ) {
			/* ̵Ѵ */
			if ( nchar + 1 >= MaxChar ) {
				/* Է³β */
				if ( (max -= 3) < 0 ) break;
				*dp++ = '=';
				*dp++ = '\r';
				*dp++ = '\n';
				nchar = 0;
			}
			if ( --max < 0 ) break;
			*dp++ = c;
			nchar++;
		} else {
			/* =NN Ѵ */
			encodech(dp, c, max);
			if ( max < 0 ) break;
		}
	}

skip_end:
	rempos = ( sp < esp )? sp: NULL;

	if ( dp < edp ) *dp = '\0';

	return dp - dst;
}

/* ------------------------------------------------------------------------ */
} // namespace LIBCPP1
