/*
 *	@(#)tadio.cc (libcpp1) 01-04-12
 *
 *	TAD ϥ饤֥
 *	(C) Copyright 2000-2001 by Personal Media Corporation
 */

#include "libcpp.h"
#include "cpp/1/tadio.h"

namespace LIBCPP1 {

/* ------------------------------------------------------------------------ */
/*
 *	class TADIO
 *	TAD ϴܥ饹
 */

/*
 * TAD ǡ񤭹
 *	֤߰ tadp Ǥդ TAD ǡ򣱤Ľ񤭹ࡣ
 *	tadp ϼؿʤ롣
 *	ΤޤߥǥѴԤ롣
 *	vid ¸μ¿ȤؤID
 *	Ȥ¸ȤѴ(ocnv_vob)˻Ѥ롣
 *	vid = 0 ξϤѴϹԤʤ
 *	fast = true ΤȤϡʸϤޤȤƽ񤭹ޤ롣
 *	tadp ΰ֤ʸǤСʹߤκǽʸʳΥǡ
 *	ޤϹޤǤޤȤƽ񤭹ޤ롣
 *	fast = false ΤȤϡʸĽ񤭹ޤ롣
 */
ERR TADIO::puttad( TADP &tadp, W vid, bool fast )
{
	const TC	*str;
	W		lang, len;
	TSEG		seg;
	TNEST		nst;
	TVOBJ		vob;
	LINK		lnk;
	TC		c;
	ERR		err;

	if ( (c = *tadp) == TNULL ) {
		/* TNULL Ͻ񤭹ޤʤ */
		++tadp;
		return ER_OK;
	}

	switch ( TSTR::ttype(c) ) {
	  case TSTR::TChar:
		if ( fast ) {
			len = tadp.get(str, lang);
			err = puts((TC*)str, lang, len);
			if ( err < ER_OK ) goto err_ret;
			tadp += len;
		} else {
			TC	ch;
			tadp.get(ch, lang);
			err = putc(ch, lang);
			if ( err < ER_OK ) goto err_ret;
			++tadp;
		}
		break;

	  case TSTR::TSeg:
		tadp.get(seg);
		err = seg.dup();
		if ( err < ER_OK ) goto err_ret;
		err = seg.cnvendian(bigEndian);
		if ( err < ER_OK ) goto err_ret;
		err = putseg(seg);
		if ( err < ER_OK ) goto err_ret;
		++tadp;
		break;

	  case TSTR::TNest:
		tadp.get(nst);
		err = puttad(*nst.tad, vid);
		if ( err < ER_OK ) goto err_ret;
		++tadp;
		break;

	  case TSTR::TVobj:
		tadp.get(vob);
		err = vob.getseg(seg, lnk, vid);
		if ( err < ER_OK ) goto err_ret;
		err = seg.cnvendian(bigEndian);
		if ( err < ER_OK ) goto err_ret;
		err = putseg(seg, lnk);
		if ( err < ER_OK ) goto err_ret;
		++tadp;
		break;
	}

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TADIO::puttad(TADP) err = %d\n", err));
	return err;
}

/*
 * TAD ǡ񤭹
 *	ְ߰ʹߤ tad ˴ޤޤ뤹٤ƤΥǡ񤭹ࡣ
 *	ΤޤߥǥѴԤ롣
 *	vid ¸μ¿ȤؤID
 *	Ȥ¸ȤѴ(ocnv_vob)˻Ѥ롣
 *	vid = 0 ξϤѴϹԤʤ
 */
ERR TADIO::puttad( TAD &tad, W vid )
{
	TADP	tadp(tad);
	ERR	err;

	while ( !tadp.isend() ) {
		err = puttad(tadp, vid, true);
		if ( err < ER_OK ) goto err_ret;
	}

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TADIO::puttad(TAD) err = %d\n", err));
	return err;
}

/* ------------------------------------------------------------------------ */
/*
 *	class TADRecIO
 *	TAD եϥ饹
 */

/*
 * 󥹥ȥ饯
 */
TADRecIO::TADRecIO( BIO &bio )
{
	this->bio = &bio;
	prev_lang = cur_lang = TSC_SYS;
	prev_pos = 0;
	lnkpos = prev_lnkpos = 0;
	tcbuf = TNULL;
}

/*
 * Хåեեå
 *	񤭹ߤԤä硢ޤ񤭽ФƤʤǡ
 *	٤ƽ񤭽Ф롣
 */
ERR TADRecIO::flush()
{
	ERR	err;

	err = bio->flush();
	if ( err < ER_OK ) goto err_ret;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TADRecIO::flush err = %d\n", err));
	return err;
}

/*
 * ɤ߹ߥХåե(tcbuf)ˣʸɤ߹ࡣ
 * Ǥɤ߹ޤƤȤɤ߹ޤʤ
 */
WERR TADRecIO::read_one()
{
	ERR	err;

	if ( tcbuf != TNULL ) return tcbuf; /* Ǥɤ߹ޤƤ */

	do {
		/* ɤ߹ */
		err = bio->read(&tcbuf, sizeof(TC));
		if ( err < ER_OK ) goto err_ret;
		if ( err < (W)sizeof(TC) ) {
			/* ǡü */
			return tcbuf = TNULL;
		}

		tcbuf = ConvEndianH(tcbuf);

	/* TNULL ̵뤷Ƽɤ߹ */
	} while ( tcbuf == TNULL );

	return tcbuf;

err_ret:
	DEBUG_PRINT(("TADRecIO::read_one err = %d\n", err));
	return err;
}

/*
 * ֤߰ɤ߹֤߰ȤƵϿ
 */
void TADRecIO::save_pos()
{
	prev_lang = cur_lang;
	prev_pos = bio->pos();
	if ( tcbuf != TNULL ) prev_pos -= sizeof(TC);
	prev_lnkpos = lnkpos;
}

/*
 * ʸɤ߽Ф
 *	֤߰飱ʸɤ߽Ф(TC)֤
 *	ꥳɤϲᤵ졢ʸȤͤˤ֤ʤ
 *	lang ˤʸθ(TLANG)֤
 *	֤߰ɤ߽Фʬʤ롣
 *
 *	֤߰ȤǤȤϡͤ˥ID(>=0xff80)
 *	֤֤߰Ѳʤ
 *
 *	ǡνüǤСͤˣ֤
 */
WERR TADRecIO::getc( W &lang )
{
	W	tc;
	W	i, n;
	ERR	err;

	/* ɤ߹֤߰Ͽ */
	save_pos();

	tc = read_one();
	if ( tc < ER_OK ) { err = tc; goto err_ret; }

	/* ȤޤϽü */
	if ( tc >= 0xff80 || tc == TNULL ) return tc;

	tcbuf = TNULL;  /* ɤ߹ߥХåե򥯥ꥢ */

	n = 0;
	while ( (i = isTLANGch(tc, &n)) != 0 ) {
		cur_lang = i;

		tc = read_one();
		if ( tc < ER_OK ) { err = tc; goto err_ret; }

		/* ȤޤϽü */
		if ( tc >= 0xff80 || tc == TNULL ) return tc;

		tcbuf = TNULL;  /* ɤ߹ߥХåե򥯥ꥢ */
	}

	lang = cur_lang;
	return tc;

err_ret:
	DEBUG_PRINT(("TADRecIO::getc err = %d\n", err));
	return err;
}

/*
 * ɤ߽Ф
 *	֤߰飱ɤ߽Ф str ֤
 *	 max ʸ(TC)ޤ str ˳Ǽ졢max ʸ̤Ǥ
 *	Ǹ TNULL Ǽ롣
 *	ޤϥȤޤǤ򣱹ԤȤ롣
 *	ޤ str ˳Ǽ롣ȤϳǼʤ
 *	ꥳɤϲᤵ뤬str ˤ⤽Τޤ޳Ǽ롣
 *	ꥳɤ max ʸãϡθ
 *	ɤľޤǤ str ˳Ǽ롣
 *	lang  str Ƭθ(TLANG)֤
 *	ͤɤ߽Фʸ(TC)֤
 *	֤߰ɤ߽Фʬʤ롣
 *
 *	֤߰ȤǤȤϡstr Ƭ˥ID
 *	(>=0xff80)ΤߤǼ롣֤߰Ѳʤ
 *
 *	ǡνüǤСͤˣ֤
 */
WERR TADRecIO::gets( TC *str, W max, W &lang )
{
	TC	*p = str;
	TC	*ep = p + max;
	TC	*sv_p = NULL;
	W	sv_lang;
	W	sv_pos;
	W	tc;
	W	i, n;
	ERR	err;

	/* ɤ߹֤߰Ͽ */
	save_pos();

	tc = read_one();
	if ( tc < ER_OK ) { err = tc; goto err_ret; }

	/* ȤޤϽü */
	if ( tc == TNULL ) return 0;
	if ( tc >= 0xff80 ) {
		if ( max <= 0 ) return 0;
		*str = tc;
		return 1;
	}

	n = 0;
	while ( p < ep ) {
		/* ȤޤϽüʤ齪 */
		if ( tc >= 0xff80 || tc == TNULL ) break;

		*p++ = tc;
		tcbuf = TNULL;  /* ɤ߹ߥХåե򥯥ꥢ */

		/* ʤ齪 */
		if ( tc == TK_NL ) break;

		i = isTLANGch(tc, &n);
		if ( i != 0 ) {
			if ( i == -2 ) {
				if ( sv_p == NULL ) {
					/* ꥳɤγϰ֤ݻ */
					sv_pos = bio->pos() - sizeof(TC);
					sv_lang = cur_lang;
					sv_p = p - 1;
				}
			} else {
				sv_p = NULL;
				cur_lang = i;
			}
		}

		tc = read_one();
		if ( tc < ER_OK ) { err = tc; goto err_ret; }
	}
	if ( sv_p != NULL ) {
		/* ꥳɤγϰ֤ޤ᤹ */
		err = bio->seek(sv_pos, RecIO::SeekSet);
		if ( err < ER_OK ) goto err_ret;
		tcbuf = TNULL;
		cur_lang = sv_lang;
		p = sv_p;
	}
	if ( p < ep ) *p = TNULL;

	lang = prev_lang;
	return p - str;

err_ret:
	DEBUG_PRINT(("TADRecIO::gets err = %d\n", err));
	return err;
}

/*
 * ɤ߽Ф
 *	֤߰飱ɤ߽Ф seg ֤
 *	ͤ˥ID(>=0xff80)֤
 *	֤߰ɤ߽Фʬʤ롣
 *	(body)ϥǥѴʤ
 *
 *	ɤ߽ФȤȥȤξ硢βȤΥ󥯥쥳ɤ
 *	lnk ֤롣ȥȰʳξϡlnk ˤϲ֤ʤ
 *
 *	֤߰ȤǤʤȤϡͤ˸֤߰Υǡ(TC)
 *	֤seg ƤѲʤ֤߰Ѳʤ
 *
 *	ǡνüǤСͤˣ֤
 */
WERR TADRecIO::getseg( TSEG &seg, LINK &lnk )
{
	TC	id;
	W	tc, len;
	UH	tmp;
	ERR	err;

	/* ɤ߹֤߰Ͽ */
	save_pos();

	tc = read_one();
	if ( tc < ER_OK ) { err = tc; goto err_ret; }

	/* ʸޤϽü */
	if ( tc < 0xff80 ) return tc;

	/* ID */
	id = tc;
	tcbuf = TNULL;  /* ɤ߹ߥХåե򥯥ꥢ */

	/* Ĺ */
	err = bio->read(&tmp, sizeof(UH));
	if ( err < (W)sizeof(UH) ) goto err_eof;
	if ( tmp == 0xffff ) {
		err = bio->read(&len, sizeof(UW));
		if ( err < (W)sizeof(UW) ) goto err_eof;
		len = ConvEndianW(len);
	} else {
		len = ConvEndianH(tmp);
	}
	if ( len < 0 ) { err = ER_LIMIT; goto err_ret; }

	/* γǼѤΥ꡼ */
	err = seg.set(id, len, NULL);
	if ( err < ER_OK ) goto err_ret;

	/* ɤ߹ */
	err = bio->read(seg->body, len);
	if ( err < len ) goto err_eof;

	if ( id == (TS_VOBJ | 0xff00) ) {
		/* ȥȤΥ󥯥쥳ɤɹ */
		err = bio->read_link(lnk);
		if ( err < ER_OK ) goto err_ret;
		lnkpos++;
	}

	return id;

err_eof:
	if ( err >= 0 ) err = 0;
err_ret:
	DEBUG_PRINT(("TADRecIO::getseg err = %d\n", err));
	return err;
}

/*
 * ɤ߽Ф
 *	֤߰飱ɤ߽Ф seg ֤
 *	ͤ˥ID(>=0xff80)֤
 *	֤߰ɤ߽Фʬʤ롣
 *	(body)ϥǥѴʤ
 *
 *	֤߰ȤǤʤȤϡͤ˸֤߰Υǡ(TC)
 *	֤seg ƤѲʤ֤߰Ѳʤ
 *
 *	ǡνüǤСͤˣ֤
 */
WERR TADRecIO::getseg( TSEG &seg )
{
	LINK	lnk;

	return getseg(seg, lnk);
}

/*
 * 
 *	ɤ߽Ф֤ޤǸ֤᤹߰
 *	unget() 򣲲ʾϢ³ƸƤӽФȤϽʤ
 */
ERR TADRecIO::unget()
{
	ERR	err;

	err = bio->seek_linkrec(prev_lnkpos, RecIO::SeekSet);
	if ( err < ER_OK ) goto err_ret;

	err = bio->seek(prev_pos, RecIO::SeekSet);
	if ( err < ER_OK ) goto err_ret;

	tcbuf = TNULL;
	cur_lang = prev_lang;
	lnkpos = prev_lnkpos;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TADRecIO::unget err = %d\n", err));
	return err;
}

/*
 * ʸ񤭹
 */
ERR TADRecIO::write_one( TC ch )
{
	ERR	err;

	ch = ConvEndianH(ch);
	err = bio->write(&ch, sizeof(TC));
	if ( err < ER_OK ) goto err_ret;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TADRecIO::write_one err = %d\n", err));
	return err;
}

/*
 * ꥳɤν񤭹
 */
ERR TADRecIO::write_lang( TLANG lang )
{
	TC	*s, *p;
	W	n;
	ERR	err;

	n = TLANGtoTC(NULL, 0, lang);
	s = new(nothrow) TC[n];
	if ( s == NULL ) { err = ER_NOMEM; goto err_ret; }

	TLANGtoTC(s, n, lang);

	p = s;
	while ( n-- > 0 ) {
		err = write_one(*p++);
		if ( err < ER_OK ) goto err_ret;
	}
	cur_lang = lang;

	delete s;

	return ER_OK;

err_ret:
	delete s;
	DEBUG_PRINT(("TADRecIO::write_lang err = %d\n", err));
	return err;
}

/*
 * ʸ񤭹
 *	֤߰ ch 񤭹ࡣ
 *	lang ˤϡch θ(TLANG)ꤹ롣
 *	ߤθ줬 lang ȰۤʤäƤСlang θꥳɤ
 *	񤭹ޤ롣lang <= 0 ξϡlang θꥳ
 *	Ͻ񤭹ޤʤ
 */
ERR TADRecIO::putc( TC ch, W lang )
{
	ERR	err;

	if ( lang != cur_lang && lang > 0 ) {
		/* ꥳɤν񤭹 */
		err = write_lang(lang);
		if ( err < ER_OK ) goto err_ret;
	}

	/* ʸ񤭹 */
	err = write_one(ch);
	if ( err < ER_OK ) goto err_ret;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TADRecIO::putc err = %d\n", err));
	return err;
}

/*
 * Խ񤭹
 *	֤߰ str 񤭹ࡣ
 *	len < 0 ʤ TNULL ľޤǽ񤭹ࡣ
 *	len >= 0 ʤ len ʸ(TC)ޤǤǡ TNULL ľޤ
 *	lang ˤϡstr Ƭθ(TLANG)ꤹ롣
 *	ߤθ줬 lang ȰۤʤäƤСlang θꥳɤ
 *	񤭹ޤ롣lang <= 0 ξϡlang θꥳɤ
 *	񤭹ޤʤ
 *	str ˥ȤޤޤƤƤϤʤ
 */
ERR TADRecIO::puts( TC *str, W lang, W len )
{
	TC	ch;
	W	i, n;
	ERR	err;

	if ( lang != cur_lang && lang > 0 ) {
		/* ꥳɤν񤭹 */
		err = write_lang(lang);
		if ( err < ER_OK ) goto err_ret;
	}

	n = 0;
	while ( len-- != 0 && (ch = *str++) != TNULL ) {
		i = isTLANGch(ch, &n);
		if ( i != 0 ) cur_lang = i;

		err = write_one(ch);
		if ( err < ER_OK ) goto err_ret;
	}

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TADRecIO::puts err = %d\n", err));
	return err;
}

/*
 * Ƚ񤭹
 *	֤߰ seg 񤭹ࡣ
 *	(body)ϥǥѴʤ
 *
 *	putseg(seg, lnk) ξϡseg ȥȤǤС
 *	lnk 󥯥쥳ɤ˽񤭹ࡣ
 */
ERR TADRecIO::putseg( TSEG &seg, LINK &lnk )
{
	ERR	err;

	err = write_one(seg.id);
	if ( err < ER_OK ) goto err_ret;

	if ( seg->len < 0xffff ) {
		UH len = ConvEndianH(seg->len);
		err = bio->write(&len, sizeof(UH));
		if ( err < ER_OK ) goto err_ret;
	} else {
		UW len = ConvEndianW(seg->len);
		err = bio->write(&len, sizeof(UW));
		if ( err < ER_OK ) goto err_ret;
	}

	err = bio->write(seg->body, seg->len);
	if ( err < ER_OK ) goto err_ret;

	if ( seg.id == (TS_VOBJ | 0xff00) ) {
		/* 󥯥쥳ɤν񤭽Ф */
		err = bio->write_link(lnk);
		if ( err < ER_OK ) goto err_ret;
	}

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TADRecIO::putseg err = %d\n", err));
	return err;
}

/*
 * Ƚ񤭹
 *	֤߰ seg 񤭹ࡣ
 *	(body)ϥǥѴʤ
 */
ERR TADRecIO::putseg( TSEG &seg )
{
	LINK	lnk;

	return putseg(seg, lnk);
}

/*
 * ֤߰θμ
 *	ͤ˸֤߰θ(TLANG)֤
 */
W TADRecIO::getlang()
{
	return cur_lang;
}

/*
 * ֤߰θ
 *	֤߰θ lang ѹ롣
 *	ǡΤѹʤ줬ڤؤäƤꥳ
 *	ϥǡ˽񤭹ޤʤ
 */
void TADRecIO::setlang( TLANG lang )
{
	cur_lang = lang;
}

/* ------------------------------------------------------------------------ */
/*
 *	class TADTrayIO
 *	TAD ȥ졼ϥ饹
 */

/*
 * 󥹥ȥ饯
 */
TADTrayIO::TADTrayIO( TrayIO &tio, bool save )
{
	this->tio = &tio;
	this->save = save;
	prev.lang = cur.lang = TSC_SYS;
	prev.recno = cur.recno = 0;
	prev.ofs = cur.ofs = 0;
	trec = &tio.buf;
	trec->clean();
	trec->id = 0;
	tcbuf = TNULL;
}

/*
 * ȥ졼쥳ɤɤ߽Ф
 */
WERR TADTrayIO::read_trec( W recno )
{
	W	sz;

	if ( !save ) trec->clean();

	sz = tio->get_trec(recno, trec);
#ifdef DEBUG
	if ( sz < ER_OK ) DEBUG_PRINT(("TADTrayIO::read_trec err = %d\n", sz));
#endif
	return sz;
}

/*
 * ɤ߹ߥХåե(tcbuf)ˣʸɤ߹ࡣ
 * Ǥɤ߹ޤƤȤɤ߹ޤʤ
 */
WERR TADTrayIO::read_one()
{
	ERR	err;

	if ( tcbuf != TNULL ) return tcbuf; /* Ǥɤ߹ޤƤ */

	do {
		if ( cur.ofs >= trec->len ) {
			/* Υ쥳ɤɤ߽Ф */
			err = read_trec(++cur.recno);
			if ( err < ER_OK ) {
				if ( err != ER_REC ) goto err_ret;
				return TNULL; // ǡü
			}
			cur.ofs = 0;
		}

		switch ( trec->id ) {
		  case TR_TEXT:
		  case TR_FIG:
			cur.ofs += trec->read(cur.ofs, &tcbuf, sizeof(TC));
			tcbuf = ConvEndianH(tcbuf);
			break;
		  case TR_VOBJ:
			tcbuf = TS_VOBJ | 0xff00;
			break;
		  default:
			tcbuf = trec->id & 0xff | 0xff00;
		}

	/* TNULL ̵뤷Ƽɤ߹ */
	} while ( tcbuf == TNULL );

	return tcbuf;

err_ret:
	DEBUG_PRINT(("TADTrayIO::read_one err = %d\n", err));
	return err;
}

/*
 * ֤߰ɤ߹֤߰ȤƵϿ
 */
void TADTrayIO::save_pos()
{
	prev = cur;
	if ( (trec->id == TR_TEXT || trec->id == TR_FIG)
	  && tcbuf != TNULL ) prev.ofs -= sizeof(TC);
}

/*
 * ʸɤ߽Ф
 *	֤߰飱ʸɤ߽Ф(TC)֤
 *	ꥳɤϲᤵ졢ʸȤͤˤ֤ʤ
 *	lang ˤʸθ(TLANG)֤
 *	֤߰ɤ߽Фʬʤ롣
 *
 *	֤߰ȤǤȤϡͤ˥ID(>=0xff80)
 *	֤֤߰Ѳʤ
 *
 *	ǡνüǤСͤˣ֤
 */
WERR TADTrayIO::getc( W &lang )
{
	W	tc;
	W	i, n;
	ERR	err;

	/* ɤ߹֤߰Ͽ */
	save_pos();

	tc = read_one();
	if ( tc < ER_OK ) { err = tc; goto err_ret; }

	/* ȤޤϽü */
	if ( tc >= 0xff80 || tc == TNULL ) return tc;

	tcbuf = TNULL;  /* ɤ߹ߥХåե򥯥ꥢ */

	n = 0;
	while ( (i = isTLANGch(tc, &n)) != 0 ) {
		cur.lang = i;

		tc = read_one();
		if ( tc < ER_OK ) { err = tc; goto err_ret; }

		/* ȤޤϽü */
		if ( tc >= 0xff80 || tc == TNULL ) return tc;

		tcbuf = TNULL;  /* ɤ߹ߥХåե򥯥ꥢ */
	}

	lang = cur.lang;
	return tc;

err_ret:
	DEBUG_PRINT(("TADTrayIO::getc err = %d\n", err));
	return err;
}

/*
 * ɤ߽Ф
 *	֤߰飱ɤ߽Ф str ֤
 *	 max ʸ(TC)ޤ str ˳Ǽ졢max ʸ̤Ǥ
 *	Ǹ TNULL Ǽ롣
 *	ޤϥȤޤǤ򣱹ԤȤ롣
 *	ޤ str ˳Ǽ롣ȤϳǼʤ
 *	ꥳɤϲᤵ뤬str ˤ⤽Τޤ޳Ǽ롣
 *	ꥳɤ max ʸãϡθ
 *	ɤľޤǤ str ˳Ǽ롣
 *	lang  str Ƭθ(TLANG)֤
 *	ͤɤ߽Фʸ(TC)֤
 *	֤߰ɤ߽Фʬʤ롣
 *
 *	֤߰ȤǤȤϡstr Ƭ˥ID
 *	(>=0xff80)ΤߤǼ롣֤߰Ѳʤ
 *
 *	ǡνüǤСͤˣ֤
 */
WERR TADTrayIO::gets( TC *str, W max, W &lang )
{
	TC		*p = str;
	TC		*ep = p + max;
	TC		*sv_p = NULL;
	struct pos	sv;
	W		tc;
	W		i, n;
	ERR		err;

	/* ɤ߹֤߰Ͽ */
	save_pos();

	tc = read_one();
	if ( tc < ER_OK ) { err = tc; goto err_ret; }

	/* ȤޤϽü */
	if ( tc == TNULL ) return 0;
	if ( tc >= 0xff80 ) {
		if ( max <= 0 ) return 0;
		*str = tc;
		return 1;
	}

	n = 0;
	while ( p < ep ) {
		/* ȤޤϽüʤ齪 */
		if ( tc >= 0xff80 || tc == TNULL ) break;

		*p++ = tc;
		tcbuf = TNULL;  /* ɤ߹ߥХåե򥯥ꥢ */

		/* ʤ齪 */
		if ( tc == TK_NL ) break;

		i = isTLANGch(tc, &n);
		if ( i != 0 ) {
			if ( i == -2 ) {
				if ( sv_p == NULL ) {
					/* ꥳɤγϰ֤ݻ */
					sv = cur;
					sv.ofs -= sizeof(TC);
					sv_p = p - 1;
				}
			} else {
				sv_p = NULL;
				cur.lang = i;
			}
		}

		tc = read_one();
		if ( tc < ER_OK ) { err = tc; goto err_ret; }
	}
	if ( sv_p != NULL ) {
		/* ꥳɤγϰ֤ޤ᤹ */
		err = move_pos(sv);
		if ( err < ER_OK ) goto err_ret;
		p = sv_p;
	}
	if ( p < ep ) *p = TNULL;

	lang = prev.lang;
	return p - str;

err_ret:
	DEBUG_PRINT(("TADTrayIO::gets err = %d\n", err));
	return err;
}

/*
 * ʸϡ޷ɤ߹
 */
ERR TADTrayIO::read_seg( W id, TSEG &seg )
{
	UW	len;
	UH	tmp;
	ERR	err;

	/* Ĺ */
	cur.ofs += trec->read(cur.ofs, &tmp, sizeof(UH));
	if ( tmp == 0xffff ) {
		cur.ofs += trec->read(cur.ofs, &len, sizeof(UW));
		len = ConvEndianW(len);
	} else {
		len = ConvEndianH(tmp);
	}

	/* γǼѤΥ꡼ */
	err = seg.set(id, len, NULL);
	if ( err < ER_OK ) goto err_ret;

	/* ɤ߹ */
	cur.ofs += trec->read(cur.ofs, seg->body, len);

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TADTrayIO::read_seg err = %d\n", err));
	return err;
}

/*
 * ȥɤ߹
 */
ERR TADTrayIO::read_vobj( TSEG &seg, LINK &lnk )
{
	UW	len;
	ERR	err;

	/* Ĺ */
	len = trec->len - sizeof(VLINK);

	/* γǼѤΥ꡼ */
	err = seg.set(TS_VOBJ | 0xff00, len, NULL);
	if ( err < ER_OK ) goto err_ret;

	/* ɤ߹ */
	trec->read(sizeof(VLINK), seg->body, len);

	/* 󥯥쥳ɤ߹ */
	trec->read(0, &lnk, sizeof(LINK));

	cur.ofs = trec->len;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TADTrayIO::read_vobj err = %d\n", err));
	return err;
}

/*
 * ¾ɤ߹
 */
ERR TADTrayIO::read_segrec( TSEG &seg )
{
	UW	len;
	UB	*p;
	ERR	err;

	/* Ĺ */
	len = tio->get_trecsize(cur.recno);

	/* γǼѤΥ꡼ */
	err = seg.set(trec->id & 0xff | 0xff00, len, NULL);
	if ( err < ER_OK ) goto err_ret;

	for ( p = seg->body;; ) {
		/* ɤ߹ */
		p += trec->read(0, p, trec->len);

		if ( (trec->id & TR_CONT) == 0 ) break;

		/* Υ쥳ɤɤ߹ */
		err = read_trec(++cur.recno);
		if ( err < ER_OK ) goto err_ret;
	}

	cur.ofs = trec->len;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TADTrayIO::read_segrec err = %d\n", err));
	return err;
}

/*
 * ɤ߽Ф
 *	֤߰飱ɤ߽Ф seg ֤
 *	ͤ˥ID(>=0xff80)֤
 *	֤߰ɤ߽Фʬʤ롣
 *	(body)ϥǥѴʤ
 *
 *	ɤ߽ФȤȥȤξ硢βȤΥ󥯥쥳ɤ
 *	lnk ֤롣ȥȰʳξϡlnk ˤϲ֤ʤ
 *
 *	֤߰ȤǤʤȤϡͤ˸֤߰Υǡ(TC)
 *	֤seg ƤѲʤ֤߰Ѳʤ
 *
 *	ǡνüǤСͤˣ֤
 */
WERR TADTrayIO::getseg( TSEG &seg, LINK &lnk )
{
	TC	id;
	W	tc;
	ERR	err;

	/* ɤ߹֤߰Ͽ */
	save_pos();

	tc = read_one();
	if ( tc < ER_OK ) { err = tc; goto err_ret; }

	/* ʸޤϽü */
	if ( tc < 0xff80 ) return tc;

	/* ID */
	id = tc;
	tcbuf = TNULL;  /* ɤ߹ߥХåե򥯥ꥢ */

	switch ( trec->id ) {
	  case TR_TEXT:
	  case TR_FIG:
		err = read_seg(id, seg);
		if ( err < ER_OK ) goto err_ret;
		break;
	  case TR_VOBJ:
		err = read_vobj(seg, lnk);
		if ( err < ER_OK ) goto err_ret;
		break;
	  default:
		err = read_segrec(seg);
		if ( err < ER_OK ) goto err_ret;
	}

	return id;

err_ret:
	DEBUG_PRINT(("TADTrayIO::getseg err = %d\n", err));
	return err;
}

/*
 * ɤ߽Ф
 *	֤߰飱ɤ߽Ф seg ֤
 *	ͤ˥ID(>=0xff80)֤
 *	֤߰ɤ߽Фʬʤ롣
 *	(body)ϥǥѴʤ
 *
 *	֤߰ȤǤʤȤϡͤ˸֤߰Υǡ(TC)
 *	֤seg ƤѲʤ֤߰Ѳʤ
 *
 *	ǡνüǤСͤˣ֤
 */
WERR TADTrayIO::getseg( TSEG &seg )
{
	LINK	lnk;

	return getseg(seg, lnk);
}

/*
 * ֤߰ΰư
 */
ERR TADTrayIO::move_pos( struct pos &p )
{
	ERR	err;

	if ( cur.recno != p.recno ) {
		/* ȥ졼쥳ɤɤ߽Ф */
		err = read_trec(p.recno);
		if ( err < ER_OK ) goto err_ret;
	}

	cur = p;
	tcbuf = TNULL;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TADTrayIO::move_pos err = %d\n", err));
	return err;
}

/*
 * 
 *	ɤ߽Ф֤ޤǸ֤᤹߰
 *	unget() 򣲲ʾϢ³ƸƤӽФȤϽʤ
 */
ERR TADTrayIO::unget()
{
	ERR	err;

	err = move_pos(prev);
#ifdef DEBUG
	if ( err < ER_OK ) DEBUG_PRINT(("TADTrayIO::unget err = %d\n", err));
#endif
	return err;
}

/*
 * 쥳ɤѰդ
 */
ERR TADTrayIO::create_trec( W id )
{
	ERR	err;

	if ( trec->dt != NULL ) {
		/* ߥ쥳ɤ񤭹 */
		err = tio->put_trec(*trec);
		if ( err < ER_OK ) goto err_ret;
	}

	/* 쥳ɤѰ */
	trec->clean();
	trec->id = id;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TADTrayIO::create_trec err = %d\n", err));
	return err;
}

/*
 * ʸ񤭹
 */
ERR TADTrayIO::write_str( TC *str, W len )
{
	ERR	err;

	/* ʸϥ쥳ɤǤʤСʸϥ쥳ɤɲ */
	if ( trec->id != TR_TEXT ) {
		err = create_trec(TR_TEXT);
		if ( err < ER_OK ) goto err_ret;
	}

	/* ʸν񤭹 */
	err = trec->put_tc(str, len);
	if ( err < ER_OK ) {
		if ( err != ER_LIMIT ) goto err_ret;

		/* 쥳ɲ */
		err = create_trec(TR_TEXT);
		if ( err < ER_OK ) goto err_ret;

		/* ١ʸ񤭹ľ */
		err = trec->put_tc(str, len);
		if ( err < ER_OK ) goto err_ret;
	}

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TADTrayIO::write_str err = %d\n", err));
	return err;
}

/*
 * ꥳɤν񤭹
 */
ERR TADTrayIO::write_lang( TLANG lang )
{
	TC	*s;
	W	n;
	ERR	err;

	n = TLANGtoTC(NULL, 0, lang);
	s = new(nothrow) TC[n];
	if ( s == NULL ) { err = ER_NOMEM; goto err_ret; }

	TLANGtoTC(s, n, lang);

	/* ꥳɤν񤭹 */
	err = write_str(s, n);
	if ( err < ER_OK ) goto err_ret;

	cur.lang = lang;

	delete s;

	return ER_OK;

err_ret:
	delete s;
	DEBUG_PRINT(("TADTrayIO::write_lang err = %d\n", err));
	return err;
}

/*
 * ʸ񤭹
 *	֤߰ ch 񤭹ࡣ
 *	lang ˤϡch θ(TLANG)ꤹ롣
 *	ߤθ줬 lang ȰۤʤäƤСlang θꥳɤ
 *	񤭹ޤ롣lang <= 0 ξϡlang θꥳ
 *	Ͻ񤭹ޤʤ
 */
ERR TADTrayIO::putc( TC ch, W lang )
{
	ERR	err;

	if ( lang != cur.lang && lang > 0 ) {
		/* ꥳɤν񤭹 */
		err = write_lang(lang);
		if ( err < ER_OK ) goto err_ret;
	}

	/* ʸ񤭹 */
	err = write_str(&ch, 1);
	if ( err < ER_OK ) goto err_ret;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TADTrayIO::putc err = %d\n", err));
	return err;
}

/*
 * Խ񤭹
 *	֤߰ str 񤭹ࡣ
 *	len < 0 ʤ TNULL ľޤǽ񤭹ࡣ
 *	len >= 0 ʤ len ʸ(TC)ޤǤǡ TNULL ľޤ
 *	񤭹ࡣ
 *	lang ˤϡstr Ƭθ(TLANG)ꤹ롣
 *	ߤθ줬 lang ȰۤʤäƤСlang θꥳɤ
 *	񤭹ޤ롣lang <= 0 ξϡlang θꥳ
 *	Ͻ񤭹ޤʤ
 *	str ˥ȤޤޤƤƤϤʤ
 */
ERR TADTrayIO::puts( TC *str, W lang, W len )
{
	TC	ch, *p;
	W	i, n;
	ERR	err;

	if ( lang != cur.lang && lang > 0 ) {
		/* ꥳɤν񤭹 */
		err = write_lang(lang);
		if ( err < ER_OK ) goto err_ret;
	}

	p = NULL;
	n = 0;
	while ( len-- != 0 && (ch = *str++) != TNULL ) {
		i = isTLANGch(ch, &n);
		if ( i != 0 ) {
			if ( p == NULL ) {
				/* ꥳɤγϰ֤¸ */
				p = str - 1;
			}
			if ( i == -2 ) continue;

			/* ꥳɤν񤭽Ф */
			err = write_str(p, str - p);
			if ( err < ER_OK ) goto err_ret;

			p = NULL;
			cur.lang = i;
			continue;
		}

		err = write_str(&ch, 1);
		if ( err < ER_OK ) goto err_ret;
	}

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TADTrayIO::puts err = %d\n", err));
	return err;
}

/*
 * ʸϡ޷Ƚ񤭹
 */
ERR TADTrayIO::write_seg( W id, TSEG &seg )
{
	ERR	err;

	/* 쥳ɥפۤʤäƤСɲ */
	if ( trec->id != id ) {
		err = create_trec(id);
		if ( err < ER_OK ) goto err_ret;
	}

	/* Ƚ񤭹 */
	err = trec->put_seg(seg);
	if ( err < ER_OK ) {
		if ( err != ER_LIMIT ) goto err_ret;

		/* 쥳ɲ */
		err = create_trec(id);
		if ( err < ER_OK ) goto err_ret;

		/* ١Ȥ񤭹ľ */
		err = trec->put_seg(seg);
		if ( err < ER_OK ) goto err_ret;
	}

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TADTrayIO::write_seg err = %d\n", err));
	return err;
}

/*
 * ȥȽ񤭹
 */
ERR TADTrayIO::write_vobj( TSEG &seg, LINK &lnk )
{
	ERR	err;

	/* 쥳ɺ */
	err = create_trec(TR_VOBJ);
	if ( err < ER_OK ) goto err_ret;

	/* 󥯥쥳ɽ񤭹 */
	err = trec->put(&lnk, sizeof(VLINK));
	if ( err < ER_OK ) goto err_ret;

	/* ȥȽ񤭹 */
	err = trec->put(seg->body, seg->len);
	if ( err < ER_OK ) goto err_ret;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TADTrayIO::write_vobj err = %d\n", err));
	return err;
}

/*
 * ¾Ƚ񤭹
 */
ERR TADTrayIO::write_segrec( TSEG &seg )
{
	ERR	err;

	/* 쥳ɺ */
	err = create_trec(seg.id & 0x00ff);
	if ( err < ER_OK ) goto err_ret;

	/* Ƚ񤭹 */
	err = trec->put(seg->body, seg->len);
	if ( err < ER_OK ) goto err_ret;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TADTrayIO::write_segrec err = %d\n", err));
	return err;
}

/*
 * Ƚ񤭹
 *	֤߰ seg 񤭹ࡣ
 *	(body)ϥǥѴʤ
 *
 *	seg ȥȤǤСlnk 󥯥쥳ɤ˽񤭹ࡣ
 */
ERR TADTrayIO::putseg( TSEG &seg, LINK &lnk )
{
	W	id;
	ERR	err;

	/* Ȥбȥ졼쥳ɥ */
	id = seg.id & 0x00ff;
	if ( seg.id >= (TS_TPAGE | 0xff00)
	  && seg.id <= (TS_TAPPL | 0xff00) ) id = TR_TEXT;
	if ( seg.id >= (TS_FPRIM | 0xff00)
	  && seg.id <= (TS_FAPPL | 0xff00) ) id = TR_FIG;
	if ( seg.id == (TS_VOBJ  | 0xff00) ) id = TR_VOBJ;

	switch ( id ) {
	  case TR_TEXT:
	  case TR_FIG:
		err = write_seg(id, seg);
		if ( err < ER_OK ) goto err_ret;
		break;
	  case TR_VOBJ:
		err = write_vobj(seg, lnk);
		if ( err < ER_OK ) goto err_ret;
		break;
	  default:
		err = write_segrec(seg);
		if ( err < ER_OK ) goto err_ret;
	}

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TADTrayIO::putseg err = %d\n", err));
	return err;
}

/*
 * Ƚ񤭹
 *	֤߰ seg 񤭹ࡣ
 *	(body)ϥǥѴʤ
 */
ERR TADTrayIO::putseg( TSEG &seg )
{
	LINK	lnk;

	return putseg(seg, lnk);
}

/*
 * ֤߰θμ
 *	ͤ˸֤߰θ(TLANG)֤
 */
W TADTrayIO::getlang()
{
	return cur.lang;
}

/*
 * ֤߰θ
 *	֤߰θ lang ѹ롣
 *	ǡΤѹʤ줬ڤؤäƤꥳ
 *	ϥǡ˽񤭹ޤʤ
 */
void TADTrayIO::setlang( TLANG lang )
{
	cur.lang = lang;
}

/* ------------------------------------------------------------------------ */
} // namespace LIBCPP1
