/*
 *	@(#)tadseg.cc (libcpp1) 01-01-29
 *
 *	TAD ȥ饤֥
 *	(C) Copyright 2000-2001 by Personal Media Corporation
 */

#include "libcpp.h"
#include "cpp/1/tadseg.h"
#include "cpp/1/tadview.h"

namespace LIBCPP1 {

/* ------------------------------------------------------------------------ */
/*
 *	class TSEGF
 *	ǽ TAD 
 */

/*
 * ǥȥ饯
 */
TSEGF::~TSEGF()
{
}

/*
 * 
 */
TSEGF& TSEGF::operator = ( const TSEG &seg )
{
	*static_cast<TSEG*>(this) = seg;
	return *this;
}

/*
 * ǥեͤ
 */
ERR TSEGF::setdefault()
{
	return ER_NOSPT;
}

/*
 * 쥤
 *	ȤƤˤäơ쥤ȾԤ
 *	LATR ϸߤ°Ǥ롣
 *	ʸʤɤ°ѹ륻ȤξϡLATR 
 *	°ꤷƹgid ĶȿǤ롣
 *	޷ǤʤɤԤȤξϡΰ
 *	RECT ֤
 *	PNT ϸߤʸ赯򼨤Ƥ롣ΥȤˤ
 *	ʸ赯ưϡPNT 򹹿֤
 */
ERR TSEGF::layout( W gid, LATR &atr, PNT&, RECT& )
{
	return setgenv(gid, atr);
}

/*
 * Ķ
 *	LATR ϸߤ°Ǥ롣
 *	ʸʤɤ°ѹ륻ȤξϡLATR 
 *	°ꤷƹgid ĶȿǤ롣
 */
ERR TSEGF::setgenv( W gid, LATR& )
{
	return ER_OK;
}

/*
 * 
 *	ȤƤˤäơLVIEW Υ꡼褹롣
 *	LATR ϸߤ°Ǥ롣
 *	ȼʤʸʤɤ°ѹ륻Ȥ
 *	ϡLATR ˤ°ꤷƹLVIEW Ķ
 *	ȿǤ롣
 *	PNT ϸߤʸ赯
 */
ERR TSEGF::draw( const LVIEW &vi, LATR &atr, const LPNT& )
{
	return setgenv(vi.gid, atr);
}

/* ------------------------------------------------------------------------ */
/*
 *	template class TSEGT
 *	ɸƥץ졼
 */

/*
 * 
 */
template< class SEGTYPE >
TSEGT<SEGTYPE>& TSEGT<SEGTYPE>::operator = ( const TSEG &seg )
{
	*static_cast<TSEG*>(this) = seg;
	return *this;
}

/*
 * 쥤
 */
template< class SEGTYPE >
ERR TSEGT<SEGTYPE>::layout( W gid, LATR &atr, PNT&, RECT& )
{
	return setgenv(gid, atr);
}

/*
 * Ķ
 */
template< class SEGTYPE >
ERR TSEGT<SEGTYPE>::setgenv( W gid, LATR& )
{
	return ER_OK;
}

/*
 * 
 */
template< class SEGTYPE >
ERR TSEGT<SEGTYPE>::draw( const LVIEW &vi, LATR &atr, const LPNT& )
{
	return setgenv(vi.gid, atr);
}

/* ------------------------------------------------------------------------ */
/*
 *	class TSEG_LGAP
 *	Դֳֻ
 */

/*
 * ǥեͤ
 */
ERR TSEG_LGAP::setdefault()
{
	ERR	err;

	err = set(TS_TRULER|0xff00, sizeof(TT_LGAP), NULL);
	if ( err < ER_OK ) goto err_ret;

	(*this)->subid = TT_LGAP_SID;
	(*this)->attr  = 0x01;		// Դ֤ʤ
	(*this)->pitch = 0x8000;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TSEG_LGAP::setdefault err = %d\n", err));
	return err;
}

/*
 * Ķ
 */
ERR TSEG_LGAP::setgenv( W gid, LATR &atr )
{
	atr.lgap_atr = (*this)->attr;
	atr.lgap     = (*this)->pitch;

	return ER_OK;
}

/* ------------------------------------------------------------------------ */
/*
 *	class TSEG_TAB
 *	ֽ񼰻
 */

/*
 * 
 */
TSEG_TAB& TSEG_TAB::operator = ( const TSEG &seg )
{
	*static_cast<TSEG*>(this) = seg;
	return *this;
}

/*
 * ǥեͤ
 */
ERR TSEG_TAB::setdefault()
{
	return setdefault(0);
}
ERR TSEG_TAB::setdefault( H paperwid )
{
	W	n, i, x;
	ERR	err;

	n = paperwid / (CHSSTD * 4);

	err = set(TS_TRULER|0xff00, TT_TAB_SIZE(n), NULL);
	if ( err < ER_OK ) goto err_ret;

	(*this)->subid  = TT_TAB_SID;
	(*this)->attr   = 0x00;
	(*this)->height = 0x8000;		// ֳ֤ʤ
	(*this)->pargap = 0x8000;
	(*this)->left   = 0;			// ޡʤ
	(*this)->right  = 0;
	(*this)->indent = 0;
	(*this)->ntabs  = n;			// ֣ʸ
	for ( x = 0, i = 0; i < n; ++i ) (*this)->tabs[i] = (x += CHSSTD * 4);

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TSEG_TAB::setdefault err = %d\n", err));
	return err;
}

/*
 * Ķ
 */
ERR TSEG_TAB::setgenv( W gid, LATR &atr )
{
	atr.tab = *this;

	return ER_OK;
}

/*
 * Υ֥ȥåװ
 */
W TSEG_TAB::nextstop( W xs, W xe, W x )
{
	W	i, xt;

	for ( i = 0; i < (*this)->ntabs; ++i ) {
		xt = xs + (*this)->tabs[i];
		if ( xt > x ) return xt;
	}
	return xe;
}

/* ------------------------------------------------------------------------ */
/*
 *	class TSEG_RATIO
 *	ʸ硿̾
 */

/*
 * ǥեͤ
 */
ERR TSEG_RATIO::setdefault()
{
	ERR	err;

	err = set(TS_TFONT|0xff00, sizeof(TT_RATIO), NULL);
	if ( err < ER_OK ) goto err_ret;

	(*this)->subid   = TT_RATIO_SID;
	(*this)->unused  = 0;
	(*this)->h_ratio = 0x0000;	// 
	(*this)->w_ratio = 0x0000;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TSEG_RATIO::setdefault err = %d\n", err));
	return err;
}

/*
 * Ķ
 */
ERR TSEG_RATIO::setgenv( W gid, LATR &atr )
{
	ERR	err;

	err = atr.setchratio(gid, (*this)->h_ratio, (*this)->w_ratio);
#ifdef DEBUG
	if ( err < ER_OK )
		DEBUG_PRINT(("TSEG_RATIO::setgenv err = %d\n", err));
#endif
	return err;
}

/* ------------------------------------------------------------------------ */
/*
 *	class TSEG_CGAP
 *	ʸֳֻ
 */

/*
 * ǥեͤ
 */
ERR TSEG_CGAP::setdefault()
{
	ERR	err;

	err = set(TS_TFONT|0xff00, sizeof(TT_CGAP), NULL);
	if ( err < ER_OK ) goto err_ret;

	(*this)->subid = TT_CGAP_SID;
	(*this)->attr  = 0x01;		// ʸ֤ʤ
	(*this)->pitch = 0x8000;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TSEG_CGAP::setdefault err = %d\n", err));
	return err;
}

/* ------------------------------------------------------------------------ */
/*
 *	class TSEGU
 *	TAD ȶ
 */

/*
 * 󥹥ȥ饯
 */
TSEGU::TSEGU( TSEG &seg )
{
	switch ( seg.id & 0x00ff ) {
	  case TS_TRULER:		// Խ񼰻
		TRULER(seg);
		break;
	  case TS_TFONT:		// ʸ
		TFONT(seg);
		break;

	  case TS_INFO:			// 󥻥
	  case TS_TEXT:			// ʸϳϥ
	  case TS_TEXTEND:		// ʸϽλ
	  case TS_FIG:			// ޷ϥ
	  case TS_FIGEND:		// ޷λ
	  case TS_IMAGE:		// 
	  case TS_VOBJ:			// ȥ
	  case TS_DFUSEN:		// 䵥
	  case TS_FFUSEN:		// ǽ䵥
	  case TS_SFUSEN:		// 䵥

	  case TS_TPAGE:		// ʸϥڡդ
	  case TS_TCHAR:		// üʸ
	  case TS_TATTR:		// ʸդ
	  case TS_TSTYLE:		// ʸ
	  case TS_TVAR:			// ѿȻ
	  case TS_TMEMO:		// ʸϥ
	  case TS_TAPPL:		// ʸϥץꥱ

	  case TS_FPRIM:		// ޷ǥ
	  case TS_FDEF:			// ǡ
	  case TS_FGRP:			// 롼
	  case TS_FMAC:			// ޥ/ȥ
	  case TS_FATTR:		// ޷
	  case TS_FPAGE:		// ޷ڡդ
	  case TS_FMEMO:		// ޷
	  case TS_FAPPL:		// ޷ץꥱ

	  default:			// 
		new(&buf) TSEGF(seg);
	}
}

/*
 * 󥹥ȥ饯(Խ񼰻)
 */
void TSEGU::TRULER( TSEG &seg )
{
	switch ( seg.subid() ) {
	  case TT_LGAP_SID:		// Դֳֻ
		new(&buf) TSEG_LGAP(seg);
		break;
	  case TT_TAB_SID:		// ֽ񼰻
		new(&buf) TSEG_TAB(seg);
		break;

	  case TT_ALIGN_SID:		// ·
	  case TT_FIELD_SID:		// եɽ񼰻
	  case TT_DIR_SID:		// ʸ
	  case TT_LTOP_SID:		// Ƭư

	  default:			// 
		new(&buf) TSEGF(seg);
	}
}

/*
 * 󥹥ȥ饯(ʸ)
 */
void TSEGU::TFONT( TSEG &seg )
{
	switch ( seg.subid() ) {
	  case TT_RATIO_SID:		// ʸ硿̾
		new(&buf) TSEG_RATIO(seg);
		break;
	  case TT_CGAP_SID:		// ʸֳֻ
		new(&buf) TSEG_CGAP(seg);
		break;

	  case TT_FONT_SID:		// եȻ
	  case TT_FATR_SID:		// ե°
	  case TT_SIZE_SID:		// ʸ
	  case TT_ROTATE_SID:		// ʸž
	  case TT_COLOR_SID:		// ʸ顼
	  case TT_BASE_SID:		// ʸְư

	  default:			// 
		new(&buf) TSEGF(seg);
	}
}

/*
 * ǥȥ饯
 */
TSEGU::~TSEGU()
{
	(*this)->~TSEGF();
}

/* ------------------------------------------------------------------------ */
} // namespace LIBCPP1
