/*
 *	@(#)tadsel.cc (libcpp1) 01-03-03
 *
 *	TAD 쥤ȡƥ
 *	(C) Copyright 2000-2001 by Personal Media Corporation
 */

#include "libcpp.h"
#include "cpp/1/tadview.h"

namespace LIBCPP1 {

/* ------------------------------------------------------------------------ */
/*
 *	LTAD ǡ
 *	class LTADSEL
 */

/*
 * 󥹥ȥ饯
 */
LTADSEL::LTADSEL( LOTAD *t, LVIEW *v )
{
	lotad = t;
	vi = v;
	vis = false;
	act = true;
	sel = false;
	drg = false;
	menuvid = INVALID;
}

/*
 * Ȥ
 */
ERR LTADSEL::setselrgn( RECT *tr, RECT *er )
{
	RECT	trect, erect;
	RECT	scr;
	LRECT	laysz;
	ERR	err;

	menuvid = INVALID;

	/* ɥåƤλѹʤ */
	if ( drg ) return ER_OK;

	/* ǡζμ */
	if ( tr == NULL ) {
		err = lotad->area(*vi, top, trect);
		if ( err < ER_OK ) goto err_ret;
		tr = &trect;
	}
	if ( er == NULL ) {
		err = lotad->area(*vi, end, erect);
		if ( err < ER_OK ) goto err_ret;
		er = &erect;
	}

	/* Ȥ
	 *	Ȥɸ(ɥå)ʬӾ˹Ƥ
	 *	ɬפ롣
	 */
	if ( tr->c.bottom > er->c.top ) {
		/*  */
		selrgn.size = 4;
		selrgn.pt[0].x = tr->c.left - 2;	// pt[0] 
		selrgn.pt[0].y = MIN(tr->c.top, er->c.top) - 2;
		selrgn.pt[1].x = er->c.right;
		selrgn.pt[1].y = selrgn.pt[0].y;
		selrgn.pt[2].x = selrgn.pt[1].x;	// pt[2] 
		selrgn.pt[2].y = MAX(tr->c.bottom, er->c.bottom);
		selrgn.pt[3].x = selrgn.pt[0].x;
		selrgn.pt[3].y = selrgn.pt[2].y;
	} else {
		/* ʣ */
		lotad->layoutsize(laysz);
		vi->scrpos_limit(scr, laysz);
		selrgn.size = 8;
		selrgn.pt[0].x = tr->c.left - 2;	// pt[0] 
		selrgn.pt[0].y = tr->c.top - 2;
		selrgn.pt[1].x = scr.c.right;
		selrgn.pt[1].y = selrgn.pt[0].y;
		selrgn.pt[2].x = selrgn.pt[1].x;
		selrgn.pt[2].y = er->c.top - 2;
		selrgn.pt[3].x = er->c.right;
		selrgn.pt[3].y = selrgn.pt[2].y;
		selrgn.pt[4].x = selrgn.pt[3].x;	// pt[4] 
		selrgn.pt[4].y = er->c.bottom;
		selrgn.pt[5].x = scr.c.left - 2;
		selrgn.pt[5].y = selrgn.pt[4].y;
		selrgn.pt[6].x = selrgn.pt[5].x;
		selrgn.pt[6].y = tr->c.bottom;
		selrgn.pt[7].x = selrgn.pt[0].x;
		selrgn.pt[7].y = selrgn.pt[6].y;
	}
	selrgn.sts = 0x4000;
	selrgn.round = 0;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("LTADSEL::setselrgn err = %d\n", err));
	return err;
}

/*
 * Ƚ
 *	ȤǤ true ֤
 */
bool LTADSEL::inselrgn( PNT *pos )
{
	bool	in;

	if ( !sel ) return false;

	if ( selrgn.size == 4 ) {
		in = pos->x >= selrgn.pt[0].x
		  && pos->x <  selrgn.pt[2].x
		  && pos->y >= selrgn.pt[0].y
		  && pos->y <  selrgn.pt[2].y;
	} else {
		in  = pos->x >= selrgn.pt[7].x
		   && pos->x <  selrgn.pt[1].x
		   && pos->y >= selrgn.pt[1].y
		   && pos->y <  selrgn.pt[7].y;
		in |= pos->x >= selrgn.pt[6].x
		   && pos->x <  selrgn.pt[2].x
		   && pos->y >= selrgn.pt[6].y
		   && pos->y <  selrgn.pt[2].y;
		in |= pos->x >= selrgn.pt[5].x
		   && pos->x <  selrgn.pt[3].x
		   && pos->y >= selrgn.pt[3].y
		   && pos->y <  selrgn.pt[5].y;
	}

	return in;
}

/*
 * Ȥΰư
 *	Ȥΰ֤ dx, dy ư sr ˳Ǽ
 */
SEL_RGN* LTADSEL::moveselrgn( SELRGN &sr, W dx, W dy )
{
	W	i;

	sr.sts  |= 0x4000;
	sr.round = 0;
	sr.size  = selrgn.size;

	for ( i = 0; i < selrgn.size; ++i ) {
		sr.pt[i].x = selrgn.pt[i].x + dx;
		sr.pt[i].y = selrgn.pt[i].y + dy;
	}

	return (SEL_RGN*)&sr;
}

/*
 * 
 *	p ΰ֤ʸ򤹤롣
 *		0 : оݤʤ
 *		1 : 򤷤
 *	оݤʤäϡ̵Ȥʤ롣
 */
WERR LTADSEL::select( PNT &p )
{
	TADP	tp;
	ERR	err;

	/* öȤä̵ˤ */
	visible(false);
	sel = false;

	/* p ΰ֤Υǡõ */
	err = lotad->pick(*vi, p, tp);
	if ( err < ER_OK ) goto err_ret;
	if ( err == 0 ) return 0; // оݤʤ

	top = tp;
	end = tp;
	org = TOP;

	/* ΰ */
	err = setselrgn(NULL, NULL);
	if ( err < ER_OK ) goto err_ret;

	/* ɽ */
	sel = true;
	visible(true);

	return err;

err_ret:
	DEBUG_PRINT(("LTADSEL::select(PNT) err = %d\n", err));
	return err;
}

/*
 * 
 *	p ΰ֤ʸ򤹤롣
 *		0 : оݤʤ
 *		1 : 򤷤
 *	оݤʤäϡ̵Ȥʤ롣
 */
ERR LTADSEL::select( TADP &p )
{
	RECT	r;
	LRECT	lr;
	ERR	err;

	/* öȤä̵Ȥ */
	visible(false);
	sel = false;

	/* ǡζ */
	err = lotad->area(*vi, p, r, lr);
	if ( err < ER_OK ) goto err_ret;
	if ( lr.empty() ) return 0; // оݤʤ

	top = p;
	end = p;
	org = TOP;

	/* Ȥ */
	err = setselrgn(&r, &r);
	if ( err < ER_OK ) goto err_ret;

	/* ɽ */
	sel = true;
	visible(true);

	return 1;

err_ret:
	DEBUG_PRINT(("LTADSEL::select(TADP) err = %d\n", err));
	return err;
}

/*
 * 
 *	tp  ep ϰϤ򤹤롣
 *	tp <= ep ǤʤФʤʤ
 *	tp == ep ǣʸȤʤ롣
 *		0 : оݤʤ
 *		1 : 򤷤
 *	оݤʤäϡ̵Ȥʤ롣
 */
WERR LTADSEL::select( TADP &tp, TADP &ep )
{
	RECT	tr, er;
	LRECT	lr;
	ERR	err;

	/* öȤä̵Ȥ */
	visible(false);
	sel = false;

	/* ǡζ */
	err = lotad->area(*vi, tp, tr, lr);
	if ( err < ER_OK ) goto err_ret;
	if ( lr.empty() ) return 0; // оݤʤ

	err = lotad->area(*vi, ep, er, lr);
	if ( err < ER_OK ) goto err_ret;
	if ( lr.empty() ) return 0; // оݤʤ

	top = tp;
	end = ep;
	org = TOP;

	/* Ȥ */
	err = setselrgn(&tr, &er);
	if ( err < ER_OK ) goto err_ret;

	/* ɽ */
	sel = true;
	visible(true);

	return 1;

err_ret:
	DEBUG_PRINT(("LTADSEL::select(TADP,TADP) err = %d\n", err));
	return err;
}

/*
 * 
 *	ߤ p ΰ֤ʸޤǽ򤹤롣
 *		0 : оݤʤ
 *		1 : 򤷤 (ΰѲ)
 *		2 : 򤷤 (ΰѲʤ)
 *	ˤ򤬤ʤʤ뤳ȤϤʤͤ 0 ֤ʤ
 *	ߤ򤬤ʤȤ select() ƱưȤʤꡢ
 *	ΤȤͤ select() ƱȤʤ롣
 */
WERR LTADSEL::modify( PNT &p )
{
	TADP	tp;
	ERR	err;

	if ( !sel ) return select(p);

	/* p ΰ֤Υǡõ */
	err = lotad->pick(*vi, p, tp);
	if ( err < ER_OK ) goto err_ret;

	/* ɤ餫ᤤ֤ѹ */
	if ( tp <= top ) {
		if ( tp == top ) return 2;
		top = tp; org = END;
	} else if ( tp >= end ) {
		if ( tp == end ) return 2;
		end = tp; org = TOP;
	} else {
		if ( selrgn.size == 4 ) {
			if ( p.x - selrgn.pt[0].x < selrgn.pt[2].x - p.x ) {
				top = tp; org = END;
			} else {
				end = tp; org = TOP;
			}
		} else {
			if ( p.y - selrgn.pt[1].y < selrgn.pt[5].y - p.y ) {
				top = tp; org = END;
			} else {
				end = tp; org = TOP;
			}
		}
	}

	/* öȤä */
	visible(false);
	sel = false;

	/* Ȥ */
	err = setselrgn(NULL, NULL);
	if ( err < ER_OK ) goto err_ret;

	/* ɽƳ */
	sel = true;
	visible(true);

	return 1;

err_ret:
	DEBUG_PRINT(("LTADSEL::modify(PNT) err = %d\n", err));
	return err;
}

/*
 * 
 *	ߤ p ΰ֤ʸޤǽ򤹤롣
 *		0 : оݤʤ
 *		1 : 򤷤 (ΰѲ)
 *		2 : 򤷤 (ΰѲʤ)
 *	ˤ򤬤ʤʤ뤳ȤϤʤͤ 0 ֤ʤ
 *	ߤ򤬤ʤȤ select() ƱưȤʤꡢ
 *	ΤȤͤ select() ƱȤʤ롣
 */
WERR LTADSEL::modify( TADP &p )
{
	RECT	r, *tr, *er;
	LRECT	lr;
	ERR	err;

	if ( !sel ) return select(p);

	/* ǡζ */
	err = lotad->area(*vi, p, r, lr);
	if ( err < ER_OK ) goto err_ret;
	if ( lr.empty() ) return 2;

	if ( p <= top ) {
		/* ֤ѹ */
		if ( top == p ) return 2;
		top = p; org = END;
		tr = &r;
		er = NULL;
	} else {
		/* ֤ѹ */
		if ( end == p ) return 2;
		end = p; org = TOP;
		tr = NULL;
		er = &r;
	}

	/* öȤä */
	visible(false);
	sel = false;

	/* Ȥ */
	err = setselrgn(tr, er);
	if ( err < ER_OK ) goto err_ret;

	/* ɽƳ */
	sel = true;
	visible(true);

	return 1;

err_ret:
	DEBUG_PRINT(("LTADSEL::modify(TADP) err = %d\n", err));
	return err;
}

/*
 * ɥå
 *	ߤ p ΰ֤ʸޤǽ򤹤롣
 *		0 : оݤʤ
 *		1 : 򤷤 (ΰѲ)
 *		2 : 򤷤 (ΰѲʤ)
 *	ˤ򤬤ʤʤ뤳ȤϤʤͤ 0 ֤ʤ
 *	ߤ򤬤ʤȤ select() ƱưȤʤꡢ
 *	ΤȤͤ select() ƱȤʤ롣
 */
WERR LTADSEL::dragsel( PNT &p )
{
	TADP	tp;
	ERR	err;

	if ( !sel ) return select(p);

	/* p ΰ֤Υǡõ */
	err = lotad->pick(*vi, p, tp);
	if ( err < ER_OK ) goto err_ret;

	if ( org == TOP ) {
		if ( tp >= top ) {
			if ( tp == end ) return 2;
			end = tp;
		} else {
			end = top;
			top = tp;
			org = END;
		}
	} else {
		if ( tp <= end ) {
			if ( tp == top ) return 2;
			top = tp;
		} else {
			top = end;
			end = tp;
			org = TOP;
		}
	}

	/* öȤä */
	visible(false);
	sel = false;

	/* Ȥ */
	err = setselrgn(NULL, NULL);
	if ( err < ER_OK ) goto err_ret;

	/* ɽƳ */
	sel = true;
	visible(true);

	return 1;

err_ret:
	DEBUG_PRINT(("LTADSEL::dragsel err = %d\n", err));
	return err;
}

/*
 * ɥåưαƤ
 *	gid	ɥåƤĶ
 *	dx, dy	ΰ֤ư (õΤȤϻѤʤ)
 *	on	true ɽ / false õ
 *	ɥåƤ褹ǽ֤ȤƤɥåƤ
 *	ä˲ǽ֤᤹ȡ
 */
ERR LTADSEL::dragmove( W gid, W dx, W dy, bool on )
{
	SELRGN	sr;
	ERR	err;

	drg = true;

	/* ֤Ѳʤв⤷ʤ */
	if ( vis == on && dx == prev_dx && dy == prev_dy ) return ER_OK;

	if ( vis ) {
		/* ߤɽä */
		sr.sts = 0x1000;
		err = adsp_sel(gid, moveselrgn(sr, prev_dx, prev_dy), 0);
		if ( err < ER_OK ) goto err_ret;
		vis = false;
	}

	if ( on ) {
		/* ưɽ */
		sr.sts = 0x0000;
		err = adsp_sel(gid, moveselrgn(sr, dx, dy), 1);
		if ( err < ER_OK ) goto err_ret;
		vis = true;
		prev_dx = dx;
		prev_dy = dy;
	}

	return ER_OK;

err_ret:
	DEBUG_PRINT(("LTADSEL::dragmove err = %d\n", err));
	return err;
}

/*
 * Ȥκ
 *	Ȥɽ֤ꤷľ
 */
ERR LTADSEL::reset()
{
	ERR	err;

	if ( !sel ) return ER_OK;

	err = setselrgn(NULL, NULL);
	if ( err < ER_OK ) goto err_ret;

	return ER_OK;

err_ret:
	sel = false;
	DEBUG_PRINT(("LTADSEL::reset err = %d\n", err));
	return err;
}

/*
 * β
 */
void LTADSEL::cancel()
{
	visible(false);
	sel = false;
}

/*
 * 
 *	Ĥ
 *		Ȥɽ֤ǤФĤԤ
 *	ݥ󥿷ѹ
 *		pos ǤХݥ󥿤ηѹ롣
 *		pos = NULL λϷѹԤʤ
 *		true	ݥ󥿷Ԥä
 *		false	ݥ󥿷ѹƤʤ
 */
bool LTADSEL::idle( PNT *pos )
{
	bool	set = false;

	if ( !sel || !vis ) return set;		// ̵ޤɽ

	/* Ĥ */
	adsp_sel(vi->gid, (SEL_RGN*)&selrgn, -1);

	if ( pos != NULL && inselrgn(pos) ) {
		/* ݥ󥿷ѹ */
		setpointer(PS_MOVE|PS_CHKBUSY, NULL);
		set = true;
	}

	return set;
}

/*
 * ȤɽΥ󡿥
 */
void LTADSEL::visible( bool on )
{
	if ( sel && act ) {
		adsp_sel(vi->gid, (SEL_RGN*)&selrgn, on);
		vis = on;
	}
}

/*
 * Ȥǽ֤
 */
void LTADSEL::active( bool on )
{
	ERR	err;

	if ( drg && on ) {
		drg = false;

		/* Ȥɽ֤ */
		err = setselrgn(NULL, NULL);
		if ( err < ER_OK ) sel = false;
	}
	act = true;
	visible(on);
	act = on;
}

/*
 * ΰ֤
 *	򤬤ͤ true ֤ΰ sp, ep ֤
 *	sp 򳫻ϰ
 *	ep λ
 *	ɬǡ¤ӽ sp ep Ȥʤ롣
 *	ǡĤΤߤΤȤϡsp  ep ϤʤȤʤ롣
 *	(sp <= ep)
 *	򤬤ʤȤ sp, ep 
 */
bool LTADSEL::selarea( TADP &sp, TADP &ep )
{
	if ( sel ) {
		sp = top;
		ep = end;
	}

	return sel;
}

/*
 * ˥塼 vid μ
 *	oget_vmn() Ϳ vid ֤
 */
W LTADSEL::getmenuvid()
{
	TADP	tp, ep;
	TVOBJ	vobj;

	if ( !sel ) return -1;

	/*  vid ĤäƤФ֤ */
	if ( menuvid > INVALID ) return menuvid;

	menuvid = -1;

	/* ϰϤμ */
	tp = top;
	ep = end;
	++ep;

	/* Ȥõ */
	while ( tp < ep ) {
		if ( TSTR::ttype(*tp) == TSTR::TVobj ) {
			if ( menuvid > 0 ) {
				/* ʣβȤ򤷤Ƥ */
				menuvid = 0x4000; // ̹ܤΤ
				break;
			}

			tp.get(vobj);
			menuvid = vobj.vid;
		}
		++tp;
	}

	return menuvid;
}

/* ------------------------------------------------------------------------ */
} // namespace LIBCPP1
