/*
 *	@(#)tadstr.cc (libcpp1) 01-04-27
 *
 *	TAD ǡ饤֥
 *	(C) Copyright 2000-2001 by Personal Media Corporation
 */

#include "libcpp.h"
#include "cpp/1/tadstr.h"

namespace LIBCPP1 {

/* ------------------------------------------------------------------------ */
/*
 *	class RBUF
 *	ȥղĹХåե
 */

/*
 * ΰ
 */
void* RBUF::operator new ( size_t, UW len )
{
	UW s = offsetof(RBUF, body) + len;
	return ::operator new(s);
}
void* RBUF::operator new ( size_t, const std::nothrow_t&, UW len ) throw()
{
	UW s = offsetof(RBUF, body) + len;
	return ::operator new(s, nothrow);
}

/*
 * 󥹥ȥ饯
 *	len  new ǻꤷƱǤʤФʤʤ
 *	body = NULL ξ body ƤȤʤ롣
 * () RBUF p = new(len) RBUF(len, buf);
 */
RBUF::RBUF( UW len, const VP body )
{
	this->refcnt = 0;
	this->len = len;
	if ( body != NULL ) memcpy(this->body, body, len);
}

/*
 * ԡ󥹥ȥ饯
 *	new ʣ̸Ʊꤹɬפ롣
 * () RBUF p = new(s.len) RBUF(s);
 */
RBUF::RBUF( const RBUF &src )
{
	refcnt = 0;
	len = src.len;
	memcpy(body, src.body, len);
}

/*
 * 
 *	body ʣ̤ϡʣ̸ޤʣΤɤ餫
 *	ޤǤȤʤ롣
 */
RBUF& RBUF::operator = ( const RBUF &src )
{
	memcpy(body, src.body, ( len < src.len )? len: src.len);
	return *this;
}

/* ------------------------------------------------------------------------ */
/*
 *	class TSEG
 *	TAD 
 */

/*
 * ǥȥ饯
 */
TSEG::~TSEG()
{
	if ( buf != NULL ) {
		if ( --buf->refcnt <= 0 ) delete buf;
	}
}

/*
 * ԡ󥹥ȥ饯
 *	ȤƤʣ줺 buf Ʊ(RBUF)ؤ
 */
TSEG::TSEG( const TSEG &seg )
{
	id = seg.id;
	buf = seg.buf;
	if ( buf != NULL ) buf->refcnt++;
}
TSEG& TSEG::operator = ( const TSEG &seg )
{
	if ( buf != NULL ) {
		if ( --buf->refcnt <= 0 ) delete buf;
	}

	id = seg.id;
	buf = seg.buf;
	if ( buf != NULL ) buf->refcnt++;

	return *this;
}

/*
 * ȥǡΤ礭(Хȿ)
 */
UW TSEG::length()
{
	return ( buf == NULL )? 0: buf->len;
}

/*
 * ID
 */
UB TSEG::subid()
{
#if BIGENDIAN
	return ( buf == NULL )? 0: buf->body[0];
#else
	return ( buf == NULL )? 0: buf->body[1];
#endif
}

/*
 * ȥǡꤹ
 *	id	ID
 *	len	ȥإåǡΤ礭(Хȿ)
 *	body	ΤΥǡ
 *	ȥǡ¸ΰݤǡ¸롣
 *	body = NULL ξϡΰγݤΤߤȤʤ롣
 */
ERR TSEG::set( TC id, UW len, const VP body )
{
	if ( buf != NULL ) {
		if ( --buf->refcnt <= 0 ) delete buf;
	}

	buf = new(nothrow, len) RBUF(len, body);
	if ( buf == NULL ) goto err_ret;

	this->id = id;
	buf->refcnt = 1;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TSEG::set err = %d\n", ER_NOMEM));
	return ER_NOMEM;
}

/*
 * ȥǡʣ
 *	ǡ(RBUF)¿ŻȤˤʤäƤСʣΩ
 *	롣¿ŻȤǤʤв⤷ʤ
 */
ERR TSEG::dup()
{
	RBUF	*bp;

	if ( buf == NULL ) return ER_OK;

	if ( buf->refcnt > 1 ) {
		/* ǡΤʣ */
		bp = new(nothrow, buf->len) RBUF(*buf);
		if ( bp == NULL ) goto err_ret;

		bp->refcnt = 1;
		buf->refcnt--;
		buf = bp;
	}

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TSEG::dup err = %d\n", ER_NOMEM));
	return ER_NOMEM;
}

/*
 * TSEG  TSTR ؤγǼѤηѴ s ؽ񤭹ࡣ
 * ͤ s ؽ񤭹 TC ֤
 * s = NULL ξϡɬ TC Τߤ֤
 */
W TSEG::pack( TC *s )
{
	if ( s != NULL ) {
		s[0] = id;
		SetMisalignW((UB*)&s[1], (UW)buf);

		if ( buf != NULL ) buf->refcnt++;
	}
	return 3;
}

/*
 * TSTR ؤγǼ TSEG Ƥ롣
 * ͤ s ɤ߹ TC ֤
 * move = true λϰưȤʤꡢư s Ƥ̵Ȥʤ롣
 * move = false λʣ̤Ȥʤꡢư s ƤͭΤޤޤȤʤ롣
 */
W TSEG::unpack( const TC *s, bool move )
{
	if ( buf != NULL ) {
		if ( --buf->refcnt <= 0 ) delete buf;
	}

	id = s[0];
	buf = (RBUF*)GetMisalignW((UB*)&s[1]);

	if ( buf != NULL && !move ) buf->refcnt++;

	return 3;
}

/*
 * TSTR ؤγǼĹ֤
 * s  TSTR ؤγǼѴ줿ǡ
 */
W TSEG::packlen( const TC *s )
{
	return 3;
}

/*
 * ǥѴԤ
 *	CPU ΥǥΥǥۤʤ
 *	ѴԤ롣(include/btron/cnvend.h Ʊεǽ)
 *	toBig ˤѴꤹ롣
 *	  toBig = True  ӥåǥѴ
 *	  toBig = False ȥ륨ǥѴ
 *	̾ＡΤ褦ꤹɤ
 *	  toBig = BIGENDIAN
 *		ե롦ȥ졼ʤɤ
 *		ĤޤꡢCPU ΥǥؤѴ
 *	  toBig = bigEndian
 *		ե롦ȥ졼ʤɤؤν
 *		Ĥޤꡢե롦ȥ졼ʤɤΥǥؤѴ
 *	ѴǤʤǡξˤϥ顼֤
 *	  ER_NOSPT	̤ݡȥǡ
 *	  ER_PAR	ǡ
 */
ERR TSEG::cnvendian( int toBig )
{
	ERR	err;

	err = ConvEndianTADBody(id, buf->len, buf->body, buf->body,
							(Bool)toBig);
	if ( err < ER_OK ) goto err_ret;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TSEG::cnvendian err = %d\n", err));
	return err;
}

/* ------------------------------------------------------------------------ */
/*
 *	class TNEST
 *	ʸϡ޷ TAD
 */

/*
 * ǥȥ饯
 */
TNEST::~TNEST()
{
	if ( tad != NULL ) {
		if ( --tad->refcnt <= 0 ) delete tad;
	}
}

/*
 * ԡ󥹥ȥ饯
 *	TAD ǡƤʣ줺 tad Ʊ(TAD)ؤ
 */
TNEST::TNEST( const TNEST &nest )
{
	id = nest.id;
	tad = nest.tad;
	if ( tad != NULL ) tad->refcnt++;
}
TNEST& TNEST::operator = ( const TNEST &nest )
{
	if ( tad != NULL ) {
		if ( --tad->refcnt <= 0 ) delete tad;
	}

	id = nest.id;
	tad = nest.tad;
	if ( tad != NULL ) tad->refcnt++;

	return *this;
}

/*
 * ʸϡ޷ǡʣ
 *	ǡ(TAD)¿ŻȤˤʤäƤСʣΩ
 *	롣¿ŻȤǤʤв⤷ʤ
 */
ERR TNEST::dup()
{
	TAD	*p;
	ERR	err;

	if ( tad == NULL ) return ER_OK;

	if ( tad->refcnt > 1 ) {
		/* ǡΤʣ */
		p = tad->newTAD();
		if ( p == NULL ) { err = ER_NOMEM; goto err_ret1; }

		err = p->dupset(*tad);
		if ( err < ER_OK ) goto err_ret2;

		p->refcnt = 1;
		tad->refcnt--;
		tad = p;
	}

	return ER_OK;

err_ret2:
	delete p;
err_ret1:
	DEBUG_PRINT(("TNEST::dup err = %d\n", err));
	return err;
}

/*
 * TNEST  TSTR ؤγǼѤηѴ s ؽ񤭹ࡣ
 * ͤ s ؽ񤭹 TC ֤
 * s = NULL ξϡɬ TC Τߤ֤
 */
W TNEST::pack( TC *s )
{
	if ( s != NULL ) {
		s[0] = id;
		SetMisalignW((UB*)&s[1], (UW)tad);

		if ( tad != NULL ) tad->refcnt++;
	}
	return 3;
}

/*
 * TSTR ؤγǼ TNEST Ƥ롣
 * ͤ s ɤ߹ TC ֤
 * move = true λϰưȤʤꡢư s Ƥ̵Ȥʤ롣
 * move = false λʣ̤Ȥʤꡢư s ƤͭΤޤޤȤʤ롣
 */
W TNEST::unpack( const TC *s, bool move )
{
	if ( tad != NULL ) {
		if ( --tad->refcnt <= 0 ) delete tad;
	}

	id = s[0];
	tad = (TAD*)GetMisalignW((UB*)&s[1]);

	if ( tad != NULL && !move ) tad->refcnt++;

	return 3;
}

/*
 * TSTR ؤγǼĹ֤
 * s  TSTR ؤγǼѴ줿ǡ
 */
W TNEST::packlen( const TC *s )
{
	return 3;
}

/* ------------------------------------------------------------------------ */
/*
 *	class TVOBJ
 *	 ID
 */

/*
 * Ͽ
 *	wid Υɥ˲ϿԤ
 *	TSEG ϲȥȤǤʤФʤʤ
 */
ERR TVOBJ::reg( W wid, TSEG &seg, LINK *lnk )
{
	ERR	err;

	err = oreg_vob((VLINK*)lnk, &seg->body, wid, V_NODISP);
	if ( err < ER_OK ) goto err_ret;

	id = seg.id;
	vid = err;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TVOBJ::reg err = %d\n", err));
	return err;
}

/*
 * ȤϿ
 */
ERR TVOBJ::del()
{
	ERR	err;

	err = odel_vob(vid, 0);
	if ( err < ER_OK ) goto err_ret;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TVOBJ::del err = %d\n", err));
	return err;
}

/*
 * ȥȤȥ󥯤μФ
 *	org_vid > 0 ξϡID org_vid λؤ¿ȤسǼ뤿
 *	ȤѴ(ocnv_vob)Ԥ롣
 */
ERR TVOBJ::getseg( TSEG &seg, LINK &lnk, W org_vid )
{
	UW	sz;
	ERR	err;

	err = oget_vob(vid, NULL, NULL, 0, &sz);
	if ( err < ER_OK ) goto err_ret;

	err = seg.set(TS_VOBJ|0xff00, sz, NULL);
	if ( err < ER_OK ) goto err_ret;

	err = oget_vob(vid, (VLINK*)&lnk, seg->body, sz, NULL);
	if ( err < ER_OK ) goto err_ret;

	if ( org_vid > 0 ) {
		err = ocnv_vob(org_vid, vid, &lnk);
		if ( err < ER_OK ) goto err_ret;
	}

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TVOBJ::getseg err = %d\n", err));
	return err;
}

/*
 * Ȥʣ
 *	ߤβȤʣơʣȤ֤롣
 *	ʣβȤϿϤʤΥ֥Ȥ
 *	 ID (vid)äΤǡβȤؤϥǤʤʤ롣
 */
ERR TVOBJ::dup()
{
	ERR	err;

	err = odup_vob(vid);
	if ( err < ER_OK ) goto err_ret;

	vid = err;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TVOBJ::dup err = %d\n", err));
	return err;
}

/*
 * TVOBJ  TSTR ؤγǼѤηѴ s ؽ񤭹ࡣ
 * ͤ s ؽ񤭹 TC ֤
 * s = NULL ξϡɬ TC Τߤ֤
 */
W TVOBJ::pack( TC *s )
{
	if ( s != NULL ) {
		s[0] = id;
		SetMisalignW((UB*)&s[1], vid);
	}
	return 3;
}

/*
 * TSTR ؤγǼ TVOBJ Ƥ롣
 * ͤ s ɤ߹ TC ֤
 */
W TVOBJ::unpack( const TC *s )
{
	id = s[0];
	vid = GetMisalignW((UB*)&s[1]);
	return 3;
}

/*
 * TSTR ؤγǼĹ֤
 * s  TSTR ؤγǼѴ줿ǡ
 */
W TVOBJ::packlen( const TC *s )
{
	return 3;
}

/* ------------------------------------------------------------------------ */
/*
 *	class TSTR
 *	TAD ǡ
 */

static TC dummy_str[1] = { TNULL };

/*
 * 󥹥ȥ饯
 */
TSTR::TSTR( W lang )
{
	str = dummy_str;
	len = 0;
	this->lang = lang;
}

/*
 * ǥȥ饯
 */
TSTR::~TSTR()
{
	/* ǡơΰ */
	if ( str != dummy_str ) {
		inv(str, len);
		free(str);
	}
}

/*
 * ٤ƺ
 */
void TSTR::del()
{
	inv(str, len);
	alloc(0);
}

/*
 * ǡȽ
 */
TSTR::TTYPE TSTR::ttype( TC id )
{
	if ( id < 0xff80 ) return TChar;

	switch ( id ) {
	  case TS_VOBJ   | 0xff00:
	  case TS_FFUSEN | 0xff00:
		return TVobj;

	  case TS_NEST:
		return TNest;
	}
	return TSeg;
}

/*
 * len (TC)Υǡݻ˽ʬ礭˳ĥޤϽ̾롣
 * str Υɥ쥹Ѳ뤳Ȥ롣
 */
ERR TSTR::alloc( UW len )
{
	TC	*p;
	UW	reqsz;	// ׵᥵
	UW	cursz;	// ߥ

	/* ʸü TNULL ʬɲäƳݤ */
	reqsz = (len       + BLKSZ) / BLKSZ * BLKSZ;
	cursz = (this->len + BLKSZ) / BLKSZ * BLKSZ;

	if ( len == 0 ) {
		if ( str != dummy_str ) {
			free(str);
			str = dummy_str;
		}

	} else if ( str == dummy_str ) {
		p = (TC*)malloc(reqsz * sizeof(TC));
		if ( p == NULL ) goto err_ret;
		str = p;
		str[0] = TNULL;

	} else if ( reqsz != cursz ) {
		p = (TC*)realloc(str, reqsz * sizeof(TC));
		if ( p == NULL ) goto err_ret;
		str = p;
	}
	this->len = len;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TSTR::alloc err = %d\n", ER_NOMEM));
	return ER_NOMEM;
}

/*
 * pos ΰ֤ len (TC)ζΰĥ롣
 * pos ʹߤΥǡϸˤ餵롣ΰƤꡣ
 * str Υɥ쥹Ѳ뤳Ȥ롣
 */
ERR TSTR::expand( UW pos, UW len )
{
	W	n;
	TC	*p;
	ERR	err;

	/* pos ʹߤĹ (ü TNULL ޤ) */
	n = (this->len + 1) - pos;

	/* ΰĥ */
	err = alloc(this->len + len);
	if ( err < ER_OK ) goto err_ret;

	/* pos ʹߤˤ餹 */
	p = str + pos;
	memmove(p + len, p, n * sizeof(TC));

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TSTR::expand err = %d\n", err));
	return err;
}

/*
 * pos ΰ֤ len (TC)ΥǡΤƤΰ̾롣
 * ΤƤΰΥǡ̵(̣Τʤ)ǡȤƼΤƤ롣
 * ΤƤ줿ʬΥǡˤ餵롣
 * str Υɥ쥹Ѳ뤳Ȥ롣
 */
ERR TSTR::shorten( UW pos, UW len )
{
	W	n;
	TC	*p;
	ERR	err;

	/* pos + len ʹߤĹ (ü TNULL ޤ) */
	n = (this->len + 1) - (pos + len);

	/* pos + len ʹߤˤ餹 */
	p = str + pos;
	memmove(p, p + len, n * sizeof(TC));

	/* ΰ̾ */
	err = alloc(this->len - len);
	if ( err < ER_OK ) goto err_ret;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TSTR::shorten err = %d\n", err));
	return err;
}

/*
 * src  dst  len (TC) TSTR Υǡʣ̤롣
 */
void TSTR::cpy( TC *dst, const TC *src, UW len )
{
	const TC	*end = src + len;
	W		n;
	TSEG		seg;
	TNEST		nest;
	TVOBJ		vobj;

	n = 0;
	while ( src < end ) {
		if ( isTLANGch(*src, &n) != 0 ) {
			*dst++ = *src++;
			continue;
		}
		switch ( ttype(*src) ) {
		  case TChar:
			*dst++ = *src++;
			break;
		  case TSeg:
			src += seg.unpack(src);
			dst += seg.pack(dst);
			break;
		  case TNest:
			src += nest.unpack(src);
			dst += nest.pack(dst);
			break;
		  case TVobj:
			src += vobj.unpack(src);
			dst += vobj.pack(dst);
			break;
		}
	}
}

/*
 * str  len (TC) TSTR Υǡ̵ˤ롣
 */
void TSTR::inv( TC *str, UW len )
{
	TC	*end = str + len;
	TSEG	seg;
	TNEST	nest;
	TVOBJ	vobj;

	while ( str < end ) {
		if ( isTLANG(str, 0, &str) != 0 ) continue;

		switch ( ttype(*str) ) {
		  case TChar:	str++;				break;
		  case TSeg:	str += seg.unpack(str, true);	break;
		  case TNest:	str += nest.unpack(str, true);	break;
		  case TVobj:	str += vobj.unpack(str);	break;
		}
	}
}

/*
 * ¿ŻȤȤʤäƤǡʣơ¾λȤʬΥ
 */
ERR TSTR::dup()
{
	TSEG	seg;
	TNEST	nest;
	TVOBJ	vobj;
	TC	*p = str;
	ERR	err;

	while ( *p != TNULL ) {
		if ( isTLANG(p, 0, &p) != 0 ) continue;

		switch ( ttype(*p) ) {
		  case TChar:
			p++;
			break;
		  case TSeg:
			seg.unpack(p);
			err = seg.dup();
			if ( err < ER_OK ) goto err_ret;
			p += seg.pack(p);
			break;
		  case TNest:
			nest.unpack(p);
			err = nest.dup();
			if ( err < ER_OK ) goto err_ret;
			p += nest.pack(p);
			break;
		  case TVobj:
			vobj.unpack(p);
			err = vobj.dup();
			if ( err < ER_OK ) goto err_ret;
			p += vobj.pack(p);
			break;
		}
	}

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TSTR::dup err = %d\n", err));
	return err;
}

/*
 * src 鼫Ȥʣ
 * TSEG ʤɤλȷΥǡΤʣ̤졢ȤʬΥ롣
 */
ERR TSTR::dupset( const TSTR &src )
{
	ERR	err;

	/* ʣ */
	err = set(src);
	if ( err < ER_OK ) goto err_ret;

	/* ¿ŻȤʬΥ */
	err = dup();
	if ( err < ER_OK ) goto err_ret;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TSTR::dupset err = %d\n", err));
	return err;
}

/*
 * src 鼫Ȥʣ
 * TSEG ʤɤλȷΥǡΤʣ줺¿ŻȾ֤Ȥʤ롣
 */
ERR TSTR::set( const TSTR &src )
{
	ERR	err;

	if ( str != dummy_str ) {
		/* ߤƤ */
		inv(str, len);
	}

	/* ΰ */
	err = alloc(src.len);
	if ( err < ER_OK ) goto err_ret;

	/* ʣ */
	cpy(str, src.str, len + 1);
	lang = src.lang;

	return ER_OK;

err_ret:
	alloc(0);
	DEBUG_PRINT(("TSTR::set err = %d\n", err));
	return err;
}

/*
 * ǡĹ
 */
W TSTR::packlen( const TC *s )
{
	switch ( ttype(*s) ) {
	  case TChar:	return 1;
	  case TSeg:	return TSEG::packlen(s);
	  case TNest:	return TNEST::packlen(s);
	  case TVobj:	return TVOBJ::packlen(s);
	}
	return 0; /*  */
}

/* ------------------------------------------------------------------------ */
/*
 *	class TSTRP
 *	TAD ǡݥ
 */

/*
 * 󥹥ȥ饯
 */
TSTRP::TSTRP( TSTR &s )
{
	init(&s);
}

/*
 * 
 */
void TSTRP::init( TSTR *s )
{
	TC	*p;
	W	i;

	tstr = s;
	clang = tstr->lang;
	p = tstr->str;
	while ( (i = isTLANG(p, 0, &p)) != 0 ) {
		clang = i;
	}
	cpos = p - tstr->str;
	ppos = cpos;
	plang = clang;
}

/*
 * ݥ󥿤򣱤Ŀʤ롿᤹
 *	ʸ䥻ȤʤɤΥǡñ̤ǰư롣
 *	ꥳɤϲᤵ졢ꥳɤΰ֤ˤϥݥ󥿤
 *	ߤʤ
 */
void TSTRP::next()	// ݥ󥿤ʤ
{
	TC	*p = &tstr->str[cpos];
	W	i;

	if ( cpos >= tstr->len ) return; /* ʾʤʤ */

	ppos = cpos;
	plang = clang;

	p += TSTR::packlen(p);
	while ( (i = isTLANG(p, 0, &p)) != 0 ) {
		clang = i;
	}
	cpos = p - tstr->str;
}
void TSTRP::prev()	// ݥ󥿤᤹
{
	TSTRP	p(*tstr);
	TSTRP	pp = p;

	while ( p < *this ) {
		pp = p++;
	}
	*this = pp;
}

/*
 * ݥ󥿤ʤ
 *	ntc(TC)ʬݥ󥿤ʤ롣᤹(ntc<0)ȤϤǤʤ
 *	ʤ᤿֤ꥳɤʤɥݥȤǤʤ֤
 *	СΰְʹߤκǽΥݥȲǽʰ֤Ȥʤ롣
 */
void TSTRP::forward( int ntc )
{
	TC	*p, *tp;
	W	i;

	if ( cpos + ntc > tstr->len ) {
		/* ʸνüĶϡüޤǤȤ */
		ntc = tstr->len - cpos;
	}
	if ( ntc <= 0 ) return; /* ưʤ */

	p = &tstr->str[cpos];
	tp = p + ntc;

	while ( p < tp ) {
		ppos = p - tstr->str;
		plang = clang;

		p += TSTR::packlen(p);
		while ( (i = isTLANG(p, 0, &p)) != 0 ) {
			clang = i;
		}
	}
	cpos = p - tstr->str;
}

/*
 * ݥ󥿤
 */
int TSTRP::cmp( const TSTRP &p )
{
	return cpos - p.cpos;
}

/*
 * ʸ(TC)ȤθФ
 */
void TSTRP::get( TC &c, W &lang )
{
	c = tstr->str[cpos];
	lang = clang;
}

/*
 * ʸȤƬθФ
 *	֤߰Ϣ³ʸ(ꥳɤޤ)Ф
 *	ְ߰ʹߤκǽʸʳΥǡüȤʤ롣
 *	s ʸƬΥݥ󥿤֤ꡢĹ(TC)֤ͤ롣
 *	s  TSTR ݻƤǡľܻؤƤΤǡƤ
 *	ѹƤϤʤ
 */
W TSTRP::get( const TC* &s, W &lang )
{
	TC	*p;

	s = p = &tstr->str[cpos];

	while ( TSTR::ttype(*p) == TSTR::TChar && *p != TNULL ) {
		p++;
		while ( isTLANG(p, 0, &p) != 0 );
	}

	lang = clang;
	return p - s;
}

/*
 * ¾ΥǡФ
 *	֤߰ΥǡפȼФǡפʤȤϡ
 *	id Τ߸֤߰Υǡ֤롣
 */
void TSTRP::get( TSEG &seg )
{
	TC	*p = &tstr->str[cpos];

	if ( TSTR::ttype(*p) == TSTR::TSeg ) {
		seg.unpack(p);
	} else {
		seg.id = *p;
	}
}
void TSTRP::get( TNEST &nest )
{
	TC	*p = &tstr->str[cpos];

	if ( TSTR::ttype(*p) == TSTR::TNest ) {
		nest.unpack(p);
	} else {
		nest.id = *p;
	}
}
void TSTRP::get( TVOBJ &vobj )
{
	TC	*p = &tstr->str[cpos];

	if ( TSTR::ttype(*p) == TSTR::TVobj ) {
		vobj.unpack(p);
	} else {
		vobj.id = *p;
	}
}

/*
 * ʸ
 *	ʸˤϡɬפ˱Ƹꥳɤ
 *	롣
 *	lang = 0 ξϡc ϸߤθƱǤȤߤʤ
 */
ERR TSTRP::ins( TC c, W lang )
{
	TC	*p;
	UW	ip;
	W	n1, n2, n;
	ERR	err;

	if ( lang == 0 ) lang = clang;

	/* ֤θꥳɤ̵ͭꤹ */
	if ( clang == plang || clang == lang ) {
		p = &tstr->str[cpos];
		ip = cpos;
		n1 = ( lang == clang )? 0: TLANGtoTCvc(NULL, 0, lang);
	} else {
		p = &tstr->str[ppos];
		ip = ppos + TSTR::packlen(p);
		n1 = ( lang == plang )? 0: TLANGtoTCvc(NULL, 0, lang);
	}
	n2 = ( lang == clang || *p == TNULL )? 0: TLANGtoTCvc(NULL, 0, clang);

	/* TSTR ΰĥ */
	n = n1 + 1 + n2;
	err = tstr->expand(ip, n);
	if ( err < ER_OK ) goto err_ret;

	/*  */
	p = &tstr->str[ip];
	if ( n1 > 0 ) p += TLANGtoTC(p, n1, lang);
	*p++ = c;
	if ( n2 > 0 ) p += TLANGtoTC(p, n2, clang);

	/* ־󹹿 */
	ppos = ip + n1;
	plang = lang;
	cpos += n;
	if ( *p == TNULL ) clang = lang;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TSTRP::ins(TC) err = %d\n", err));
	return err;
}

/*
 * ʸ
 *	ʸ s  TNULL ޤ len ʸ(TC)Τɤ餫ã
 *	ޤ롣len < 0 ξϡlen ̵뤹롣
 *	ʸˤϡɬפ˱Ƹꥳɤ
 *	롣
 *	lang = 0 ξϡs Ƭθ줬ߤθƱǤ
 *	ߤʤ
 */
ERR TSTRP::ins( const TC *s, W lang, W len = -1 )
{
	const TC	*sp, *ep;
	W		slang, elang;
	TC		*p;
	UW		ip;
	W		i, n, n1, n2;
	ERR		err;

	if ( lang == 0 ) lang = clang;

	/* ʸƬüθĴ٤ */
	sp = NULL;
	for ( n = 0; *s != TNULL && len != 0; s++, len-- ) {
		i = isTLANGch(*s, &n);
		if ( i != 0 ) {
			lang = i;
			continue;
		}
		if ( sp == NULL ) {
			sp = s;
			slang = lang;
		}
		ep = s;
		elang = lang;
	}
	if ( sp == NULL ) return ER_OK; /* ٤ͭʸʤ */

	/* ֤θꥳɤ̵ͭꤹ */
	if ( clang == plang || clang == slang ) {
		p = &tstr->str[cpos];
		ip = cpos;
		n1 = ( slang == clang )? 0: TLANGtoTCvc(NULL, 0, slang);
	} else {
		p = &tstr->str[ppos];
		ip = ppos + TSTR::packlen(p);
		n1 = ( slang == plang )? 0: TLANGtoTCvc(NULL, 0, slang);
	}
	n2 = ( elang == clang || *p == TNULL )?	0: TLANGtoTCvc(NULL, 0, clang);

	/* TSTR ΰĥ */
	i = ep - sp + 1;
	n = n1 + i + n2;
	err = tstr->expand(ip, n);
	if ( err < ER_OK ) goto err_ret;

	/*  */
	p = &tstr->str[ip];
	if ( n1 > 0 ) p += TLANGtoTC(p, n1, slang);
	memcpy(p, sp, i * sizeof(TC));
	p += i;
	if ( n2 > 0 ) p += TLANGtoTC(p, n2, clang);

	/* ־ι */
	ppos = ip + n1 + i - 1;
	plang = elang;
	cpos += n;
	if ( *p == TNULL ) clang = elang;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TSTRP::ins(TC*) err = %d\n", err));
	return err;
}

/*
 * ¾Υǡ
 */
ERR TSTRP::ins( TSEG &seg )
{
	ERR	err;

	/* TSTR ΰĥ */
	err = tstr->expand(cpos, seg.pack(NULL));
	if ( err < ER_OK ) goto err_ret;

	/*  */
	cpos += seg.pack(&tstr->str[cpos]);

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TSTRP::ins(TSEG) err = %d\n", err));
	return err;
}
ERR TSTRP::ins( TNEST &nest )
{
	ERR	err;

	/* TSTR ΰĥ */
	err = tstr->expand(cpos, nest.pack(NULL));
	if ( err < ER_OK ) goto err_ret;

	/*  */
	cpos += nest.pack(&tstr->str[cpos]);

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TSTRP::ins(TNEST) err = %d\n", err));
	return err;
}
ERR TSTRP::ins( TVOBJ &vobj )
{
	ERR	err;

	/* TSTR ΰĥ */
	err = tstr->expand(cpos, vobj.pack(NULL));
	if ( err < ER_OK ) goto err_ret;

	/*  */
	cpos += vobj.pack(&tstr->str[cpos]);

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TSTRP::ins(TVOBJ) err = %d\n", err));
	return err;
}
ERR TSTRP::ins( TSTR &str )
{
	const TC	*s, *sp, *ep;
	W		lang, slang, elang;
	TC		*p;
	UW		ip;
	W		i, n, n1, n2;
	ERR		err;

	/* ǡƬüθĴ٤ */
	sp = NULL;
	s = str.str;
	lang = str.lang;
	while ( *s != TNULL ) {
		i = isTLANG(s, 0, (TC**)&s);
		if ( i != 0 ) {
			lang = i;
			continue;
		}
		if ( sp == NULL ) {
			sp = s;
			slang = lang;
		}
		ep = s;
		elang = lang;
		s += TSTR::packlen(s);
	}
	if ( sp == NULL ) return ER_OK; /* ٤ͭʥǡʤ */

	/* ֤θꥳɤ̵ͭꤹ */
	if ( clang == plang || clang == slang ) {
		p = &tstr->str[cpos];
		ip = cpos;
		n1 = ( slang == clang )? 0: TLANGtoTCvc(NULL, 0, slang);
	} else {
		p = &tstr->str[ppos];
		ip = ppos + TSTR::packlen(p);
		n1 = ( slang == plang )? 0: TLANGtoTCvc(NULL, 0, slang);
	}
	n2 = ( elang == clang || *p == TNULL )?	0: TLANGtoTCvc(NULL, 0, clang);

	/* TSTR ΰĥ */
	i = ep + TSTR::packlen(ep) - sp;
	n = n1 + i + n2;
	err = tstr->expand(ip, n);
	if ( err < ER_OK ) goto err_ret;

	/*  */
	p = &tstr->str[ip];
	if ( n1 > 0 ) p += TLANGtoTC(p, n1, slang);
	TSTR::cpy(p, sp, i);
	p += i;
	if ( n2 > 0 ) p += TLANGtoTC(p, n2, clang);

	/* ־ι */
	ppos = ip + n1 + (ep - sp);
	plang = elang;
	cpos += n;
	if ( *p == TNULL ) clang = elang;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TSTRP::ins(TSTR) err = %d\n", err));
	return err;
}

/*
 * ʸȥȤδޤޤ줿 TC 
 *	ʸȥȤκ s  TNULL ޤ len ʸ(TC)
 *	ɤ餫ãޤ롣
 *	len < 0 ξϡlen ̵뤹롣
 *	ȤϤ٤ TSEG ǳǼΤǡȥ
 *	ʤ TSEG ǤϳǼǤʤΤ s ˴ޤ뤳ȤϤǤʤ
 */
ERR TSTRP::instadstr( const TC *s, W lang, W len )
{
	const TC	*p, *q;
	TC		c;
	W		i, n, p_lang;
	UW		sz;
	TSEG		seg;
	ERR		err;

	n = 0;
	p = s;
	p_lang = lang;
	while ( len != 0 && (c = *p) != TNULL ) {
		i = isTLANGch(c, &n);
		if ( i != 0 ) {
			p_lang = i;
			++p;
			--len;
			continue;
		}
		if ( c < 0xff80 ) {
			++p;
			--len;
			continue;
		}

		if ( (i = p - s) > 0 ) {
			/* ʸ */
			err = ins(s, lang, i);
			if ( err < ER_OK ) goto err_ret;
			lang = p_lang;
			s = p;
		}

		/*  */
		q = p + 1;
		if ( --len == 0 ) break;
		sz = *q++;
		if ( sz == 0xffff ) {
			if ( --len == 0 || --len == 0 ) break;
			sz = GetMisalignW((UB*)q);
			q += 2;
		}
		i = sz / sizeof(TC);
		if ( --len >= 0 && len < i ) break;
		err = seg.set(c, sz, (VP)q);
		if ( err < ER_OK ) goto err_ret;
		err = ins(seg);
		if ( err < ER_OK ) goto err_ret;
		s = p = q + i;
		len -= i;
	}
	if ( (i = p - s) > 0 ) {
		/* ʸ */
		err = ins(s, lang, i);
		if ( err < ER_OK ) goto err_ret;
	}

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TSTRP::instadstr err = %d\n", err));
	return err;
}

/*
 * ֤߰Υǡ
 * ()	߰ ^  D 
 *	ABCDEFG
 *	   ^
 *	ABCEFG
 *	   ^
 */
ERR TSTRP::del()
{
	UW	npos, sp, ep;
	W	nlang, i;
	TC	*p;
	ERR	err;

	p = &tstr->str[cpos];
	if ( *p == TNULL ) return ER_OK; /* üʤΤǺԲ */

	/* оݥǡľΰ */
	p += TSTR::packlen(p);
	ep = p - tstr->str;

	/* Υǡΰ֤ȸ */
	nlang = clang;
	while ( (i = isTLANG(p, 0, &p)) != 0 ) {
		nlang = i;
	}
	npos = p - tstr->str;
	if ( *p == TNULL ) nlang = plang;

	/* θκȽ */
	sp = ppos + TSTR::packlen(&tstr->str[ppos]);
	if ( clang == nlang ) {
		if ( plang != nlang ) sp = cpos;
		ep = npos;
	} else {
		if ( plang == nlang ) ep = npos;
	}

	/* ˵ͤ */
	i = ep - sp;
	TSTR::inv(&tstr->str[sp], i);
	err = tstr->shorten(sp, i);
	if ( err < ER_OK ) goto err_ret;

	/* ־򹹿 */
	cpos = npos - i;
	clang = nlang;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TSTRP::del err = %d\n", err));
	return err;
}

/*
 * ֤߰ p ľޤǤ
 * p Ʊ TSTR ǡ֤߰ؤƤʤФʤʤ
 * 塢p ΰ֤Ȥʤ롣
 * ǡ s ¸롣
 * ()	ABCDEFG
 *	 ^   p
 *	AFG
 *	 ^
 */
ERR TSTRP::cut( TSTR &s, TSTRP &p )
{
	TC	*sp, *ep;
	UW	i;
	ERR	err;

	/* ʣ򥯥ꥢƤ */
	if ( s.len > 0 ) TSTR::inv(0, s.len);

	/* ʣ̸Ƭü */
	sp = &tstr->str[cpos];
	ep = &tstr->str[p.ppos];
	ep += TSTR::packlen(ep);
	i = ep - sp;

	/* ʣɬפΰݤ */
	err = s.alloc(i);
	if ( err < ER_OK ) goto err_ret2;
	if ( i == 0 ) return ER_OK;

	/* ʣ */
	memcpy(s.str, sp, i * sizeof(TC));
	s.lang = clang;

	/* оݤƬü */
	sp = &tstr->str[ppos];
	sp += TSTR::packlen(sp);
	ep = &tstr->str[p.cpos];

	/* ꥳɤɬפʤ */
	if ( plang != p.clang ) {
		sp += TLANGtoTCvc(sp, ep - sp, p.clang);
	}

	/* ʬΰͤ */
	i = sp - tstr->str;
	err = tstr->shorten(i, ep - sp);
	if ( err < ER_OK ) goto err_ret1;

	/* ־򹹿 */
	cpos = i;
	clang = p.clang;

	return ER_OK;

err_ret2:
	s.alloc(0);
err_ret1:
	DEBUG_PRINT(("TSTRP::cut err = %d\n", err));
	return err;
}

/*
 * ֤߰ p ľޤǤ s ʣ̤
 * p Ʊ TSTR ǡ֤߰ؤƤʤФʤʤ
 */
ERR TSTRP::cpy( TSTR &s, TSTRP &p )
{
	TC	*sp, *ep;
	UW	len;
	ERR	err;

	/* ʣ򥯥ꥢƤ */
	if ( s.len > 0 ) TSTR::inv(0, s.len);

	/* ʣ̸Ƭü */
	sp = &tstr->str[cpos];
	ep = &tstr->str[p.ppos];
	ep += TSTR::packlen(ep);
	len = ep - sp;

	/* ʣɬפΰݤ */
	err = s.alloc(len);
	if ( err < ER_OK ) goto err_ret;

	/* ʣ */
	TSTR::cpy(s.str, sp, len);
	s.lang = clang;

	return ER_OK;

err_ret:
	s.alloc(0);
	DEBUG_PRINT(("TSTRP::cpy err = %d\n", err));
	return err;
}

/*
 * ְ߰ʹߤʬΥs ¸
 * ֤߰ϽüȤʤ롣
 */
ERR TSTRP::split( TSTR &s )
{
	UW	n, pos;
	ERR	err;

	/* ʣ򥯥ꥢƤ */
	if ( s.len > 0 ) TSTR::inv(0, s.len);

	/* ʬΥĹ */
	n = tstr->len - cpos;

	/* ¸ɬפΰݤ */
	err = s.alloc(n);
	if ( err < ER_OK ) goto err_ret2;

	/* Ƭθ */
	s.lang = clang;

	if ( n == 0 ) return ER_OK;

	/* ¸ (ü TNULL ޤʣ) */
	memcpy(s.str, &tstr->str[cpos], (n + 1) * sizeof(TC));

	/* ƬĹ */
	n = TSTR::packlen(&tstr->str[ppos]);
	pos = ppos + n;
	n = tstr->len - pos;

	/* ʬΰͤ */
	err = tstr->shorten(pos, n);
	if ( err < ER_OK ) goto err_ret1;

	/* ־򹹿 */
	cpos = pos;
	clang = plang;

	return ER_OK;

err_ret2:
	s.alloc(0);
err_ret1:
	DEBUG_PRINT(("TSTRP::split err = %d\n", err));
	return err;
}

/*
 * ü s ɲä
 * ֤߰Ѳʤ
 * ֤߰üǤСɲøɲäǡƬȤʤ롣
 */
ERR TSTRP::join( TSTR &s )
{
	TSTRP	dp = *this;
	TC	*p;
	W	i;
	ERR	err;

	/* ü */
	while ( *dp != TNULL ) ++dp;
	err = dp.ins(s);
	if ( err < ER_OK ) goto err_ret;

	/* ־򹹿 */
	p = &tstr->str[ppos];
	p += TSTR::packlen(p);
	clang = plang;
	while ( (i = isTLANG(p, 0, &p)) != 0 ) {
		clang = i;
	}
	cpos = p - tstr->str;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TSTRP::join err = %d\n", err));
	return err;
}

/* ------------------------------------------------------------------------ */
/*
 *	class TBIND
 *	TAD ǡ(TSTR)νޤ
 */

/*
 * 󥹥ȥ饯
 */
TBIND::TBIND( W level )
{
	W	i;

	this->level = level;
	nent = 0;
	for ( i = 0; i < NENT; ++i ) ent[i].clear(level);
}

/*
 * ǥȥ饯
 */
TBIND::~TBIND()
{
	W	i;

	if ( level == 0 ) {
		for ( i = 0; i < NENT; ++i ) delete ent[i].s;
	} else {
		for ( i = 0; i < NENT; ++i ) delete ent[i].b;
	}
}

/*
 * TSTR 
 */
TSTR* TBIND::newTSTR()
{
	return new(nothrow) TSTR;
}

/*
 * TBIND 
 */
TBIND* TBIND::newTBIND( W level )
{
	return new(nothrow) TBIND(level);
}

/*
 * ȥѤζڡ
 *	ȥ򤺤餷ơix ܤΥȥľ˶롣
 *	ȥΰ֤֤ͤ
 *	ʤ -1 ֤
 *	ix ΰ֤ưȤϡix ⹹롣
 */
W TBIND::insspc( W &ix )
{
	W	i;

	i = ix;
	if ( i >= TBIND::NENT ) {
		while ( --i >= 0 ) {
			if ( !ent[i].empty(level) ) break;
		}
		if ( ++i < TBIND::NENT ) return i;
	}

	/* ix ˶뤫 */
	for ( i = ix - 1; i >= 0; --i ) {
		if ( !ent[i].empty(level) ) continue;

		while ( ++i < ix ) ent[i-1] = ent[i];
		ent[--i].clear(level);
		return i;
	}

	/* ix ˶뤫 */
	for ( i = ix + 1; i < TBIND::NENT; ++i ) {
		if ( !ent[i].empty(level) ) continue;

		while ( --i >= ix ) ent[i+1] = ent[i];
		ent[++i].clear(level);
		ix++;
		return i;
	}

	return -1;
}

/*
 * ȥΰư
 *	moveu	sp ξ夫 n ȥ dp ذư롣
 *	moved	sp β n ȥ dp ذư롣
 *	ưȥ֤ͤ
 */
W TBIND::moveu( TBIND *dp, TBIND *sp, W n )
{
	W	level;
	W	i, j, cnt;

	if ( dp == NULL ) return 0;

	level = sp->level;

	/* dp Υȥ˵ͤ */
	i = 0;
	for ( j = 0; j < NENT; ++j ) {
		if ( !dp->ent[j].empty(level) ) {
			if ( i != j ) dp->ent[i] = dp->ent[j];
			i++;
		}
	}

	/* sp  dp إȥư */
	cnt = 0;
	for ( j = 0; j < n; ++j ) {
		if ( i >= NENT ) break;

		if ( !sp->ent[j].empty(level) ) {
			cnt += ( level == 0 )? 1: sp->ent[j].b->nent;
			dp->ent[i++] = sp->ent[j];
			sp->ent[j].clear(level);
		}
	}

	/* dp λĤ򥯥ꥢ */
	while ( i < NENT ) dp->ent[i++].clear(level);

	dp->nent += cnt;
	sp->nent -= cnt;

	return cnt;
}
W TBIND::moved( TBIND *dp, TBIND *sp, W n )
{
	W	level;
	W	i, j, cnt;

	if ( dp == NULL ) return 0;

	level = sp->level;

	/* dp Υȥ򲼤˵ͤ */
	i = NENT-1;
	for ( j = NENT-1; j >= 0; --j ) {
		if ( !dp->ent[j].empty(level) ) {
			if ( i != j ) dp->ent[i] = dp->ent[j];
			i--;
		}
	}

	/* sp  dp إȥư */
	cnt = 0;
	for ( j = NENT-1; j >= NENT-n; --j ) {
		if ( i < 0 ) break;

		if ( !sp->ent[j].empty(level) ) {
			cnt += ( level == 0 )? 1: sp->ent[j].b->nent;
			dp->ent[i--] = sp->ent[j];
			sp->ent[j].clear(level);
		}
	}

	/* dp λĤ򥯥ꥢ */
	while ( i >= 0 ) dp->ent[i--].clear(level);

	dp->nent += cnt;
	sp->nent -= cnt;

	return cnt;
}

/*
 * src 鼫Ȥʣ
 * ƥȥ(TBIND,TSTR)ʣ롣
 */
ERR TBIND::dupset( const TBIND *src )
{
	W	i;
	ERR	err;

	if ( level > 0 ) {
		TBIND	*sp, *dp;

		for ( i = 0; i < NENT; ++i ) {
			sp = src->ent[i].b;
			if ( sp == NULL ) continue;

			dp = newTBIND(level);
			if ( dp == NULL ) { err = ER_NOMEM; goto err_ret; }
			ent[i].b = dp;

			err = dp->dupset(sp);
			if ( err < ER_OK ) goto err_ret;

			nent += dp->nent;
		}
	} else {
		TSTR	*sp, *dp;

		for ( i = 0; i < NENT; ++i ) {
			sp = src->ent[i].s;
			if ( sp == NULL ) continue;

			dp = newTSTR();
			if ( dp == NULL ) { err = ER_NOMEM; goto err_ret; }
			ent[i].s = dp;

			err = dp->dupset(*sp);
			if ( err < ER_OK ) goto err_ret;

			nent++;
		}
	}

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TBIND::dupset err = %d\n", err));
	return err;
}

/* ------------------------------------------------------------------------ */
/*
 *	class TAD
 *	TAD ǡ()
 */

/*
 * 󥹥ȥ饯
 */
TAD::TAD()
{
	refcnt = 0;
	root = NULL;
}

/*
 * ǥȥ饯
 */
TAD::~TAD()
{
	delete root;
}

/*
 * TSTR 
 */
TSTR* TAD::newTSTR()
{
	return new(nothrow) TSTR;
}

/*
 * TBIND 
 */
TBIND* TAD::newTBIND( W level )
{
	return new(nothrow) TBIND(level);
}

/*
 * TAD 
 */
TAD* TAD::newTAD()
{
	return new(nothrow) TAD;
}

/*
 * src 鼫Ȥʣ
 *	src Ƥ򼫿Ȥؤ٤ƥԡ롣
 *	ȷΥǡΤʣ̤졢ȤʬΥ롣
 */
ERR TAD::dupset( const TAD &src )
{
	ERR	err;

	if ( root != NULL ) {
		/* ߤƤ */
		delete root;
		root = NULL;
	}

	if ( src.root != NULL ) {
		/* ʣ */
		root = newTBIND(src.root->level);
		if ( root == NULL ) { err = ER_NOMEM; goto err_ret; }

		err = root->dupset(src.root);
		if ( err < ER_OK ) goto err_ret;
	}

	return ER_OK;

err_ret:
	delete root;
	DEBUG_PRINT(("TAD::dupset err = %d\n", err));
	return err;
}

/*
 * Ƥ򤹤٤ƾõ
 */
void TAD::clear()
{
	delete root;
	root = NULL;
}

/* ------------------------------------------------------------------------ */
/*
 *	class TBINDP
 *	TBIND ݥ
 */

/*
 * 󥹥ȥ饯
 */
TBINDP::TBINDP( TAD &data )
{
	init(&data);
}

/*
 * 
 */
void TBINDP::init( TAD *tp )
{
	tad = tp;
	jmp(0);
}

/*
 * Ǥդΰ֤ذư
 *	üԤξ index[0] = NENT Ȥʤ롣
 */
void TBINDP::jmp( W line_no )
{
	TBIND	*p, *q;
	W	i, ix;

	p = tad->root;
	if ( p == NULL ) {
		index[0] = TBIND::NENT;
		return;
	}

	if ( line_no < 0 ) {
		/* üԤذư */
		line_no = p->nent;
	}

	while ( p->level > 0 ) {
		for ( i = 0; i < TBIND::NENT; ++i ) {
			q = p->ent[i].b;
			if ( q == NULL ) continue;

			ix = i;
			if ( q->nent > line_no ) break;
			line_no -= q->nent;
		}
		index[p->level] = ix;
		p = p->ent[ix].b;
		if ( i >= TBIND::NENT ) line_no += p->nent;
	}

	for ( i = 0; i < TBIND::NENT; ++i ) {
		if ( p->ent[i].s == NULL ) continue;

		if ( --line_no < 0 ) break;
	}
	index[0] = i;
}

/*
 * ݥ󥿤 n Կʤ
 */
W TBINDP::next( TBIND *p, W n )
{
	W	i, ix, level;
	TBIND	*q;

	if ( p == NULL ) return n;

	level = p->level;
	i = index[level];

	if ( level > 0 ) {
		if ( i >= 0 ) {
			n = next(p->ent[i].b, n);
			if ( n <= 0 ) return n;
		}
		ix = -1;
		while ( ++i < TBIND::NENT ) {
			q = p->ent[i].b;
			if ( q == NULL ) continue;

			ix = i;
			if ( q->nent >= n ) break;
			n -= q->nent;
		}
		if ( ix >= 0 ) {
			index[level] = ix;
			q = p->ent[ix].b;
			if ( i >= TBIND::NENT ) n += q->nent;

			index[level-1] = -1;
			n = next(q, n);
		}
	} else {
		if ( i >= TBIND::NENT ) return n;

		while ( ++i < TBIND::NENT ) {
			if ( p->ent[i].s == NULL ) continue;

			if ( --n <= 0 ) break;
		}
		index[0] = i;
	}

	return n;
}

/*
 * ݥ󥿤 n ᤹
 */
W TBINDP::prev( TBIND *p, W n )
{
	W	i, ix, level;
	TBIND	*q;

	if ( p == NULL ) return n;

	level = p->level;
	i = index[level];

	if ( level > 0 ) {
		if ( i < TBIND::NENT ) {
			n = prev(p->ent[i].b, n);
			if ( n <= 0 ) return n;
		}
		ix = -1;
		while ( --i >= 0 ) {
			q = p->ent[i].b;
			if ( q == NULL ) continue;

			ix = i;
			if ( q->nent >= n ) break;
			n -= q->nent;
		}
		if ( ix >= 0 ) {
			index[level] = ix;
			q = p->ent[ix].b;
			if ( i < 0 ) n += q->nent;

			index[level-1] = TBIND::NENT;
			n = prev(q, n);
		}
	} else {
		ix = i;
		while ( --i >= 0 ) {
			if ( p->ent[i].s == NULL ) continue;

			ix = i;
			if ( --n <= 0 ) break;
		}
		index[0] = ix;
	}

	return n;
}

/*
 * ݥ󥿤 n Կʤ
 */
void TBINDP::next( W n )
{
	if ( n >= 0 )	next(tad->root, n);
	else		prev(tad->root, -n);
}

/*
 * ݥ󥿤 n ᤹
 */
void TBINDP::prev( W n )
{
	if ( n >= 0 )	prev(tad->root, n);
	else		next(tad->root, -n);
}

/*
 * ݥ󥿤
 */
int TBINDP::cmp( const TBINDP &p )
{
	W	level, i;

	if ( tad->root == NULL ) return 0;

	for ( level = tad->root->level; level >= 0; --level ) {
		i = index[level] - p.index[level];
		if ( i != 0 ) return i;
	}

	return 0;
}

/*
 * ߤιԤФ
 *	üԤξ NULL ֤
 */
TSTR* TBINDP::operator * ()
{
	TBIND	*p;

	p = tad->root;
	if ( p == NULL ) return NULL;

	while ( p->level > 0 ) {
		p = p->ent[index[p->level]].b;
	}

	return ( index[0] >= TBIND::NENT )? NULL: p->ent[index[0]].s;
}

/*
 * Ѷȥ
 *		= 1	줿
 *		= 0	ʤ
 *		< 0	顼
 */
WERR TBINDP::insentspc( TBIND *p )
{
	W	i, j, n, level;
	TBIND	*q;

	level = p->level;	/* ɬ > 0 */

	i = index[level];
	j = index[level-1];
	if ( j < TBIND::NENT ) {
		/* ٤ TBIND إȥ꡼ưƶ뤳Ȥߤ */
		n = j;
		if ( n > 0 && i > 0 ) {
			n = TBIND::moveu(p->ent[i-1].b, p->ent[i].b, n);
			if ( n > 0 ) return 1;
		}
		n = TBIND::NENT-1 - j;
		if ( n > 0 && i < TBIND::NENT-1 ) {
			n = TBIND::moved(p->ent[i+1].b, p->ent[i].b, n);
			if ( n > 0 ) return 1;
		}
	}

	/*  TBIND ɲѥȥ */
	i = p->insspc(index[level]);
	if ( i < 0 ) return 0;

	/*  TBIND ɲ */
	q = tad->newTBIND(level-1);
	if ( q == NULL ) goto err_ret;
	p->ent[i].b = q;

	/* ȾʬĤʬ */
	TBIND::moveu(q, p->ent[index[level]].b, TBIND::NENT/2);
	if ( index[level-1] < TBIND::NENT/2 ) index[level] = i;

	return 1;

err_ret:
	DEBUG_PRINT(("TBIND::insentspc err = %d\n", ER_NOMEM));
	return ER_NOMEM;
}

/*
 * 
 *		= 1	λ
 *		= 0	ʤ
 *		< 0	顼
 */
WERR TBINDP::insent( TBIND *p, TSTR *s )
{
	W	i, level;
	WERR	err;

	level = p->level;
	i = index[level];

	if ( level > 0 ) {
		/* ߤ */
		err = insent(p->ent[i].b, s);
		if ( err < ER_OK ) goto err_ret;

		if ( err == 0 ) {
			/* ȥ */
			err = insentspc(p);
			if ( err <= 0 ) return err; /* ʤ */
			i = index[level];

			/* ߤ */
			err = insent(p->ent[i].b, s);
			if ( err < ER_OK ) goto err_ret;
		}
	} else {
		/* ȥ */
		i = p->insspc(index[0]);
		if ( i < 0 ) return 0; /* ʤ */

		p->ent[i].s = s;
	}

	p->nent++;
	return 1; /* λ */

err_ret:
	DEBUG_PRINT(("TBINDP::insent(TBIND) err = %d\n", err));
	return err;
}

/*
 * Ԥ
 *	߹Ԥľ˹Ԥ롣
 *	߹ԤѤʤ(Ԥμι)
 */
ERR TBINDP::ins( TSTR *s )
{
	TBIND	*p, *q;
	ERR	err;

	p = tad->root;
	if ( p == NULL ) {
		/*  */
		p = tad->newTBIND(0);
		if ( p == NULL ) { err = ER_NOMEM; goto err_ret; }
		tad->root = p;

		p->ent[0].s = s;
		p->nent = 1;
	} else {
		/* ߤ */
		err = insent(p, s);
		if ( err < ER_OK ) goto err_ret;

		if ( err == 0 ) {
			if ( p->level >= MAXLEVEL ) {
				/* ʾĥǤʤ */
				err = ER_LIMIT;
				goto err_ret;
			}

			/* ǥå٥γĥ */
			q = tad->newTBIND(p->level + 1);
			if ( q == NULL ) { err = ER_NOMEM; goto err_ret; }
			q->ent[0].b = p;
			q->nent = p->nent;
			index[q->level] = 0;
			tad->root = q;

			/* ߤ */
			err = insent(q, s);
			if ( err < ER_OK ) goto err_ret;
		}
	}

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TBINDP::ins err = %d\n", err));
	return err;
}

/*
 * 
 */
W TBINDP::delent( TBIND *p )
{
	W	i, level;
	W	n;
	TBIND	*q;

	level = p->level;
	i = index[level];

	if ( level > 0 ) {
		q = p->ent[i].b;
		n = delent(q);
		if ( n > 0 ) {
			/* ݥ󥿤ʤ */
			n = next(p, n);
		}
		if ( q->nent == 0 ) {
			/* ˤʤä */
			delete q;
			p->ent[i].b = NULL;
		}
	} else {
		/* ݥ󥿤򼡤ؿʤ */
		n = next(p, 1);

		/*  */
		delete p->ent[i].s;
		p->ent[i].s = NULL;
	}

	p->nent--;
	return n;
}

/*
 * Ԥκ
 *	߹Ԥ롣
 *	߹ԤϼιԤȤʤ롣
 */
ERR TBINDP::del()
{
	TBIND	*p;
	ERR	err;

	p = tad->root;
	if ( p == NULL || index[0] >= TBIND::NENT )
			{ err = ER_ENDR; goto err_ret; }

	/*  */
	delent(p);
	if ( p->nent == 0 ) {
		/* ˤʤä */
		delete p;
		tad->root = NULL;
	}

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TBINDP::del err = %d\n", err));
	return err;
}

/* ------------------------------------------------------------------------ */
/*
 *	class TADP
 *	TAD ǡݥ
 */

/*
 * 󥹥ȥ饯
 */
TADP::TADP( TAD &tad )
	: bp(tad)
{
	TSTR	*s;

	s = *bp;
	if ( s != NULL ) sp.init(s);
}

/*
 * ǡüʤ true
 */
bool TADP::isend()
{
	if ( *bp == NULL ) return true;
	if ( *sp == TNULL && *(bp + 1) == NULL ) return true;
	return false;
}

/*
 * ݥ󥿤򣱤Ŀʤ
 */
void TADP::next()
{
	TSTR	*s;

	if ( *bp == NULL ) return;  /* ü */

	if ( *sp == TNULL ) {
		/*   ԤƬ */
		s = *++bp;
		if ( s != NULL ) sp.init(s);
	} else {
		++sp;
	}
}

/*
 * ݥ󥿤򣱤᤹
 */
void TADP::prev()
{
	TSTR	*s;

	s = *bp;
	if ( s == NULL || sp == TSTRP(*s) ) {
		/* üޤϹƬ  Ԥνü */
		if ( *--bp != s ) {
			s = *bp;
			sp.init(s);
			while ( *sp != TNULL ) ++sp;
		}
	} else {
		--sp;
	}
}

/*
 * ݥ󥿤ʤ
 *	ntc(TC)ʬݥ󥿤ʤ롣᤹(ntc<0)ȤϤǤʤ
 *	ԤĶưϤǤʤ
 *	ʤ᤿֤ꥳɤʤɥݥȤǤʤ֤
 *	СΰְʹߤκǽΥݥȲǽʰ֤Ȥʤ롣
 */
TADP& TADP::operator += ( int ntc )
{
	if ( *bp != NULL ) sp += ntc;

	return *this;
}

/*
 * ݥ󥿤򣱹Կʤ롿᤹
 *	ʸ֤ϹԤƬˤʤ롣
 */
void TADP::nextline()
{
	TSTR	*s;

	s = *++bp;
	if ( s != NULL ) sp.init(s);
}
void TADP::prevline()
{
	if ( bp == TBINDP(*bp.tad) ) return;  /* Ƭ */

	sp.init(*--bp);
}

/*
 * ݥ󥿤 n ܤ˰ư
 *	ƬԤ 0 ܤǤ롣
 *	n = -1 ǺǽԤؤΰưȤʤ
 */
void TADP::jumpline( W n )
{
	TSTR	*s;

	bp.jmp(n);
	s = *bp;
	if ( s != NULL ) sp.init(s);
}

/*
 * ݥ󥿤򸽺ߤιԤƬ˰ư
 */
void TADP::linetop()
{
	TSTR	*s;

	s = *bp;
	if ( s != NULL ) sp.init(s);
}

/*
 * ݥ󥿤
 */
int TADP::cmp( const TADP &p )
{
	int	i;

	i = bp.cmp(p.bp);
	if ( i != 0 ) return i;
	return sp.cmp(p.sp);
}

/*
 * ֤߰Υǡ(TC)Ф
 */
TC TADP::operator * ()
{
	return ( *bp == NULL )? TNULL: *sp;
}

/*
 * ʸ(TC)ȤθФ
 */
void TADP::get( TC &c, W &lang )
{
	if ( *bp != NULL ) {
		sp.get(c, lang);
	} else {
		c = TNULL;
		lang = TSC_SYS;
	}
}

/*
 * ʸȤƬθФ
 *	֤߰Ϣ³ʸ(ꥳɤޤ)Ф
 *	ְ߰ʹߤκǽʸʳΥǡޤϹüȤʤ롣
 *	s ʸƬΥݥ󥿤֤ꡢĹ(TC)֤ͤ롣
 *	s  TSTR ݻƤǡľܻؤƤΤǡƤ
 *	ѹƤϤʤ
 */
W TADP::get( const TC* &s, W &lang )
{
	if ( *bp != NULL ) {
		return sp.get(s, lang);
	} else {
		s = NULL;
		lang = TSC_SYS;
		return 0;
	}
}

/*
 * ¾ΥǡФ
 *	֤߰ΥǡפȼФǡפʤȤϡ
 *	id Τ߸֤߰Υǡ֤롣
 */
void TADP::get( TSEG &seg )
{
	if ( *bp != NULL ) {
		sp.get(seg);
	} else {
		seg.id = TNULL;
	}
}
void TADP::get( TNEST &nest )
{
	if ( *bp != NULL ) {
		sp.get(nest);
	} else {
		nest.id = TNULL;
	}
}
void TADP::get( TVOBJ &vobj )
{
	if ( *bp != NULL ) {
		sp.get(vobj);
	} else {
		vobj.id = TNULL;
	}
}

/*
 * Ԥκ
 *	߹Ԥľ˶ιԤɲä롣
 *	ɲäԤƬ˸֤߰ư롣
 */
ERR TADP::insline()
{
	TSTR	*s;
	ERR	err;

	s = bp.tad->newTSTR();
	if ( s == NULL ) { err = ER_NOMEM; goto err_ret; }

	err = bp.ins(s);
	if ( err < ER_OK ) goto err_ret;

	--bp;
	sp.init(s);

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TADP::insline err = %d\n", err));
	return err;
}

/*
 * ʸ
 *	ʸˤϡɬפ˱Ƹꥳɤ
 *	롣
 *	lang = 0 ξϡc ϸߤθƱǤȤߤʤ
 */
ERR TADP::ins( TC c, W lang )
{
	ERR	err;

	if ( *bp == NULL ) {
		/* ü  ˹Ԥɲ */
		err = insline();
		if ( err < ER_OK ) goto err_ret;
	}

	err = sp.ins(c, lang);
	if ( err < ER_OK ) goto err_ret;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TADP::ins(TC) err = %d\n", err));
	return err;
}

/*
 * ʸ
 *	ʸ s  TNULL ޤ len ʸ(TC)Τɤ餫ã
 *	ޤ롣len < 0 ξϡlen ̵뤹롣
 *	ʸˤϡɬפ˱Ƹꥳɤ
 *	롣
 *	lang = 0 ξϡs Ƭθ줬ߤθƱǤ
 *	ߤʤ
 */
ERR TADP::ins( const TC *s, W lang, W len )
{
	ERR	err;

	if ( *bp == NULL ) {
		/* ü  ˹Ԥɲ */
		err = insline();
		if ( err < ER_OK ) goto err_ret;
	}

	err = sp.ins(s, lang, len);
	if ( err < ER_OK ) goto err_ret;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TADP::ins(TC*) err = %d\n", err));
	return err;
}

/*
 * ¾Υǡ
 */
ERR TADP::ins( TSEG &seg )
{
	ERR	err;

	if ( *bp == NULL ) {
		/* ü  ˹Ԥɲ */
		err = insline();
		if ( err < ER_OK ) goto err_ret;
	}

	err = sp.ins(seg);
	if ( err < ER_OK ) goto err_ret;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TADP::ins(TSEG) err = %d\n", err));
	return err;
}
ERR TADP::ins( TNEST &nest )
{
	ERR	err;

	if ( *bp == NULL ) {
		/* ü  ˹Ԥɲ */
		err = insline();
		if ( err < ER_OK ) goto err_ret;
	}

	err = sp.ins(nest);
	if ( err < ER_OK ) goto err_ret;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TADP::ins(TNEST) err = %d\n", err));
	return err;
}
ERR TADP::ins( TVOBJ &vobj )
{
	ERR	err;

	if ( *bp == NULL ) {
		/* ü  ˹Ԥɲ */
		err = insline();
		if ( err < ER_OK ) goto err_ret;
	}

	err = sp.ins(vobj);
	if ( err < ER_OK ) goto err_ret;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TADP::ins(TVOBJ) err = %d\n", err));
	return err;
}
ERR TADP::ins( TSTR &str )
{
	ERR	err;

	if ( *bp == NULL ) {
		/* ü  ˹Ԥɲ */
		err = insline();
		if ( err < ER_OK ) goto err_ret;
	}

	err = sp.ins(str);
	if ( err < ER_OK ) goto err_ret;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TADP::ins(TSTR) err = %d\n", err));
	return err;
}

/*
 * ֥å
 * ()	Υǡ	ǡ	
 *	ABC		uvw		Auvw
 *	 ^		xyz		xyzBC
 *					   ^
 */
ERR TADP::ins( TAD &tad )
{
	TBINDP	src(tad);
	TSTR	*s;
	ERR	err;

	s = *src;
	if ( s == NULL ) return ER_OK; /*  */

	if ( *bp == NULL ) {
		/* ü  ˹Ԥɲ */
		err = insline();
		if ( err < ER_OK ) goto err_ret;
	}

	for ( ;; ) {
		err = sp.ins(*s);
		if ( err < ER_OK ) goto err_ret;

		s = *++src;
		if ( s == NULL ) break;

		err = split();
		if ( err < ER_OK ) goto err_ret;
	}

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TADP::ins(TAD) err = %d\n", err));
	return err;
}

/*
 * ʸȥȤδޤޤ줿 TC 
 *	ʸȥȤκ s  TNULL ޤ len ʸ(TC)
 *	ɤ餫ãޤ롣
 *	len < 0 ξϡlen ̵뤹롣
 *	ȤϤ٤ TSEG ǳǼΤǡȥ
 *	ʤ TSEG ǤϳǼǤʤΤ s ˴ޤ뤳ȤϤǤʤ
 *	s ˲(TK_NL)Фΰ֤ǲ(ʬ)Ԥ롣
 *	lang = 0 ξϡs Ƭθ줬ߤθƱǤ
 *	ߤʤ
 */
ERR TADP::instadstr( const TC *s, W lang, W len )
{
	const TC	*p, *q;
	TC		c;
	W		i, n, p_lang;
	UW		sz;
	TSEG		seg;
	ERR		err;

	n = 0;
	p = s;
	p_lang = lang;
	while ( len != 0 && (c = *p) != TNULL ) {
		i = isTLANGch(c, &n);
		if ( i != 0 ) {
			p_lang = i;
			++p;
			--len;
			continue;
		}
		if ( c < 0xff80 ) {
			++p;
			--len;
			if ( c != TK_NL ) continue;
		}

		if ( (i = p - s) > 0 ) {
			/* ʸ */
			err = ins(s, lang, i);
			if ( err < ER_OK ) goto err_ret;
			lang = p_lang;
			s = p;
		}

		if ( c == TK_NL ) {
			/*  */
			err = split();
			if ( err < ER_OK ) goto err_ret;
			continue;
		}

		/*  */
		q = p + 1;
		if ( --len == 0 ) break;
		sz = *q++;
		if ( sz == 0xffff ) {
			if ( --len == 0 || --len == 0 ) break;
			sz = GetMisalignW((UB*)q);
			q += 2;
		}
		i = sz / sizeof(TC);
		if ( --len >= 0 && len < i ) break;
		err = seg.set(c, sz, (VP)q);
		if ( err < ER_OK ) goto err_ret;
		err = ins(seg);
		if ( err < ER_OK ) goto err_ret;
		s = p = q + i;
		len -= i;
	}
	if ( (i = p - s) > 0 ) {
		/* ʸ */
		err = ins(s, lang, i);
		if ( err < ER_OK ) goto err_ret;
	}

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TADP::instadstr err = %d\n", err));
	return err;
}

/*
 * ߹Ԥμ
 *	߹Ԥ֤üԤξ NULL ֤
 *	֤줿 TSTR  TAD 饹ǴƤǡľܻؤ
 *	Τǡ(delete)ƤϤʤ
 */
TSTR* TADP::getline()
{
	return *bp;
}

/*
 * Ԥ
 *	߹Ԥľˣ롣
 *	֤߰Ѳʤ
 *	TSTR  TAD 饹δ롣
 *	TSTR  new ǳ֥ȤǤʤФʤʤ
 */
ERR TADP::insline( TSTR *str )
{
	ERR	err;

	err = bp.ins(str);
	if ( err < ER_OK ) goto err_ret;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TADP::insline err = %d\n", err));
	return err;
}

/*
 * ߹Ԥκ
 *	߹Ԥ롣
 *	֤߰ϼιԤƬȤʤ롣
 */
ERR TADP::delline()
{
	TSTR	*s;
	ERR	err;

	if ( *bp == NULL ) return ER_OK;  /* ü */

	/* Ժ */
	err = bp.del();
	if ( err < ER_OK ) goto err_ret;

	/* üԤǤʤСƬ֤ */
	if ( (s = *bp) != NULL ) sp.init(s);

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TADP::delline err = %d\n", err));
	return err;
}

/*
 * ֤߰Υǡ
 *	 TNULL ϺǤʤ
 *	äơԤ뤳ȤϤǤʤ
 * ()	߰ ^  D 
 *	ABCDEFG
 *	   ^
 *	ABCEFG
 *	   ^
 */
ERR TADP::del()
{
	ERR	err;

	if ( *bp == NULL ) return ER_OK;  /* üԤʤΤǺԲ */

	err = sp.del();
	if ( err < ER_OK ) goto err_ret;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TADP::del err = %d\n", err));
	return err;
}

/*
 * ֤߰ p ľޤǤ
 * p Ʊ TAD ǡ֤߰ؤƤʤФʤʤ
 * 塢p ΰ֤Ȥʤ롣
 * ǡ blk ¸롣
 * ()	ABCDEFG
 *	 ^   p
 *	AFG
 *	 ^
 */
ERR TADP::cut( TAD &blk, TADP &p )
{
	TSTR	*s;
	ERR	err;

	/* ¸򥯥ꥢƤ */
	blk.clear();
	TBINDP dst(blk);

	if ( bp < p.bp ) {
		/* ǽιԤιԤ椫κ */
		if ( sp > TSTRP(**bp) ) {
			s = blk.newTSTR();
			if ( s == NULL ) { err = ER_NOMEM; goto err_ret; }
			err = sp.split(*s);
			if ( err < ER_OK ) goto err_ret;
			err = dst.ins(s);
			if ( err < ER_OK ) goto err_ret;
			++bp;
		}

		/* ñ̤κ */
		while ( bp < p.bp ) {
			err = dst.ins(*bp);
			if ( err < ER_OK ) goto err_ret;
			err = bp.del();
			if ( err < ER_OK ) goto err_ret;
		}

		/* üԤǤʤСƬ֤ */
		if ( (s = *bp) != NULL ) sp.init(s);
	}

	/* ǸιԤκ */
	if ( *bp != NULL && sp < p.sp ) {
		s = blk.newTSTR();
		if ( s == NULL ) { err = ER_NOMEM; goto err_ret; }
		err = sp.cut(*s, p.sp);
		if ( err < ER_OK ) goto err_ret;
		err = dst.ins(s);
		if ( err < ER_OK ) goto err_ret;
	}

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TADP::cut err = %d\n", err));
	return err;
}

/*
 * ֤߰ p ľޤǤ blk ʣ̤
 * p Ʊ TAD ǡ֤߰ؤƤʤФʤʤ
 */
ERR TADP::cpy( TAD &blk, TADP &p )
{
	TSTR	*s;
	TSTRP	q;
	ERR	err;

	/* ¸򥯥ꥢƤ */
	blk.clear();
	TBINDP dst(blk);

	if ( bp < p.bp ) {
		/* ǽιԤιԤ椫ʣ */
		if ( sp > TSTRP(**bp) ) {
			s = blk.newTSTR();
			if ( s == NULL ) { err = ER_NOMEM; goto err_ret; }
			for ( q = sp; *q != TNULL; q++ );
			err = sp.cpy(*s, q);
			if ( err < ER_OK ) goto err_ret;
			err = dst.ins(s);
			if ( err < ER_OK ) goto err_ret;
			++bp;
		}

		/* ñ̤ʣ */
		while ( bp < p.bp ) {
			s = blk.newTSTR();
			if ( s == NULL ) { err = ER_NOMEM; goto err_ret; }
			err = s->set(**bp);
			if ( err < ER_OK ) goto err_ret;
			err = dst.ins(s);
			if ( err < ER_OK ) goto err_ret;
			++bp;
		}

		/* üԤǤʤСƬ֤ */
		if ( (s = *bp) != NULL ) sp.init(s);
	}

	/* ǸιԤʣ */
	if ( *bp != NULL && sp < p.sp ) {
		s = blk.newTSTR();
		if ( s == NULL ) { err = ER_NOMEM; goto err_ret; }
		err = sp.cpy(*s, p.sp);
		if ( err < ER_OK ) goto err_ret;
		err = dst.ins(s);
		if ( err < ER_OK ) goto err_ret;
	}

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TADP::cpy err = %d\n", err));
	return err;
}

/*
 * Ԥʬ䤹
 *	߹Ԥθְ߰ʹߤʬ䤷ԤȤƼιԤ롣
 *	֤߰ϿԤƬȤʤ(Ĥޤꡢ֤߰
 *	Ѥʤ)
 *	֤߰üǤСԤɲäƱǤ롣
 */
ERR TADP::split()
{
	TSTR	*s;
	ERR	err;

	if ( *bp == NULL ) { err = ER_ENDR; goto err_ret; }  /* ü */

	s = bp.tad->newTSTR();
	if ( s == NULL ) { err = ER_NOMEM; goto err_ret; }

	++bp;
	err = bp.ins(s);
	--bp;
	if ( err < ER_OK ) goto err_ret;

	err = sp.split(*s);
	sp.init(s);
	if ( err < ER_OK ) goto err_ret;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TADP::split err = %d\n", err));
	return err;
}

/*
 * Ԥ礹
 *	߹Ԥθ˼ιԤĤʤǣԤˤ롣
 *	֤߰Ѥʤ
 */
ERR TADP::join()
{
	TSTR	*s;
	ERR	err;

	if ( *bp == NULL ) { err = ER_ENDR; goto err_ret; }  /* ü */

	s = *(bp + 1);
	if ( s == NULL ) return ER_OK;  /* ԤϤʤ */

	err = sp.join(*s);
	if ( err < ER_OK ) goto err_ret;

	++bp;
	err = bp.del();
	--bp;
	if ( err < ER_OK ) goto err_ret;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TADP::join err = %d\n", err));
	return err;
}

/*
 * 
 *	(TK_NL)split() ǹԤʬ䤹롣
 */
ERR TADP::newline()
{
	ERR	err;

	err = ins(TK_NL, 0);
	if ( err < ER_OK ) goto err_ret;

	err = split();
	if ( err < ER_OK ) goto err_ret;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TADP::newline err = %d\n", err));
	return err;
}

/* ------------------------------------------------------------------------ */
} // namespace LIBCPP1
