/*
 *	@(#)tadview.cc (libcpp1) 01-11-22
 *
 *	TAD 쥤ȡɽ饤֥
 *	(C) Copyright 2000-2001 by Personal Media Corporation
 */

#include "libcpp.h"
#include "cpp/1/tadview.h"

namespace LIBCPP1 {

/*
 * RATIO Ѵ
 */
W ratio( RATIO r, W x )
{
	W a = r >> 8;
	W b = r & 0xff;
	return ( b == 0 )? x: x * a / b;
}

/*
 * SCALE Ѵ
 */
W scale( SCALE s, W std )
{
	return ( (s & 0x8000) == 0 )? ratio(s, std): s & 0x7fff;
}

/* ------------------------------------------------------------------------ */
/*
 *	class LPNT
 *	쥤ȺɸϤΰ
 */

/*
 * ư
 */
LPNT& LPNT::move( W dx, W dy )
{
	x += dx;
	y += dy;

	return *this;
}
LPNT& LPNT::move( const PNT &d )
{
	x += d.x;
	y += d.y;

	return *this;
}

/* ------------------------------------------------------------------------ */
/*
 *	class LRECT, CLRECT
 *	쥤ȺɸϤϰ
 */

/*
 * 󥹥ȥ饯
 */
CLRECT::CLRECT( W l, W t, W r, W b )
{
	left   = l;
	top    = t;
	right  = r;
	bottom = b;
}
CLRECT::CLRECT( const LPNT &lefttop, const LPNT &rightbot )
{
	left   = lefttop.x;
	top    = lefttop.y;
	right  = rightbot.x;
	bottom = rightbot.y;
}

/*
 * 	r 򤽤Τޤ
 */
LRECT& LRECT::set( const RECT &r )
{
	left   = r.c.left;
	top    = r.c.top;
	right  = r.c.right;
	bottom = r.c.bottom;

	return *this;
}

/*
 * 	org кɸǼ r ΰ֤
 */
LRECT& LRECT::set( const LPNT &org, const RECT &r )
{
	left   = org.x + r.c.left;
	right  = org.x + r.c.right;
	top    = org.y + r.c.top;
	bottom = org.y + r.c.bottom;

	return *this;
}

/*
 * 	r κ p ΰ֤˹碌
 */
LRECT& LRECT::pos( const LPNT &p, const RECT &r )
{
	left   = p.x;
	right  = p.x + rectwidth(r);
	top    = p.y;
	bottom = p.y + rectheight(r);

	return *this;
}

/*
 * ư
 */
LRECT& LRECT::move( W dx, W dy )
{
	left   += dx;
	right  += dx;
	top    += dy;
	bottom += dy;

	return *this;
}
LRECT& LRECT::move( const PNT &d )
{
	left   += d.x;
	right  += d.x;
	top    += d.y;
	bottom += d.y;

	return *this;
}

/*
 * å
 */
bool LRECT::sect( const LRECT &r )
{
	return left   < r.right
	    && right  > r.left
	    && top    < r.bottom
	    && bottom > r.top;
}

/*
 * ޥå
 */
bool LRECT::in( const LPNT &p )
{
	return left   <= p.x
	    && right  >  p.x
	    && top    <= p.y
	    && bottom >  p.y;
}

/* ------------------------------------------------------------------------ */
/*
 *	class LVIEW
 *	쥤ɽѴ
 */

/*
 * 쥤Ⱥɸ饹꡼ɸؤѴ
 *	org ϥ쥤Ⱥɸδrel Ϥа
 */
PNT& LVIEW::scrpos( PNT &sp, const LPNT &lp )
{
	W dx = viewport.c.left - window.left;
	W dy = viewport.c.top  - window.top;

	sp.x = lp.x + dx;
	sp.y = lp.y + dy;

	return sp;
}
PNT& LVIEW::scrpos( PNT &sp, const LPNT &org, const PNT &rel )
{
	W dx = viewport.c.left - window.left;
	W dy = viewport.c.top  - window.top;

	sp.x = org.x + rel.x + dx;
	sp.y = org.y + rel.y + dy;

	return sp;
}
RECT& LVIEW::scrpos( RECT &sr, const LRECT &lr )
{
	W dx = viewport.c.left - window.left;
	W dy = viewport.c.top  - window.top;

	sr.c.left   = lr.left   + dx;
	sr.c.right  = lr.right  + dx;
	sr.c.top    = lr.top    + dy;
	sr.c.bottom = lr.bottom + dy;

	return sr;
}
RECT& LVIEW::scrpos( RECT &sr, const LPNT &org, const RECT &rel )
{
	W dx = viewport.c.left - window.left;
	W dy = viewport.c.top  - window.top;

	sr.c.left   = org.x + rel.c.left   + dx;
	sr.c.right  = org.x + rel.c.right  + dx;
	sr.c.top    = org.y + rel.c.top    + dy;
	sr.c.bottom = org.y + rel.c.bottom + dy;

	return sr;
}

/*
 * 쥤Ⱥɸ饹꡼ɸؤѴ(ߥå)
 *	Ѵγƺɸͤ RECT ɽ碌ϰϤĶϡ
 *	³ͤǥߥåȤ롣Τ褦ʺɸĤǤ⤢
 *	 true ֤٤Ƥκɸ RECT ɽ碌ϰǤ
 *	 false ֤
 *
 *	 16bit դޤǻȤݤʤȤ¿Τǡ30000 ǥߥåȤ롣
 */
LOCAL H limit( W x, bool &over )
{
const	H	max = 30000;
const	H	min = -30000;

	if ( x > max ) {
		x = max;
		over = true;
	}
	if ( x < min ) {
		x = min;
		over = true;
	}

	return x;
}
bool LVIEW::scrpos_limit( PNT &sp, const LPNT &lp )
{
	W dx = viewport.c.left - window.left;
	W dy = viewport.c.top  - window.top;

	bool over = false;

	sp.x = limit(lp.x + dx, over);
	sp.y = limit(lp.y + dy, over);

	return over;
}
bool LVIEW::scrpos_limit( PNT &sp, const LPNT &org, const PNT &rel )
{
	W dx = viewport.c.left - window.left;
	W dy = viewport.c.top  - window.top;

	bool over = false;

	sp.x = limit(org.x + rel.x + dx, over);
	sp.y = limit(org.y + rel.y + dy, over);

	return over;
}
bool LVIEW::scrpos_limit( RECT &sr, const LRECT &lr )
{
	W dx = viewport.c.left - window.left;
	W dy = viewport.c.top  - window.top;

	bool over = false;

	sr.c.left   = limit(lr.left   + dx, over);
	sr.c.right  = limit(lr.right  + dx, over);
	sr.c.top    = limit(lr.top    + dy, over);
	sr.c.bottom = limit(lr.bottom + dy, over);

	return over;
}
bool LVIEW::scrpos_limit( RECT &sr, const LPNT &org, const RECT &rel )
{
	W dx = viewport.c.left - window.left;
	W dy = viewport.c.top  - window.top;

	bool over = false;

	sr.c.left   = limit(org.x + rel.c.left   + dx, over);
	sr.c.right  = limit(org.x + rel.c.right  + dx, over);
	sr.c.top    = limit(org.y + rel.c.top    + dy, over);
	sr.c.bottom = limit(org.y + rel.c.bottom + dy, over);

	return over;
}

/*
 * ꡼ɸ쥤ȺɸؤѴ
 */
LPNT& LVIEW::laypos( LPNT &lp, const PNT &sp )
{
	W dx = viewport.c.left - window.left;
	W dy = viewport.c.top  - window.top;

	lp.x = sp.x - dx;
	lp.y = sp.y - dy;

	return lp;
}
LRECT& LVIEW::laypos( LRECT &lr, const RECT &sr )
{
	W dx = viewport.c.left - window.left;
	W dy = viewport.c.top  - window.top;

	lr.left   = sr.c.left   - dx;
	lr.right  = sr.c.right  - dx;
	lr.top    = sr.c.top    - dy;
	lr.bottom = sr.c.bottom - dy;

	return lr;
}

/*
 * ꡼ɸкɸؤѴ
 *	org ϥ쥤Ⱥɸδа֤Ѵ
 */
PNT& LVIEW::relpos( PNT &rel, const LPNT &org, const PNT &sp )
{
	W dx = viewport.c.left - window.left;
	W dy = viewport.c.top  - window.top;

	rel.x = sp.x - dx - org.x;
	rel.y = sp.y - dy - org.y;

	return rel;
}
RECT& LVIEW::relpos( RECT &rel, const LPNT &org, const RECT &sr )
{
	W dx = viewport.c.left - window.left;
	W dy = viewport.c.top  - window.top;

	rel.c.left   = sr.c.left   - dx - org.x;
	rel.c.right  = sr.c.right  - dx - org.x;
	rel.c.top    = sr.c.top    - dy - org.y;
	rel.c.bottom = sr.c.bottom - dy - org.y;

	return rel;
}

/* ------------------------------------------------------------------------ */
/*
 *	class LENV
 *	쥤ȴĶ
 */

/*
 * ɸŪʽ
 */
ERR LENV::setstd( W wid, TADTYPE typ )
{
	W	n;
	ERR	err;

	/* ǡ */
	type = typ;

	/* 쥤ѻ極libapp  */
	paper.h = paper_size.x;
	paper.v = paper_size.y;

	/* طʥѥ󡧥ɥطʥѥ */
	n = wget_bgp(wid, NULL, 0);
	if ( n < ER_OK ) { err = n; goto err_ret1; }
	bgpat = (PAT*)malloc(n);
	if ( bgpat == NULL ) { err = ER_NOMEM; goto err_ret1; }
	err = wget_bgp(wid, bgpat, n);
	if ( err < ER_OK ) goto err_ret2;

	return ER_OK;

err_ret2:
	free(bgpat);
err_ret1:
	DEBUG_PRINT(("LENV::setstd err = %d\n", err));
	return err;
}

/* ------------------------------------------------------------------------ */
/*
 *	class LATR
 *	쥤°
 */

/*
 * ͤ (ɸ)
 */
ERR LATR::setdefault( LENV &env )
{
	H	paperwid;
	ERR	err;

	chsz = CHSSTD;				// ʸɸ(16)
	h_ratio = w_ratio = 0;			// ʸ

	fgc = COL_BLACK;			// ʸ
	bgc = COL_TRANS;			// ʸطƩ
	dir = TORIGHT;				// 
	gap.hgap.dir = gap.vgap.dir = 0;	// ʸֳ֤ʤ
	gap.hgap.gap = gap.vgap.gap = 0x8000;
	gap.hspgap.dir = gap.vspgap.dir = 0;	// ֳ֤ʤ
	gap.hspgap.gap = gap.vspgap.gap = 0x8000;
	fspec.name[0] = TNULL;			// ǥեȥե
	fspec.fclass = FTC_DEFAULT;
	fspec.attr = 0;
	fspec.size.h = fspec.size.v = chsz;

	lheight = 0;
	lgap_atr = 0;				// Դֳ֤ʤ
	lgap = 0;

	if ( env.paper.h == 0x7fff && env.paper.v == 0x7fff ) {
		/* üꡧѻ極Ĳ 0x7ffff ʤ饿֤ʤ */
		paperwid = 0;
	} else {
		paperwid = MAX(env.paper.h, env.paper.v);
	}

	err = tab.setdefault(paperwid);
	if ( err < ER_OK ) goto err_ret;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("LATR::setdefault err = %d\n", err));
	return err;
}

/*
 * ͤ (ɥɸ)
 */
ERR LATR::setdefault_win( LENV &env )
{
	ERR	err;

	/* ɸ */
	err = setdefault(env);
	if ( err < ER_OK ) goto err_ret;

	/* ɥΤ */
	err = wget_inf(WI_FSWINDOW, &fspec, sizeof(fspec));
	if ( err < ER_OK ) goto err_ret;

	/* ʸطʿ */
	err = wget_inf(WI_GSBGC(WI_WORKBACK), &bgc, sizeof(bgc));
	if ( err < ER_OK ) goto err_ret;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("LATR::setdefault_win err = %d\n", err));
	return err;
}

/*
 * ͤ (ѥͥɸ)
 */
ERR LATR::setdefault_pnl( LENV &env )
{
	ERR	err;

	/* ɸ */
	err = setdefault(env);
	if ( err < ER_OK ) goto err_ret;

	/* ѥͥΤ */
	err = wget_inf(WI_FSPANEL, &fspec, sizeof(fspec));
	if ( err < ER_OK ) goto err_ret;

	/* ʸطʿ */
	err = wget_inf(WI_GSBGC(WI_PANELBACK), &bgc, sizeof(bgc));
	if ( err < ER_OK ) goto err_ret;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("LATR::setdefault_pnl err = %d\n", err));
	return err;
}

/*
 * Ķ
 *	ߤ° gid Ķꤹ롣
 */
ERR LATR::setgenv( W gid )
{
	ERR	err, error = ER_OK;

	/* եȤ¸ߤʤץȤǥեԤȥ顼
	   ʤΤǡöƥॹץȤѹ */
	err = gset_scr(gid, TSC_SYS);
	if ( err < ER_OK ) error = err;

	fspec.size.h = ratio(w_ratio, chsz);	// ʸ
	fspec.size.v = ratio(h_ratio, chsz);

	err = gset_chc(gid, fgc, bgc);		// ʸ
	if ( err < ER_OK ) error = err;

	err = gset_chd(gid, dir, &gap);		// ʸֳ
	if ( err < ER_OK ) error = err;

	err = gset_fon(gid, &fspec);		// եȻ
	if ( err < ER_OK ) error = err;

	err = gget_fon(gid, NULL, &finfo);	// եȾμ
	if ( err < ER_OK ) error = err;

#ifdef DEBUG
	if ( error < ER_OK ) DEBUG_PRINT(("LATR::setgenv err = %d\n", error));
#endif
	return error;
}

/*
 * °ѹĶؤ (ʸΨ)
 */
ERR LATR::setchratio( W gid, RATIO height, RATIO width )
{
	ERR	err, error = ER_OK;

	/* եȤ¸ߤʤץȤǥեԤȥ顼
	   ʤΤǡöƥॹץȤѹ */
	err = gset_scr(gid, TSC_SYS);
	if ( err < ER_OK ) error = err;

	h_ratio = height;
	w_ratio = width;

	fspec.size.v = ratio(h_ratio, chsz);
	fspec.size.h = ratio(w_ratio, chsz);

	/* եȻ */
	err = gset_fon(gid, &fspec);
	if ( err < ER_OK ) error = err;

	/* եȾμ */
	err = gget_fon(gid, NULL, &finfo);
	if ( err < ER_OK ) error = err;

#ifdef DEBUG
	if ( error < ER_OK )
		DEBUG_PRINT(("LATR::setchratio err = %d\n", error));
#endif
	return error;
}

/*
 * ʸֳ(ɥåȿ)
 */
W LATR::hgap()
{
	W n = scale(gap.hgap.gap, fspec.size.h);
	return ( gap.hgap.dir == 0 )? n: -n;
}
W LATR::vgap()
{
	W n = scale(gap.vgap.gap, fspec.size.v);
	return ( gap.vgap.dir == 0 )? n: -n;
}

/* ------------------------------------------------------------------------ */
/*
 *	class LTSTR
 *	TAD ǡ
 */

/*
 * 󥹥ȥ饯
 */
LTSTR::LTSTR( W lang )
	: TSTR(lang)
{
}

/* ------------------------------------------------------------------------ */
/*
 *	class LOSTR
 *	LTSTR 쥤ȥ󥸥
 */

/*
 * 󥹥ȥ饯
 */
LOSTR::LOSTR( LTSTR *s, LENV *e )
{
	env = e;
	str = s;
	chr = NULL;
	chp = NULL;
}

/*
 * ǥȥ饯
 */
LOSTR::~LOSTR()
{
	delete[] chr;
	delete[] chp;
}

/*
 * ʸ֤μ
 *	gid	Ķ
 *	atr	쥤°
 *	x, y	ʸ賫ϰ
 *	str	ʸ
 *	lang	ʸƬθ
 *		üθ줬֤롣
 *	len	str Ĺ (TC ñ)
 *	chp	ʸ֤Ǽ (len ɬ)
 *	chr	ʸΰǼ (len ɬ)
 *
 *	 (TORIGHT)Τб
 */
ERR LOSTR::getstrpos( W gid, LATR &atr, W x, W y,
			const TC *str, W &lang, W len, PNT chp[], RECT chr[] )
{
	W	i, n, l, pitch;
	ERR	err;

	if ( (atr.fspec.attr & FT_PROP) != 0 ) {
		/* ԥåDP ƤӽФ */

		err = gset_scr(gid, lang);
		if ( err < ER_OK ) goto err_ret;
		err = gset_chp(gid, x, y, True);
		if ( err < ER_OK ) goto err_ret;

		/* ʸΰ */
		err = gget_str(gid, (TC*)str, len, NULL, chp, chr, NULL, NULL);
		if ( err < ER_OK ) goto err_ret;
		if ( err > 0 ) lang = err;
	} else {
		/* ԥåDP ƤӽФ˼Ƿ׻(®Τ) */

		pitch = atr.fspec.size.h + atr.hgap();
		n = 0;
		for ( i = 0; i < len; ++i ) {
			l = isTLANGch(str[i], &n);
			if ( l != 0 || str[i] == TNULL ) {
				if ( l > 0 ) lang = l;
				/* ꥳɤ϶Ȥư */
				chp[i].x = x;
				chp[i].y = y;
				chr[i].c.left   = x;
				chr[i].c.right  = x;
				chr[i].c.top    = y;
				chr[i].c.bottom = y;
			} else {
				chp[i].x = x;
				chp[i].y = y;
				chr[i].c.left   = x;
				chr[i].c.right  = x + atr.fspec.size.h;
				chr[i].c.top    = y - atr.finfo.base + 1;
				chr[i].c.bottom = chr[i].c.top
							+ atr.finfo.height;
				x += pitch;
			}
		}
	}

	return ER_OK;

err_ret:
	DEBUG_PRINT(("LOSTR::getstrpos err = %d\n", err));
	return err;
}

/*
 * 쥤Ⱦμ(ʸ)
 */
WERR LOSTR::getlayoutinfo_str( W gid, LATR &atr, TSTRP &sp )
{
	PNT	*chpp = &chp[sp.cpos];
	RECT	*chrp = &chr[sp.cpos];
const	TC	*tp, *ep, *p;
	TC	c;
	W	i, n, lang, dx;
	PNT	nchp;
	ERR	err;

	/* ʸμ */
	n = sp.get(tp, lang);

	/* Ľ񤭤ξ֥եå */
	dx = ( atr.dir == TOUP || atr.dir == TODOWN )? atr.fspec.size.h/2: 0;

	nchp = *chpp;
	ep = tp + n;
	for ( p = tp; tp <= ep; ++p ) {
		if ( !(*p < 0x0020 || *p == 0x007f) && p < ep ) continue;

		i = p - tp;
		if ( i > 0 ) {
			/* ʸΰ */
			err = getstrpos(gid, atr, nchp.x - dx, nchp.y,
						tp, lang, i+1, chpp, chrp);
			if ( err < ER_OK ) goto err_ret;

			while ( --i >= 0 ) {
				chpp->x += dx;
				++chpp;
				++chrp;
			}
			chpp->x += dx;
			nchp = *chpp;  // 
		}

		/* 楳ʬ */
		*chpp = nchp;
		if ( (c = *p) == TK_NL || c == TK_TAB ) {
			if ( atr.dir == TORIGHT || atr.dir == TOLEFT ) {
				i = -(atr.finfo.base - 1);
				setrect(*chrp,
					chpp->x, i,
					chpp->x, i + atr.finfo.height);
			} else {
				i = -(atr.finfo.width / 2);
				setrect(*chrp,
					i, chpp->y,
					i + atr.finfo.width, chpp->y);
			}
		} else {
			chrp->p.lefttop  = *chpp;
			chrp->p.rightbot = *chpp;
		}
		++chpp;
		++chrp;

		tp = p + 1;
	}

	sp += n;
	return n;

err_ret:
	DEBUG_PRINT(("LOSTR::getlayoutinfo_str err = %d\n", err));
	return err;
}

/*
 * 쥤Ⱦμ()
 */
WERR LOSTR::getlayoutinfo_seg( W gid, LATR &atr, TSTRP &sp )
{
	PNT	*chpp = &chp[sp.cpos];
	RECT	*chrp = &chr[sp.cpos];
	TSEG	buf;
	ERR	err;

	/* Ȥμ */
	sp.get(buf);
	TSEGU seg(buf);

	chrp[0].p.lefttop  = chpp[0];
	chrp[0].p.rightbot = chpp[0];
	chpp[1] = chpp[0];

	/* ƥȤΥ쥤 */
	err = seg->layout(gid, atr, chpp[1], chrp[0]);
	if ( err < ER_OK ) goto err_ret;

	++sp;
	return 1;

err_ret:
	DEBUG_PRINT(("LOSTR::getlayoutinfo_seg err = %d\n", err));
	return err;
}

/*
 * 쥤Ⱦμ(TAD)
 */
WERR LOSTR::getlayoutinfo_nest( W gid, LATR &atr, TSTRP &sp )
{
	/* ̤ݡȡ̵ */
	++sp;
	return 0;
}

/*
 * 쥤Ⱦμ()
 */
WERR LOSTR::getlayoutinfo_vobj( W gid, LATR &atr, TSTRP &sp )
{
	PNT	*chpp = &chp[sp.cpos];
	RECT	*chrp = &chr[sp.cpos];
	TVOBJ	vobj;
	W	dx, dy, w, h;
	ERR	err;

	/* Ȥμ */
	sp.get(vobj);

	/* Ȥΰ֤礭μ */
	err = orsz_vob(vobj.vid, chrp, V_CHECK|V_NODISP);
	if ( err < ER_OK ) goto err_ret;

	if ( env->type == TAD_TEXT ) {
		/*  */
		switch ( atr.dir ) {
		  case TORIGHT:
			dx = chpp->x - chrp->c.left;
			dy = chpp->y - (chrp->c.bottom - 1);
			w = rectwidth(*chrp) + atr.hgap();
			h = 0;
			break;
		  case TOLEFT:
			dx = chpp->x - (chrp->c.right - 1);
			dy = chpp->y - (chrp->c.bottom - 1);
			w = -(rectwidth(*chrp) + atr.hgap());
			h = 0;
			break;
		  case TOUP:
			dx = chpp->x - (chrp->c.left + rectwidth(*chrp) / 2);
			dy = chpp->y - (chrp->c.bottom - 1);
			w = 0;
			h = -(rectheight(*chrp) + atr.vgap());
			break;
		  default:
			dx = chpp->x - (chrp->c.left + rectwidth(*chrp) / 2);
			dy = chpp->y - chrp->c.top;
			w = 0;
			h = rectheight(*chrp) + atr.vgap();
		}
		moverect(chrp, dx, dy);
		chpp[1].x = chpp[0].x + w;  // 
		chpp[1].y = chpp[0].y + h;
	} else {
		chpp[1] = chpp[0];
	}

	++sp;
	return 1;

err_ret:
	DEBUG_PRINT(("LOSTR::getlayoutinfo_vobj err = %d\n", err));
	return err;
}

/*
 * 쥤Ⱦμ
 *	ʸϥǡξϡ(0,0) 賫ϰ֤Ȥñ˰¤٤
 *	쥤Ȥ롣
 *	޷ǡξϡΥǡ̤Υ쥤Ȥ롣
 */
ERR LOSTR::getlayoutinfo( W gid, LATR &atr )
{
	TSTRP	sp(*str);
	TC	c;
	UW	pp;
	W	n;
	ERR	err;

	setpt(chp[0], 0, 0);  // Ƭ
	pp = 0;
	for ( ;; ) {
		/* ʬˤ϶ΰꤷƤ */
		while ( pp < sp.cpos ) {
			chr[pp].p.lefttop  = chp[pp];
			chr[pp].p.rightbot = chp[pp];
			++pp;
			chp[pp] = chp[pp-1];  // 
		}

		if ( (c = *sp) == TNULL ) break;

		switch ( TSTR::ttype(c) ) {
		  case TSTR::TChar:
			n = getlayoutinfo_str(gid, atr, sp);
			break;

		  case TSTR::TSeg:
			n = getlayoutinfo_seg(gid, atr, sp);
			break;

		  case TSTR::TNest:
			n = getlayoutinfo_nest(gid, atr, sp);
			break;

		  case TSTR::TVobj:
			n = getlayoutinfo_vobj(gid, atr, sp);
			break;
		}
		if ( n < ER_OK ) { err = n; goto err_ret; }
		pp += n;
	}

	return ER_OK;

err_ret:
	DEBUG_PRINT(("LOSTR::getlayoutinfo err = %d\n", err));
	return err;
}

/*
 * 쥤Ȥκ
 *	ñ˰¤٤줿쥤Ȥ顢ԥ쥤Ȥ롣
 */
ERR LOSTR::makelayout( LATR &atr )
{
	TSTRP	sp(*str);
	RECT	*chrp;
	TC	c;
	W	x, xs, xe, dx, dy;
	W	ch_h, fg_h, bottom, h;
	W	max_x;
	UW	lp, cp;

	str->nline = 0;		// Կ
	xs = 0;			// Ƭ
	xe = env->paper.h;	// 
	max_x = xs;		// ºݤʸɽ

	while ( (c = *sp) != TNULL ) {
		if ( c == TK_TAB ) break;
		chrp = &chr[sp.cpos];
		if ( chrp->c.left != chrp->c.right
		  || chrp->c.top  != chrp->c.bottom ) break;
		++sp;
	}

	dx = xs - chr[sp.cpos].c.left;
	dy = 0;
	ch_h = fg_h = bottom = 0;
	lp = cp = 0;

	for ( ;; ) {
		c = *sp;
		chrp = &chr[sp.cpos];

		if ( chrp->c.right + dx > xe && !emptyrect(*chrp)
		  || (c == TK_TAB && chrp->c.left + dx >= xe)
		  || c == TNULL ) {
			/*  */
			h = MAX(ch_h, fg_h);
			if ( h > 0 ) {
				++str->nline;		// Կû
				atr.lheight =		// Թ⤵
					( ch_h > 0 )? ch_h: atr.finfo.height;
			}
			dy += h;

			/*  */
			while ( lp < sp.cpos ) {
				chp[lp].y += dy;
				chr[lp].c.top    += dy;
				chr[lp].c.bottom += dy;
				++lp;
			}

			if ( c == TNULL ) break;

			dx = xs - chrp->c.left;
			ch_h = fg_h = bottom = 0;
		}

		h = rectheight(*chrp);
		if ( TSTR::ttype(c) == TSTR::TChar ) {
			if ( h > ch_h ) ch_h = h;  // ʸκ⤵
		} else {
			if ( h > fg_h ) fg_h = h;  // ʸʳκ⤵
		}
		if ( chrp->c.bottom > bottom ) bottom = chrp->c.bottom;

		/*  */
		while ( cp <= sp.cpos ) {
			chp[cp].x += dx;
			chr[cp].c.left  += dx;
			chr[cp].c.right += dx;
			if ( chr[cp].c.right > max_x ) max_x = chr[cp].c.right;
			++cp;
		}

		if ( c == TK_TAB ) {
			/* Υְ֤ޤǤ򥿥֤ζΰȤ */
			x = atr.tab.nextstop(xs, xe, chp[cp].x + dx);
			chr[cp-1].c.right = x;

			/* Υְ֤ޤǤ */
			dx = x - chp[cp].x;
		}

		++sp;
	}

	/* 쥤ΰ */
	str->rect.c.left   = xs;
	str->rect.c.right  = max_x;
	str->rect.c.top    = 0;
	str->rect.c.bottom = dy + bottom;

	/* Υ쥤ȴ */
	str->next.x = 0;
	str->next.y = dy;

	return ER_OK;
#if 0
err_ret:
	DEBUG_PRINT(("LOSTR::makelayout err = %d\n", err));
	return err;
#endif
}

/*
 * 쥤ȤԤ
 *	gid	쥤ȺѤĶ
 *		ĶԤȤϤʤΤǡŬʺѤ
 *		ĶꤹФ褤
 *		ʸֳ֤ʤɤ°ѹ롣
 *	atr	ƬΥ쥤°ꤹ롣
 *		üΥ쥤°ᤵ롣
 */
ERR LOSTR::layout( W gid, LATR &atr )
{
	ERR	err;

	/* ƬΥ쥤°¸ */
	str->atr = atr;

	/* ǡĹ(TC)ʬΥ쥤¸ΰѰ */
	chr = new(nothrow) RECT[str->len+1];
	chp = new(nothrow) PNT[str->len+1];
	if ( chr == NULL || chp == NULL ) { err = ER_NOMEM; goto err_ret; }

	/* Ķ */
	err = atr.setgenv(gid);
	if ( err < ER_OK ) goto err_ret;

	/* ñ˰¤٤Υ쥤Ⱦ */
	err = getlayoutinfo(gid, atr);
	if ( err < ER_OK ) goto err_ret;

	/* ԥ쥤Ȥ */
	err = makelayout(atr);
	if ( err < ER_OK ) goto err_ret;

	return ER_OK;

err_ret:
	delete[] chr; chr = NULL;
	delete[] chp; chp = NULL;
	DEBUG_PRINT(("LOSTR::layout err = %d\n", err));
	return err;
}

/*
 * 쥤ȴ(кɸ)
 */
void LOSTR::setorg( LPNT &o )
{
	org = o;
}

/*
 * Υ쥤ȴ(кɸ)μ
 */
void LOSTR::nextorg( LPNT &next )
{
	next = org;
	next.move(str->next);
}

/*
 * (ʸ)
 */
ERR LOSTR::draw_str( LVIEW &vi, LATR &atr, TSTRP &sp )
{
	PNT	*chpp = &chp[sp.cpos];
	PNT	chpos;
const	TC	*s;
	TC	c;
	W	p, tp, np;
	W	i, n, lang, base;
	ERR	err;

	/* ʸμ */
	n = sp.get(s, lang);

	err = gset_scr(vi.gid, lang);
	if ( err < ER_OK ) goto err_ret;

	base = chpp[0].y;
	for ( tp = p = 0; tp <= n; ++p ) {
		c = s[p];
		if ( !(c < 0x0020 || c == 0x007f) && p < n ) {
			if ( chpp[p].y == base ) continue;
			np = p;
		} else {
			np = p + 1;
		}

		i = p - tp;
		if ( i > 0 ) {
			/* ֤򥹥꡼ɸѴ */
			vi.scrpos(chpos, org, chpp[tp]);

			/* ʸ */
			err = gdra_stp(vi.gid, chpos.x, chpos.y,
					const_cast<TC*>(s + tp), i, G_STORE);
			if ( err < ER_OK ) goto err_ret;
		}
		tp = np;
		base = chpp[tp].y;
	}

	sp += n;
	return ER_OK;

err_ret:
	DEBUG_PRINT(("LOSTR::draw_str err = %d\n", err));
	return err;
}

/*
 * ()
 */
ERR LOSTR::draw_seg( LVIEW &vi, LATR &atr, TSTRP &sp )
{
	LPNT	lchp;
	TSEG	buf;
	ERR	err;

	/* Ȥμ */
	sp.get(buf);
	TSEGU seg(buf);

	/* ֤쥤кɸѴ */
	lchp = org;
	lchp.move(chp[sp.cpos]);

	/* ƥȤ */
	err = seg->draw(vi, atr, lchp);
	if ( err < ER_OK ) goto err_ret;

	++sp;
	return 1;

err_ret:
	DEBUG_PRINT(("LOSTR::draw_seg err = %d\n", err));
	return err;
}

/*
 * (TAD)
 */
ERR LOSTR::draw_nest( LVIEW&, LATR&, TSTRP &sp )
{
	/* ̤ݡȡ̵ */
	++sp;
	return ER_OK;
}

/*
 * ()
 */
ERR LOSTR::draw_vobj( LVIEW &vi, LATR &atr, TSTRP &sp )
{
	TVOBJ	vobj;
	RECT	rect;
	ERR	err;

	/* Ȥμ */
	sp.get(vobj);

	/* ꡼ɸѴ */
	vi.scrpos(rect, org, chr[sp.cpos]);

	/*  */
	err = omov_vob(vobj.vid, 0, &rect, V_DISPALL);
	if ( err < ER_OK ) goto err_ret;

	++sp;
	return ER_OK;

err_ret:
	DEBUG_PRINT(("LOSTR::draw_vobj err = %d\n", err));
	return err;
}

/*
 * vi ΰ⡢r ǻꤷϰϤ褹
 */
ERR LOSTR::draw( LVIEW &vi, RECT &r )
{
	TSTRP	sp(*str);
	LATR	atr = str->atr;
	TC	c;
	RECT	vr;
	ERR	err;

	/* åԥΰ */
	err = gget_vis(vi.gid, &vr);
	if ( err < ER_OK ) goto err_ret1;
	err = gset_vis(vi.gid, r);
	if ( err < ER_OK ) goto err_ret1;

	/* Ķ */
	err = atr.setgenv(vi.gid);
	if ( err < ER_OK ) goto err_ret2;

	while ( (c = *sp) != TNULL ) {

		switch ( TSTR::ttype(c) ) {
		  case TSTR::TChar:
			err = draw_str(vi, atr, sp);
			break;

		  case TSTR::TSeg:
			err = draw_seg(vi, atr, sp);
			break;

		  case TSTR::TNest:
			err = draw_nest(vi, atr, sp);
			break;

		  case TSTR::TVobj:
			err = draw_vobj(vi, atr, sp);
			break;
		}
		if ( err < ER_OK ) goto err_ret2;
	}

	/* åԥΰ᤹ */
	err = gset_vis(vi.gid, vr);
	if ( err < ER_OK ) goto err_ret1;

	return ER_OK;

err_ret2:
	gset_vis(vi.gid, vr);
err_ret1:
	DEBUG_PRINT(("LOSTR::draw(RECT) err = %d\n", err));
	return err;
}

/*
 * vi ΰΤ褹
 */
ERR LOSTR::draw( LVIEW &vi )
{
	ERR	err;

	err = draw(vi, vi.viewport);
#ifdef DEBUG
	if ( err < ER_OK ) DEBUG_PRINT(("LOSTR::draw err = %d\n", err));
#endif
	return err;
}

/*
 * 쥤°μ
 *	gid	ѤĶ
 *		ĶԤȤϤʤΤǡŬʺѤ
 *		ĶꤹФ褤
 *		ʸֳ֤ʤɤ°ѹ롣
 *	tp	°ǡΰ
 *	atr	tp ΰ֤Υ쥤°ᤵ롣
 */
ERR LOSTR::getatr( W gid, TSTRP &tp, LATR &atr )
{
	TSTRP	sp(*str);
	TC	c;
	TSEG	buf;
	ERR	err;

	atr = str->atr;

	/* Ķ */
	err = atr.setgenv(gid);
	if ( err < ER_OK ) goto err_ret;

	while ( sp < tp && (c = *sp) != TNULL ) {

		switch ( TSTR::ttype(c) ) {
		  case TSTR::TSeg: {
			sp.get(buf);
			TSEGU seg(buf);
			err = seg->setgenv(gid, atr);
			if ( err < ER_OK ) goto err_ret;
			break;
		  }
		  case TSTR::TChar:
		  case TSTR::TNest:
		  case TSTR::TVobj:
			break;
		}
		++sp;
	}

	return ER_OK;

err_ret:
	DEBUG_PRINT(("LOSTR::getatr err = %d\n", err));
	return err;
}

/*
 * vi Υ꡼ɸ pos ΰ֤бǡ򸡺
 *	pos ΰ֤줫Υǡ֤˥ޥå
 *			1
 *		sp	Υǡ
 *	ޥåʤä
 *			0
 *		sp	ƬޤϺǸΤ줫ᤤ
 */
WERR LOSTR::pick( LVIEW &vi, PNT &pos, TSTRP &sp )
{
	UW	last, i, n = str->len;
	PNT	p;
	bool	outer;

	/* LTSTR кɸѴ */
	vi.relpos(p, org, pos);

	/* ƬԤξƬΥǡȤ */
	outer = ( p.y < str->rect.c.top );

	last = 0;
	for ( i = 0; i < n; ++i ) {
		if ( emptyrect(chr[i]) ) continue;
		if ( outer ) break;
		if ( p.y < chr[i].c.bottom && p.x < chr[i].c.right ) break;
		last = i;
	}
	if ( i >= n ) {
		i = last;
		outer = true;
	}

	sp.init(str);
	sp += i - sp.cpos;

	return ( outer )? 0: 1;
}

/*
 * sp ΥǡϤ r ֤
 *	r  vi Υ꡼ɸ
 *	r γƺɸͤ RECT ɽ碌ϰϤĶϡθ³ͤ
 * 	ߥåȤ롣Τ褦ʺɸĤǤ⤢ͤ true 
 *	٤Ƥκɸ RECT ɽ碌ϰǤ false ֤
 */
bool LOSTR::area( LVIEW &vi, TSTRP &sp, RECT &r )
{
	return vi.scrpos_limit(r, org, chr[sp.cpos]);
}

/*
 * sp ΥǡϤ r  lr ֤
 *	lr ϥ쥤Ⱥɸ
 *	r  vi Υ꡼ɸ
 *	r γƺɸͤ RECT ɽ碌ϰϤĶϡθ³ͤ
 * 	ߥåȤ롣Τ褦ʺɸĤǤ⤢ͤ true 
 *	٤Ƥκɸ RECT ɽ碌ϰǤ false ֤
 */
bool LOSTR::area( LVIEW &vi, TSTRP &sp, RECT &r, LRECT &lr )
{
	lr.set(org, chr[sp.cpos]);
	return vi.scrpos_limit(r, lr);
}

/* ------------------------------------------------------------------------ */
/*
 *	class LTBIND
 *	TAD ǡ(LTSTR)νޤ
 */

/*
 * 󥹥ȥ饯
 */
LTBIND::LTBIND( W level )
	: TBIND(level)
{
}

/*
 * TSTR 
 */
TSTR* LTBIND::newTSTR()
{
	return new(nothrow) LTSTR;
}

/*
 * TBIND 
 */
TBIND* LTBIND::newTBIND( W level )
{
	return new(nothrow) LTBIND(level);
}

/* ------------------------------------------------------------------------ */
/*
 *	class LTAD
 *	TAD ǡ()
 */

/*
 * TSTR 
 */
TSTR* LTAD::newTSTR()
{
	return new(nothrow) LTSTR;
}

/*
 * TBIND 
 */
TBIND* LTAD::newTBIND( W level )
{
	return new(nothrow) LTBIND(level);
}

/*
 * TAD 
 */
TAD* LTAD::newTAD()
{
	return new(nothrow) LTAD;
}

/* ------------------------------------------------------------------------ */
/*
 *	class LOTAD
 *	LTAD 쥤ȥ󥸥
 */

/*
 * 󥹥ȥ饯
 */
LOTAD::LOTAD( LTAD *tp, LENV *ep )
{
	tad = tp;
	env = ep;
}

/*
 * 쥤ȤԤ
 *	gid	쥤ȺѤĶ
 *		ĶԤȤϤʤΤǡŬʺѤ
 *		ĶꤹФ褤
 *		ʸֳ֤ʤɤ°ѹ롣
 */
ERR LOTAD::layout( W gid )
{
	TBINDP	bp(*tad);
	LTSTR	*sp;
	LATR	atr;
	LPNT	org;
	ERR	err;

	atr = tad->atr;
	org.x = 0;
	org.y = -1;
	for ( ; (sp = dynamic_cast<LTSTR*>(*bp)) != NULL; ++bp ) {
		LOSTR	lo(sp, env);

		lo.setorg(org);

		err = lo.layout(gid, atr);
		if ( err < ER_OK ) goto err_ret;

		lo.nextorg(org);
	}

	height = org.y;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("LOTAD::layout err = %d\n", err));
	return err;
}

/*
 * vi ΰ⡢r ǻꤷϰϤ褹
 */
ERR LOTAD::draw( LVIEW &vi, RECT &r )
{
	TBINDP	bp(*tad);
	LTSTR	*sp;
	LATR	atr;
	LPNT	org;
	LRECT	dr, fr;
	ERR	err;

	/* ϰϤ쥤ȺɸѴ */
	vi.laypos(dr, r);

	org.x = 0;
	org.y = -1;
	for ( ; (sp = dynamic_cast<LTSTR*>(*bp)) != NULL; ++bp ) {
		LOSTR	lo(sp, env);

		lo.setorg(org);

		/* ϰϤ˴ޤޤƤ褹 */
		fr.set(org, sp->rect);
		if ( fr.sect(dr) ) {
			atr = sp->atr;
			err = lo.layout(vi.gid, atr);
			if ( err < ER_OK ) goto err_ret;

			err = lo.draw(vi, r);
			if ( err < ER_OK ) goto err_ret;
		}

		lo.nextorg(org);
	}

	return ER_OK;

err_ret:
	DEBUG_PRINT(("LOTAD::draw(RECT) err = %d\n", err));
	return err;
}

/*
 * vi ΰΤ褹
 */
ERR LOTAD::draw( LVIEW &vi )
{
	ERR	err;

	err = draw(vi, vi.viewport);
#ifdef DEBUG
	if ( err < ER_OK ) DEBUG_PRINT(("LOTAD::draw err = %d\n", err));
#endif
	return err;
}

/*
 * 쥤°μ
 *	gid	ѤĶ
 *		ĶԤȤϤʤΤǡŬʺѤ
 *		ĶꤹФ褤
 *		ʸֳ֤ʤɤ°ѹ롣
 *	tp	°ǡΰ
 *	atr	tp ΰ֤Υ쥤°ᤵ롣
 */
ERR LOTAD::getatr( W gid, TADP &tp, LATR &atr )
{
	LTSTR	*sp;
	ERR	err;

	sp = dynamic_cast<LTSTR*>(*tp.bp);
	if ( sp == NULL ) { err = ER_PAR; goto err_ret; }

	{
		LOSTR	lo(sp, env);
		err = lo.getatr(gid, tp.sp, atr);
		if ( err < ER_OK ) goto err_ret;
	}

	return ER_OK;

err_ret:
	DEBUG_PRINT(("LOTAD::getatr err = %d\n", err));
	return err;
}

/*
 * vi Υ꡼ɸ pos ΰ֤бǡ򸡺
 *	pos ΰ֤줫Υǡ֤˥ޥå
 *			1
 *		tp	Υǡ
 *	ޥåʤä
 *			0
 *		tp	ƬޤϺǸΤ줫ᤤ
 */
WERR LOTAD::pick( LVIEW &vi, PNT &pos, TADP &tp )
{
	LTSTR	*sp;
	LATR	atr;
	LPNT	pk, org;
	LRECT	fr;
	ERR	err;

	/* ԥå֤쥤ȺɸѴ */
	vi.laypos(pk, pos);

	tp.bp.init(tad);
	org.x = 0;
	org.y = -1;
	for ( ; (sp = dynamic_cast<LTSTR*>(*tp.bp)) != NULL; ++tp.bp ) {
		LOSTR	lo(sp, env);

		lo.setorg(org);

		fr.set(org, sp->rect);
		if ( pk.y < fr.bottom || fr.bottom >= height ) {
			atr = sp->atr;
			err = lo.layout(vi.gid, atr);
			if ( err < ER_OK ) goto err_ret;

			err = lo.pick(vi, pos, tp.sp);
			if ( err < ER_OK ) goto err_ret;
			return err;
		}

		lo.nextorg(org);
	}

	tp = TADP(*tad);

	return 0;

err_ret:
	DEBUG_PRINT(("LOTAD::pick err = %d\n", err));
	return err;
}

/*
 * tp ΥǡϤ r ֤
 *	r  vi Υ꡼ɸ
 *	r γƺɸͤ RECT ɽ碌ϰϤĶϡθ³ͤ
 * 	ߥåȤ롣Τ褦ʺɸĤǤ⤢ͤ true 
 *	٤Ƥκɸ RECT ɽ碌ϰǤ false ֤
 */
WERR LOTAD::area( LVIEW &vi, TADP &tp, RECT &r )
{
	LRECT	lr;
	return area(vi, tp, r, lr);
}

/*
 * tp ΥǡϤ r  lr ֤
 *	lr ϥ쥤Ⱥɸ
 *	r  vi Υ꡼ɸ
 *	r γƺɸͤ RECT ɽ碌ϰϤĶϡθ³ͤ
 * 	ߥåȤ롣Τ褦ʺɸĤǤ⤢ͤ true 
 *	٤Ƥκɸ RECT ɽ碌ϰǤ false ֤
 */
WERR LOTAD::area( LVIEW &vi, TADP &tp, RECT &r, LRECT &lr )
{
	TBINDP	bp(*tad);
	LTSTR	*sp;
	LATR	atr;
	LPNT	org;
	ERR	err;

	org.x = 0;
	org.y = -1;
	for ( ; (sp = dynamic_cast<LTSTR*>(*bp)) != NULL; ++bp ) {
		LOSTR	lo(sp, env);

		lo.setorg(org);

		if ( bp == tp.bp ) {
			atr = sp->atr;
			err = lo.layout(vi.gid, atr);
			if ( err < ER_OK ) goto err_ret;

			return lo.area(vi, tp.sp, r, lr);
		}

		lo.nextorg(org);
	}

	return false;

err_ret:
	DEBUG_PRINT(("LOTAD::area err = %d\n", err));
	return err;
}

/*
 * 쥤Τ礭μ
 */
void LOTAD::layoutsize( LRECT &r )
{
	r.left   = 0;
	r.top    = 0;
	r.right  = env->paper.h;
	r.bottom = height;
}

/* ------------------------------------------------------------------------ */
} // namespace LIBCPP1
