/*
 *	@(#)tcstr.cc (libcpp1) 01-04-06
 *
 *	TC ʸ
 *	(C) Copyright 2000-2001 by Personal Media Corporation
 */

#include "libcpp.h"
#include "cpp/1/misc.h"

namespace LIBCPP1 {

/* ------------------------------------------------------------------------- */
/*
 *	class TCSTR
 *	TC ʸ
 *
 *	Ȥޤ뤳ȤϤǤ뤬Ȥᤷʤ
 *	0x0000 (=TNULL) ޤॻȤξդɬפǤ롣
 */

/*
 * 󥹥ȥ饯
 */
TCSTR::TCSTR()
{
	next = NULL;
}

/*
 * ǥȥ饯
 *	³(TCSTR)ޤƽü(next == NULL)ޤǤ٤ƺ롣
 *	˹Ԥä硢Ԥ next ѹʤա
 */
TCSTR::~TCSTR()
{
	TCSTR	*p, *np;

	/* ñ delete next ȤȺƵƽФˤʤäƤޤ
	   Ƶ򤱤ƺԤ*/
	np = next;
	while ( np != NULL ) {
		p = np;
		np = p->next;
		p->next = NULL;
		delete p;
	}
}

/*
 * ʸǡν񤭹
 *	MemIO θߤΰ֤ buf  size ХȽ񤭹ࡣ
 *	񤭹Хȿ֤ͤ
 *	񤭹ߤ TC ñ̤ǹԤ뤿ᡢsize ξǸ
 *	1 ХȤϽ񤭹ޤʤ
 *	MemIO θ֤߰Ͻ񤭹ʬʤ롣
 *	Хåեγĥɬפʾˤϡü TNULL ʬ
 *	äƳĥ졢ü TNULL ɲä롣
 */
WERR TCSTR::write( const void *buf, W size )
{
	W	sz;
	ERR	err;

	/* size  TC ñ̤˴ݤ */
	size = (size / sizeof(TC)) * sizeof(TC);

	/* 񤭹ߤɬפʥХåե */
	sz = curpos + size + sizeof(TC);

	if ( sz > cursize ) {
		/* Хåեĥ */
		err = resizebuf(sz);
		if ( err < ER_OK ) goto err_ret;

		/* ü TNULL ɲ */
		tcbuf()[sz / sizeof(TC) - 1] = TNULL;
	}

	/* ʸǡν񤭹 */
	err = MemIO::write(buf, size);
	if ( err < ER_OK ) goto err_ret;

	return size;

err_ret:
	DEBUG_PRINT(("TCSTR::write err = %d\n", err));
	return err;
}

/*
 * ʸɲ
 *	ʸθ buf ɲä롣
 *	TNULL ޤǤ len ʸ(TC )ޤǤΤ줫ãȤ
 *	ޤǤɲä롣len < 0 ξ len ̵뤵롣
 *	MemIO θ֤߰Ȥϴطʤʸüɲä롣
 *	MemIO θ֤߰Ѳʤ
 */
ERR TCSTR::put( const TC *buf, W len )
{
const	TC	*ep;
	W	pos;
	ERR	err;

	/* buf νü */
	for ( ep = buf; len-- != 0 && *ep != TNULL; ++ep );
	len = ep - buf;

	/* ߤνü */
	pos = length();

	/* Хåեĥ */
	err = resizebuf((pos + len + 1) * sizeof(TC));
	if ( err < ER_OK ) goto err_ret;

	/* ʸ񤭹 */
	memcpy(tcbuf() + pos, buf, len * sizeof(TC));
	tcbuf()[pos + len] = TNULL;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TCSTR::put err = %d\n", err));
	return err;
}

/*
 * Ԥ
 *	Ԥμˣ롣
 *	Ԥ new ˤ롣
 *	ͤԤ֤
 *	ǤʤäȤ NULL ֤
 */
TCSTR* TCSTR::insline()
{
	TCSTR	*s;

	/* Ԥ */
	s = new(nothrow) TCSTR;
	if ( s == NULL ) goto err_ret;

	/* Ԥ */
	s->next = next;
	next = s;

	return s;

err_ret:
	DEBUG_PRINT(("TCSTR::insline err = %d\n", ER_NOMEM));
	return NULL;
}

/* ------------------------------------------------------------------------- */
} // namespace LIBCPP1
