/*
 *	@(#)trayio.cc (libcpp1) 01-04-12
 *
 *	ȥ졼ϥ饤֥
 *	(C) Copyright 2000-2001 by Personal Media Corporation
 */

#include "libcpp.h"
#include "cpp/1/trayio.h"

namespace LIBCPP1 {

/* ------------------------------------------------------------------------ */
/*
 *	class TREC
 *	ȥ졼쥳ɥ饹
 */

/*
 * ǡΰγ
 *	ߤΥǡΰ襵 size Х̤ʤ顢
 *	size ХȳǼǤ륵ޤǳĥ롣
 */
ERR TREC::alloc( W size )
{
	W	n;
	VP	p;
	ERR	err;

	if ( id == TR_TEXT || id == TR_FIG ) {
		/* ¤γǧ
		   ξ֤ξϥ¤ʤ*/
		if ( size > MAXSZ && len > 0 )
			{ err = ER_LIMIT; goto err_ret; }
	}

	/* ߤΥǡΰ襵 */
	n = (len + BLKSZ - 1) / BLKSZ * BLKSZ;

	if ( size > n ) {
		/* ĥ */
		n = (size + BLKSZ - 1) / BLKSZ * BLKSZ;
		p = realloc(dt, n);
		if ( p == NULL ) { err = ER_NOMEM; goto err_ret; }
		dt = (B*)p;
	}

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TREC::alloc err = %d\n", err));
	return err;
}

/*
 * ȥ졼ǡν񤭹
 *	buf  size ХȤƤ򡢤Τޤ޸ߤΥǡθ
 *	ɲä롣
 *	ǡΰϼưŪ˳ĥ롣
 */
ERR TREC::put( VP buf, W size )
{
	W	n;
	ERR	err;

	/* 񤭹߸Υ */
	n = len + size;

	/* ǡΰ襵γǧȳĥ */
	err = alloc(n);
	if ( err < ER_OK ) goto err_ret;

	/* ǡǼ */
	memcpy(dt + len, buf, size);
	len = n;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TREC::put err = %d\n", err));
	return err;
}

/*
 * ȥ졼ǡν񤭹(ʸ)
 *	str ʸ ConvEndian ˤäƥǥѴơ
 *	ߤΥǡθɲä롣
 *	str Ƥϥå len ʸ(TC)ʬ񤭹ࡣ
 *	TNULL ⽪üȤϰʤ
 *	ǡΰϼưŪ˳ĥ롣
 */
ERR TREC::put_tc( TC *str, W slen )
{
	W	n;
	ERR	err;

	/* 񤭹߸Υ */
	n = len + slen * sizeof(TC);

	/* ǡΰ襵γǧȳĥ */
	err = alloc(n);
	if ( err < ER_OK ) goto err_ret;

	/* ǡǼ */
	ConvEndianHs((UH*)(dt + len), str, slen);
	len = n;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TREC::put_tc err = %d\n", err));
	return err;
}

/*
 * ȥ졼ǡν񤭹(ʸϡ޷)
 *	seg ΥȤ򡢸ߤΥǡθɲä롣
 *	ȤΥǡ(seg.body)ϡǥѴ줺
 *	Τޤ޽񤭹ޤ롣
 *	ǡΰϼưŪ˳ĥ롣
 */
ERR TREC::put_seg( TSEG &seg )
{
	W	n;
	ERR	err;

	n = ( seg->len > 0xfffe )? sizeof(LTADSEG): sizeof(TADSEG);

	/* ǡΰ襵γǧȳĥ */
	err = alloc(len + n + seg->len);
	if ( err < ER_OK ) goto err_ret;

	/* ȥإåǼ */
	if ( seg->len > 0xfffe ) {
		LTADSEG *p = (LTADSEG*)(dt + len);
		p->id = ConvEndianH(seg.id);
		p->len = 0xffff;
		SetMisalignW((UB*)&p->llen, ConvEndianW(seg->len));
	} else {
		TADSEG *p = (TADSEG*)(dt + len);
		p->id = ConvEndianH(seg.id);
		p->len = ConvEndianH(seg->len);
	}

	/* ǡγǼ */
	memcpy(dt + len + n, seg->body, seg->len);
	len += n + seg->len;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TREC::put_seg err = %d\n", err));
	return err;
}

/*
 * ȥ졼ǡɤ߹
 *	ofs Хܤ size ХȤɤ߹ǡbuf ˳Ǽ롣
 */
W TREC::read( W ofs, VP buf, W size )
{
	if ( size > len - ofs ) size = len - ofs;
	if ( size <= 0 ) return 0;

	memcpy(buf, dt + ofs, size);

	return size;
}

/*
 * ȥ졼ǡξõ
 */
void TREC::clean()
{
	if ( dt != NULL ) free(dt);
	dt = NULL;
	len = 0;
}

/* ------------------------------------------------------------------------ */
/*
 *	class TrayIO
 *	ȥ졼ϥ饹
 */

/*
 * 󥹥ȥ饯
 */
TrayIO::TrayIO()
{
	name = NULL;
	head = NULL;
}

/*
 * ǥȥ饯
 */
TrayIO::~TrayIO()
{
	W	i;

	delete name;
	if ( head != NULL ) {
		for ( i = 0; i < nrec; ++i ) head[i].clean();
		free(head);
	}
}

/*
 * ȥ졼سǼ
 */
WERR TrayIO::push( VP data, W nrec )
{
	ERR	err;

	err = tpsh_dat((TRAYREC*)data, nrec, name);
#ifdef DEBUG
	if ( err < ER_OK ) DEBUG_PRINT(("TrayIO::push err = %d\n", err));
#endif
	return err;
}

/*
 * ȥ졼Ф
 */
WERR TrayIO::pop( VP data, W size, W *a_size, W rec )
{
	ERR	err;

	err = tpop_dat((TRAYREC*)data, size, a_size, rec, name);
#ifdef DEBUG
	if ( err < ER_OK ) DEBUG_PRINT(("TrayIO::pop err = %d\n", err));
#endif
	return err;
}

/*
 * ȥ졼ץ
 *	mode ǻꤷ⡼ɤǥȥ졼򥢥뤿νԤ
 *	Pop λ
 *		sel ˤꡢоݤΥȥ졼֤ꤹ롣(Ƭ)
 *		sel = 0 ϡ֤Υȥ졼оݤȤʤ롣
 *		ɤ߽Фȥ졼Υǡ̾ name ֤
 *	Push λ
 *		sel λ̵뤵롣
 *		name ȥ졼Υǡ̾ꤵ롣
 *	name = NULL λϡǡ̾꡿ʤ
 */
ERR TrayIO::open( OpenMode mode, TC *name, W sel )
{
	W	sz, i;
	ERR	err;

	this->mode = mode;

	/* ȥХåե򥯥ꥢ */
	buf.clean();
	buf.id = 0;

	if ( mode == Push ) {
		if ( name != NULL ) {
			/* ȥ졼ǡ̾¸ */
			this->name = new(nothrow) TC[12+1];
			if ( this->name == NULL )
					{ err = ER_NOMEM; goto err_ret; }
			tc_strcpy(this->name, name);
		} else {
			this->name = NULL;
		}

		head = NULL;
		nrec = 0;
	} else {
		if ( sel > 0 ) {
			/* ȥ졼 */
			err = tsel_dat(sel);
			if ( err < ER_OK ) goto err_ret;
		}

		/* ȥ졼إåǡ̾Ф */
		this->name = name;
		err = pop(NULL, 0, &sz, 0);
		this->name = NULL;
		if ( err < ER_OK ) goto err_ret;

		head = (TREC*)malloc(sz);
		if ( head == NULL ) { err = ER_NOMEM; goto err_ret; }

		err = pop(head, sz, NULL, 0);
		if ( err < ER_OK ) goto err_ret;
		nrec = err;

		for ( i = 0; i < nrec; ++i ) head[i].dt = NULL;
	}

	return ER_OK;

err_ret:
	if ( head != NULL ) free(head);
	head = NULL;
	DEBUG_PRINT(("TrayIO::open err = %d\n", err));
	return err;
}

/*
 * ȥ졼
 *	Push ξ硢ȥ졼˥ǡǼ롣
 *	del = True ξ硢֤Υȥ졼ǡ롣
 */
ERR TrayIO::close( Bool del )
{
	W	i;
	ERR	err, error = ER_OK;

	if ( mode == Push ) {
		if ( buf.len > 0 ) {
			/* ȥХåեƤ񤭹 */
			err = put_trec(buf);
			if ( err < ER_OK ) error = err;
		}
		if ( nrec > 0 ) {
			/* ȥ졼سǼ */
			err = push(head, nrec);
			if ( err < ER_OK ) error = err;
		}
	}

	if ( del ) {
		/* ȥ졼 */
		err = tdel_dat();
		if ( err < ER_OK ) error = err;
	}

	delete name;
	if ( head != NULL ) {
		for ( i = 0; i < nrec; ++i ) head[i].clean();
		free(head);
	}
	name = NULL;
	head = NULL;

#ifdef DEBUG
	if ( error < ER_OK ) DEBUG_PRINT(("TrayIO::close err = %d\n", err));
#endif
	return error;
}

/*
 * ȥ졼쥳ɤɤ߽Ф (Pop Τ߻Ѳ)
 *	trec  TrayIO ǴƤȥ졼إå쥳ɤؤ
 *	ݥ󥿤֤
 *	trec->dt פˤʤäȤ˺(trec->clean())Ƥ褤
 *	ʤƤ close() ˤϼưŪ˺롣
 *	ͤɤ߽Фȥ졼쥳ɤΥǡ֤롣
 *	ǡü(recno 쥳ɿĶƤ)ξϡ
 *	ER_REC ֤
 */
WERR TrayIO::get_trec( W recno, TREC* &trec )
{
	W	len;
	ERR	err;

	if ( recno > nrec ) return ER_REC;

	/* إåФ */
	trec = &head[recno-1];

	len = trec->len;
	if ( trec->dt == NULL && len > 0 ) {
		/* ǡΤγǼΰ */
		trec->dt = (B*)malloc(len);
		if ( trec->dt == NULL ) { err = ER_NOMEM; goto err_ret; }

		/* ǡΤμФ */
		err = pop(trec->dt, len, NULL, recno);
		if ( err < ER_OK ) goto err_ret;
	}

	return len;

err_ret:
	trec->clean();
	DEBUG_PRINT(("TrayIO::get_trec err = %d\n", err));
	return err;
}

/*
 * ȥ졼쥳ɤν񤭽Ф (Push Τ߻Ѳ)
 *	ȥ졼쥳ɤϺǸɲä롣
 *	trec ΥǡΤϾõ(len = 0, dt = NULL)롣
 */
ERR TrayIO::put_trec( TREC &trec )
{
	W	n;
	VP	p;
	ERR	err;

	/* ߤΥإåΰ礭 */
	n = (nrec + HEADBLKSZ - 1) / HEADBLKSZ * HEADBLKSZ;

	if ( nrec >= n ) {
		/* ȥ졼إåΰĥ */
		p = realloc(head, (n + HEADBLKSZ) * sizeof(TREC));
		if ( p == NULL ) { err = ER_NOMEM; goto err_ret; }
		head = (TREC*)p;
	}

	/* ȥ졼ǡ¸ */
	head[nrec++] = trec;
	trec.dt = NULL;
	trec.len = 0;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("TrayIO::put_trec err = %d\n", err));
	return err;
}

/*
 * 쥳ɥμ
 *	recno Υ쥳ɤΥ쥳ɥ(ǡʬΥ)
 *	֤
 *	recno Υ쥳ɤ³ե饰(TR_CONT)ꤵƤС
 *	ʹߤη³쥳Τιץ֤
 */
W TrayIO::get_trecsize( W recno )
{
	W	size = 0;
	W	i = recno - 1;

	do {
		size += head[i].len;
	} while ( (head[i++].id & TR_CONT) != 0 );

	return size;
}

/*
 * ȥ졼ǡμ
 *	TrayIO ݻƤȥ졼ǡФ
 *	TrayIO Υȥ졼ǡ϶Ȥʤ롣
 *	header ˥ȥ졼إåΥݥ󥿡ͤ˥쥳ɿ֤
 */
W TrayIO::get_alldata( TREC* &header )
{
	W n = nrec;
	header = head;
	head = NULL;
	nrec = 0;
	return n;
}

/*
 * ȥ졼ǡκ
 *	get_alldata() Ǽȥ졼ǡ롣
 */
void TrayIO::delete_traydata( TREC *header, W nrec )
{
	W	i;

	for ( i = 0; i < nrec; ++i ) header[i].clean();
	free(header);
}

/* ------------------------------------------------------------------------ */
/*
 *	class TmpTrayIO
 *	ȥ졼ϥ饹
 */

/*
 * ȥ졼سǼ
 */
WERR TmpTrayIO::push( VP data, W nrec )
{
	ERR	err;

	err = tset_dat((TRAYREC*)data, nrec);
#ifdef DEBUG
	if ( err < ER_OK ) DEBUG_PRINT(("TmpTrayIO::push err = %d\n", err));
#endif
	return err;
}

/*
 * ȥ졼Ф
 */
WERR TmpTrayIO::pop( VP data, W size, W *a_size, W rec )
{
	ERR	err;

	err = tget_dat((TRAYREC*)data, size, a_size, rec);
#ifdef DEBUG
	if ( err < ER_OK ) DEBUG_PRINT(("TmpTrayIO::pop err = %d\n", err));
#endif
	return err;
}

/*
 * ȥ졼ץ
 *	mode ǻꤷ⡼ɤǰȥ졼򥢥뤿ν
 *	Ԥ
 *	name  sel ̵뤵롣
 */
ERR TmpTrayIO::open( OpenMode mode, TC *name, W sel )
{
	ERR	err;

	err = TrayIO::open(mode, NULL, 0);
#ifdef DEBUG
	if ( err < ER_OK ) DEBUG_PRINT(("TmpTrayIO::open err = %d\n", err));
#endif
	return err;
}

/*
 * ȥ졼
 *	Push ξ硢ȥ졼˥ǡǼ롣
 *	del ̵뤵롣
 */
ERR TmpTrayIO::close( Bool del )
{
	ERR	err;

	err = TrayIO::close(False);
#ifdef DEBUG
	if ( err < ER_OK ) DEBUG_PRINT(("TmpTrayIO::close err = %d\n", err));
#endif
	return err;
}

/* ------------------------------------------------------------------------ */
} // namespace LIBCPP1
