/*
 *	@(#)window.cc (libcpp1) 01-04-16
 *
 *	ɥ饤֥
 *	(C) Copyright 2000-2001 by Personal Media Corporation
 */

#include "libcpp.h"
#include "cpp/1/window.h"

namespace LIBCPP1 {

/* ------------------------------------------------------------------------- */
/*
 *	С
 *	class SCRLBAR
 */

/*
 * Сι
 */
ERR SCRLBAR::update( W ix, SIDE side )
{
	ERR	err;

	/* lo  clo  chi  hi ˤʤ褦 */
	if ( v.lo > v.clo ) v.lo = v.clo;
	if ( v.hi < v.chi ) v.hi = v.chi;

	/* Τͤˤʤ褦Ĵ */
	if ( v.lo < 0 ) {
		v.chi -= v.lo;
		v.clo -= v.lo;
		v.hi  -= v.lo;
		v.lo  -= v.lo;
	}
	wid = v.hi - v.lo; // Τ

	/* 00x7fff ϰϤ褦˥ */
	while ( v.hi > 0x7fff ) {
		v.hi >>= 1;
		v.lo >>= 1;
		if ( v.chi > 1 ) v.chi >>= 1;
		if ( v.clo > 1 ) v.clo >>= 1;
	}

	/* lohi  0 ȥ顼ˤʤäƤޤΤ */
	if ( v.lo == v.hi ) {
		--v.lo;
		--v.clo;
	}

	/* С */
	err = update_sbar(ix, side, (W*)&v);

#ifdef DEBUG
	if ( err < ER_OK ) DEBUG_PRINT(("SCRLBAR::update err = %d\n", err));
#endif
	return err;
}

/* ------------------------------------------------------------------------- */
/*
 *	ɥåĶ
 *	class DRAG
 */

/*
 * 󥹥ȥ饯
 */
DRAG::DRAG( WINDOW *bwin )
{
	wi = bwin;
}

/*
 * ٥
 */
ERR DRAG::adjevt( WEVENT *evt )
{
	PNT	abs;
	W	w;
	ERR	err;

	/*  EV_NULL  */
	if ( evt->s.type != EV_NULL ) return ER_OK;

	/* ٥ȯ */
	err = get_etm(&evt->s.time);
	if ( err < ER_OK ) goto err_ret;

	/* ɥΰ֤θ */
	abs = evt->s.pos;
	err = gcnv_abs(gid, &abs);
	if ( err < ER_OK ) goto err_ret;
	err = wfnd_wnd(&abs, NULL, &w);
	if ( err < ER_OK ) goto err_ret;

	if ( w == wi->wid ) {
		evt->s.cmd = err;
		evt->s.wid = w;
	} else {
		evt->s.cmd = -1;
		evt->s.wid = 0;
	}

	return ER_OK;

err_ret:
	DEBUG_PRINT(("DRAG::adjevt err = %d\n", err));
	return err;
}

/*
 * ɥåϽ
 *	evt	ץ쥹ϻΥ٥(EV_BUTDWN, EV_SWITCH, EV_RSWITCH)
 */
ERR DRAG::dragstart( WEVENT *evt )
{
	/* ⤷ʤ */
	return ER_OK;
}

/*
 * ɥåΥ
 *	evt	EV_NULL
 *	count	Ϣ³ƽв (0 = )
 */
ERR DRAG::scroll( WEVENT *evt, W count )
{
	W	type = -1;
	RECT	wr;
	ERR	err;

	/* ɥ(ΰ)μ */
	err = wget_wrk(wi->wid, &wr);
	if ( err < ER_OK ) goto err_ret;

	/* ݥ󥿤ɥγ(Ͷ)˰֤ƤȤϡ
	   ĤȲߤ˥뤹 */

	if ( evt->s.pos.x < wr.c.left  ) type = 0x12;
	if ( evt->s.pos.x > wr.c.right ) type = 0x13;

	if ( type < 0 || (count & 1) == 0 ) {
		if ( evt->s.pos.y < wr.c.top    ) type = 0x00;
		if ( evt->s.pos.y > wr.c.bottom ) type = 0x01;
	}

	if ( type >= 0 ) {
		/*  */
		wi->scrlfn(type, count);
	}

	return ER_OK;

err_ret:
	DEBUG_PRINT(("DRAG::scroll err = %d\n", err));
	return err;
}

/*
 * ץΥɥǥ꡼
 *	evt	EV_BUTUP
 *	rwi	꡼ɥ
 */
ERR DRAG::release_mywin( WEVENT *evt, WINDOW *rwi )
{
	return cancel(evt);
}

/*
 * ¾ץΥɥǥ꡼
 *	evt	EV_BUTUP
 */
ERR DRAG::release_otherwin( WEVENT *evt )
{
	return cancel(evt);
}

/*
 * ɥå󥻥
 *	evt	EV_BUTUP
 */
ERR DRAG::cancel( WEVENT *evt )
{
	/* ⤷ʤ */
	return ER_OK;
}

/*
 * ꡼
 *	evt	EV_BUTUP
 */
ERR DRAG::release( WEVENT *evt )
{
	WINQ	*q;
	ERR	err;

	if ( evt->s.wid <= 0 ) {
		/* ɥ꡼ */
		err = cancel(evt);
		if ( err < ER_OK ) goto err_ret;
	} else {
		for ( q = WINDOW::OpenWinQ.next();
				q != &WINDOW::OpenWinQ; q = q->next() ) {
			if ( q->me()->wid == evt->s.wid ) break;
		}
		if ( q != &WINDOW::OpenWinQ ) {
			/* ץΥɥإ꡼ */
			err = release_mywin(evt, q->me());
			if ( err < ER_OK ) goto err_ret;
		} else {
			/* ¾ץΥɥإ꡼ */
			err = release_otherwin(evt);
			if ( err < ER_OK ) goto err_ret;
		}
	}

	return ER_OK;

err_ret:
	DEBUG_PRINT(("DRAG::release err = %d\n", err));
	return err;
}

/*
 * Ž׵ᥤ٥Ȥȯ
 *	evt	EV_BUTUP
 *	lefttop	Ȥκɸ(ɥåĶǤкɸ)
 *		W_NAK (0x80)	Žߵ
 *		W_ACK (0x40)	Žߴλ
 *		W_ACK+1		Žߴλ(ʣ׵)
 *		0		ॢ
 *	ŽߤλϡŽإɥڤؤ롣
 */
WERR DRAG::pastereq( WEVENT *evt, PNT lefttop )
{
	WEVENT	req;
	W	sts, wgid;
	ERR	err;

	/* ȤκɸŽΥɥкɸѴ */
	wgid = wget_gid(wi->wid);
	if ( wgid < ER_OK ) { err = wgid; goto err_ret; }
	err = gcnv_abs(wgid, &lefttop);
	if ( err < ER_OK ) goto err_ret;
	wgid = wget_gid(evt->s.wid);
	if ( wgid < ER_OK ) { err = wgid; goto err_ret; }
	err = gcnv_rel(wgid, &lefttop);
	if ( err < ER_OK ) goto err_ret;

	req.s.type = EV_REQUEST;
	req.s.cmd  = W_PASTE;
	req.s.time = PNTtoUW(evt->s.pos);
	req.s.pos  = lefttop;
	req.s.wid  = evt->s.wid;

	/* Ž׵ᥤ٥Ȥ */
	err = wsnd_evt(&req);
	if ( err < ER_OK ) goto err_ret;

	/* Ԥ */
	sts = wwai_rsp(&req, W_PASTE, TIMEOUT);
	if ( sts < ER_OK ) { err = sts; goto err_ret; }

	if ( sts != W_ACK ) return sts;

	if ( req.s.pos.x == (H)0x8000 && req.s.pos.y == (H)0x8000 ) {
		/* Ž褫ʣ׵ */
		++sts;
	}

	/* Žإɥڤؤ */
	err = wswi_wnd(evt->s.wid, NULL);
	if ( err < ER_OK ) goto err_ret;

	return sts;

err_ret:
	DEBUG_PRINT(("DRAG::pastereq err = %d\n", err));
	return err;
}

/*
 * ɥå
 *	evt1st	ץ쥹ϻΥ٥(EV_BUTDWN, EV_SWITCH, EV_RSWITCH)
 *	typ	W_PRESS ޤ W_QPRESS
 */
ERR DRAG::drag( WEVENT *evt1st, W typ )
{
	PNT	pos;
	WEVENT	evt;
	STATE	state, prev_state = Still;
	UW	start = 0;
	W	count;
	ERR	err;

	this->typ = typ;
	dx = dy = 0;

	/* ɥå */
	gid = wsta_drg(wi->wid, 0);
	if ( gid < ER_OK ) { err = gid; goto err_ret1; }

	/* ɥåϽ */
	err = dragstart(evt1st);
	if ( err < ER_OK ) goto err_ret2;

	for ( ;; ) {
		/* ٥ȼФ */
		err = wget_drg(&pos, &evt);
		if ( err < ER_OK ) goto err_ret3;

		/* ɥåϻΰư */
		dx = pos.x - evt1st->s.pos.x;
		dy = pos.y - evt1st->s.pos.y;

		if ( err == EV_BUTUP ) break;

		/* ٥ */
		err = adjevt(&evt);
		if ( err < ER_OK ) goto err_ret3;

		if ( evt.s.wid == wi->wid ) {
			state = ( evt.s.cmd == W_WORK )? Inside: OnFrame;
		} else {
			state = Outside;
		}
		if ( state != OnFrame && prev_state == state ) state = Still;
		else prev_state = state;

		/* ɥåɽ */
		err = tracking(&evt, state);
		if ( err < ER_OK ) goto err_ret3;

		/* ֥ɥե졼αޤäƤ饹 */
		if ( state == OnFrame && evt.s.type == EV_NULL ) {
			if ( start == 0 ) {
				start = evt.s.time;
				count = 0;
			} else if ( evt.s.time - start >= SCROLL_DELAY ) {
				/*  */
				err = scroll(&evt, count++);
				if ( err < ER_OK ) goto err_ret3;
			}
		} else {
			start = 0;
		}
	}

	/* ɥåλ */
	err = dragend(&evt);
	if ( err < ER_OK ) goto err_ret2;

	/* ɥåλ */
	err = wend_drg();
	if ( err < ER_OK ) goto err_ret1;

	/* ꡼ */
	err = release(&evt);
	if ( err < ER_OK ) goto err_ret1;

	return ER_OK;

err_ret3:
	cancel(NULL);
err_ret2:
	wend_drg();
err_ret1:
	DEBUG_PRINT(("DRAG::drag err = %d\n", err));
	return err;
}

/* ------------------------------------------------------------------------- */
/*
 *	ɥܥ饹
 *	class WINDOW
 */

WINFOREC* WINDOW::WinRec;	// ɥ
WINQ WINDOW::OpenWinQ;		// ץΥɥ
WINQ WINDOW::CloseWinQ;		// Ƥ륦ɥ
PAT WINDOW::WinBgPat;		// ɥطʿ

/*
 * 󥹥ȥ饯
 */
WINDOW::WINDOW( W i, WINDOW_DEF *wd )
{
	ix = i;
	wflag = 0;
	wid = -1;
	windef = wd;
	wrect = windef->wrect;
	bgpat = NULL;
	drag = NULL;
	pastereq = false;

	WinRec[ix].info[0] = (W)this;
}

/*
 * WINFOREC ν
 */
ERR WINDOW::setwinforec()
{
	WINFOREC	*wr = &WinRec[ix];
	ERR		err;

	wr->wid = wid;
	wr->chgmod = 0x10 | W_MOVE;
	nullrect(wr->limit);

	err = wget_bar(wid, &wr->pid[0], &wr->pid[1], &wr->pid[2]);
	if ( err < ER_OK ) goto err_ret;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("WINDOW::setwinforec err = %d\n", err));
	return err;
}

/*
 * ѡĥǡν
 *	ǡܥåΥѡνԤ
 */
ERR WINDOW::initpartsdata( PARTS* parts )
{
	ERR	err;

	switch ( parts->tb.type & P_TYPE ) {
	  case TB_PARTS:	/* ƥȡܥå */
	  case XB_PARTS:	/* åȡƥȡܥå */
		offtoptr((UW*)&parts->tb.text);
		break;

	  case NB_PARTS:	/* ͥܥå */
		break;

	  case SB_PARTS:	/* ꥢ롦ܥå */
		offtoptr((UW*)&parts->sb.fmt);
		offtoptr((UW*)&parts->sb.cv);
		break;

	  case AS_PARTS:	/* ƥȡ륿͡ȡå */
	  case MS_PARTS:	/* ƥȡ⡼󥿥ꡦå */
	  case WS_PARTS:	/* å쥯 */
	  case SS_PARTS:	/* 롦쥯 */
		offtoptr((UW*)&parts->ss.name);
		break;

	  case PA_PARTS:	/* ԥȥࡦ륿͡ȡå */
	  case PM_PARTS:	/* ԥȥࡦ⡼󥿥ꡦå */
		break;

	  case VL_PARTS:	/* ܥ塼 */
		break;

	  default:
		err = ER_SYS; goto err_ret;
	}

	adjscalr(&parts->tb.r);

	return ER_OK;

err_ret:
	DEBUG_PRINT(("initpartsdata err = %d\n", err));
	return err;
}

/*
 * ѡĤνꡦϿ
 */
ERR WINDOW::setupparts()
{
	PARTS_DEF	*pdef;
	PNL_ITEM	*pi;
	PARTS		*pa;
	W		i;
	ERR		err;

	/* ѡǡ */
	pdef = (PARTS_DEF*)ptrdbox(windef->parts);
	if ( pdef == NULL ) { err = ER_SYS; goto err_ret1; }

	/* ѡǡʣ̤ */
	parts = (PARTS_DEF*)malloc(PARTS_DEF_SZ(pdef->nitem));
	if ( parts == NULL ) { err = ER_NOMEM; goto err_ret1; }
	memcpy(parts, pdef, PARTS_DEF_SZ(pdef->nitem));

	for ( i = 0; i < parts->nitem; ++i ) {
		pi = &parts->item[i];

		adjscalr(&pi->ir);
		offtoptr((UW*)&pi->ptr);

		if ( (pi->itype & 0x0f) == PARTS_ITEM && pi->ptr != NULL ) {
			pa = (PARTS*)pi->ptr;

			/* ѡĥǡν */
			err = initpartsdata(pa);
			if ( err < ER_OK ) goto err_ret2;

			/* ѡĤϿ */
			err = ccre_par(wid, pa);
			if ( err < ER_OK ) goto err_ret2;
			pi->desc = err;

			/* ѡİ */
			err = cset_pos(pi->desc, &pi->ir);
			if ( err < ER_OK ) goto err_ret2;
		}
	}

	return ER_OK;

err_ret2:
	free(parts);
	parts = NULL;
err_ret1:
	DEBUG_PRINT(("WINDOW::setupparts err = %d\n", err));
	return err;
}

/*
 * ɥΥץ
 *	pwid	ƥɥID
 *	orgr	ư
 *	pict	ԥȥֹ
 *	title	ɥȥ
 */
ERR WINDOW::openwin( W pwid, RECT *orgr, W pict, TC *title )
{
	UW	wattr;
	RECT	workr;
	ERR	err;

	/* ɥ */
	wattr = windef->attr;
	if ( (wflag & WF_FULLSCR) != 0 ) wattr |= WA_FULL;
	workr = wrect;
	if ( bgpat == NULL ) bgpat = &WinBgPat;
	wid = wopn_wnd(wattr, pwid, &workr, orgr, pict, title, bgpat, NULL);
	if ( wid < ER_OK ) { err = wid; goto err_ret1; }

	if ( windef->parts != 0 ) {
		/* ѡν */
		err = setupparts();
		if ( err < ER_OK ) goto err_ret2;
	} else {
		parts = NULL;
	}

	/* ɥ쥳ɤ */
	err = setwinforec();
	if ( err < ER_OK ) goto err_ret2;

	/* ץ󥦥ɥꥹȤϿ */
	remove();		// CloseWinQ 
	OpenWinQ.insert(this);	// OpenWinQ Υȥåפ³

	wflag |= WF_OPEN;

	return ER_OK;

err_ret2:
	wcls_wnd(wid, CLR);
err_ret1:
	wid = -1;
	DEBUG_PRINT(("WINDOW::openwin err = %d\n", err));
	return err;
}

/*
 * ɥ
 */
ERR WINDOW::closewin()
{
	ERR	err, error = ER_OK;

	if ( wid < 0 ) { error = ER_PAR; goto err_ret; }

	/* ɥĤ (ѡĺޤ) */
	err = wcls_wnd(wid, CLR);
	if ( err < ER_OK ) error = err;

	/* ѡǡκ */
	if ( parts != NULL ) {
		free(parts);
		parts = NULL;
	}

	/* ɥꥹȤϿ */
	remove();		// OpenWinQ 
	wid = -1;
	WinRec[ix].wid = -1;
	CloseWinQ.insert(this);

	wflag &= ~WF_OPEN;

err_ret:
#ifdef DEBUG
	if ( error < ER_OK )
		DEBUG_PRINT(("WINDOW::closewin err = %d\n", error));
#endif
	return error;
}

/*
 * ɥ
 */
void WINDOW::idlefn()
{
	bool	in;
	W	lock;

	/* ɥκΰ˥ݥ󥿤Ȥ true */
	in = ( wevt.s.wid == wid && wevt.s.cmd == W_WORK );

	/*** ݥ󥿤ΰ̵֤ط˹Ԥ ***/

	/* ѡĤΥɥ */
	lock = cidl_par(wid, ( in )? &wevt.s.pos: NULL);

	/*** ɥκΰ˥ݥ󥿤ν ***/
	if ( in ) {

		/* ѡĥޥ͡㡼ݥ󥿷«Ƥ餺
		   ̿ᥭƤʤȤݥ󥿷ѹ */
		if ( lock != 1  && !CTRL(wevt.s.stat) ) {
			setpointer(PS_SELECT|PS_CHKBUSY, NULL);
		}
	}
}

/*
 * Ȥɽõ
 */
void WINDOW::visiblesel( VIS )
{
	/* ⤷ʤ */
}

/*
 * ɥۿѹ
 */
ERR WINDOW::chgwincolor()
{
	/* ⤷ʤ */
	return ER_OK;
}

/*
 * С
 */
ERR WINDOW::setscrlbar( W side )
{
	/* ⤷ʤ */
	return ER_OK;
}

/*
 * ɥѹ
 *	newr	ΰ
 */
ERR WINDOW::resize( RECT &newr )
{
	/* ⤷ʤ */
	return ER_OK;
}

/*
 * Τɽ(ɽɽ)
 */
ERR WINDOW::dispall()
{
	/* ⤷ʤ */
	return ER_OK;
}

/*
 * r ɽ
 */
ERR WINDOW::redisprect( RECT &r )
{
	/* ⤷ʤ */
	return ER_OK;
}

/*
 * ɽ׵ꥹȤκɽ
 *	clr = true ΤȤɽΰ򥦥ɥطʿ
 *	ɤĤ֤Ƥɽ
 */
ERR WINDOW::redisplist( bool clr )
{
const	W	N = 3;
static	RLIST	rlist[N] = { { &rlist[1] }, { &rlist[2] }, { NULL } };
	RECT	r, *rp;
	W	i, n;
	ERR	err;

	/* Ȥξõ */
	visiblesel(Off);

	do {
		if ( (n = err = wsta_dsp(wid, &r, rlist)) <= 0 ) break;

		rp = ( n > N )? &r: &rlist[0].rcomp;
		for ( i = 0; i < n; rp = &rlist[++i].rcomp ) {

			if ( clr ) {
				/* ɽΰطʿɤĤ֤ */
				err = wera_wnd(wid, rp);
				if ( err < ER_OK ) goto err_ret;
			}

			/* ɽ */
			err = redisprect(*rp);
			if ( err < ER_OK ) goto err_ret;

			if ( rp == &r ) break;
		}
	} while ( (err = wend_dsp(wid)) > 0 );
	if ( err < ER_OK ) goto err_ret;

	/* Ȥɽ */
	visiblesel(On);

	return ER_OK;

err_ret:
	DEBUG_PRINT(("WINDOW::redisplist err = %d\n", err));
	return err;
}

/*
 * ɽ
 *	mode			  ɽ	newr 
 *	-1	ɽ׵			NULL
 *	0	ɽ׵ᥤ٥		NULL
 *	1	ɥåư			NULL
 *	2	ɥåѷ			ΰ
 *	3	ɥåѷ			ΰ
 *	4	̾⡼ڴ			ΰ
 *	5	̥⡼ڴ			ΰ
 *	6	̾⡼ڴ			ΰ
 *	7	ѥͥ			NULL
 *	8	ѹ			ΰ
 *	9	ѹ			ΰ
 */
void WINDOW::dspfn( W mode, RECT *newr )
{
	WDSTAT	stat;
	ERR	err;

	if ( mode < 0 ) {
		/* ɽ */
		err = dispall();
		if ( err < ER_OK ) goto err_ret;

		err = setscrlbar();
		if ( err < ER_OK ) goto err_ret;

		return;
	}

	if ( newr != NULL ) {
		/* ɥѹ */
		err = resize(*newr);
		if ( err < ER_OK ) goto err_ret;

		/* С */
		err = setscrlbar();
		if ( err < ER_OK ) goto err_ret;
	}

	if ( wcolor_changed != 0 ) {
		/* ɥۿѹ */
		err = chgwincolor();
		if ( err < ER_OK ) goto err_ret;
	}

	/* ɽ׵ꥹȤκɽ */
	err = redisplist(newr == NULL);
	if ( err < ER_OK ) goto err_ret;

	/* ɥΰ֤ȥ¸ */
	switch ( mode ) {
	  case 0:	// ưѷʤ
	  case 7:
		break;

	  case 5:	// ̥⡼
		wflag |= WF_FULLSCR;
		break;

	  default:	// ̾⡼
		wflag &= ~WF_FULLSCR;
		err = wget_sts(wid, &stat, NULL);
		if ( err < ER_OK ) goto err_ret;
		wrect = stat.r;
	}

	return;

err_ret:
	DEBUG_PRINT(("WINDOW::dspfn err = %d\n", err));
	return;
}

/*
 * ɽ
 */
ERR WINDOW::redisp( bool setbgpat )
{
	ERR	err, error = ER_OK;

	/* Ȥξõ */
	visiblesel(Off);

	if ( setbgpat ) {
		/* ɥطʿ */
		err = wset_bgp(wid, bgpat);
		if ( err < ER_OK ) error = err;
	}

	/* ɥΤطʿɤĤ֤ */
	err = wera_wnd(wid, NULL);
	if ( err < ER_OK ) error = err;

	/* ɽ׵򥯥ꥢƤ */
	wsta_dsp(wid, NULL, NULL);

	/* ɽ */
	err = dispall();
	if ( err < ER_OK ) error = err;

	wend_dsp(wid);

	/* Ȥɽ */
	visiblesel(Reset);

	/* С */
	err = setscrlbar();
	if ( err < ER_OK ) error = err;

#ifdef DEBUG
	if ( error < ER_OK ) DEBUG_PRINT(("WINDOW::redisp err = %d\n", error));
#endif
	return error;
}

/*
 * 
 *	type = xxxx xxxx xxCC TTDD
 *		CC = 0	С
 *		     1	С
 *		     2	С
 *		TT = 0	ࡼ
 *		     1	ꥢ
 *		     2	ץ
 *		DD = 0	她
 *		     1	
 *		     2	
 *		     3	
 *
 *	diff	ץ	ư clo - ư clo
 *		ࡼ	Ϣ³ƽХ(0)
 *		ꥢ	̤
 */
void WINDOW::scrlfn( W type, W diff )
{
	/* ⤷ʤ */
}

/*
 * ץ쥹
 *	evt	ץ쥹ϻΥ٥(EV_BUTDWN, EV_SWITCH, EV_RSWITCH)
 *		0 : ץ쥹̵뤷ƥ٥ȥ롼פ
 *		1 : ץ쥹򳫻Ϥ
 */
WERR WINDOW::pressstart( WEVENT *evt )
{
	/* ⤷ʤ */
	return 1;
}

/*
 * å֥륯å
 *	evt	ץ쥹ϻΥ٥(EV_BUTDWN, EV_SWITCH, EV_RSWITCH)
 *	typ	W_CLICK ޤ W_DCLICK
 */
ERR WINDOW::click( WEVENT *evt, W typ )
{
	/* ⤷ʤ */
	return ER_OK;
}

/*
 * ץ쥹λ
 *	顼ˤ뽪λλsts < 0 ȤƸƤӽФ롣
 *		0   : ٥ȥ롼פ³
 *		> 0 : ٥ȥ롼פλ (evt_loop() ͤȤʤ)
 */
WERR WINDOW::pressend( ERR sts )
{
	/* ⤷ʤ */
	return 0;
}

/*
 * PD ץ쥹
 *		== 0 : ٥ȥ롼פ³
 *		!= 0 : ٥ȥ롼פλ (evt_loop() ͤȤʤ)
 */
W WINDOW::presfn()
{
	W	typ;
	ERR	err;

	/* ץ쥹 */
	err = pressstart(&wevt);
	if ( err < ER_OK ) goto err_ret1;
	if ( err == 0 ) return 0; // ̵

	/* ֥륯åȽ */
	typ = wchk_dck(wevt.s.time);
	if ( typ < ER_OK ) { err = typ; goto err_ret2; }

	switch ( typ ) {
	  case W_PRESS:
	  case W_QPRESS:
		if ( drag != NULL ) {
			err = drag->drag(&wevt, typ);
			if ( err < ER_OK ) goto err_ret2;
			break;
		}
		typ += 2; /* W_PRESS -> W_CLICK, W_QPRESS -> W_DCLICK */
		/* no break */

	  case W_CLICK:
	  case W_DCLICK:
		err = click(&wevt, typ);
		if ( err < ER_OK ) goto err_ret2;
		break;
	}

	/* ץ쥹λ */
	err = pressend(err);
	if ( err < ER_OK ) goto err_ret1;

	return err;

err_ret2:
	pressend(err);
err_ret1:
	DEBUG_PRINT(("WINDOW::presfn err = %d\n", err));
	return 0;
}

/*
 * ϼդ֤ؤ
 *	sts
 *	= 0x0001EV_SWITCH ޤ EV_RSWITCH ȯ
 *	= 0x0002W_SWITCH ȯ (¾ɥ)
 *	= 0x0102W_SWITCH ȯ (ѥͥ뤫)
 *	< 0x0000W_CLOSED ȯ
 *		  sts = -( wid)
 */
void WINDOW::activwin( W sts )
{
	/* Ȥɽ */
	visiblesel(Active);
}

/*
 * ϼդ֤ؤ
 *	sts
 *	= 0x0000EV_INACT ȯ (¾ɥؤڤ괹)
 *	= 0x0100EV_INACT ȯ (ѥͥؤڤ괹)
 *	>=0x4000W_OPENED ȯ
 *		  sts = 0x4000 + (ҥץˤꥪץ󤵤줿 wid)
 */
void WINDOW::inactwin( W sts )
{
	/* Ȥξõ */
	visiblesel(Inactive);
}

/*
 * Ѳ
 *	sts
 *	= 0x0000EV_INACT ȯ (¾ɥؤڤ괹)
 *	= 0x0001EV_SWITCH ޤ EV_RSWITCH ȯ
 *	= 0x0002W_SWITCH ȯ (¾ɥ)
 *	= 0x0100EV_INACT ȯ (ѥͥؤڤ괹)
 *	= 0x0102W_SWITCH ȯ (ѥͥ뤫)
 *	>=0x4000W_OPENED ȯ
 *		  (sts 0x4000+(ҥץˤꥪץ󤵤줿wid) Ȥʤ)
 *	< 0x0000W_CLOSED ȯ ( wid   -sts Ȥʤ)
 */
void WINDOW::stsfn( W sts )
{
	if ( sts < 0x0000 || (sts < 0x4000 && (sts & 0x0003) != 0) ) {
		/* ɥꥹȤΥȥåפ˰ư */
		remove();
		OpenWinQ.insert(this);

		/* ϼդ֤ؤ */
		activwin(sts);

		if ( pastereq ) {
			/* Ž߽ */
			pasteexe();
			pastereq = false;
		}
	} else {
		/* ϼդ֤ؤ */
		inactwin(sts);
	}
}

/*
 * Ž׵ᥤ٥Ƚ
 *	pos	Ž߰(ΰκ)
 *		W_ACK	Ž߲
 *		W_ACK+1	Ž߲(ʣ׵)
 *		W_NAK	ŽԲ
 */
WERR WINDOW::pasteevt( PNT &pos )
{
	/* Žߵ */
	return W_NAK;
}

/*
 * Ž߽
 */
ERR WINDOW::pasteexe()
{
	/* ⤷ʤ */
	return ER_OK;
}

/*
 * Ž߽
 *	Ž׵ᥤ٥ȤäȤpasteevt() ƤӽФ
 *	Ž߲ĤǤСθ˼ɥƥ֥ɥ
 *	ڤؤäȤpasteexe() ƤӽФ
 */
W WINDOW::pastefn( PNT &pos )
{
	W	rsp;

	rsp = pasteevt(pos);
	if ( rsp < ER_OK ) goto err_ret;

	switch ( rsp ) {
	  case W_ACK+1:
		wevt.s.pos.x = 0x8000;	// ʣ׵
		wevt.s.pos.y = 0x8000;
		/* no break */
	  case W_ACK:
		pastereq = true;
		rsp = W_ACK;
		break;

	  default:
		rsp = W_NAK;
	}

	return rsp;

err_ret:
	DEBUG_PRINT(("WINDOW::pastefn err = %d\n", rsp));
	return W_NAK;
}

/* ------------------------------------------------------------------------- */
/*
 *	WINDOW 饹 static ؿ
 */

/*
 * 
 *	WINDOW 饹ǽ˻Ѥˣ٤¹Ԥ롣
 */
ERR WINDOW::initialize( WINFOREC *wr )
{
	WinRec = wr;

	/* ɥ塼ν */
	OpenWinQ.init();
	CloseWinQ.init();

	return ER_OK;
}

/*
 * λ
 *	ɥĤ롣
 */
ERR WINDOW::finish()
{
	WINDOW	*wi;
	ERR	err, error = ER_OK;

	/* ΥɥˡɥĤ */
	while ( !OpenWinQ.isempty() ) {
		wi = OpenWinQ.next();

		err = wi->closewin();
		if ( err < ER_OK ) error = err;
	}

#ifdef DEBUG
	if ( error < ER_OK ) DEBUG_PRINT(("WINDOW::finish err = %d\n", error));
#endif
	return error;
}

/*
 * ɥطʿ
 *	bgcolor	طʿ
 *	bgmask	طʿޥ(FILL0  FILL100 ޤ 0)
 *	vbcolor	Ȥɽΰطʿ
 */
void WINDOW::setwinbgcol( COLOR bgcolor, W bgmask, COLOR vbcolor )
{
	WinBgPat.spat.kind  = 0;
	WinBgPat.spat.hsize = 16;
	WinBgPat.spat.vsize = 16;
	WinBgPat.spat.bgcol = COL_WHITE;

	if ( bgmask == 0 ) {
		/* Ȥɽΰطʿ */
		WinBgPat.spat.fgcol = vbcolor;
		WinBgPat.spat.mask  = FILL100;
	} else {
		/* ο */
		WinBgPat.spat.fgcol = bgcolor;
		WinBgPat.spat.mask  = (UB*)bgmask;
	}
}

/* ------------------------------------------------------------------------- */
/*
 *	WFUNCREC ϿѴؿ
 */

/*
 * ɥ
 */
void WINDOW::idlefn_entry()
{
	WINQ	*q;

	/* ץ󤵤Ƥ뤹٤ƤΥɥΥɥԤ */
	for ( q = OpenWinQ.next(); q != &OpenWinQ; q = q->next() ) {
		q->me()->idlefn();
	}
}

/*
 * ̥å
 */
W WINDOW::msgfn_entry( MESSAGE *msg )
{
	switch ( msg->msg_type ) {
	  case MS_ABORT:
	  case MS_EXIT:
	  case MS_TERM:
		/* ҥץɥ򳫤˽λơ
		   ݥ󥿤Υӥå */
		setpointer(PS_BUSYUNLOCK, NULL);
		/* no break */

	  default:
		/* åΤƤ */
		clr_msg(MM_ALL, MM_ALL);
	}

	return 0;
}

/*
 * ɽ
 *	mode			  ɽ	new 
 *	-1	ɽ׵			NULL
 *	0	ɽ׵ᥤ٥		NULL
 *	1	ɥåư			NULL
 *	2	ɥåѷ			ΰ
 *	3	ɥåѷ			ΰ
 *	4	̾⡼ڴ			ΰ
 *	5	̥⡼ڴ			ΰ
 *	6	̾⡼ڴ			ΰ
 *	7	ѥͥ			NULL
 *	8	ѹ			ΰ
 *	9	ѹ			ΰ
 *
 *	˥塼[ɽ]ƤФ (mode = 4/5/6 Ȥ)
 */
void WINDOW::dspfn_entry( W ix, W mode, RECT *newr )
{
	if ( WinRec[ix].wid > 0 ) getwin(ix)->dspfn(mode, newr);
}

/*
 * Ѳ
 *	sts
 *	= 0x0000EV_INACT ȯ (¾ɥؤڤ괹)
 *	= 0x0001EV_SWITCH ޤ EV_RSWITCH ȯ
 *	= 0x0002W_SWITCH ȯ (¾ɥ)
 *	= 0x0100EV_INACT ȯ (ѥͥؤڤ괹)
 *	= 0x0102W_SWITCH ȯ (ѥͥ뤫)
 *	>=0x4000W_OPENED ȯ
 *		  (sts 0x4000+(ҥץˤꥪץ󤵤줿wid) Ȥʤ)
 *	< 0x0000W_CLOSED ȯ ( wid   -sts Ȥʤ)
 */
void WINDOW::stsfn_entry( W ix, W sts )
{
	/* ݥ󥿤Υӥå */
	setpointer(PS_BUSYUNLOCK, NULL);

	if ( WinRec[ix].wid > 0 ) getwin(ix)->stsfn(sts);
}

/*
 * PD ץ쥹
 */
W WINDOW::presfn_entry( W ix )
{
	return ( WinRec[ix].wid > 0 )? getwin(ix)->presfn(): 0;
}

/*
 * ĥ߽
 */
W WINDOW::pastefn_entry( W ix, PNT pos )
{
	return ( WinRec[ix].wid > 0 )? getwin(ix)->pastefn(pos): W_NAK;
}

/*
 * 
 *	type = xxxx xxxx xxCC TTDD
 *		CC = 0	С
 *		     1	С
 *		     2	С
 *		TT = 0	ࡼ
 *		     1	ꥢ
 *		     2	ץ
 *		DD = 0	她
 *		     1	
 *		     2	
 *		     3	
 *
 *	diff	ץ	ư clo - ư clo
 *		ࡼ	Ϣ³ƽХ(0)
 *		ꥢ	̤
 */
void WINDOW::scrlfn_entry( W ix, W type, W diff )
{
	if ( WinRec[ix].wid > 0 ) getwin(ix)->scrlfn(type, diff);
}

/* ------------------------------------------------------------------------- */
} // namespace LIBCPP1
