/*
 *	@(#)atomic.c (libstlpot) 2001-03-16
 *
 *	(C) Copyright 2001 by Personal Media Corporation
 */

#include <basic.h>
#include <stl/_brightv_atomic.h>

#if CPU_ID & CPU_I386

#define _ATOMIC_ADD(vmem, vreg)			\
	Asm("   lock;"				\
	    "   xaddl    %0, %1  "		\
		: "=r"(vreg), "=m"(vmem) 	\
		: "0"(vreg), "1"(vmem))

#define _ATOMIC_SWAP(vmem, vreg)		\
	Asm("	xchgl	%0, %1	"		\
		: "=m"(vmem), "=r"(vreg)	\
		: "0"(vmem), "1"(vreg))

#else
#	error "Not implemented yet."
#endif /* CPUID & CPU_I386 */

void _atomic_increment(unsigned long *__p)
{
	long v = 1;
	_ATOMIC_ADD(*__p, v);
}
  
unsigned long _atomic_decrement(unsigned long *__p)
{
	long v = -1;
	_ATOMIC_ADD(*__p, v);
	return v - 1;
}

unsigned long _atomic_swap(unsigned long * __p, unsigned long __q)
{
	_ATOMIC_SWAP(*__p, __q);
	return __q;
}
