/*
 *	@(#)brightv_io.c (libstlpot) 2001-03-16
 *
 *	(C) Copyright 2001 by Personal Media Corporation
 */

#include <basic.h>
#include <bsys/cons_io.h>
#include <bsys/cio_svc.h>

#include "stub_header.h"

#include "stdio.h"
#include "brightv_io.h"

#define IS_OUTPUTFD(fd) ((fd == 1) || (fd == 2))

#define NFILES 3
/* file descriptor Τ߽ */
FILE __sF[NFILES] = {
	{0, 0, 0, 0, 0,{0, 0}, 0, 0, 0, 0, 0, 0, {0, 0}, 0, 0, {0, 0, 0}, {0}, {0, 0}, 0, 0},
	{0, 0, 0, 0, 1,{0, 0}, 0, 0, 0, 0, 0, 0, {0, 0}, 0, 0, {0, 0, 0}, {0}, {0, 0}, 0, 0},
	{0, 0, 0, 0, 2,{0, 0}, 0, 0, 0, 0, 0, 0, {0, 0}, 0, 0, {0, 0, 0}, {0}, {0, 0}, 0, 0},
};

/* ------------------------------------------------------------ */
/* from libsys/src/raw_cio.c */
static	int	__MyConsPort = 0;

#define	MyPort		(__MyConsPort <= 0 ? GetMyPort() : __MyConsPort)

static	int     GetMyPort()
{
	if (__MyConsPort <= 0) {
		if (console_conf(CS_GETPORT, (UW*)&__MyConsPort) < 0) {
			__MyConsPort = CONSOLE_PORT;
		}
	}
	return	__MyConsPort;
}

size_t	_file_write(int i, const void *ptr, size_t size)
{
	int len;

	if (!IS_OUTPUTFD(i)) {
		NOT_IMPLEMENT("_file_fwrite");
		return 0;
	}

	len = console_out(MyPort, (B *)ptr, size);
	return (len <= 0) ? 0 : (len / size);
}
