/*
 *	@(#)spinlock.c 2001-03-07
 *
 *	ԥå
 *	(C) Copyright 2001 by Personal Media Corporation
 */

#include <basic.h>
#include <btron/process.h>
#include <stl/_brightv_spinlock.h>

#define WAIT_MILLISECOND 5

/* Хȷvmem, vreg򥢥ȥߥå˸򴹤롣 */
#if CPU_ID & CPU_I386
#define _ATOMIC_SWAP_BYTE(vmem, vreg)		\
	Asm("	xchgb	%0, %1	"		\
		: "=m"(vmem), "=r"(vreg)		\
		: "0"(vmem), "1"(vreg));
#else
#	error "Not implemented yet."
#endif

/*
 * Note: _ATOMIC_SWAP_BYTE()ϥ껲ȥڥɤޤasmʸǤꡢ
 *       gccŬǤ⥳ѥǤ褦inlineؿ˴ޤƤ
 */
Inline UB
try_lock(_SpinLock *spinlock)
{
	UB flg = 1;
	_ATOMIC_SWAP_BYTE(spinlock->flg, flg);
	return flg == 0;
}

void
_SLock(_SpinLock *spinlock)
{
	for (;;) {
		if (try_lock(spinlock))
			break;

		/* 
		 * åγ˼ԤΤǡ¾˥塼󥰤
		 * Ԥġ
		 */
		b_dly_tsk(WAIT_MILLISECOND);
	}
}
