/*
	disp.c		ץץ : ɽ

	(C) Copyright 1998 by Personal Media Corporation
*/
#include	"sample.h"

/* С */
typedef	struct	{
	W	clo, chi, lo, hi;
} SCRL_BAR;

LOCAL	SCRL_BAR	hbar = {0,0,0,0};	/* С */
LOCAL	SCRL_BAR	vbar = {0,0,0,0};	/* С */

/* ɽ RLIST */
#define	N_VIEWR		4
LOCAL	RLIST		view_rl[N_VIEWR];

/*
	Сɽι
*/
LOCAL	VOID	disp_sbar(VOID)
{
	W	lo, hi;

	if (window[0].wid <= 0) return;		/* ɥϳƤʤ */

	/* ΥץǤϡСϡ
	   ΰ (frect) Ⱥΰ (vrect) ͤΤΤѤ
	*/

	/* С:
		hi  (ü)	: frect.c.top
		chi ()	: vrect.c.top
		clo ()	: vrect.c.bottom
		lo  (ü)	: frect.c.bottom
	*/
	hi = frect.c.bottom;
	if (hi < vrect.c.bottom) hi = vrect.c.bottom;

	/* ͤѹСꤹ */
	if (vbar.clo != vrect.c.top || vbar.chi != vrect.c.bottom ||
	    vbar.lo  != frect.c.top || vbar.hi != hi) {
		vbar.clo = vrect.c.top;
		vbar.chi = vrect.c.bottom;
		vbar.lo  = frect.c.top;
		vbar.hi  = hi;
		update_sbar(0, 0, (W*)&vbar);
	}

	/* С:
		hi  (ü)	: frect.c.left
		chi ()	: vrect.c.left
		clo ()	: vrect.c.right
		lo  (ü)	: frect.c.right
	*/
	lo = frect.c.right;
	if (lo < vrect.c.right) lo = vrect.c.right;

	/* ͤѹСꤹ */
	if (hbar.clo != vrect.c.right || hbar.chi != vrect.c.left ||
	    hbar.lo  != lo  || hbar.hi != frect.c.left ) {
		hbar.clo = vrect.c.right;
		hbar.chi = vrect.c.left;
		hbar.lo  = lo;
		hbar.hi  = frect.c.left;
		update_sbar(0, 1, (W*)&hbar);
	}
}

/*
	ɥɽ
*/
EXPORT	VOID	view(RECT r)
{
	SEGMENT	*s;

	/* ɽΰΤߤ򥯥åΰȤ */
	gset_vis(mygid, r);

	/* ޤطʤطʿɤĤ֤ */
	gfil_rec(mygid, r, &windpat, 0, G_STORE);

	/* ɽΰˤäƤ륻Ȥ򲼤褹 */
	for (s = segroot; s != NULL; s = s->next) {
		if (sectrect(r, s->frame)) {
			/* ѥѥѤ褹 */
			wkpat.spat.fgcol = s->lcolor;
			gdra_pln(mygid, (POLY*)&s->round, s->lwidth,
						&wkpat, G_STORE);
		}
	}

	/* åΰ򸵤᤹ */
	gset_vis(mygid, vrect);
}

/*
	ɽ
*/
LOCAL VOID	redisplay(VOID)
{
	W	nr;
	RECT	r;

	do {
		/* ɽɬפΰФ */
		nr  = wsta_dsp(mywid, &r, view_rl);
		if (nr <= 0) break;	/* ɽΰʤ */

		/* ɽɬפΰκɽԤ */
		if (nr > N_VIEWR)	view(r);
		else	while (--nr >= 0) view(view_rl[nr].rcomp);
	} while (wend_dsp(mywid) > 0);
}

/*
	ɽΥ
*/
LOCAL	VOID	scrl_disp(W dx, W dy)
{
	W	sts;

	if (dx != 0 || dy != 0) {
		/* ΰƤ򥹥뤷ɽɬפΰꤹ */
		sts = wscr_wnd(mywid, NULL, dx, dy, W_SCRL | W_RDSET);
		if (sts >= ER_OK) {
			/* frame ΰ򿷤ΰ(vrect) Ȥ */
			gget_fra(mygid, &vrect);
			gset_vis(mygid, vrect);

			/* ɽ */
			if ((sts & W_RDSET) != 0) redisplay();
			else	view(vrect);	/* ΰκɽ */
		}
	}
}

/*
	륤٥Ƚ

		sts =	xxx..xxxxCCTTDD
			CC = 0: 1: 2: 
			TT = 0: SMOOTH1:AREA2: JUMP
			DD = 0: UP1: DOWN2:LEFT3:RIGHT
*/
EXPORT	VOID	scrl_fn(W ix, W sts, W diff)
{
	PNT	p;

	/* ̤׻:
		ࡼñ̤ ɸʸ(CHSSTD) Ȥ
	*/
	p = chk_scroll(sts, diff, CHSSTD, vrect, frect);

	/* 뤹ɬפϥ뤹 */
	if (p.x != 0 || p.y != 0) {
		scrl_disp(p.x, p.y);
		/* Сɽι */
		disp_sbar();
	}
}

/*
	ɽ٥Ƚ

		mode =	-1: ɽ׵
			0 : ɽ׵	(׺ɽ)
			1 : ư	(/ݺɽ)
			2 : ѹ
			3 : ѹ	(׺ɽ)
			4 : ̾⡼
			5 : ̥⡼	(׺ɽ)
			6 : ̾⡼	(׺ɽ)
			7 : ѥͥ	(׺ɽ)
			8 : ѹ
			9 : ѹ	(׺ɽ)
*/
EXPORT	VOID	disp_fn(W ix, W mode, RECT *new)
{
	if (mode < 0) {		/* ɽ׵ */
		genrectlist(N_VIEWR, view_rl);	/* view_rl ν */
		view(vrect);			/* ɽΰɽ */
		disp_sbar();			/* Сɽ */

	} else {
		/* ΰѹäϡΰꤹ */
		if (mode >= 2 && mode != 7) {
			vrect = *new;			/*  vrect */
			gset_vis(mygid, vrect);		/*  vrect  */
		}
		/* ɽԤ */
		redisplay();

		/* ΰѹäϡС򹹿 */
		if (mode >= 2 && mode != 7) {
			/* /¦λΰ褬ˤʤϡ
			   뤷ƺΰ褬ˤʤʤ褦ˤ
			*/
			if (vrect.c.left < 0 || vrect.c.top < 0) {
				scrl_disp(vrect.c.left, vrect.c.top);
			}
			/* Сɽι */
			disp_sbar();
		}
	}
}
