/*
	adr.C		ŻҼĢ : Ͽǡδ

	(C) Copyright 1997-98 by Personal Media Corporation
*/
#include "sched.h"

/*
 * Фñ̤Υڡֹ
 *	ȥǡޤหФ롼פΥڡֹ
 */
LOCAL	struct {
	W	no;	/* ƱФ롼ǤΥڡֹ */
	W	all;	/* ƱФ롼Υڡ */
} cur_page;

/*
 * ǡ꡼γ
 */
EXPORT	ADR_DATA*	alloc_adr_data(void)
{
	ADR_DATA	*dp;

	/* ꡼ */
	dp = (ADR_DATA*)malloc(sizeof(ADR_DATA));

	if ( dp != NULL ) {
		/* ǡꥢ */
		memset(dp, 0, sizeof(ADR_DATA));
	}

	return dp;
}

/*
 * ɤߤ饤ǥåʸ
 *	ɤߤκǽʸҤ餬ʤξˤϤʸ
 *	ʤξˤϤҤ餬ʤѴʸ
 *	¾ʸξˤ TNULL ֤
 */
LOCAL	TC	get_yomi_index(TC *yomi)
{
	TC	yo;

	yo = tohira(yomi[0]);

	if ( tc_ishira(yo) ) return yo;
	return TNULL;
}

/*
 * ǥåʸ
 *	Ҥ餬ʤʸɽ
 *	¾ʸ(TNULL)ϤҤ餬ʤ礭
 *	node ʸ礭ä ( node->index > yo )   
 *			      ( node->index = yo )   
 *	node 	      ( node->index < yo ) ݣ
 */
LOCAL	W	cmp_adr_index(ADR_NODE *node, TC yo)
{
	TC		ch;

	if (node == 0) {
		return 1;
	}
	ch = node->index;

	if ( ch == yo ) return 0;
	if ( yo == TNULL ) return -1;
	if ( ch == TNULL ) return 1;
	if ( ch < yo ) return -1;
	return 1;
}

/*
 * ߤ
 *	ʤϤҤ餬ʤѴӤ
 *	yomi1 >  yomi2 λˤ > 0
 *	yomi1 == yomi2 λˤ = 0
 *	yomi1 <  yomi2 λˤ < 0
 *	֤
 *	ʤ̥륹ȥ󥰤ϺǤ礭ΤȤ롣
 */
LOCAL	W	cmp_adr_yomi(TC *yomi1,TC *yomi2)
{
	TC	c1, c2;

	c1 = *yomi1;
	c2 = *yomi2;
	if ( c1 == TNULL || c2 == TNULL ) {

		/* ̥륹ȥ󥰤ФȽ */
		if ( c1 == c2 ) return 0;
		return ( c1 == TNULL )? 1: -1;
	}

	/* ̾Ƚ */
	do {
		c1 = tohira(*yomi1++);
		c2 = tohira(*yomi2++);
		if ( c1 > c2 ) return  1;
		if ( c1 < c2 ) return -1;
	} while ( c1 != TNULL );
	return 0;
}

/*
 * Ρɤɲ
 *	np ΥΡɤ˥Ρɤɲä
 *	prev - np  prev - new - np Τ褦ɲä
 *	np == NULL λˤϡǸΥΡɤȤϿ
 *	ΡɤΥɥ쥹֤
 *	顼ΤȤ NULL ֤
 */
LOCAL	ADR_NODE*	add_adr_node( ADR_NODE *np,TC yo)
{
	ADR_NODE	*new;
	W		i;

	/* ꡼ */
	new = (ADR_NODE*)malloc(lsizeof(ADR_NODE));
	if ( new == NULL ) return NULL;

	/*  */
	new->index = yo;
	for ( i = 0; i < MAX_ADR; ++i ) new->data[i] = NULL;

	if ( adr_data == NULL ) {
		/* 롼Ȥ˥ */
		new->next = new;
		new->prev = new;
		adr_data  = new;
	} else {
		/* 󥯤Ƭؤ³ʤ顢adr_data 򿷤Ρɤ */
		if ( adr_data == np ) adr_data = new;

		if ( np == NULL ) np = adr_data; /* Ǹ³ */

		/* Ρɤ */
		(np->prev)->next = new;
		new->prev	 = np->prev;
		new->next	 = np;
		np->prev	 = new;
	}

	return new;
}

/*
 * Ρɤκ
 *	np ΥΡɤ
 *	np ˤϴ˥ǡϰĤʤȤȤƤ
 *	np ΥΡɤ̡ΡɤĤʤʤäȤˤ
 *	cur_adr  NULL ˤ FALSE ֤
 *	ʳǤ cur_adr Ѳ TRUE ֤
 */
LOCAL	BOOL	del_adr_node( ADR_NODE *np)
{
	/* Ĥ꣱ĤΥΡɤ */
	if ( np->next == np ) adr_data = cur_adr = NULL;

	if ( np == adr_data ) {
		/* ƬΡɤ򼡤ΥΡɤ˰ܤ */
		adr_data = np->next;
	}

	/* Ρɺ */
	(np->next)->prev = np->prev;
	(np->prev)->next = np->next;
	free(np);

	return ( cur_adr != NULL );
}

/*
 * ΥǡΡ֤ߡפȤ
 *	ΥǡΤߤˤ	> 0
 *	ߤ			= 0
 *	ΥǡΤߤˤ	< 0
 *	֤
 */
LOCAL	W	cmp_next( ADR_NODE *np, W i,TC *yomi)
/* np->data[i] ӳϰ */
/* Ӥ֤ߡ */
{
	ADR_DATA	*dp;
	TC		yo;

	/* ǥåʸФ */
	yo = get_yomi_index(yomi);

	/* Υǡõ */
	do {
		/* ǥåʸ */
		if ( cmp_adr_index(np, yo) > 0 ) return 1;

		while ( i < MAX_ADR ) {
			if ( (dp = np->data[i]) != NULL ) {
				/* ΥǡĤäʸ */
				return cmp_adr_yomi(dp->yomi, yomi);
			}
			++i;
		}
		i = 0;
	} while ( (np = np->next) != adr_data );

	return 1; /* ΥǡϤʤ */
}

/*
 * Ρɤ˥ǡɲ
 *	֤ߡפˤʤ褦˥ǡɲä
 *	ɲäǤ NULL ֤
 *	ɲä̡ΡɤϤ߽Фǡäˤϡ
 *	ΥǡΥݥ󥿤֤
 */
LOCAL	ADR_DATA*	add_adr_data( ADR_NODE *np,ADR_DATA *data)
{
	ADR_DATA	*dp;
	W		i;

	for ( i = 0; i < MAX_ADR; ++i ) {

		/* ߤ
		 * ΡɤϿƤǡɲäǡ
		 * ˤˤϡإǡ
		 * Ρɤ˶äˤϡϿƤǡ
		 * ɲäǡˤʤСإǡɲä
		 */
		if ( ( np->data[i] == NULL )?
			cmp_next(np, i+1, data->yomi) > 0 :
			cmp_adr_yomi((np->data[i])->yomi, data->yomi) > 0
		) {
			/* ǡϿ */
			for ( ; i < MAX_ADR; ++i ) {
				dp = np->data[i];
				np->data[i] = data;
				data->node = np;
				if ( (data = dp) == NULL ) break;
				data->node = NULL;
			}
			return data;
		}
	}

	return data;
}

/*
 * ǡϿ
 */
EXPORT	W	insert_adr(ADR_DATA *data)
/* ǡ */
{
	TC		yo;	/* ɤߤκǽΣʸ(ǥåʸ) */
	ADR_NODE	*np;
	W		i;

	/* ǥåʸФ */
	yo = get_yomi_index(data->yomi);

	if ( adr_data == NULL ) {
		/* ޤĤΡɤʤΤǡ˥Ρɤɲä */
		if ( add_adr_node(NULL, yo) == NULL ) return ER_NOMEM;
	}

	np = adr_data;
	do {
		if ( (i = cmp_adr_index(np, yo)) < 0 ) continue;

		if ( i > 0 ) {	/* yo ΥΡ */
			/* Ρɤɲ */
			np = add_adr_node(np, yo);
			if ( np == NULL ) return ER_NOMEM;
		}

		/* ǡϿ */
		if ( (data = add_adr_data(np, data)) == NULL ) return E_OK;

	} while ( (np = np->next) != adr_data );

	/* yo ƱǥåΥΡɤ⡢yo ΥΡɤʤ */
	/* 󥯤κǸ˿Ρɤɲ */
	if ( (np = add_adr_node(NULL, yo)) == NULL ) return ER_NOMEM;

	/* ǡϿ */
	add_adr_data(np, data);

	return E_OK;
}

/*
 * ФֹѴ
 */
EXPORT	W	midashi_idx( TC yo)
{
	if ( yo < 0x2421 ) return 10; /* ¾ */
	if ( yo < 0x242b ) return  0; /*  */
	if ( yo < 0x2435 ) return  1; /*  */
	if ( yo < 0x243f ) return  2; /*  */
	if ( yo < 0x244a ) return  3; /*  */
	if ( yo < 0x244f ) return  4; /*  */
	if ( yo < 0x245e ) return  5; /*  */
	if ( yo < 0x2463 ) return  6; /*  */
	if ( yo < 0x2469 ) return  7; /*  */
	if ( yo < 0x246e ) return  8; /*  */
	if ( yo < 0x2473 ) return  9; /*  */
			   return 10; /* ¾ */
}

/*
 * ФʸѴ
 */
EXPORT	TC	midashi_char(TC yo)
{
	TC*	midashi = (TC*) getdbox (MIDASHI);

	return midashi[midashi_idx(yo)];
}

/*
 * ȥǡΥڡֹƷ׻
 */
EXPORT	BOOL	calc_adr_page(void)
{
	ADR_NODE	*np = adr_data;
	W		idx;
	W		i;

	cur_page.no  = 0;
	cur_page.all = 0;

	/* ߤΥǥåֹФ */
	idx = midashi_idx(cur_adr->index);

	do {
		i = midashi_idx(np->index);
		if ( i < idx ) continue;
		if ( i > idx ) break;

		/* ƱФΥ롼ʤΤǥȤ */
		for ( i = 0; i < MAX_ADR; ++i ) {
			if ( np->data[i] != NULL ) {
				/* ڡ */
				cur_page.all++;
				if ( np == cur_adr && i == cur_adr_ofs ) {
					/* ߥڡֹ */
					cur_page.no = cur_page.all;
				}
			}
		}
	} while ( (np = np->next) != adr_data );

	return TRUE;
}

/*
 * θФʸκǽΥǡ˰դ
 * Υǡʤ FALSE ֤
 *	idx = 0: 1: ... 9: 10:¾
 */
EXPORT	BOOL	set_adr_page(W idx,W mode)
/* ڡֹκƷ׻ʤᤢ */
{
	ADR_NODE	*np = adr_data;
	W		i;

	if ( adr_data == NULL ) return FALSE; /* ǡʤ */

	do {
		if ( midashi_idx(np->index) == idx ) {
			for ( i = 0; i < MAX_ADR; ++i ) {
				if ( np->data[i] != NULL ) {
					/* Ȱ */
					cur_adr     = np;
					cur_adr_ofs = i;

					/* ڡֹƷ׻ */
					if ( (mode & 1) != 0 ) {
						calc_adr_page();
					}
					return TRUE; /* ưλ */
				}
			}
		}
	} while ( (np = np->next) != adr_data );

	return FALSE; /* θФΥǡʤ */
}

/*
 * Υǡ򥫥Ȥꤹ
 */
LOCAL	BOOL	set_cur_data(ADR_DATA *dp)
{
	ADR_NODE	*np;
	W		i;

	np = dp->node;
	if ( np == NULL ) return FALSE; /* ΡɤϿƤʤ */

	for ( i = 0; i < MAX_ADR; ++i ) {
		if ( np->data[i] == dp ) {
			/* Ȥ */
			cur_adr = np;
			cur_adr_ofs = i;
			calc_adr_page(); /* ڡֹƷ׻ */
			return TRUE; /* 괰λ */
		}
	}
	return FALSE; /* Ĥʤ */
}

/*
 * np, i ǻꤵ줿֤顢˸˿ʤǥǡΤ֤˰դ
 * ǡʤ FALSE ֤
 */
LOCAL	BOOL	next_find( ADR_NODE *np, W i)
{
	do {
		while ( i < MAX_ADR ) {
			if ( np->data[i] != NULL ) {
				cur_adr     = np;
				cur_adr_ofs = i;
				return TRUE; /* ưλ */
			}
			++i;
		}
		i = 0;
	} while ( (np = np->next) != adr_data );

	return FALSE; /* ǡʤ */
}

/*
 * np, i ǻꤵ줿֤顢äƥǡΤ֤˰դ
 * ǡʤ FALSE ֤
 */
LOCAL	BOOL	prev_find( ADR_NODE *np, W i)
{
	ADR_NODE	*p;

	do {
		while ( i >= 0 ) {
			if ( np->data[i] != NULL ) {
				cur_adr     = np;
				cur_adr_ofs = i;
				return TRUE; /* ưλ */
			}
			--i;
		}
		i = MAX_ADR-1;
		p = np; np = np->prev;
	} while ( p != adr_data );

	return FALSE; /* ǡʤ */
}

/*
 * Υڡ˰դ
 * ڡΰưʤ FALSE ֤
 */
EXPORT	BOOL	next_adr_page(void)
{
	W	idx;

	if ( adr_data == NULL ) return FALSE; /* ǡʤ */

	idx = midashi_idx(cur_adr->index); /* ߤθФֹ */

	/* ڡư */
	if ( !next_find(cur_adr, cur_adr_ofs+1) ) return FALSE;

	/* ڡֹι */
	if ( idx == midashi_idx(cur_adr->index) ) {
		cur_page.no++;
	} else {
		/* ڡֹκƷ׻ */
		calc_adr_page();
	}

	return TRUE;
}

/*
 * Υڡ˰դ
 * ڡΰưʤ FALSE ֤
 */
EXPORT	BOOL	prev_adr_page(void)
{
	W	idx;

	if ( adr_data == NULL ) return FALSE; /* ǡʤ */

	idx = midashi_idx(cur_adr->index); /* ߤθФֹ */

	/* ڡư */
	if ( !prev_find(cur_adr, cur_adr_ofs-1) ) return FALSE;

	/* ڡֹι */
	if ( idx == midashi_idx(cur_adr->index) ) {
		cur_page.no--;
	} else {
		/* ڡֹκƷ׻ */
		calc_adr_page();
	}

	return TRUE;
}

/*
 * ǽΥڡ˰դ
 * ڡΰưʤ FALSE ֤
 */
EXPORT	BOOL	first_adr_page(void)
{
	if ( adr_data == NULL ) return FALSE; /* ǡʤ */

	/* ڡư */
	if ( !next_find(adr_data, 0) ) return FALSE;

	/* ФֹκƷ׻ */
	calc_adr_page();

	return TRUE;
}

/*
 * ǸΥڡ˰դ
 * ڡΰưʤ FALSE ֤
 */
EXPORT	BOOL	last_adr_page(void)
{
	if ( adr_data == NULL ) return FALSE; /* ǡʤ */

	if ( !prev_find(adr_data->prev, MAX_ADR-1) ) return FALSE;

	/* ФֹκƷ׻ */
	calc_adr_page();

	return TRUE;
}

/*
 * Ͽѥǡ
 */
EXPORT	W	set_new_adr(void)
{
	ADR_DATA	*dp;
	W		err;

	/* ꡼ */
	if ( (dp = alloc_adr_data()) == NULL ) return ER_NOMEM;

	/* ΡɤϿ */
	if ( (err = insert_adr(dp)) < E_OK ) {
		free(dp);
		return err;
	}

	/* Ͽǡ򥫥Ȥ */
	set_cur_data(dp);

	modified = TRUE; /* Խ줿 */
	return E_OK;
}

/*
 * ǡꥢ
 *	֤߰Υǡ򥯥ꥢ
 */
LOCAL	BOOL	clear_adr_data(void)
{
	ADR_DATA	*dp;

	if ( cur_adr == NULL ) return FALSE; /* ǡʤ */
	dp = cur_adr->data[cur_adr_ofs];
	if ( dp == NULL ) return FALSE; /* ǡʤ */

	/* ǡꥢ */
	dp->yomi[0]  = TNULL;	dp->yubin[0] = TNULL;
	dp->addr1[0] = TNULL;	dp->addr2[0] = TNULL;
	dp->addr3[0] = TNULL;	dp->name[0]  = TNULL;
	dp->tel[0]   = TNULL;	dp->fax[0]   = TNULL;
	dp->memo1[0] = TNULL;	dp->memo2[0] = TNULL;

	return TRUE;
}

/*
 * ǡ
 */
LOCAL	BOOL	is_data_empty( ADR_DATA *dp)
{
	return (
		dp->yomi[0]  == TNULL && dp->yubin[0] == TNULL
	     &&	dp->addr1[0] == TNULL && dp->addr2[0] == TNULL
	     &&	dp->addr3[0] == TNULL && dp->name[0]  == TNULL
	     &&	dp->tel[0]   == TNULL && dp->fax[0]   == TNULL
	     &&	dp->memo1[0] == TNULL && dp->memo2[0] == TNULL
	);
}

/*
 * ǡΡɤڤΥ
 * ڤΥǡؤΥݥ󥿤֤
 */
LOCAL	ADR_DATA*	remove_data( ADR_NODE *np,W ofs)
{
	ADR_DATA	*dp = np->data[ofs];
	W		i;

	if ( dp != NULL ) {
		/* ΡɤڤΥ */
		np->data[ofs] = NULL;
		dp->node = NULL;
	}

	/* Ρɤζʬͤ */
	for ( i = ofs+1; i < MAX_ADR; ++i ) {
		if ( np->data[i] != NULL ) {
			np->data[ofs++] = np->data[i];
			np->data[i] = NULL;
		}
	}

	if ( ofs == 0 ) {
		/* Ρɤ˥ǡĤʤʤäΤǡΡɤ */
		del_adr_node(np);
	}

	return dp;
}

/*
 * ȥΡɤΥǥå򹹿
 */
LOCAL	BOOL	update_cur_index(void)
{
	ADR_DATA	*dp;

	if ( cur_adr == NULL ) return FALSE; /* ǡʤ */

	dp = cur_adr->data[cur_adr_ofs];
	if ( dp == NULL ) return FALSE; /* ǡʤ */

	cur_adr->index = get_yomi_index(dp->yomi);

	return TRUE;
}

/*
 * ȥǡ
 */
EXPORT	W	delete_adr_data(void)
{
	ADR_NODE	*np = cur_adr;
	W		i   = cur_adr_ofs;
	ADR_DATA	*dp;
	ADR_DATA	*curp;

	/* ޤΥڡ˰ư */
	if ( !( next_adr_page() || prev_adr_page() ) ) {
		/* ǸΰʤΤǥꥢΤ */
		clear_adr_data();
		update_cur_index(); /* ǥå */
		modified = TRUE; /* Խ줿 */
		return E_OK;
	}
	curp = cur_adr->data[cur_adr_ofs]; /* ǡؤΥݥ󥿤¸ */

	/* ǡڤΥ */
	dp = remove_data(np, i);
	if ( dp == NULL ) return E_OK; /* ǡʤ */

	/* ǡ */
	free(dp);

	/* ֤߰ꤷľ */
	set_cur_data(curp);

	modified = TRUE; /* Խ줿 */

	return E_OK;
}

/*
 * ȥǡϿ
 *	ϿľȤǡȤԤ
 */
LOCAL	W	re_regist_adr(W mode)
/* ȥǡä
				 *  0 : ʤ
				 * -1 : ƥȤΥǡ˰ư
				 *  1 : ƥȤ򼡤Υǡ˰ư
				 */
{
	ADR_NODE	*np = cur_adr;
	W		i   = cur_adr_ofs;
	ADR_DATA	*dp;
	W		err;

	/* ޤΥڡ˰ư */
	if ( ( mode >= 0 )?
		!( next_adr_page() || prev_adr_page() ):
		!( prev_adr_page() || next_adr_page() ) ) {
		/* ǸΰʤΤǤΤޤޡǥåʸΤ߹ */
		update_cur_index();
		return E_OK;
	}

	/* ǡڤΥ */
	dp = remove_data(np, i);
	if ( dp == NULL ) return E_OK; /* ǡʤ */

	if ( mode != 0 && is_data_empty(dp) ) {
		/* ǡ϶Ͽ() */
		free(dp);
		calc_adr_page(); /* ڡֹκƷ׻ */
		modified = TRUE; /* Խ줿 */
	} else {
		/* Ͽ */
		if ( (err = insert_adr(dp)) < E_OK ) {
			/* ϿǤʤä顼ѥͥɽ */
			errpanel(ER_REGIST, err);
			/*
			 *  Τޤޤȥǡæ 
			 * ɤ롩  (911112 fujita)
			 */
			return err;
		}

		/* Ͽ֤򥫥Ȥ */
		set_cur_data(dp);
	}

	return E_OK;
}

/*
 * ѹΥȡڤӺɽ
 */
EXPORT	W	chg_adr_yomi(void)
{
	W	err;

	/* ߥڡϿľơȤԤ */
	if ( (err = re_regist_adr(0)) >= E_OK ) {

		/* ȴλڡֹѹʬΤߺɽ */
		win_dispsw(ADR_WIN);
		view_window(ADR_WIN, &visrect[ADR_WIN], 1);

		/* ѥͥΥܥɽ */
		if ( win[SRC_WIN].id > 0 ) pnl_dispsw(SRC_WIN, 1);
	} else {

		/* 顼ȸϿǤʤä
		 * ϿǤʤäǡϼƤ
		 */
		redisp_adr(1); /* ɽ */
	}

	return err;
}

/*
 * ȥڡֹʸѴ
 *	"" η
 *   ͤ᢬	   ͤ
 */
EXPORT	VOID	get_adr_page_str(TC *str)
/* ʸ֤ܣʸʬɬ */
{
LOCAL	TC	warning[] = {0x2176,0x2176,0x2176,TNULL}; /* "" */

	if ( cur_page.no <= 999 ) {
		stoal(str, cur_page.no, 3);
	} else {
		tc_strcpy(str, warning);
	}

	str[3] = 0x213f; /* "" */

	if ( cur_page.all <= 999 ) {
		stoa(str+4, cur_page.all);
	} else {
		tc_strcpy(str+4, warning);
	}
}

/*
 * ǽɽ뽻ǡ򥫥ȤȤꤹ
 */
EXPORT	W	set_cur_adr(void)
{
	W	err;

	/* ǽΥǡ˰դ */
	if ( !first_adr_page() ) {

		/* ǡʤΤǡϿѤΥǡ */
		if ( (err = set_new_adr()) < E_OK ) return err;
	}

	return E_OK;
}

/*
 * ȤθФֹȥڡֹ֤
 */
EXPORT	BOOL	get_cur_adr_page(W *idx,W *no)
{
	if ( cur_adr == NULL ) return FALSE;

	*idx = midashi_idx(cur_adr->index);
	*no  = cur_page.no;
	return TRUE;
}

/*
 * θФֹ桦ڡֹΥǡ˰ư
 */
EXPORT	BOOL	set_cur_adr_page( W idx, W no)
{
	ADR_NODE	*np = cur_adr;		/* ֤߰¸ */
	W		ofs = cur_adr_ofs;

	/* θФƬڡ˰ư */
	if ( !set_adr_page(idx, 0) ) goto err_exit;

	/* ڡֹʬʤ */
	while ( --no > 0 ) {
		if ( !next_find(cur_adr, cur_adr_ofs+1) ) goto err_exit;
	}

	/* θФˡϤ߽ФƤʤ */
	if ( idx != midashi_idx(cur_adr->index) ) goto err_exit;

	calc_adr_page(); /* ڡֹƷ׻ */

	return TRUE; /* ưλ */

err_exit:
	/* ΥڡĤʤΤǡ᤹ */
	cur_adr     = np;
	cur_adr_ofs = ofs;
	return FALSE;
}
