/*
	fileio.c	ŻҼĢ : ѥեϴؿ

	(C) Copyright 1997-98 by Personal Media Corporation

	  TAD ե򰷤褦ˤʤäƤΤ
	 1 Ȥ礭 32KB ʾϤϥݡȤƤʤ
*/
#include <basic.h>
#include <bstdlib.h>
#include <bstring.h>
#include <errcode.h>
#include <tcode.h>
#include <btron/file.h>
#include <btron/message.h>
#include <btron/dp.h>
#include <btron/libapp.h>
#include <btron/cnvend.h>
#include "fileio.h"

#define	lsizeof(n)	((W)sizeof(n))

EXPORT	W	ropen_err;	/* rcreat,ropen,rfdopen Υ顼ơ */

/*
 * ߤɤ߹֤߰
 */
#define	get_cur_ofs(fp)	( (fp)->rec_ofs - (W)((fp)->buf_s - (fp)->buf_p) )

/*
 * ߤΥեɤ߹֤߰¸
 */
#define	set_prv_ofs(fp)	( (fp)->prv_ofs = get_cur_ofs(fp) )

/*
 * ߤΥեåȰ֤쥳ɽüޤǤΥ
 */
LOCAL	W	record_size( RFILE *fp)
{
	W		size;
	W		err;

	err = rea_rec(fp->fd, fp->rec_ofs, NULL, 0L, &size, NULL);
	if ( err < E_OK ) {
		fp->err = err;
		return 0L;
	}

	return size;
}

/*
 * 쥳ɤõ
 */
LOCAL	W	search_record( RFILE *fp,W mode)
{
	W		rectyp;

	rectyp = fnd_rec(fp->fd, mode, fp->typmsk, 0, &fp->rec_num);

	fp->rec_ofs = 0L;
	fp->prv_ofs = 0L;
	fp->buf_s = 0;
	fp->buf_p = 0;

	if ( rectyp >= E_OK ) {
		fp->rec_typ = rectyp;
		fp->rec_siz = record_size(fp);
	} else {
		if ( rectyp == ER_REC )	fp->eof = TRUE;
		else			fp->err = rectyp;
		fp->rec_siz = 0L;
	}

	return rectyp;
}

/*
 * 쥳ɤ I/O Хåե RBUFSIZ Хɤ߽Ф
 */
LOCAL	W	read_record(RFILE *fp)
{
	W		rectyp;
	W		s;

	rectyp = rea_rec(fp->fd, fp->rec_ofs,
				fp->buf, (W)RBUFSIZ, &fp->rec_siz, NULL);
	if ( rectyp < E_OK ) fp->err = rectyp;

	s = ( fp->rec_siz > (W)RBUFSIZ )? RBUFSIZ: (W)fp->rec_siz;
	fp->rec_ofs += s;
	fp->buf_s = s;
	fp->buf_p = 0;

	return rectyp;
}

/*
 * I/O Хåեե buf_p ХȽ񤭽Ф
 */
LOCAL	W	write_record(RFILE *fp)
{
	W		rectyp;
	W		s;

	rectyp = wri_rec(fp->fd, fp->rec_ofs, fp->buf, (W)fp->buf_p,
						&fp->rec_siz, NULL, 0);
	if ( rectyp < E_OK ) fp->err = rectyp;

	if ( fp->rec_siz >= (W)fp->buf_p ) {
		s = fp->buf_p;
	} else {
		/* Ͻ񤭹ʤä */
		s = (W)fp->rec_siz;
		fp->eof = TRUE;
	}
	fp->rec_ofs += s;
	fp->buf_s = RBUFSIZ;
	fp->buf_p = 0;

	return rectyp;
}

/*
 * ե뤫飱ɤ߽Ф
 * ɤ߹ǡ꥿ͤȤ֤
 * 顼äȤˤ -1L ֤
 */
LOCAL	W	get_ch( RFILE *fp)
{
	TC		ch;
	W		n;

	if ( fp->buf_p >= fp->buf_s ) {
		/* ե뤫ɤ߹ */
		if ( read_record(fp) < E_OK ) return -1L;
	}

	/* ɤ߹ߥǧ */
	if ( (n = fp->buf_s - fp->buf_p) <= 0 ) return -1L;

	if ( n >= sizeof(TC) ) {
		/* ХϢ³ɤ */
		ch = *((TC*)(fp->buf + fp->buf_p));
		fp->buf_p += sizeof(TC);
		return (W)ch;
	}

	/* ХϢ³ɤʤ(Хܤ¸) */
	ch = fp->buf[fp->buf_p++];

	/* ³ե뤫ɤ߹ */
	if ( read_record(fp) < E_OK ) return -1L;
	if ( (fp->buf_s - fp->buf_p) <= 0 ) return -1L;

	ch |= fp->buf[fp->buf_p++] << 8;
	return (W)ch;
}

/*
 * եأɽ񤭽Ф
 * 顼ơ֤
 */
LOCAL	W	put_ch(TC ch, RFILE *fp)
{
	W		err;

	/* Хåեǧ */
	if ( (fp->buf_p + sizeof(TC)) > fp->buf_s ) {
		/* եؽ񤭽Ф */
		if ( (err = write_record(fp)) < E_OK ) return err;
	}

	/* ɽ񤭽Ф */
	*((TC*)(fp->buf + fp->buf_p)) = ch;
	fp->buf_p += sizeof(TC);

	return E_OK;
}

/*
 * ֥åɤ߽Ф
 * ɤ߽ФХȿ֤
 */
LOCAL	W	get_blk(B *buf,W size, RFILE *fp)
{
	W		s;
	W		n;

	for ( s = size; s > 0; s -= n ) {

		if ( fp->buf_p >= fp->buf_s ) {
			/* ե뤫ɤ߹ */
			if ( read_record(fp) < E_OK ) break;
		}

		/* ɤ߹ߥǧ */
		n = fp->buf_s - fp->buf_p;
		if ( n >= s ) n = s;

		/* I/O buf  buf ɤ߹ */
		memcpy(buf, fp->buf + fp->buf_p, n);
		fp->buf_p += n;
		buf += n;
	}

	return size-s;
}

/*
 * ֥å񤭽Ф
 * 񤭽ФХȿ֤
 */
LOCAL	W	put_blk(B *buf,W size, RFILE *fp)
{
	W		s;
	W		n;

	for ( s = size; s > 0; s -= n ) {

		if ( fp->buf_p >= fp->buf_s ) {
			/* եؽ񤭽Ф */
			if ( write_record(fp) < E_OK || reof(fp) ) break;
		}

		/* 񤭽Фǧ */
		n = fp->buf_s - fp->buf_p;
		if ( n >= s ) n = s;

		/* buf  I/O buf ؽ񤭽Ф */
		memcpy(fp->buf + fp->buf_p, buf, n);
		fp->buf_p += n;
		buf += n;
	}

	return size-s;
}

/*
 * 쥳ɤɤ߼Τ
 */
LOCAL	VOID	skip_rec(UW len, RFILE *fp)
{
	UW		l;

	l = fp->buf_s - fp->buf_p;
	if ( l >= len ) {
		/* buf ɤ߹ޤƤϰϤǥåײǽ */
		fp->buf_p += (W)len;
	} else {
		/* buf ɤ߹ޤƤʾ˥åפ */
		fp->rec_ofs += len - l;
		fp->buf_s = 0;
		fp->buf_p = 0;
		fp->rec_siz = record_size(fp);
	}
}

/*
 * ե뤫 buf ˣɤ߽Ф
 * ȥ size ХȤĶȤˤ size ХȤޤɤ߹
 * ĤϼΤƤ
 * ꥿ͤȤɤ߽ФХȿ֤
 */
LOCAL	W	get_seg(B *buf, W size, RFILE *fp)
{
	W		ch;
	UW		len;
	W		s;
	W		n;

	/* ܤɤ */
	if ( (s = 2) > size ) return 0;
	if ( (ch = get_ch(fp)) < 0L ) return 0;
	*((TC*)buf)++ = (TC)ch;

	if ( ConvEndianH((TC)ch) < 0xff80 ) return s; /* 1 or 2 Хȥ */

	/* Ĺ */
	if ( (s += 2) > size ) return s-2;
	if ( (ch = get_ch(fp)) < 0L ) return s-2;
	*((TC*)buf)++ = (TC)ch;

	if ( ConvEndianH((TC)ch) == 0xffff ) {
		/* 顼 */
		if ( (s += 4) > size ) return s-4;
		if ( (ch = get_ch(fp)) < 0L ) return s-4;
		*((TC*)buf)++ = (TC)ch;
		len = ConvEndianH(ch);
		if ( (ch = get_ch(fp)) < 0L ) return s-2;
		*((TC*)buf)++ = (TC)ch;
		len |= ConvEndianH(ch) << 16;
	} else {
		/* ̾糧 */
		len = ConvEndianH((UW)ch);
	}

	/* ɤ߽Ф */
	n = ( (UW)(size-s) > len )? len: size-s;
	s += get_blk(buf, n, fp);

	if ( (len -= n) > 0L ) {
		/* buf ­ʬɤФ */
		skip_rec(len, fp);
	}

	return s;
}

/*
 * buf եأȽ񤭽Ф
 * ꥿ͤȤƽ񤭽ФХȿ֤
 *
 *	buf ؤƤ little endian data
 */
LOCAL	W	put_seg( B *buf,RFILE *fp)
{
	TC		ch;
	UW		len;
	W		s = 0;

	/* ܤ񤭽Ф */
	ch = *((TC*)buf)++;
	if ( put_ch(ch, fp) < E_OK ) return s;
	s += 2;

	if ( ConvEndianH(ch) < 0xff80 ) return s; /* 1 or 2 Хȥ */

	/* Ĺ */
	ch = *((TC*)buf)++;
	if ( put_ch(ch, fp) < E_OK ) return s;
	s += 2;

	if ( ConvEndianH(ch) == 0xffff ) {
		/* 顼 */
		ch = *((TC*)buf)++;
		if ( put_ch(ch, fp) < E_OK ) return s;
		s += 2;
		len = (UW)ConvEndianH(ch);

		ch = *((TC*)buf)++;
		if ( put_ch(ch, fp) < E_OK ) return s;
		s += 2;
		len |= (UW)ConvEndianH(ch) << 16;
	} else {
		/* ̾糧 */
		len = (UW)ConvEndianH(ch);
	}

	/* ν񤭽Ф */
	if ( len >= 0x8000L ) {
		len = 0x7fffL;
		fp->err = ER_SZOVR;
	}
	s += put_blk(buf, (W)len, fp);

	return s;
}

/* ------------------------------------------------------------------------- */

/*
 * եtypmsk 쥳ɤϤν򤹤
 * ꥿ͤȤƥեݥ󥿤֤
 * 顼ˤ NULL ֤
 */
EXPORT	RFILE*	rcreat(LINK *lnk,TC *name,UW typmsk,W opt)
/* եλ */
/* ե̾ */
/* 쥳ɥפΥޥ */
/* ˡ (F_FLOAT|F_FIX|F_FIELD) */
{
	RFILE		*fp;
	W		err;

	/* եݥ(fp)ν */
	ropen_err = ER_NOMEM;
	if ( (fp = (RFILE*)malloc(lsizeof(RFILE))) == NULL ) return NULL;
	memset(fp, 0, sizeof(RFILE));

	/* ե */
	if ( (err = cre_fil(lnk, name, NULL, 0, opt)) < E_OK ) goto err_exit;
	fp->fd	   = err;
	fp->typmsk = typmsk;
	fp->mode   = F_UPDATE;

	/* Ƭ쥳ɤ˰ưƤ */
	fp->rec_typ = ER_REC;
	err = search_record(fp, F_TOPEND);
	if ( err < E_OK && err != ER_REC ) goto err_exit;

	ropen_err = E_OK;
	return fp;

err_exit:
	ropen_err = err;
	free(fp);
	return NULL;
}

/*
 * ե򥪡ץ󤷡typmsk 쥳ɤϤν򤹤
 * ꥿ͤȤƥեݥ󥿤֤
 * 顼ˤ NULL ֤
 */
EXPORT	RFILE*	ropen(LINK *lnk,UW typmsk,W mode)
/* ե */
/* 쥳ɥפΥޥ */
/* ץ⡼ (F_READ|F_WRITE|F_UPDATE) */
{
	RFILE		*fp;
	W		err;

	/* եݥ(fp)ν */
	ropen_err = ER_NOMEM;
	if ( (fp = (RFILE*)malloc(lsizeof(RFILE))) == NULL ) return NULL;
	memset(fp, 0, sizeof(RFILE));

	/* ե륪ץ */
	if ( (err = opn_fil(lnk, mode, NULL)) < E_OK ) goto err_exit;
	fp->fd	   = err;
	fp->typmsk = typmsk;
	fp->mode   = mode;

	/* Ƭ쥳ɤ˰ưƤ */
	fp->rec_typ = ER_REC;
	err = search_record(fp, F_TOPEND);
	if ( err < E_OK && err != ER_REC ) goto err_exit;

	ropen_err = E_OK;
	return fp;

err_exit:
	ropen_err = err;
	free(fp);
	return NULL;
}

/*
 * Ǥ˥ץ󤵤줿եФơtypmsk 쥳ɤϤν򤹤
 * ꥿ͤȤƥեݥ󥿤֤
 * 顼ˤ NULL ֤
 */
EXPORT	RFILE*	rfdopen(W fd,UW typmsk,W mode)
/* եǥץ */
/* 쥳ɥפΥޥ */
/* ץ⡼ (F_READ|F_WRITE|F_UPDATE) */
{
	RFILE		*fp;
	W		err;

	/* եݥ(fp)ν */
	ropen_err = ER_NOMEM;
	if ( (fp = (RFILE*)malloc(lsizeof(RFILE))) == NULL ) return NULL;
	memset(fp, 0, sizeof(RFILE));

	/* fp  */
	fp->fd	   = fd;
	fp->typmsk = typmsk;
	fp->mode   = mode;

	/* Ƭ쥳ɤ˰ưƤ */
	fp->rec_typ = ER_REC;
	err = search_record(fp, F_TOPEND);
	if ( err < E_OK && err != ER_REC ) goto err_exit;

	ropen_err = E_OK;
	return fp;

err_exit:
	ropen_err = err;
	free(fp);
	return NULL;
}

/*
 * 顼ꥢ
 * ꥿ͤȤƥ顼ɤ֤ (ɬ no error ˤʤȤϸ¤ʤ)
 */
EXPORT	W	rclearerr( RFILE *fp)
{
	fp->err = E_OK;
	fp->eof = FALSE;
	search_record(fp, F_TOPEND);
	return rerror(fp);
}

/*
 * Ƭ쥳ɤ˰ư
 * 顼ơ֤
 */
EXPORT	W	rrewind(RFILE *fp)
{
	search_record(fp, F_TOPEND);
	return rerror(fp);
}

/*
 * ХåեƤե˽񤭽Ф
 * 񤭽ФУ(E_OK)ԤХ顼ơ֤
 */
EXPORT	W	rflush( RFILE *fp)
{
	/* ɤ߹ΤߤΥ⡼ɤǤ */
	if ( (fp->mode & F_UPDATE) == F_READ ) return E_OK;

	if ( fp->buf_p > 0 ) {
		/* I/O buf 񤭽Ф */
		write_record(fp);
	}
	return rerror(fp);
}

/*
 * ե򥯥
 * У(E_OK)ԤХ顼ơ֤
 */
EXPORT	W	rclose( RFILE *fp)
/* եݥ */
{
	W		err1, err2;

	err1 = rflush(fp);

	err2 = cls_fil(fp->fd);
	free(fp);

	return ( err1 == E_OK )? err2: err1;
}

/*
 * ե뤫 size ХȤΥ֥å count  buf ɤ߹
 * ꥿ͤȤɤ߽Ф֥åθĿ֤
 */
EXPORT	W	rread(B *buf,W size,W count, RFILE *fp)
/* Хåե */
/* ֥å */
/* ֥åĿ */
/* եݥ */
{
	W		i;

	/* 쥳ɽüʤмΥ쥳ɤذư */
	if ( reor(fp) ) search_record(fp, F_NFWD);

	set_prv_ofs(fp); /* ߰¸ */

	for ( i = 0; i < count; ++i ) {

		/* ߥ쥳ɤˣ֥åʬΥǡĤäƤʤ
		   ɤޤ˽λ */
		if ( size > fp->rec_siz + (fp->buf_s - fp->buf_p) ) break;

		/* ֥åʬɤ߽Ф */
		if ( get_blk(buf, size, fp) < 0 ) break;
		buf += size;
	}

	return i;
}

/*
 * buf  size ХȤΥ֥å count  ե˽񤭽Ф
 * ꥿ͤȤƽ񤭽Ф֥åθĿ֤
 */
EXPORT	W	rwrite(B *buf,W size,W count, RFILE *fp)
/* Хåե */
/* ֥å */
/* ֥å */
/* եݥ */
{
	W		i;

	for ( i = 0; i < count; ++i ) {

		/* ֥åʬ񤭽Ф */
		if ( put_blk(buf, size, fp) < size ) break;
		buf += size;
	}

	return i;
}

/*
 * ե뤫 buf ˣɤ߽Ф
 * ȥ size ХȤĶȤˤ size ХȤޤɤ߹
 * ĤϼΤƤ
 * ꥿ͤȤɤ߽ФХȿ֤
 */
EXPORT	W	rgetseg(B *buf,W size, RFILE *fp)
{
	/* 쥳ɽüʤмΥ쥳ɤذư */
	if ( reor(fp) ) search_record(fp, F_NFWD);

	set_prv_ofs(fp); /* ߰¸ */

	/* ɤ߽Ф */
	return get_seg(buf, size, fp);
}

/*
 * buf եˣȽ񤭽Ф
 * 顼ơ֤
 */
EXPORT	W	rputseg(B *buf, RFILE *fp)
{
	/* Ƚ񤭽Ф */
	put_seg(buf, fp);
	return rerror(fp);
}

/*
 * ɤ߽Ф̵ˤ (ɤ߽ФʤäȤˤ)
 * ǤȤˤϣ(E_OK)ǤʤäȤˤ֤
 */
EXPORT	W	runget( RFILE *fp)
{
	W		n;

	/* 񤭹ߥ⡼ɤǤԲ */
	if ( (fp->mode & F_WRITE) != 0 ) return -1;

	/* ᤹Хȿ */
	n = get_cur_ofs(fp) - fp->prv_ofs;
	if ( n <= 0L ) return -1;

	/* ݥ󥿡ᤷХåե򥯥ꥢ */
	if ( n <= (W)fp->buf_p ) {
		fp->buf_p -= (W)n;
	} else {
		fp->rec_ofs = fp->prv_ofs;
		fp->buf_p = 0;
		fp->buf_s = 0;
		fp->rec_siz = record_size(fp);
	}

	return fp->err;
}

/*
 * ե뤫 size-1 ХȤޤϲ˽в񤦤ޤǤΥǡ
 * buf ɤ߹ߡǸ˥̥ɲä
 * (ǡ˴ޤޤ)
 * ꥿ͤȤɤ߽ФХȿ֤
 */
EXPORT	W	rgets(B *buf,W size, RFILE *fp)
/* Хåե */
/*  */
/* եݥ */
{
	W		n;
	W		s;

	/* 쥳ɽüʤмΥ쥳ɤذư */
	if ( reor(fp) ) search_record(fp, F_NFWD);

	set_prv_ofs(fp); /* ߰¸ */

	for ( s = size; s > 0; s -= n ) {

		/* ɤ߽Ф */
		if ( (n = get_seg(buf, s, fp)) <= 0 ) break;

		/* ǧ */
		if ( n == 2 && *((TC*)buf) == TK_NL ) {
			buf += n;
			s -= n;
			if ( s >= 2 ) {
				*((TC*)buf) = TNULL;
				s -= 2;
			}
			break;
		}

		buf += n;
	}

	return size - s;
}

/*
 * buf ǡɤ߽Ф̥˽в񤦤ޤǥե˽񤭽Ф
 * ꥿ͤȤƽ񤭽ФХȿ֤
 */
EXPORT	W	rputs( B *buf,RFILE *fp)
/* Хåե */
/* եݥ */
{
	W		s = 0;
	W		n;

	while ( !rerror(fp) && *(TC*)buf != TNULL ) {
		n = put_seg(buf, fp);
		buf += n;
		s += n;
	}

	return s;
}

/*
 * ʸ񤭽Ф
 * 顼ơ֤
 */
EXPORT	W	rputc(TC ch,RFILE *fp)
{
	return put_ch(ch, fp);
}
