/*
	lib.c		ŻҼĢ : ƼΥ饤֥ؿ

	(C) Copyright 1997-98 by Personal Media Corporation
*/
#include "sched.h"

/*
 * ̻UW days
 *
 * ΥˡϡB-TRONͤ˴Ťǯ()Ȥ
 *
 *	   January 1985
 *	Su Mo Tu We Th Fr Sa
 *	       1  2  3	4  5
 *	 6  7  8  9 10 11 12
 *	13 14 15 16 17 18 19
 *	20 21 22 23 24 25 26
 *	27 28 29 30 31
 */

#define	MINUS		(0x215d)	/* ֡ݡ */
#define	ASTERISK	(0x2176)	/* ֡ */
#define	SUN		(0x467c)	/*  */
#define	MON		(0x376e)	/* ַ׷ */
#define	TUE		(0x3250)	/* ֲСײ */
#define	WED		(0x3f65)	/* ֿ׿ */
#define	THU		(0x4c5a)	/* ڡ */
#define	FRI		(0x3662)	/* ֶ׶ */
#define	SAT		(0x455a)	/* ڡ */
#define	NEN		(0x472f)	/* ǯ */
#define	TSUKI		(0x376e)	/* ַ */
#define	HI		(0x467c)	/*  */
#define	LKAKKO		(0x214a)	/* ֡ʡ׺ */
#define	RKAKKO		(0x214b)	/* ֡ˡױ */

LOCAL	TC	wk[] = {SUN,MON,TUE,WED,THU,FRI,SAT,TNULL};

/* ǯᤫƷΣޤǤ̻ (ϣǷ׻) */
LOCAL	UW	month_days[13] = {
     /* 1   2	3   4	 5    6    7	8    9	 10   11   12  */
	0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365
};

/*
 *	ʸͤѴ
 */
LOCAL	W	atos(TC *str)
{
	TC	*tail;
	W	num;
	num = tc_strtol(str, &tail, 10);
	return num;
}

/*
 *	ʸ֤򸡺
 */
LOCAL	W	strpos(TC *str, TC c)
{
	TC	*p;

	if ((p = tc_strchr(str, c)) == NULL) return -1;
	return p - str;
}

/*
 * ǯʤ TRUE ֤
 */
LOCAL	BOOL	is_uruudoshi( W year)
{
	return (((year % 4) == 0 && (year % 100) != 0) || (year % 400) == 0);
}

/*
 * ֤
 */
EXPORT	UW	month_day(DATE *date)
{
	W	month = date->month;
	UW	days;

	days = month_days[month] - month_days[month-1];
	if ( month == 2 && is_uruudoshi(date->year) ) days++;

	return days;
}

/*
 * ǯΣޤǤ̻֤
 */
LOCAL	UW	year_to_num( W year)
{
	UW	i;

	/* ¿֤뤬ñѻΤְ */
	for (i = 0; --year >= 1985; i += is_uruudoshi(year) ? 366 : 365);
	return i;
}

/*
 * ̻֤
 */
EXPORT	UW	date_to_num( DATE *date)
{
	UW	days;
	UW	i;

	/* ǯ */
	days = year_to_num(date->year);

	/*  */
	i = ( date->month > 2 && is_uruudoshi(date->year) )? 1: 0;
	days += month_days[date->month-1] + i;

	/*  */
	days += date->day - 1;

	return days;
}

/*
 * ̻ǯ
 */
EXPORT	VOID	num_to_date( DATE *date,UW num)
{
	UW	i;

	/* ǯ */
	date->year = num / 365 + 1985;
	i = year_to_num(date->year);
	if ( num < i ) i = year_to_num(--date->year);
	num -= i;

	/*  */
	i = ( is_uruudoshi(date->year) )? 1: 0;
	if ( num >= month_days[2]+i ) {
		/* ʹ */
		num -= i;
		for ( i = 3; i <= 12; ++i ) {
			if ( num < month_days[i] ) break;
		}
	} else {
		/*  */
		i = ( num < month_days[1] )? 1: 2;
	}
	date->month = i;

	/*  */
	date->day = num - month_days[i-1] + 1;
}

/*
 * ̻
 *	0:1:2:С3:塢4:ڡ5:⡢6:
 */
EXPORT	W	num_to_week(UW days)
{
	return (days + 2) % 7;
}

/*
 * դ
 *	0:1:2:С3:塢4:ڡ5:⡢6:
 */
EXPORT	W	date_to_week(DATE *date)
{
	return num_to_week(date_to_num(date));
}

/*
 * ηΰ
 *	0:1:2:С3:塢4:ڡ5:⡢6:
 */
EXPORT	W	get_week1st(DATE date)
/* ݥ󥿤ǤϤʤΤա */
{
	date.day = 1;
	return date_to_week(&date);
}

/*
 * short integer οͤʸѴ
 *	ͤѴ
 *	Ѵ줿ʸκǸTNULLΰ֤ؤΥݥ󥿤֤
 */
EXPORT	TC*	stoa(TC *str, W num)
{
	W	i;

	if ( num < 0 ) {
		*str++ = MINUS;
		num = -num;
	}

	for ( i = 10000; i > 1; i /= 10 ) if ( num >= i ) break;

	for ( ; i > 0; i /= 10 ) {
		*str++ = 0x2330 + (num / i);
		num %= i;
	}

	*str = TNULL;

	return str;
}

/*
 * short integer οͤʸѴ
 *	len αͤѴ
 */
EXPORT	TC*	stoal(TC *str, W num, W len)
{
	TC	*ep;
	BOOL	minus = FALSE;

	ep = str += len;
	*str-- = TNULL;

	if ( num < 0 ) {
		num = -num;
		minus = TRUE;
	}

	while ( len-- > 0 ) {
		*str-- = 0x2330 + (num % 10);
		if ( (num /= 10) == 0 ) break;
	}

	if ( minus && len-- > 0 ) *str-- = MINUS;

	while ( len-- > 0 ) *str-- = TK_KSP; /* ͤ */

	return ep;
}

/*
 * ʸǡޥͤѴ
 */
EXPORT	W	str_to_weeks( TC *str)
{
	W	i;
	W	m = 0;
	TC	ch;

	while ( (ch = *str++) != TNULL ) {
		if ( (i = strpos(wk, ch)) < 0L ) break;
		m |= BIT_MASK((W)i);
	}
	return m;
}

/*
 * ޥǡʸѴ
 */
EXPORT	TC*	weeks_to_str( TC *str, W w)
{
	W	i;

	for ( i = 0; i < 7; ++i ) {
		if ( (w & 1) != 0 ) *str++ = wk[i];
		w >>= 1;
	}
	*str = TNULL;
	return str;
}

/*
 * ʸեǡͤѴ
 */
EXPORT	BOOL	to_date( DATE *date,TC *str)
{
	TC	*p;

	/* ǯפμФ */
	p = str;
	str = tc_strchr(p, DATE_SEP);
	if ( str == NULL ) return FALSE;
	date->year = ( p[0] == ASTERISK )? -1: atos(p);

	/* ַפμФ */
	p = str+1;
	str = tc_strchr(p, DATE_SEP);
	if ( str == NULL ) return FALSE;
	date->month = ( p[0] == ASTERISK )? -1: atos(p);

	/* פμФ */
	p = str+1;
	date->day = ( p[0] == ASTERISK )? -1: atos(p);

	return TRUE;
}
/*
 * ʸեǡͤѴ
 *		ǯ
 *			
 *	ǯ  ޤ  ǡ ̵(ǯ)򼨤
 *	ϡпڶڡפΣʸʾȤ߹碌
 *	 :			: ǯ
 *			ݣ	: ǯǯ
 *	:					: 
 *						: 
 */
EXPORT	BOOL	to_holiday_date( CAL_HOLIDAY *hp, TC *str)
{
	TC	*p;
	W	m;

	/* ǯפμФ */
	p = str;
	str = tc_strchr(p, DATE_SEP);
	if ( str == NULL ) return FALSE;
	if ( p[0] == ASTERISK ) {
		hp->syear = hp->eyear = -1;
	} else {
		hp->syear = hp->eyear = tc_strtol(p, &p, 10);
		if (*p == TK_MINS) {
			hp->eyear = tc_strtol(p + 1, &p, 10);
			if (hp->eyear < hp->syear) hp->eyear = hp->syear;
		}
	}

	/* ַפμФ */
	p = str + 1;
	str = tc_strchr(p, DATE_SEP);
	if ( str == NULL ) return FALSE;
	hp->month = ( p[0] == ASTERISK ) ? -1: atos(p);

	hp->week = 0;

	/* פμФ */
	p = str + 1;
	if ( p[0] == ASTERISK ) hp->day = -1;
	else {
		hp->day = tc_strtol(p, &p, 10);
		if ((m = str_to_weeks(p)) != 0) hp->week = m;
	}
	return TRUE;
}
/*
 * ͤʸѴ
 * ʲϡ֡פȤ
 */
LOCAL	TC*	tostr( TC *str,W num)
{
	if ( num > 0 ) {
		str = stoa(str, num);
	} else {
		*str++ = ASTERISK;
		*str = TNULL;
	}
	return str;
}

/*
 * եǡʸѴ
 *  ηѴ
 */
EXPORT	TC*	to_str( TC *str, DATE *date)
/* 10ʸʬΰ褬ɬ */
{
	str = tostr(str, date->year);	*str++ = DATE_SEP;
	str = tostr(str, date->month);	*str++ = DATE_SEP;
	str = tostr(str, date->day);

	return str;
}

/*
 * եǡʸѴ
 *  ηѴ
 * ݣ ηѴ
 */
EXPORT	TC*	to_holiday_str( TC *str, CAL_HOLIDAY *hp)
{
	str = tostr(str, hp->syear);
	if (hp->eyear != hp->syear) {
		*str++ = TK_MINS;
		str = tostr(str, hp->eyear);
	}
	*str++ = DATE_SEP;
	str = tostr(str, hp->month);
	*str++ = DATE_SEP;
	str = tostr(str, hp->day);
	if (hp->week > 0) weeks_to_str(str, hp->week);
	return str;
}

/*
 * եǡʸѴ
 * ǯʣ ηѴ
 */
EXPORT	TC*	date_to_jstr(TC *str,DATE *date)
/* 14ʸʬΰ褬ɬ */
{
	str = stoal(str, date->year,  4);	*str++ = NEN;
	str = stoal(str, date->month, 2);	*str++ = TSUKI;
	str = stoal(str, date->day,   2);	*str++ = HI;
	*str++ = LKAKKO;
	*str++ = wk[date_to_week(date)];
	*str++ = RKAKKO;
	*str = TNULL;

	return str;
}

/*
 * եǡʸѴ
 * ǯ  ʿǯ ηѴ
 */
EXPORT	TC*	date_to_kstr(TC *str,DATE *date)
/* 14ʸʬΰ褬ɬ */
{
LOCAL	TC	nengou[2] = { 0x4a3f,0x402e /* ʿ */ };

	str = stoal(str, date->year, 4);	*str++ = NEN;
	str = stoal(str, date->month, 2);	*str++ = TSUKI;
	*str++ = TK_KSP;

	tc_strcpy(str, nengou); str += 2;
	str = stoal(str, date->year-1988, 2);	*str++ = NEN;
	*str = TNULL;

	return str;
}

/*
 * դϰϥå
 */
EXPORT	BOOL	chk_date( DATE *date)
{
	static W ndate [] = {31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
	/*			ǯǤʤɤ롩 */

	if ( date->year < FIRST_YEAR || date->year > LAST_YEAR ) return FALSE;
	if ( date->month < 1 || date->month > 12 ) return FALSE;
	if ( date->day	 < 1 || ndate [date->month -1] < date->day ) return FALSE;
	return TRUE;
}

/*
 * ʸեǡͤѴ
 * ʸΥեޥåȡ
 */
EXPORT	BOOL	str_to_date(DATE *date,TC *str)
{
	return to_date(date, str) && chk_date(date);
}

/*
 * դʸѴ
 * ʸΥեޥåȡ
 */
EXPORT	BOOL	date_to_str( TC *str, DATE *date)
{
	*str = TNULL;

	if ( !chk_date(date) ) return FALSE;

	str = stoa(str, date->year);	*str++ = DATE_SEP;
	str = stoa(str, date->month);	*str++ = DATE_SEP;
	str = stoa(str, date->day);

	return TRUE;
}

/*
 * ʤҤ餬ʤѴ
 */
EXPORT	TC	tohira( TC ch)
{
	if ( !tc_iskata(ch) ) return ch;	/* ʰʳʸ */

	if ( ch >= 0x2574 ) return ch;	/* ֥פϤΤޤ */

	if (tc_ischoon(ch)) return ch;	/* Ĺ⤽Τޤ */

	return ch - 0x0100;
}

/*
 * ֽ񼰥ȤǤ뤫ǧ
 */
EXPORT	BOOL	istabseg(B *seg)
{
	if ( isTC(seg) ) return FALSE;

	if ( isLSEG(seg) ) {
		if ( isTABSEG((LSEG*)seg) ) return TRUE; /* ֽ */
	} else {
		if ( isTABSEG((SEG*)seg) ) return TRUE; /* ֽ */
	}
	return FALSE;
}

/*
 *	 DP ؿ gdra_chp
 */
W
gdra_chp(GID gid, W x, W y, TC ch, DCM mode)
{
	gset_chp(gid, x, y, True);
	gdra_chr(gid, ch, mode);
	return 1;
}

/*
 *	 DP ؿ gdra_stp
 */
W
gdra_stp(GID gid, W x, W y, TC *str, W len, DCM mode)
{
	gset_chp(gid, x, y, True);
	return gdra_str(gid, str, len, mode);
}
