/*
	load.c		ŻҼĢ : եɤ߽Ф

	(C) Copyright 1997-99 by Personal Media Corporation
*/

#include "sched.h"
#include <tlang.h>
#include <mtstring.h>

EXPORT	BOOL	nosupport = FALSE;	/* ե̤ݡȥǡ
					   ޤޤƤȤ TRUE */
EXPORT	BOOL	illegal = FALSE;	/* ե̵ǡ
					   ޤޤƤȤ TRUE */

#define	READBUF_SIZE	(64)		/* ʸ䵥ȤΥإåʬ
					   뤰餤Ŭ礭 */

LOCAL	W	textvres;	/* ̲ */

/*
 * Τɤ߽ФƤ뤫ǧ
 * ٤Ƥɤ߽ФƤʤɤľ
 * ɤľɬפʾˤɬפʥХåե malloc 
 * ɤľפʤУɤľԤä飱֤
 * 顼Ȥˤϥ顼ơ֤
 */
/* LOCAL */
	W	read_check( sp )
	B	**sp;
{
	B	*seg = *sp;
	W	s;

	/* ȥγǧ */
	if ( isLSEG(seg) ) {
		s = ConvEndianW(((LSEG*)seg)->len) + 8;
	} else {
		s = ConvEndianH(((SEG*)seg)->len) + 4;
	}
	if ( s <= READBUF_SIZE ) return E_OK; /* ɤľ */

	if ( s >= 0x8000L ) return ER_SZOVR; /* 礭ɤʤ */

	/* ɤľѥ꡼γ */
	if ( (seg = (B*)malloc(s)) == NULL ) return ER_NOMEM;

	/* ɤľ */
	if ( runget(tg_fp) < E_OK || rgetseg(seg, (W)s, tg_fp) != s ) {
		free(seg);
		return rerror(tg_fp);
	}

	*sp = seg;
	return 1; /* ɤľ */
}

/*
 * ʸϳϥȤɤ߽Ф
 */
/* LOCAL */
	W	load_start_text( seg )
	B		*seg;
{
	W		err;
	SEG_TEXT	*textseg;

	/* ɤ߹߳ǧ */
	if ( (err = read_check(&seg)) < E_OK ) return err;

	if ( isLSEG(seg) ) {
		textseg = (SEG_TEXT*)&((LSEG*)seg)->tx;
	} else {
		textseg = (SEG_TEXT*)&((SEG*)seg)->tx;
	}
	ConvEndianStruct((B*)textseg, (B*)textseg, SEG_TEXT_STRUCT, sizeof(SEG_TEXT));

	/* ٤¸ */
	textvres = textseg->v_unit;

	if ( err > 0 ) free(seg);

	return E_OK;
}

/*
 * ʸϥڡդ䵤ɤ߽Ф
 */
/* LOCAL */
	W	load_pageform( seg )
	B	*seg;
{
	W	err;
	B	*bp;
	W	len;
	PNT	unit;

	/* ɤ߹߳ǧ */
	if ( (err = read_check(&seg)) < E_OK ) return err;

	if ( isLSEG(seg) ) {
		bp = (B*)&((LSEG*)seg)->tx;
		len = ((LSEG*)seg)->len;
	} else {
		bp = (B*)&((SEG*)seg)->tx;
		len = ((SEG*)seg)->len;
	}

	/* 쥤ѻ */
	unit.x = unit.y = textvres;
	switch ( loadform(bp, len, unit) ) {
	  case 0:	break;
	  case -1:	nosupport = TRUE; break;
	  default:	illegal   = TRUE;
	}

	if ( err > 0 ) free(seg);

	return E_OK;
}

/*
 * ȤμǧɬפʥȤɤ߽Ф
 * 顼ơ֤
 */
/* LOCAL */
	W	chk_loadseg( seg, top )
	B	*seg;
	W	top;	/* 1 = եƬʬɤ߽Ф
			   2 = ե뽪üʬɤ߽Ф */
{
	TC	id;

	if ( (id = ConvEndianH(*(TC*)seg)) < 0xff80 ) return E_OK;

	switch ( id & 0x00ff ) {
	  case TS_INFO:
	  case TS_TEXTEND:
	  case TS_TRULER:
		break;
	  case TS_TEXT:
		return load_start_text(seg);
	  case TS_TPAGE:
		return load_pageform(seg);
	  default:
		nosupport = TRUE; /* ̤ݡȥǡ */
	}

	return E_OK;
}

/*
 * ֽ񼰥ȤޤɤФ
 */
/* LOCAL */
	W	skip_first()
{
	B	buf[READBUF_SIZE+1];	/* ʸ䵥ȤΥإåʬ
					   뤰餤Ŭ礭 */
	W	err;

	/* 顼ե뽪üޤ */
	while ( !(rerror(tg_fp) || reof(tg_fp)) ) {

		/* ɤ߽Ф */
		if ( rgetseg(buf, sizeof(buf), tg_fp) <= 0 ) continue;

		/* Ȥμǧ */
		if ( (err = chk_loadseg(buf, 1)) < E_OK ) return err;

		/* ֽ񼰥Ȥʤ齪 */
		if ( istabseg(buf) ) break;
	}
	return rerror(tg_fp);
}

/*
 * ե뽪üޤɤФ
 */
/* LOCAL */
	W	skip_to_eof()
{
	B	buf[READBUF_SIZE+1];	/* ʸ䵥ȤΥإåʬ
					   뤰餤Ŭ礭 */
	W	err;

	/* 顼ե뽪üޤ */
	while ( !(rerror(tg_fp) || reof(tg_fp)) ) {

		/* ɤ߽Ф */
		if ( rgetseg(buf, sizeof(buf), tg_fp) <= 0 ) continue;

		/* Ȥμǧ */
		if ( (err = chk_loadseg(buf, 2)) < E_OK ) return err;
	}
	return rerror(tg_fp);
}

/*
 * եɤ߽Ф
 * tg_fp ʸ򡢥 ޤ  ˽в񤦤 n ʸ
 * ʤޤ str ɤ߽Ф
 *  ޤ  ˽в n ʸãˤϡ
 * Ĥʸɤ߼ΤƤ
 * ϥ顼ȯ뤫եνüã뤫եɤƬ
 * ֽ񼰥ȤˤǤä꥿ͤȤ 0xffff ֤
 * ʳϡեɤζڤȤʤä  ޤ  Υɤ֤
 * ʤ    TNULL ֤졢
 * n ʸãˤ n+1 ʸܤ TNULL 
 */
/* LOCAL */
TC	read_field(
	TC	*str,
	W	n)
{
	B	buf[READBUF_SIZE+1];	/* ʸ䵥ȤΥإåʬ
					   뤰餤Ŭ礭 */
	TC	ch;
	W	i = 0;
	W	length;
	W code;
	TC *multi_tlang = 0;
	W illegal_mode = 0;
	static W work = 0;	/* ؿƤӤۤݻɬפ */
	static W lang = TSC_SYS;

	/* 顼ե뽪üޤ */
	while ( !(rerror(tg_fp) || reof(tg_fp)) ) {

		/* ɤ߽Ф */
		if ((length = rgetseg(buf, sizeof(buf), tg_fp)) <= 0 ) continue;

		if ( isTC(buf) ) {
			ch = ConvEndianH(*(TC*)buf);

			/* եɽüǧ */
			if ( ch == TC_TAB || ch == TC_NL ) {
				goto ret;
			}

			/* ʸ򥪡СƤʤСɤ߽Ф */
			if (ch < 0xfeff) {
				code = isTLANGch (ch, &work);
				if (code != 0) {
					if (code > 0) {
						illegal_mode = 0;
						multi_tlang = 0;
						if (lang == code) {
							/* Ĺ */
							continue;
						}
						lang = code;
					} else if (code == -2) {
						/* ʣХȸ */
						illegal_mode = 0;
						if (!multi_tlang) {
							multi_tlang = str;
						}
					} else /*if (code == -1)*/ {
						illegal_mode = 1;
						illegal = TRUE;
						continue;
					}
				}
				if (i < n) {
					if (i == 0) {
						if (ch == (TSC_SYS|0xFE00)) {
							/* ǽΥƥॹץȻϾĹ */
							continue;
						} else if (lang != TSC_SYS && code == 0) {
							/* θ꤬ͭǤ */
							W lang_length = TLANGtoTC (0, 0, lang);
							if (n - 1 <= lang_length) {
								/* ǼǤʤۤĹץȻꥳɤ
								   ɤȤߤʤ */
								illegal_mode = 1;
							} else {
								TLANGtoTC (str, lang_length, lang);
								str += lang_length;
								i += lang_length;
							}
						}
					}
					/* ΤȤϤδ֤夦ʸ̵뤹 */
					if (!illegal_mode) {
						*str++ = ch;
						i++;
					}
				} else if (code == 0) {

					illegal = TRUE;
				}
			} else {
				illegal = TRUE; /* ̵ǡ */
			}
		} else {
			/* ֽ񼰥Ȥʤ齪λ */
			if ( i == 0 && istabseg(buf) ) break;
			nosupport = TRUE; /* ̤ݡȥǡ */
		}
	}
	ch = 0xffff;
ret:
	if (multi_tlang) {
		/* 뤷ʤʣХȸ꤬ä */
		str = multi_tlang;
		illegal = TRUE;
		work = 0;
	}
	if (illegal_mode) {
		/* եɤ֤ۤϤʤΤȤ롣
		   Ǥʤȡαƶե뽪üޤǤؤʤϤ*/
		work = 0;
	}
	*str = TNULL;
	return ch;
}

/*
 * ͽɽǡɤ߽Ф
 */
/* LOCAL */
	W	load_sch()
{
	TC	dstr[DATE_LEN+1];	/* ͽ(ʸ) */
	DATE	date;			/* ͽ() */
	TC	str[SCH_LEN+1];		/* ͽ */
	TC	ch;
	W	err;

	/* ͽɽǡνޤ */
	while ( (ch = read_field(dstr, DATE_LEN)) != 0xffff ) {
		if ( ch != TC_TAB ) {
			illegal = TRUE;	/* ̵ǡ */
			continue;
		}

		/* ʸͤѴ */
		if ( !str_to_date(&date, dstr) ) {
			illegal = TRUE;	/* ̵ǡ */
			continue;
		}

		do {
			/* ͽɤ߹ */
			ch = read_field(str, SCH_LEN);
			if ( ch == 0xffff ) return E_OK; /* ͽɽǡ */

			/* ̿Ȥ˥ǡϿ */
			if ( (err = insert_sch(&date,str)) < E_OK ) return err;
			if ( err > E_OK ) {
				/* ǡĶ */
				illegal = TRUE; /* ̵ǡ */
			}

		} while ( ch == TC_TAB );
	}

	return rerror(tg_fp);
}

/*
 * Ͽǡɤ߽Ф
 */
/* LOCAL */
	W	load_adr()
{
	ADR_DATA	*data;		/* ꣱ʬΥǡ */
	TC		yomi[YOMI_LEN+1]; /* ֤ߡפΰɤ߹ΰ */
	TC		ch;
	W		err;

	/* Ͽǡνޤ */
	while ( (ch = read_field(yomi, YOMI_LEN)) != 0xffff ) {

		/* ǡ꡼   */
		if ( (data = alloc_adr_data()) == NULL ) return ER_NOMEM;

		/* ǡɤ߹ */
		tc_strcpy(data->yomi, yomi);
		(void) ( ch == TC_TAB
		 && (ch = read_field(data->yubin, YUBIN_LEN)) == TC_TAB
		 && (ch = read_field(data->addr1, ADDR1_LEN)) == TC_TAB
		 && (ch = read_field(data->addr2, ADDR2_LEN)) == TC_TAB
		 && (ch = read_field(data->addr3, ADDR3_LEN)) == TC_TAB
		 && (ch = read_field(data->name,  NAME_LEN )) == TC_TAB
		 && (ch = read_field(data->tel,   TEL_LEN  )) == TC_TAB
		 && (ch = read_field(data->fax,   FAX_LEN  )) == TC_TAB
		 && (ch = read_field(data->memo1, MEMO1_LEN)) == TC_TAB
		 && (ch = read_field(data->memo2, MEMO2_LEN)) == TC_NL
		);

		if ( ch == TC_TAB ) {
			/* ̵ǡɤФ */
			while ( (ch = read_field(yomi, YOMI_LEN)) == TC_TAB );

			illegal = TRUE; /* ̵ǡ */
		}

		/* ̿Ȥ˥ǡϿ */
		if ( (err = insert_adr(data)) < E_OK ) return err;

		if ( ch == 0xffff ) break; /* Ͽǡ */
	}

	return rerror(tg_fp);
}

/*
 * ǡɤ߽Ф
 */
/* LOCAL */
	W	load_cal()
{
	TC		str[DATE_LEN * 2];	/* (ʸ) */
	CAL_HOLIDAY	*hp;
	TC		ch;
	W		n = 0;

	/* ꡼ */
	hp = (CAL_HOLIDAY*)malloc(lsizeof(CAL_HOLIDAY)*MAX_HOLIDAY);
	if ( hp == NULL ) return ER_NOMEM;
	holiday = hp;

	/* ǡνޤ */
	while ( (ch = read_field(str, DATE_LEN * 2)) != 0xffff ) {

		if ( n >= MAX_HOLIDAY ) {
			/* 򥪡С */
			illegal = TRUE;
			continue;
		}

		/*  */
		if ( !set_holiday(hp, str) ) {
			illegal = TRUE;	/* ̵ǡ */
			continue;
		}

		hp++; n++;

		if ( ch == TC_TAB ) {
			/* ̵ǡɤФ */
			while ((ch = read_field(str, DATE_LEN * 2)) == TC_TAB);

			illegal = TRUE; /* ̵ǡ */
		}
		if ( ch == 0xffff ) break; /* ǡ */
	}

	if ( n > 0 ) {
		/* ݤ꡼ΥĴ */
		hp = (CAL_HOLIDAY*)realloc(holiday, lsizeof(CAL_HOLIDAY)*n);
		if ( hp == NULL ) return ER_NOMEM;
	} else {
		/* ǡĤʤ */
		free(holiday);
		hp = NULL;
	}
	holiday = hp;
	nholiday = n;

	return rerror(tg_fp);
}

/*
 * ¿Ȥɤ߽Фơ̿Ȥۤ
 */
EXPORT	W	sc_load()
{
	W		err;

	nosupport = illegal = FALSE;
	textvres = DISPLAY_RESOLUTION;

	/* ̿Ȥν */
	sch_data = cur_sch = NULL;
	adr_data = cur_adr = NULL;
	cur_adr_ofs = 0;
	holiday = NULL;
	nholiday = 0;

	/* Ƭ쥳ɤذư */
	if ( (err = rrewind(tg_fp)) < E_OK ) return err;
	if ( reof(tg_fp) ) goto load_ok;

	/* ǽΥֽ񼰥ȤޤɤФ */
	if ( (err = skip_first()) < E_OK ) {
		return err;
	}
	if ( reof(tg_fp) ) goto load_ok;

	/* ͽɽǡɤ߽Ф */
	err = load_sch();
	if ( err < E_OK ) return err;

	/* Ͽǡɤ߽Ф */
	err = load_adr();
	if ( err < E_OK ) return err;

	/* ǡɤ߽Ф */
	err = load_cal();
	if ( err < E_OK ) return err;

	/* ե뽪üޤɤФ */
	if ( (err = skip_to_eof()) < E_OK ) return err;

load_ok:
	/* ƥǡν */
	if ( (err = set_cur_sch()) < E_OK ) return err;
	if ( (err = set_cur_adr()) < E_OK ) return err;

	return err;
}
