/*
	menu.c		ŻҼĢ : ˥塼

	(C) Copyright 1997-98 by Personal Media Corporation
*/
#include "sched.h"

/* ¹ */
LOCAL	W	exec_prog(int vid,int item)
{
	setpointer(PS_BUSY, NULL);
	if (oexe_apg (vid, item) > 0) setpointer(0x8001, NULL);
					/* ݥ󥿥å */
	return 0;
}

/*
 * ʪ
 */
LOCAL	W	mn_tool(W para)
{
	return exec_prog( 0, para );
}

/*
 * λ
 */
LOCAL	W	mn_exit(W para)
/* ˣ */
{
	if ( sc_exit(0) ) {
		return 1; /* 䵤򹹿ƽλ */
	} else {
		return 0; /* λ */
	}
}

/*
 * ¸
 *	param = 0 : ¿Ȥ¸
 *		1 : μ¿Ȥ¸
 */
LOCAL	W	mn_save(W para)
{
	save_file( ( para == 0 )? 0x01: 0x0e );
	return 0;
}

/*
 * 祦ɥΥץ
 */
EXPORT	W	main_win_open(W ix)
{
	W	err;

	if (win[SRC_WIN].id >= 0) {
		set_window_rect(SRC_WIN);
		close_win(SRC_WIN, 0);
	}
	if ((err = (*main_open[ix])(NULL, 1)) >= E_OK) {
		in_act_parts = sched_fusen.win_top = ix;
	}
	return err;
}

/*
 * ɽ
 *	param = 1 : ɽ
 *		2 : ͽɽɽ
 *		4 : Ͽɽ
 */
LOCAL	W	mn_view(W para)
{
	W	sw = sched_fusen.win_sw;
	W	err = E_OK;

	/* Ƥμ祦ɥĤ뤳ȤԲ */
	if ( DISP_MAIN(sw ^= para) == 0 ) return 0;

	switch ( para ) {
	  case BIT_MASK(CAL_WIN): /* ɥ */
		if ( (sw & BIT_MASK(CAL_WIN)) != 0 ) {
			err = main_win_open(CAL_WIN);
		} else {
			close_win(CAL_WIN, 0);
		}
		break;
	  case BIT_MASK(SCH_WIN): /* ͽɽɥ */
		if ( (sw & BIT_MASK(SCH_WIN)) != 0 ) {
			err = main_win_open(SCH_WIN);
		} else {
			close_win(SCH_WIN, 0);
		}
		break;
	  case BIT_MASK(ADR_WIN): /* Ͽɥ */
		if ( (sw & BIT_MASK(ADR_WIN)) != 0 ) {
			err = main_win_open(ADR_WIN);
		} else {
			close_win(ADR_WIN, 0);
		}
		break;
	  case BIT_MASK(SRC_WIN): /* ɥ */
		if ( (sw & BIT_MASK(SRC_WIN)) != 0 ) {
			if ((err = src_open()) >= E_OK) in_act_parts = SRC_WIN;
		} else {
			close_win(SRC_WIN, 0);
			in_act_parts = sched_fusen.win_top;
		}
		break;
	}
	if ((para != BIT_MASK (SRC_WIN))
	    && sw & BIT_MASK(SRC_WIN)) {
		if (src_open() < E_OK) {
			sw ^= BIT_MASK(SRC_WIN);
		}
	}
	if (err < E_OK) {
		errpanel (ER_WIND_NOE, err);
	} else {
		sched_fusen.win_sw = sw;
	}
	return 0;
}

/*
 * ȥ졼ʣ̡ư
 *	param = 0 : ȥ졼ʣ
 *		1 : ȥ졼ذư
 */
LOCAL	W	mn_cut(W para)
{
	W	ix, er;

	if ((ix = in_act_parts) < 0 || ix == CAL_WIN) return 0;

	if ((er = text_to_tray(ix, para)) < E_OK) errpanel(ER_CUT, er);

	return 0;
}

/*
 * ȥ졼ʣ̡ư
 *	param = 0 : ȥ졼ʣ
 *		1 : ȥ졼ư
 */
LOCAL	W	mn_paste(W para)
{
	W	ix, er;

	if ((ix = in_act_parts) < 0 || ix == CAL_WIN) return 0;

	if ((er = text_from_tray(ix, 0, (PNT){0x8000, 0x8000})) <= E_OK) {
		/* er==0 ξϡʸǡʤ */
		errpanel(ER_PASTE, (er == 0) ? -10001 : er);
	} else {
		/* if (nosupport) panel(PNL_NOSPTT); */
		if (para) tdel_dat();		/* ȥ졼κ */
	}

	return 0;
}

/*
 * 
 */
LOCAL	W	mn_delete(W para)
/* ˣ */
{
	W	ix, pno;
	W	pid;
	TC	buf[TBUFLEN];

	if ((ix = in_act_parts) < 0 || ix == CAL_WIN) return 0;

	pid = wpinfo[ix].pid[ (pno = wpinfo[ix].tbox_no) ];
	if ( tx_cut_txt(pid, TBUFLEN, buf, 1) > 0) {

		/* Ԥ줿 */
		/* ƥȥܥåƤɤߤ */
		pno -= wpinfo[ix].tbox_start;
		cget_val(pid, maxtxsz[ix][pno] + 1, (W*)tbufp[ix][pno]);

		/* ѹν */
		if (ix != SRC_WIN) {
			modified = TRUE;
		}
		if (ix == ADR_WIN && pno == 0) {
			chg_adr_yomi();
		}
	}

	return 0;
}

/*
 * Υڡ
 */
LOCAL	W	cal_page(W para)
{
	if ( (para <= 1 && IS_FIRST_MONTH(dispdate))
	  || (para > 1 && IS_LAST_MONTH(dispdate))  ) {
		return 0;
	}

	switch (para) {
	case 0:		/* ǽΥڡ */
		dispdate.year = FIRST_YEAR;
		dispdate.month = 1;
		break;
	case 1:		/* Υڡ */
		if (--dispdate.month < 1) {
			dispdate.year--;
			dispdate.month = 12;
		}
		break;
	case 2:		/* Υڡ */
		if (++dispdate.month > 12) {
			dispdate.year++;
			dispdate.month = 1;
		}
		break;
	case 3:		/* ǸΥڡ */
		dispdate.year = LAST_YEAR;
		dispdate.month = 12;
		break;
	}
	win_dispsw(CAL_WIN);
	view_window(CAL_WIN, &visrect[CAL_WIN], 1);
	return 0;
}

/*
 * ͽɽΥڡ
 */
LOCAL	W	sch_page(W para)
{
	DATE		date, prevdate;
	SCH_NODE	*tmpp;
	W		i;

	date = prevdate = selectdate;

	if ( (para <= 1 && IS_FIRST_DATE(date))
	  || (para > 1 && IS_LAST_DATE(date))  ) {
		return 0;
	}

	switch (para) {
	case 0:		/* ǽΥڡ */
		date.year = FIRST_YEAR;
		date.month = 1;
		date.day = 1;
		break;
	case 1:		/* Υڡ */
		tmpp = cur_sch->prev;
		if ( cur_sch != sch_data	/* ǽΥΡɤǤϤʤ */
		  && tmpp->year == cur_sch->year
		  && tmpp->month == cur_sch->month
		  && tmpp->day == cur_sch->day ) {
			/* ΥΡɤƱդξϡΡɤѹ */
			/* @@դΣܰʹߤΥΡɤξϡ */
			cur_sch = tmpp;
			set_curdata(SCH_WIN);
			selectdate = date;
			goto DISP;
		}
		if (--date.day < 1) {
			if (--date.month < 1) {
				date.year--;
				date.month = 12;
			}
			date.day = month_day(&date)/*get_maxdate(date)*/;
		}
		break;
	case 2:		/* Υڡ */
		tmpp = cur_sch->next;
		if ( tmpp != sch_data		/* ǸΥΡɤǤϤʤ */
		  && tmpp->year == cur_sch->year
		  && tmpp->month == cur_sch->month
		  && tmpp->day == cur_sch->day ) {
			/* ΥΡɤƱդξϡΡɤѹ */
			cur_sch = tmpp;
			set_curdata(SCH_WIN);
			selectdate = date;
			goto DISP;
		}
		if (++date.day > month_day(&date)/*get_maxdate(date)*/) {
			if (++date.month > 12) {
				date.year++;
				date.month = 1;
			}
			date.day = 1;
		}
		break;
	case 3:		/* ǸΥڡ */
		date.year = LAST_YEAR;
		date.month = 12;
		date.day = 31;
		break;
	}

	if ((i = change_date(date)) < E_OK) {
		panel(ER_MEMORY);
		return 0;
	}
DISP:
	redisp_date(prevdate, date);

	/* if (win[SRC_WIN].id > 0) pnl_dispsw(SRC_WIN, 1); */

	return 0;
}

/*
 * ϿΥڡ
 */
LOCAL	W	adr_page(W para)
{
	BOOL	chg;

	/* ڡ */
	switch ( para ) {
	  case 0:	/* ǽΥڡ */
		chg = first_adr_page();
		break;
	  case 1:	/* Υڡ */
		chg = prev_adr_page();
		break;
	  case 2:	/* Υڡ */
		chg = next_adr_page();
		break;
	  case 3:	/* ǸΥڡ */
		chg = last_adr_page();
		break;
	  default:
		chg = FALSE;
	}
	if ( chg ) {
		/* ڡڤؤäΤǡɽ */
		redisp_adr(1);
	}

	return 0;
}

/*
 * ѥͥξ
 *	˥塼ϸƤФʤѡĤư(pres_parts)ǸƤФ롣
 */
LOCAL	W	search_text(W para)
{
	SCH_NODE	*sp = cur_sch;	/* ɽΥΡ(ͽɽ) */
	DATE		date;
	W		find;

	/*  */
	setpointer(PS_BUSY, NULL); /* Τ */
	find = sc_search(sched_fusen.win_top, srcbuf, (para <= 1)? 0:1);
	setpointer(PS_SELECT, NULL); /*  */

	if ( find >= 0 ) {
		/* λĤä */

		switch ( sched_fusen.win_top ) {
		  case SCH_WIN:	/* ͽɽ */
			/* ɽƤΡɤʤ */
			if ( is_empty_sch_node(sp) ) delete_sch_node(sp);

			/* ɽ */
			date.year  = cur_sch->year;
			date.month = cur_sch->month;
			date.day   = cur_sch->day;
			set_curdata(SCH_WIN);
			redisp_date(selectdate, date);
			selectdate = date;
			goto SETWIN;
			break;

		  case ADR_WIN: /* Ͽ */
			/* ɽ */
			redisp_adr(1);
SETWIN:
			in_act_parts = sched_fusen.win_top;
			wpinfo[in_act_parts].tbox_no = find + wpinfo[in_act_parts].tbox_start;
			break;
		}
	} else {
		/* Ĥʤä */
		panel(ER_SRCH);
	}

	return 0;
}

EXPORT	FUNCP	cmd_page[MAX_WIN]/* = {cal_page, sch_page, adr_page, search_text}*/;


/*
 * ڡ
 *	param = 0 : ǽΥڡ
 *		1 : Υڡ
 *		2 : Υڡ
 *		3 : ǸΥڡ
 */
LOCAL	W	mn_page(W para)
{
	return (*cmd_page[sched_fusen.win_top])(para);
}

/*
 * ڡɲ(ϿΤ)
 */
LOCAL	W	mn_newadr(W para)
/* ˣ */
{
	W		err;

	if ( sched_fusen.win_top == ADR_WIN ) {
		/* Ͽɲ */
		if ( (err = set_new_adr()) >= E_OK ) {
			/* ɽ */
			redisp_adr(1);
		} else {
			/* 顼ѥͥɽ */
			errpanel(ER_REGIST, err);
		}
	}

	return 0;
}

/*
 * ڡ(ϿΤ)
 */
LOCAL	W	mn_delpage(W para)
/* ˣ */
{
	if (sched_fusen.win_top == ADR_WIN) {
		/* γǧ */
		if ( panel(PNL_DELADR) == 1 ) {
			/* Ͽκ */
			delete_adr_data();
			/* ɽ */
			redisp_adr(1);
		}
	}
	return 0;
}

/*
 * ˤ(ͽɽΤ)
 */
LOCAL	W	mn_clrpage(W para)
/* ˣ */
{
	if ( sched_fusen.win_top == SCH_WIN ) {
		/* γǧ */
		if ( panel(PNL_CLRSCH) == 1 ) {
			/* ͽɽȥǡ򥯥ꥢ */
			if ( !is_empty_sch_node(cur_sch) && clear_sch() ) {
				/* ɽ */
				set_textbox(SCH_WIN, 0);
				modified = TRUE; /* Խ줿 */
			}
		}
	}
	return 0;
}

/*
 * ѻ
 */
LOCAL	W	mn_prform(W para)
/* ˣ */
{
	if (changeform(0)) {
		modified = TRUE;
	}
	return 0;
}

/*
 * 
 */
LOCAL	W	mn_print(W para)
/* ˣ */
{
	return sc_print(0);
}

/*
 * ˥塼ؿ
 *	(ֹǴؿ򤵤)
 */
LOCAL	FUNCP	menu_func[] = {
	NULL,		/*      */
	NULL, /*mn_tool,*/	/*     ʪ */
	NULL,		/*     ¹ */
	NULL, /*mn_exit,*/	/*  0: λ */
	NULL, /*mn_save,*/	/*  1: ¸ */
	NULL, /*mn_view,*/	/*  2: ɽ */
	NULL, /*mn_cut,	*/	/*  3: ȥ졼ʣ̡ư */
	NULL, /*mn_paste,*/	/*  4: ȥ졼ʣ̡ư */
	NULL, /*mn_delete,*/	/*  5:  */
	NULL, /*mn_page,*/	/*  6: ڡ(Ƭء) */
	NULL, /*mn_page,*/	/*  7: ڡ(Ǹء) */
	NULL, /*mn_newadr,*/	/*  8: ڡɲ */
	NULL, /*mn_delpage,*/	/*  9: ڡ */
	NULL, /*mn_clrpage,*/	/* 10: ˤ */
	NULL, /*mn_prform,*/	/* 11: ѻ */
	NULL, /*mn_print*/	/* 12:  */
};

/* ֹ */
#define	MN_EXIT		0	/* λ */
#define	MN_SAVE		1	/* [¸] */
#define	MN_VIEW		2	/* [ɽ] */
#define	MN_CUT		3	/* [Խ][ȥ졼ʣ][ȥ졼ذư] */
#define	MN_PASTE	4	/* [Խ][ȥ졼ʣ][ȥ졼ư] */
#define	MN_DEL		5	/* [Խ][] */
#define	MN_PAGEB	6	/* [ڡ][ƬΥڡ][Υڡ] */
#define	MN_PAGEF	7	/* [ڡ][Υڡ][ǸΥڡ] */
#define	MN_PADD		8	/* [ڡ][ڡɲ] */
#define	MN_PDEL		9	/* [ڡ][ڡ] */
#define	MN_PCLR		10	/* [ڡ][ˤ] */
#define	MN_FORM		11	/* [][ѻ] */
#define	MN_PRINT	12	/* [][] */

/* ǽܥޥ */
#define	BM(n)	((UW)(1L<<n))

/*
 * ǽܤ
 */
LOCAL	UW	set_inact(void)
{
	UW	inact;
	W	ix, pid;
	BOOL	disable[2];
	TC	buf[TBUFLEN];

	switch (sched_fusen.win_top) {
	case CAL_WIN:
		/* ڡɲá */
		inact = BM(MN_PRINT)|BM(MN_PADD)|BM(MN_PDEL)|BM(MN_PCLR);
		break;
	case SCH_WIN:
		/* ڡɲá */
		inact = BM(MN_PADD)|BM(MN_PDEL);
		break;
	case ADR_WIN: default:
		/*  */
		inact = BM(MN_PCLR);
		break;
	}

	/* ڡ᤯ */
	chk_page_change(sched_fusen.win_top, disable);
	if (disable[0]) inact |= BM(MN_PAGEB);
	if (disable[1]) inact |= BM(MN_PAGEF);

	/* ȥ졼ط */
	if ((ix = in_act_parts) < 0 || ix == CAL_WIN) {

		inact |= ( BM(MN_CUT) | BM(MN_PASTE) | BM(MN_DEL) );

	} else {
		/* ȥ졼ΰưʣ */
		if (tget_sts((UW*)NULL, (UW*)NULL) <= 0) {
			/* ȥ졼 */
			inact |= BM(MN_PASTE);
		}

		/* ȥ졼ؤΰưʣ̡ */
		pid = wpinfo[ix].pid[ wpinfo[ix].tbox_no ];
		if ( tx_cut_txt(pid, TBUFLEN, buf, 0) <= 0) {

			inact |= ( BM(MN_CUT) | BM(MN_DEL) );
		}
	}

	return inact;
}

/*
 * ᥤ˥塼
 */
EXPORT	W	sc_menufn(void)
{
	W		ret;

	/* [ɽ]Υ󥸥 */
	indmenu(MN_VIEW, sched_fusen.win_sw, 2);	/* ɽ */

	/* ǽ */
	inactmenu(set_inact(), 0);

	/* ˥塼ϥɥ */
	ret = selmenu(-1, menu_func);

	return ret;
}

EXPORT	VOID	init_menu(void)
{

	cmd_page[0] = cal_page;
	cmd_page[1] = sch_page;
	cmd_page[2] = adr_page;
	cmd_page[3] = search_text;

	menu_func[1] = mn_tool;
	menu_func[3] = mn_exit;
	menu_func[4] = mn_save;
	menu_func[5] = mn_view;
	menu_func[6] = mn_cut;
	menu_func[7] = mn_paste;
	menu_func[8] = mn_delete;
	menu_func[9] = mn_page;
	menu_func[10] = mn_page;
	menu_func[11] = mn_newadr;
	menu_func[12] = mn_delpage;
	menu_func[13] = mn_clrpage;
	menu_func[14] = mn_prform;
	menu_func[15] = mn_print;

	return;
}
