/*
	save.c		ŻҼĢ : ե¸

	(C) Copyright 1997-99 by Personal Media Corporation
*/

#include "sched.h"
#include <tlang.h>
#include <mtstring.h>

LOCAL	struct {	/* 󥻥 */
	TC		id;
	UH		len;
	SEG_INFO	s;
} info_seg = {
	TS_INFO|0xff00, 6, {0, 2, {TAD_VERSION}}
};
#define	INFO_SEG_STRUCT	"hhhhh"

LOCAL	struct {	/* ʸϳϥ */
	TC		id;
	UH		len;
	SEG_TEXT	tx;
} text_seg = {
	TS_TEXT|0xff00, 24,
	{{{0,0,0,0}}, {{0,0,0,0}}, DISPLAY_RESOLUTION, DISPLAY_RESOLUTION,
	 TAD_LANG_JAPANESE, 0}
};
#define	TEXT_SEG_STRUCT	"hhhhhhhhhhhhhh"

LOCAL	struct {	/* ʸϽλ */
	TC		id;
	UH		len;
} textend_seg = {
	TS_TEXTEND|0xff00, 0
};
#define	TEXTEND_SEG_STRUCT	"hh"

LOCAL	struct {	/* ֽ񼰥 */
	TC		id;
	UH		len;
	SEG_TAB		tx;
} tab_seg = {
	TS_TRULER|0xff00, 14,
	{0, 2,
	 DEF_PGAP, DEF_PGAP, DEF_LM, DEF_RM, DEF_IM, 0}
};
#define	TAB_SEG_STRUCT	"hhbbhhhhhh"

/*
 * ֽ񼰥Ȥν񤭽Ф
 */
LOCAL
	W	put_tabseg(void)
{
	W	ret;

	ConvEndianStruct((B*)&tab_seg, (B*)&tab_seg, TAB_SEG_STRUCT, sizeof(tab_seg));
	ret = rputseg((B*)&tab_seg, tg_fp);
	ConvEndianStruct((B*)&tab_seg, (B*)&tab_seg, TAB_SEG_STRUCT, sizeof(tab_seg));
	return ret;
}

/* ƥॹץȥɤν񤭽Ф */
LOCAL void
put_sys_script (RFILE* file)
{
	rputc (ConvEndianH (TSC_SYS|0xFE00), file);
}

/*
 * ͽɽǡ񤭽Ф
 */
/*LOCAL*/
	W	save_sch(void)
{
	DATE		date;			/* ͽ() */
	TC		str[DATE_LEN+1];	/* ͽ(ʸ) */
	TC		buf[SCH_LEN+1];
	SCH_NODE	*np;
	W		i;
	W length;
	W lang;

	put_tabseg(); /* ֽ񼰥Ƚ񤭽Ф */

	if ( (np = sch_data) == NULL ) return E_OK; /* ǡʤ */

	do {
		/* դʸѴ */
		date.year  = np->year;
		date.month = np->month;
		date.day   = np->day;
		date_to_str(str, &date);
		ConvEndianHs(str, str, DATE_LEN+1);

		for ( i = 0; i < MAX_SCH; ++i ) {
			if ( *(np->data[i]) == TNULL ) continue;

			/* ͽɽǡ񤭽Ф */

			length = mtc_unique (buf, np->data [i], sizeof (buf)/sizeof (buf [0]) - 1);
			if (length == 0) {
				continue;
			}
			buf [length] = TNULL;
			lang = mtc_poslang (buf, buf + length - 1);
			rputs((B*)str, tg_fp);
			rputc(ConvEndianH(TC_TAB), tg_fp);
			ConvEndianHs(buf, buf, SCH_LEN+1);
			rputs((B*)buf, tg_fp);
			if (lang > 0 && lang != TSC_SYS) {
				/* ƥॹץȰʳǽλƤʸ */
				put_sys_script (tg_fp);
			}
			rputc(ConvEndianH(TC_NL), tg_fp);
		}

	} while ( !rerror(tg_fp) && (np = np->next) != sch_data );

	return rerror(tg_fp);
}

LOCAL
	VOID	swap_puts(TC *str)
{
	TC	buf[1024];
	W length;
	W lang;

	length = mtc_unique (buf, str, sizeof (buf) / sizeof (buf [0]) - 1);
	if (length == 0) {
		return;
	}
	buf [length] = TNULL;
	lang = mtc_poslang (buf, buf + length - 1);
	ConvEndianHs(buf, buf, sizeof (buf));
	rputs((B*)buf, tg_fp);
	if (lang > 0 && lang != TSC_SYS) {
		/* ƥॹץȰʳǽλƤʸ */
		put_sys_script (tg_fp);
	}
}

/*
 * Ͽǡ񤭽Ф
 */
/*LOCAL*/
	W	save_adr(void)
{
	ADR_NODE	*np;
	ADR_DATA	*data;		/* ꣱ʬΥǡ */
	W		i;

	put_tabseg(); /* ֽ񼰥Ƚ񤭽Ф */

	if ( (np = adr_data) == NULL ) return E_OK; /* ǡʤ */

	do {
		for ( i = 0; i < MAX_ADR; ++i ) {
			if ( (data = np->data[i]) == NULL ) continue;

			/* Ͽǡν񤭽Ф */
			swap_puts(data->yomi);	rputc(ConvEndianH(TC_TAB), tg_fp);
			swap_puts(data->yubin); rputc(ConvEndianH(TC_TAB), tg_fp);
			swap_puts(data->addr1); rputc(ConvEndianH(TC_TAB), tg_fp);
			swap_puts(data->addr2); rputc(ConvEndianH(TC_TAB), tg_fp);
			swap_puts(data->addr3); rputc(ConvEndianH(TC_TAB), tg_fp);
			swap_puts(data->name);	rputc(ConvEndianH(TC_TAB), tg_fp);
			swap_puts(data->tel);	rputc(ConvEndianH(TC_TAB), tg_fp);
			swap_puts(data->fax);	rputc(ConvEndianH(TC_TAB), tg_fp);
			swap_puts(data->memo1); rputc(ConvEndianH(TC_TAB), tg_fp);
			swap_puts(data->memo2); rputc(ConvEndianH(TC_NL),  tg_fp);
		}

	} while ( !rerror(tg_fp) && (np = np->next) != adr_data );

	return rerror(tg_fp);
}

/*
 * ǡ񤭽Ф
 */
/*LOCAL*/
	W	save_cal(void)
{
	CAL_HOLIDAY	*hp;
	W		n;
	TC		str[DATE_LEN * 2];	/* (ʸ) */

	put_tabseg(); /* ֽ񼰥Ƚ񤭽Ф */

	if ( (hp = holiday) == NULL ) return E_OK; /* ǡʤ */

	for ( n = nholiday; n > 0; --n, ++hp ) {

		/* ʸѴ */
		cal_to_str(str, hp);

		/* ǡ񤭽Ф */
		ConvEndianHs(str, str, DATE_LEN * 2);
		rputs((B*)str, tg_fp);
		rputc(ConvEndianH(TC_NL), tg_fp);

		if ( rerror(tg_fp) ) break;
	}

	return rerror(tg_fp);
}

/*
 * ֥å񤭽Ф
 */
/*LOCAL*/
	W	write_tg_fp(B *buf,W size)
{
	W	s = 0;

	/* rwrite() ϡ٤ 32KB ޤǤ񤭽ФʤΤǡ
	   32KB ʲʬ䤷ƽ񤭽Ф */
	while ( (size -= (W)s) > 0L ) {
		s = ( size > 0x7ff0L )? 0x7ff0: (W)size;
		if ( rwrite(buf, s, 1, tg_fp) != s ) break;
		buf += s;
	}
	return rerror(tg_fp);
}

/*
 * إåν񤭽Ф
 */
/*LOCAL*/
	W	put_header(void)
{
	/* 󥻥Ȥν񤭽Ф */
	ConvEndianStruct((B*)&info_seg, (B*)&info_seg, INFO_SEG_STRUCT, sizeof(info_seg));
	rputseg((B*)&info_seg, tg_fp);
	ConvEndianStruct((B*)&info_seg, (B*)&info_seg, INFO_SEG_STRUCT, sizeof(info_seg));

	/* ʸϳϥȤν񤭽Ф */
	ConvEndianStruct((B*)&text_seg, (B*)&text_seg, TEXT_SEG_STRUCT, sizeof(text_seg));
	rputseg((B*)&text_seg, tg_fp);
	ConvEndianStruct((B*)&text_seg, (B*)&text_seg, TEXT_SEG_STRUCT, sizeof(text_seg));

	/* ѻϢ䵤ν񤭽Ф */
	saveform(write_tg_fp, 1);

	return rerror(tg_fp);
}

/*
 * ȥ졼顼ν񤭽Ф
 */
/*LOCAL*/
	W	put_trailer(void)
{
	/* ֽ񼰥Ȥν񤭽Ф */
	put_tabseg();

	/* ʸϽλȤν񤭽Ф */
	ConvEndianStruct((B*)&textend_seg, (B*)&textend_seg, TEXTEND_SEG_STRUCT, sizeof(textend_seg));
	rputseg((B*)&textend_seg, tg_fp);
	ConvEndianStruct((B*)&textend_seg, (B*)&textend_seg, TEXTEND_SEG_STRUCT, sizeof(textend_seg));

	return rerror(tg_fp);
}

/*
 * 񤭹ߥ쥳ɤκ  Υ쥳ɤؤΰդ
 */
/*LOCAL*/
	W	creat_rec(void)
{
	W	err;

	/* ƬΥǡ쥳ɤذư */
	if ( (err = rrewind(tg_fp)) < E_OK ) return err;
	if ( reof(tg_fp) ) {

		/* ǡ쥳ɤ¸ߤʤ
		   եκǸ˥ǡ쥳ɤɲ */
		err = apd_rec(rfileno(tg_fp), NULL, 0L, RT_TADDATA, 0, 0);
		if ( err < E_OK ) return err;
	} else {

		/* ǡ쥳ɤ */
		err = ins_rec(rfileno(tg_fp), NULL, 0L, RT_TADDATA, 0, 0);
		if ( err < E_OK ) return err;
	}

	/* 񤭹ߥ쥳(Ƭ쥳)ذդ */
	return rrewind(tg_fp);
}

/*
 * ǡ쥳ɤκ
 */
/*LOCAL*/
	W	del_old_rec(void)
{
	W	err;
	W	fd = rfileno(tg_fp);

	/* ߥ쥳ɤ¸ǡʤΤǡ
	   Υ쥳ɰʹߤΥǡ쥳ɤ */

	if ( (err = see_rec(fd, 1L, 0, NULL)) < E_OK ) return err;

	while ( (err = fnd_rec(fd, F_FWD, RM_TADDATA, 0, NULL)) >= E_OK ) {
		if ( del_rec(fd) < E_OK ) see_rec(fd, 1L, 0, NULL);
	}

	/* ǥ顼ƤǤʤΤǡｪλȤ */
	return E_OK;
}

/*
 * ¿Ȥ¸
 */
/*LOCAL*/
	W	sc_save(void)
{
	W		err;
	W		newrec;		/* ¸ѥ쥳ɤֹ */

	/* 񤭹쥳ɤκ */
	if ( (err = creat_rec()) < E_OK ) return err;
	newrec = rrecordno(tg_fp);

	/* إåν񤭽Ф */
	if ( (err = put_header()) < E_OK ) goto err_exit;

	/* ͽɽǡ񤭽Ф */
	if ( (err = save_sch()) < E_OK ) goto err_exit;

	/* Ͽǡ񤭽Ф */
	if ( (err = save_adr()) < E_OK ) goto err_exit;

	/* ǡ񤭽Ф */
	if ( (err = save_cal()) < E_OK ) goto err_exit;

	/* ȥ졼顼ν񤭽Ф */
	if ( (err = put_trailer()) < E_OK ) goto err_exit;

	/* 񤭹ߥХåեեå */
	if ( (err = rflush(tg_fp)) < E_OK ) goto err_exit;

	/* ǡ쥳ɤκ */
	if ( (err = del_old_rec()) < E_OK ) goto err_exit;

	return err;

err_exit:
	/* 񤭹ǡ쥳ɤ */
	if ( see_rec(rfileno(tg_fp), newrec, 1, NULL) >= E_OK ) {
		del_rec(rfileno(tg_fp));
	}

	return err;
}

/*
 * ¸եѹǧ
 *	ե뤬¾Υץˤäƽ񤭴Ƥʤǧ
 */
/*LOCAL*/
	W	change_ok(void)
{
	F_STATE		sts;
	W		err;

	/* ե륹ơμФ */
	err = ofl_sts(rfileno(tg_fp), NULL, &sts, NULL);
	if ( err < E_OK ) return err;

	if ( tg_sts.f_mtime == sts.f_mtime ) return E_OK; /* OK */

	/* Ƥ¾ΥץꥱˤѹƤޤ
	   ѹ¾ѹƤѴޤ褤Ǥ */
	if ( panel(PNL_CUPD) <= 0 ) return 1; /*  */
	return E_OK; /* OK */
}

/*
 * ¸եΥץ
 */
/*LOCAL*/
	W	open_upfile(void)
{
	W	fd;

	fd = oopn_obj(mycmd->vid, NULL, F_UPDATE|F_EXCL, NULL);
	if ( fd < E_OK ) return fd;

	tg_fp = rfdopen(fd, (UW)RM_TADDATA, F_UPDATE|F_EXCL);
	return ropen_err;
}

/*
 * եΥץ
 */
/*LOCAL*/
	W	open_newfile(void)
{
	W	fd;
	TC	fname[20+1];

	fname[0] = TNULL;
	setpointer(PS_BUSY, NULL);

	/* ե̾ϥѥͥɽڤӿեΥץ */
	if ( (fd = ocre_obj(mycmd->vid, fname, NULL, NULL, 1)) < E_OK ) {
		setpointer(PS_SELECT, NULL);
		if ( fd == EX_PAR ) return 1; /* եä */
		errpanel(ER_WRITE, fd);
		return fd;
	}

	tg_fp = rfdopen(fd, (UW)RM_TADDATA, F_UPDATE);
	return ropen_err;
}

/*
 * λ¸ ν
 *	mode	bit 0	¸եؤιῷեؤ¸
 *		bit 1	񤭹߳ǧѥͥɽ ʤᤢ
 *		bit 2	¸եѹǧ ʤᤢ
 *		bit 3	񤭹߶ػ߻γǧѥͥɽ ʤᤢ
 *	retuen	E_OK	ｪλ
 *		1	񤭹߼
 *		< E_OK	顼 (顼ơ)
 */
EXPORT	W	save_file( W mode)
{
	W	err, cls_err;

	/* ե륷ƥ³
	 * ¿ȤΤե륷ƥबڤΥƤޤäƤˤϡ
	 * ³Ԥ(FD ʤɤ)
	 */
	if ( (err = oatt_vob(mycmd->vid, 0)) < E_OK ) return err;
	if ( err == 0 ) return 1; /*  */

	if ( (mode & 1) == 0 ) {
		/* 񤭹߳ǧ¸եϽ񤭹߲ǽ */
		if ( chk_fil(&mycmd->lnk, F_WRITE, NULL) < E_OK ) {
			/* 񤭹ߤػߤƤ
			   ե¸ޤ */
			if ( (mode & 8) == 0 || panel(PNL_ERSAVE) <= 0 )
							return 1; /*  */
			mode |= 1; /* ե¸ */
		} else {
			/* Ƥ˴ƹޤ */
			if ( (mode & 2) != 0 && panel(PNL_UPDATE) <= 0 )
							return 1; /*  */
		}
	}

	/* ¸եΥץ */
	err = ( (mode & 1) == 0 )? open_upfile(): open_newfile();
	if ( err != E_OK ) return err;

	if ( (mode & 5) == 4 ) {
		/* ¸եѹǧ */
		if ( (err = change_ok()) != E_OK ) {
			rclose(tg_fp);
			return err;
		}
	}

	/* 񤭹 */
	sysmsg(MSG_SAVE);	/* ֽ񤭹Ǥ... */
	if ( (err = sc_save()) >= E_OK ) {
		if ( (mode & 1) == 0 ) {
			/* ¸ե¸եι */
			err = ofl_sts(rfileno(tg_fp), NULL, &tg_sts, NULL);

			modified = FALSE; /* Խ֤ѹʤ */
			tg_update = 1; /* ¿Ȥѹ줿 */
		}
	}
	cls_err = rclose(tg_fp);
	if(err >= 0 && cls_err < 0) err = cls_err; /* !@ 980728 */
	sysmsg(0);
	if ( err < E_OK ) errpanel(ER_WRITE, err);

	return ( err > E_OK )? E_OK: err;
}

/*
 * λ
 *	mode	̾ｪλ (ǧѥͥɽ)
 *		λ (ǧѥͥɽˡ¸ƽλ)
 *	return	TRUE λϣ
 *		FALSEλ
 */
EXPORT	BOOL	sc_exit(W mode)
{
	F_STATE		sts;
	BOOL		update;
	W		upmode;
	W		pnl;
	W		n;

	update = modified; /* ԽƤ뤫 */
	upmode = 0x0c;
	pnl    = PNL_CLOSE;

	if ( !update && (mode & 1) == 0 ) {
		/* ե뤬ѹƤ뤫ǧ */
		if ( fil_sts(&mycmd->lnk, NULL, &sts, NULL) >= E_OK ) {
			update = ( tg_sts.f_mtime != sts.f_mtime );
			upmode = 0x08;
			pnl = PNL_CHK; /* ߤƤǺٹޤ */
		}
	}
	if ( !update ) return TRUE; /* ¸סλ */

	do {
		if ( (mode & 1) == 0 ) {
			/* λǧѥͥ */
			n = panel(pnl);
			if ( n <= 0 ) return FALSE; /* λ */
			if ( n == 1 ) return TRUE;  /* ˴ƽλ */
		}

		/* ¸ */
		n = save_file(upmode);

		if ( (mode & 1) != 0 ) return TRUE; /* λ */

		/* ¸Ǥʤäˡٽλѥͥɽ */
		pnl = PNL_XCLOSE;

	} while ( n < E_OK ); /* ϥ顼顢⤦ */

	if ( n > 0 ) return FALSE; /* λ */
	return TRUE; /* ¸λ */
}
