/*
	sch.c		ŻҼĢ : ͽɽǡδ

	(C) Copyright 1997-98 by Personal Media Corporation
*/
#include "sched.h"

/*
 * 
 *	node դΤۤä ( node > date )   
 *	Ʊդä		( node = date )   
 *	node դΤۤŤä	( node < date ) 
 */
LOCAL	W	cmp_sch_date( SCH_NODE *node, DATE *date)
{
	if ( node->year  > date->year  ) return  1;
	if ( node->year  < date->year  ) return -1;

	if ( node->month > date->month ) return  1;
	if ( node->month < date->month ) return -1;

	if ( node->day	 > date->day   ) return  1;
	if ( node->day	 < date->day   ) return -1;

	return 0;
}

/*
 * Ρɤɲ
 *	np ΥΡɤ˥Ρɤɲä
 *	prev - np  prev - new - np Τ褦ɲä
 *	np == NULL λˤϡǸΥΡɤȤϿ
 *	ΡɤΥɥ쥹֤
 *	顼ΤȤ NULL ֤
 */
LOCAL	SCH_NODE*	add_sch_node( SCH_NODE *np,DATE *date)
{
	SCH_NODE	*new;

	/* ꡼ */
	if ( (new = alloc_sch_node()) == NULL ) return NULL;

	/*  */
	new->year  = date->year;
	new->month = date->month;
	new->day   = date->day;

	if ( sch_data == NULL ) {
		/* 롼Ȥ˥ */
		new->next = new;
		new->prev = new;
		sch_data  = new;
	} else {
		/* 󥯤Ƭؤ³ʤ顢sch_data 򿷤Ρɤ */
		if ( sch_data == np ) sch_data = new;

		if ( np == NULL ) np = sch_data; /* Ǹ³ */

		/* Ρɤ */
		(np->prev)->next = new;
		new->prev	 = np->prev;
		new->next	 = np;
		np->prev	 = new;
	}

	return new;
}

/*
 * Ρɤ˥ǡɲ
 *	ɲäǤ TRUE ֤
 *	եɤʤ FALSE ֤
 */
LOCAL	BOOL	add_sch_field( SCH_NODE *np,TC *str)
{
	W		i;

	for ( i = 0; i < MAX_SCH; ++i ) {
		if ( *(np->data[i]) == TNULL ) {

			/* ǡϿ */
			tc_strcpy(np->data[i], str);
			return TRUE;
		}
	}
	return FALSE;
}

/*
 * ǡϿ
 */
EXPORT	W	insert_sch(DATE *date,TC *str)
/* ͽ */
/* ͽ */
{
	SCH_NODE	*np;
	W		i;

	if ( sch_data == NULL ) {
		/* ޤĤΡɤʤΤǡ˥Ρɤɲä */
		if ( add_sch_node(NULL, date) == NULL ) return ER_NOMEM;
	}

	np = sch_data;
	do {
		if ( (i = cmp_sch_date(np, date)) < 0 ) continue;

		if ( i > 0 ) {	/* date 꿷Ρ */
			/* Ρɤɲ */
			np = add_sch_node(np, date);
			if ( np == NULL ) return ER_NOMEM;
		}

		/* եɤϿ */
		if ( add_sch_field(np, str) ) return E_OK;
#if 1		/* MAX_SCH ĶǡϿʤ */
		else return 1; /* ǡĶ */
#endif

	} while ( (np = np->next) != sch_data );

	/* date ƱΥΡɤ⡢date 꿷ΥΡɤʤ */
	/* 󥯤κǸ˿Ρɤɲ */
	if ( (np = add_sch_node(NULL, date)) == NULL ) return ER_NOMEM;

	/* եɤϿ */
	add_sch_field(np, str);

	return E_OK;
}

/*
 * ͽޤΡɤ򥫥ȤȤꤹ
 */
EXPORT	W	set_cur_sch(void)
{

	/* get_today_date(&todaydate); դϡmain.c  */

	return get_sch_node(&todaydate, &cur_sch);
}

/*
 * ǡꥢ
 *	֤߰Υǡ򣱥Ρʬꥢ
 */
EXPORT	BOOL	clear_sch(void)
{
	W	i;

	if ( cur_sch == NULL ) return FALSE; /* ǡʤ */

	/* ǡꥢ */
	for ( i = 0; i < MAX_SCH; ++i ) {
		*(cur_sch->data[i]) = TNULL;
	}
	return TRUE;
}
