/*
	scprint.c	ŻҼĢ : 

	(C) Copyright 1997-98 by Personal Media Corporation
*/
#include "sched.h"
#include <tlang.h>

LOCAL	W		print_mode;	/* ڡڡ */

LOCAL	W		pr_size = 16;		/* ʸ */
LOCAL	W		pr_chgap = 2;		/* ʸֳ */
LOCAL	W		pr_lngap = 4;		/* ()ֳ */

LOCAL	struct {	/* 󥻥 */
	UH		id;
	UH		len;
	SEG_INFO	s;
} info_seg = {
	TS_INFO|0xff00, 6, {0, 2, {TAD_VERSION}}
};

LOCAL	struct {	/* ʸϳϥ */
	UH		id;
	UH		len;
	SEG_TEXT	tx;
} text_seg = {
	TS_TEXT|0xff00, 24,
	{{{0,0,0,0}}, {{0,0,0,0}}, DISPLAY_RESOLUTION, DISPLAY_RESOLUTION,
	 TAD_LANG_JAPANESE, 0}
};

LOCAL	struct {	/* ʸϽλ */
	UH		id;
	UH		len;
} textend_seg = {
	TS_TEXTEND|0xff00, 0
};

LOCAL	struct {	/* Դֳֻ */
	TC		id;
	UH		len;
	UH		attrsubid;
	SCALE		pitch;
} lgap_seg = {
	TS_TRULER|0xff00, 4, 0x0001, 0x0104
};

LOCAL	VOID	prs(TC *str)
{
	W	nb;

	ConvEndianHs(str, str, nb = tc_strlen(str));
	rputs((B*)str, tg_fp);
	ConvEndianHs(str, str, nb);
}

LOCAL	VOID	nl(void)
{
	static TC system_script = TC_LANG | TSC_SYS;
	rputc(ConvEndianH(system_script),  tg_fp);
	rputc(ConvEndianH(TC_NL),  tg_fp);
}
LOCAL	VOID	sp(void)
{
	rputc(ConvEndianH(TK_KSP), tg_fp);
}

/*
 * ͽɽդ񤭽Ф
 */
LOCAL	VOID	put_sch_date( SCH_NODE *np)
{
	DATE		date;		/* ͽ() */
	TC		str[14+1];	/* ͽ(ʸ) */

	/* դʸѴ */
	date.year  = np->year;
	date.month = np->month;
	date.day   = np->day;
	date_to_jstr(str, &date);

	/* ս񤭽Ф */
	prs(str);
	nl();
}

/*
 * ͽɽǡ񤭽Ф
 */
LOCAL	VOID	put_sch_data(SCH_NODE *np)
{
	W	i;
static	TC	indent[] = { TK_KSP, TK_KSP, TK_KSP, TK_KSP, 0 };

	for ( i = 0; i < MAX_SCH; ++i ) {
		if ( *(np->data[i]) == TNULL ) continue;
		/* ͽɽǡ񤭽Ф */
		prs(indent); prs(np->data[i]); nl();
	}
}

/*
 * ͽɽǡ񤭽Ф
 */
LOCAL	W	save_sch(void)
{
	SCH_NODE	*np;

	if ( (np = sch_data) == NULL ) return E_OK; /* ǡʤ */

	if (print_mode & 1) {		/* ڡ */
		do {
			/* ս񤭽Ф */
			put_sch_date( np );

			/* ǡ񤭽Ф */
			put_sch_data( np );

		} while ( !rerror(tg_fp) && (np = np->next) != sch_data );
	} else {			/* ɽΥڡ */
		/* ս񤭽Ф */
		put_sch_date(cur_sch);

		/* ǡ񤭽Ф */
		put_sch_data(cur_sch);
	}

	return rerror(tg_fp);
}

LOCAL	W	adr_per_page;	/* ڡ˽񤭽ФϿη     */
LOCAL	W	adr_cnt;	/*			      */

/*
 * Ͽǡ񤭽Ф
 */
LOCAL	VOID	put_adr_data(ADR_DATA *data)
{
	W	i;

	prs(adr_str_info[1].str); prs(data->yubin);
	for (i = YUBIN_LEN - tc_strlen(data->yubin) + 2; i > 0; i--) sp();
	prs(adr_str_info[0].str); sp();	prs(data->yomi);  nl();
	prs(adr_str_info[2].str); sp(); prs(data->addr1); nl();
	prs(adr_str_info[3].str); sp(); prs(data->addr2); nl();
	prs(adr_str_info[4].str); sp(); prs(data->addr3); nl();
	prs(adr_str_info[5].str); sp(); prs(data->name);  nl();
	prs(adr_str_info[6].str); sp(); prs(data->tel);   nl();
	prs(adr_str_info[7].str); sp(); prs(data->fax);   nl();
	prs(adr_str_info[8].str); sp(); prs(data->memo1); nl();
	prs(adr_str_info[9].str); sp(); prs(data->memo2); nl();
}

/*
 * Ͽǡ񤭽Ф
 */
LOCAL	W	save_adr(void)
{
	ADR_NODE	*np;
	ADR_DATA	*data;		/* ꣱ʬΥǡ */
	W		i;

	if ( (np = adr_data) == NULL ) return E_OK; /* ǡʤ */

	if (print_mode & 1) {		/* ڡ */

		do {
			for ( i = 0; i < MAX_ADR; ++i ) {
				if ( (data = np->data[i]) == NULL ) continue;

				/* ڡؤ */
				if (adr_cnt >= adr_per_page) {
					rputc(TC_FF, tg_fp); adr_cnt = 0;
				}

				if (adr_cnt != 0) nl();

				/* Ͽǡν񤭽Ф */
				put_adr_data(data);

				adr_cnt++;
			}

		} while ( !rerror(tg_fp) && (np = np->next) != adr_data );

	} else {			/* ɽΥڡ */

		put_adr_data(cur_adr->data[cur_adr_ofs]);
	}

	return rerror(tg_fp);
}

/*
 * ֥å񤭽Ф
 */
LOCAL	W	write_tg_fp( B *buf,W size)
{
	W	s = 0;

	/* rwrite() ϡ٤ 32KB ޤǤ񤭽ФʤΤǡ
	   32KB ʲʬ䤷ƽ񤭽Ф */
	while ( (size -= (W)s) > 0L ) {
		s = ( size > 0x7ff0L )? 0x7ff0: (W)size;
		if ( rwrite(buf, s, 1, tg_fp) != s ) break;
		buf += s;
	}
	return rerror(tg_fp);
}

/*
 * إåν񤭽Ф
 */
LOCAL	W	put_header(void)
{
	/* 󥻥Ȥν񤭽Ф */
	rputseg((B*)&info_seg, tg_fp);

	/* ʸϳϥȤν񤭽Ф */
	rputseg((B*)&text_seg, tg_fp);

	/* ѻϢ䵤ν񤭽Ф */
	saveform(write_tg_fp, 1);

	/* Դֳֻ䵤ν񤭽Ф */
	rputseg((B*)&lgap_seg, tg_fp);

	return rerror(tg_fp);
}

/*
 * ȥ졼顼ν񤭽Ф
 */
LOCAL	W	put_trailer(void)
{
	/* ʸϽλȤν񤭽Ф */
	rputseg((B*)&textend_seg, tg_fp);

	return rerror(tg_fp);
}

/*
 * 񤭹ߥ쥳ɤκ  Υ쥳ɤؤΰդ
 */
LOCAL	W	creat_rec(void)
{
	W	err;

	/* ƬΥǡ쥳ɤذư */
	if ( (err = rrewind(tg_fp)) < E_OK ) return err;
	if ( reof(tg_fp) ) {

		/* ǡ쥳ɤ¸ߤʤ
		   եκǸ˥ǡ쥳ɤɲ */
		err = apd_rec(rfileno(tg_fp), NULL, 0L, RT_TADDATA, 0, 0);
		if ( err < E_OK ) return err;
	} else {

		/* ǡ쥳ɤ */
		err = ins_rec(rfileno(tg_fp), NULL, 0L, RT_TADDATA, 0, 0);
		if ( err < E_OK ) return err;
	}

	/* 񤭹ߥ쥳(Ƭ쥳)ذդ */
	return rrewind(tg_fp);
}

/*
 * ¿Ȥ¸
 */
LOCAL	W	sc_save_print(void)
{
	W	err;
	W	newrec;		/* ¸ѥ쥳ɤֹ */

	/* 񤭹쥳ɤκ */
	if ( (err = creat_rec()) < E_OK ) return err;
	newrec = rrecordno(tg_fp);

	/* إåν񤭽Ф */
	if ( (err = put_header()) < E_OK ) goto err_exit;

	if (sched_fusen.win_top == SCH_WIN) {
		/* ͽɽǡ񤭽Ф */

		if ( (err = save_sch()) < E_OK ) goto err_exit;

	} else if (sched_fusen.win_top == ADR_WIN) {
		/* Ͽǡ񤭽Ф */

		/* ڡ˽񤯷㣱 */
		adr_per_page = paper_size.y / ((pr_size + pr_lngap) * 10);
		if (adr_per_page <= 0) adr_per_page = 1;
		adr_cnt = 0;
		if ( (err = save_adr()) < E_OK ) goto err_exit;
	}

	/* ȥ졼顼ν񤭽Ф */
	if ( (err = put_trailer()) < E_OK ) goto err_exit;

	/* 񤭹ߥХåեեå */
	if ( (err = rflush(tg_fp)) < E_OK ) goto err_exit;

	return err;

err_exit:
	return err;
}
/*
 *	եʰǤѤ
 */
LOCAL	W	save_to_tmpfl(LINK* lnk)
{
	W	vid, i, cls_er;
	W	fd;

	i = oatt_vob(vid = mycmd->vid, 0);
	if (i >= 0) {	/* FS ³ */
		*lnk = mycmd->lnk;
		if ((fd = i = cre_fil(lnk, f_name, NULL, 0, F_FLOAT)) >= 0) {
			tg_fp = rfdopen(fd, (UW)RM_TADDATA, F_UPDATE);
			i = sc_save_print();	/* ǡν񤭹 */
			cls_er = rclose(tg_fp);
			if(i >= 0 && cls_er < 0) i = cls_er;
		}
	}
	return i;
}

LOCAL	W	mk_prfile(LINK* lnk)
/* ѥե */
{
	W	er;

	sysmsg (MSG_TMPFL);		/* ե */
	er = save_to_tmpfl(lnk);
	sysmsg (0);
	if (er < 0) errpanel(ER_TMPFL, er);	/* ե顼 */
	return er;
}

/*
 * 
 */
EXPORT	W	sc_print(W para)
{
	W	i;

	if (sched_fusen.win_top == CAL_WIN) return 0;

	if (sched_fusen.win_top == SCH_WIN) {
		if (paper_size.x < (pr_size + pr_chgap) * 20) goto ERRPNL;

	} else if (sched_fusen.win_top == ADR_WIN) {
		if (paper_size.x < (pr_size + pr_chgap) * 24) {
ERRPNL:
			/* panel(????); */
		}
	} else	return 0;

	i = panel(PNL_PRPAGE);

	if (i > 0) {	/* 0: ä1: ڡ2: Υڡ */

		print_mode = (i == 1) ? 1 : 0;

		/* ¹ԡ饤֥ */
		doprint (NULL, mk_prfile);
	}
	return 0;
}
