/*
	sctray.c	ŻҼĢ : ȥ졼

	(C) Copyright 1997-98 by Personal Media Corporation
*/
#include "sched.h"
#include <tlang.h>
#include <mtstring.h>

/*
 * ȥ졼ؽ
 *	ʸΤߤ
 */
EXPORT	W	put_tray(W to,TC *buf,W len,RECT *rp)
/* 衣0ȥ졼1ȥ졼 */
/* ǡХåե */
/* ǡĹ(Wñ) */
/* ʸϳϥȤ view */
{
	TRAYREC	*tray;
	W	err;
	TEXTSEG	text;
	FUNCP	put_fn;

	if (to != 0 && to != 1) {
		return -1;
	}
	put_fn = (to)? (FUNCP)tset_dat : (FUNCP)tpsh_dat;

	/* ȥ졼쥳ɤݤ */
	if ((tray = (TRAYREC*)malloc(lsizeof(TRAYREC)*2)) == (TRAYREC*)NULL) return ER_NOMEM;
	memset(tray, 0, sizeof(TRAYREC));

	tray[1].id = TR_TEXT;
	tray[1].len = len * 2;
	tray[1].dt = (B*)buf;

	text.draw = text.view = *rp;
	text.v_unit = text.h_unit = 0;
	text.lang = 0x21;
	text.bgpat = 0;

	tray[0].id = TS_TEXT;
	tray[0].len = lsizeof(TEXTSEG);
	tray[0].dt = (B*)&text;

	ConvEndianHs(buf, buf, len);
	ConvEndianStruct((B*)&text, (B*)&text, TEXTSEG_STRUCT, sizeof(text));
	err = (*put_fn)( tray, 2, getdbox(TX_TRAYTL) );
	ConvEndianStruct((B*)&text, (B*)&text, TEXTSEG_STRUCT, sizeof(text));
	ConvEndianHs(buf, buf, len);

	free(tray);

	return err;
}

/* ȥ졼Хåե */
LOCAL	TC	tray_buff[TBUFLEN];


/*
 *	ȥ졼ʣ̡ư
 */
EXPORT	W	text_to_tray(ix, cut)
	W	ix;		/* ɥֹ */
	W	cut;		/* ưʣ (!0/0) */
{
	W	pid, no;
	TC	buf[TBUFLEN];
	TC	erbuf[TBUFLEN];
	TC	*buff;		/* ƥȥܥåΥХåե */
	W	len, err;
	RECT	r;

	/* ix ΤɤΥƥȥܥå򤵤Ƥ뤫 */
	pid = wpinfo[ix].pid[(no = wpinfo[ix].tbox_no)];

	/* ƥȥܥåХåե */
	no -= wpinfo[ix].tbox_start;
	buff = tbufp[ix][no];

	/* @@ΰ̵ͭ(˥塼ǤȤ) */

	/* 顼Τ˥ƥȥܥåΤɤ߽Ф */
	cget_val( pid, TBUFLEN, (W*)erbuf );

	/* ΰ */
	if ((len = tx_cut_txt(pid, TBUFLEN, buf, cut)) <= 0) return -1;

	cget_val( pid, TBUFLEN, (W*)buff );

	/* ȥ졼Хåե˥åȤ */
	memcpy(tray_buff, buf, len * sizeof(TC));

	/* ȥ졼إǡ򥻥åȤ */
	setrect(r, 0, 0, (CHSSTD + (CHSSTD>>3)) * len, CHSSTD);
	if ( (err = put_tray( 0, tray_buff, len, &r )) <= 0 ) {
		errpanel((err < 0)? ER_CUT : ER_MOVE, err);
		txt_recover( pid, buff, erbuf );
		return -1;
	}

	if (cut != 0) {
		if (ix != SRC_WIN) {
			modified = TRUE;
		}
		if (ix == ADR_WIN && no == 0) chg_adr_yomi();
	}

	return E_OK;
}
/*
 * ȥ졼
 */
LOCAL	W	tray_rec;
LOCAL	W	cont_rec;
LOCAL	B*	tray_buf = (B*)NULL;
LOCAL	UW	tbuf_size = 0;		/* ݤĹ(BYTE) */
LOCAL	UW	rbuf_size = 0;		/* ɤ߹Ĺ(BYTE) */

#define	TRAYBUFSIZ	0x1000L

/*
 * ȥ졼ϤγϽ
 */
EXPORT	W	init_poptray()
{
	nosupport = FALSE;
	tray_rec = 1;
	cont_rec = 0;
	if (!tray_buf) {
	    /* ȥ졼Хåե@@ */
	    if ( !(tray_buf = (B*)malloc(tbuf_size = TRAYBUFSIZ) ) )
		return ER_NOMEM;
	}
	return 0;
}

/*
 * ȥ졼Ϥνλ
 */
EXPORT	VOID	fin_poptray()
{
	if (tray_buf) free(tray_buf);		/* 920411 */
	tray_buf = (B*)NULL;
	tbuf_size = 0;
}

/*
 * ȥ졼
 */
EXPORT	W	pop_tray(W from, TC **buf, UW *tlen, W *eof)
	/* 衣0ȥ졼1ȥ졼 */
	/* ǡХåեؤΥݥ */
	/* ǡĹ(Wñ) */
	/* 1λ0³ */
{
	W	tadid, id;
	UW	size, len;
	W	rec;
	FUNCP	pop_fn;

	*eof = 0;

	pop_fn = (from)? (FUNCP)tget_dat : (FUNCP)tpop_dat;

	/* ȥ졼ɤ߹ߡ
	 * ƬХȤϡԣĥȥإåΤ˶Ƥ
	 */
AGAIN:
	id = (*pop_fn)(&tray_buf[8], tbuf_size - 8, &size, tray_rec, NULL);
	if (id <= 0) {
	    if (id == EX_PAR) {
		if (size) {		/* Хåե­ */
		    /* ɤ߹ѥХåեκƳ */
		    free(tray_buf);
		    if ((tray_buf = (B*)malloc(tbuf_size = size + 8)))
			goto AGAIN;	/* ٥ǡɤ߹ */
		    id = ER_NOMEM;
		} else {		/* 쥳ɤʤ */
		    *eof = 1;
		    return 0;
		}
	    } else if (id == 0) id = -10000;	/* ȥ졼϶ */
	    return id;
	}

	/* Хåեɤ߹ȥ졼ǡԣĤѴ */
	tadid = id & ~TR_CONT;
	if ( tadid != TR_TEXT && tadid != TR_FIG ) tadid |= 0xff00;

	/* @@size  64k ʾξ礬ɬ */
	rbuf_size = size;
	len = size;
	if (id & TR_CONT) {
	    if (cont_rec == 0) {    /* ³쥳 -- Τ len  */
		for (rec = tray_rec; id & TR_CONT; ) {
		    if ((id = (*pop_fn)(NULL, 0L, &size, ++rec, NULL)) < 0)
			return id;
		    len += size;
		}
		cont_rec = 1;
	    } else tadid = 0;
	} else if (cont_rec) {tadid = 0; cont_rec = 0;}

	if ((tadid & 0x8000) == 0) {	/* tadid >= 0 */
		/* TR_TEXT  */
		*buf = (TC*)&tray_buf[8];
		*tlen = rbuf_size / 2;
	} else if (len >= 0x10000) {
		*((H*)tray_buf) = ConvEndianH(tadid);
		*((H*)(tray_buf+2)) = 0xffff;
		*((H*)(tray_buf+4)) = ConvEndianH(len);
		*buf = (TC*)tray_buf;
		*tlen = (rbuf_size + 8) / 2;
	} else {
		*((H*)(tray_buf+4)) = ConvEndianH(tadid);
		*((H*)(tray_buf+6)) = ConvEndianH(len);
		*buf = (TC*)&tray_buf[4];
		*tlen = (rbuf_size + 4) / 2;
	}
	tray_rec++;
	return 0;
}

/*
 * ȥ졼
 *	ʸΤߤϡʴؿͤɤ߹ʸ
 */
static	B	invalid_code[] = {
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,		/*  0- F */
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 	/* 10-1F */
	1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 	/* 20-2F */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 	/* 30-3F */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 	/* 40-4F */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 	/* 50-5F */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 	/* 60-6F */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 	/* 70-7F */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 	/* 80-8F */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 	/* 90-9F */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 	/* A0-AF */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 	/* B0-BF */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 	/* C0-CF */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 	/* D0-DF */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 	/* E0-EF */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 	/* F0-FF*/
};

EXPORT	W	text_from_tray(W ix, W from, PNT pnt)
/* ix: ɥֹ */
/* from: 衣0ȥ졼1ȥ졼 */
/* pnt:  */
{
	W	i, pno, tno, sz, er, eof;
	UW	seglen, remain;
	TC	buff[TBUFLEN];
	TC*	rbuff;
	TC	cc;
	UW	pos, len;
	W code;
	W work = 0;
	TC *multi_tlang = 0;
	W illegal_mode = 0;

	/* Բ */
	if (ix == CAL_WIN) return -1;

	tno = (pno = wpinfo[ix].tbox_no) - wpinfo[ix].tbox_start;

	sz = maxtxsz[ix][tno];

	if ((er = init_poptray()) < 0) return er;

	for ( i = remain = 0; i < sz; ) {
	    if (pop_tray(from, &rbuff, &len, &eof)) goto EEXIT;
	    ConvEndianHs(rbuff, rbuff, len);
	    if (eof) break;
	    if (remain > len) { remain -= len; continue; }
	    pos = remain; remain = 0;
	    while (i < sz && pos < len) {
		    /* 򡢹ͤ */
		    cc = rbuff[pos++];
		    if (cc < 0xfeff) {	/* ʸ */
			    if (invalid_code[cc >> 8] || invalid_code[cc & 0xff]) {
				    if (cc != 0) {
					    nosupport = TRUE;
				    }
				    continue;
			    }
			    code = isTLANGch (cc, &work);
			    if (code != 0) {
				    if (code > 0) {
					    illegal_mode = 0;
					    multi_tlang = 0;
				    } else if (code == -2) {
					    /* ʣХȸ */
					    illegal_mode = 0;
					    if (!multi_tlang) {
						    multi_tlang = buff + i;
					    }
				    } else /*if (code == -1)*/ {
					    illegal_mode = 1;
					    illegal = TRUE;
					    continue;
				    }
			    }
			    /* ʸΤߥХåե */
			    if (!illegal_mode) {
				    buff[i++] = cc;
				    /* ХåեäѤˤʤä顢ɽˤ
				       ̤ޤʤǧƤߤ */
				    if (i == sz && !multi_tlang) {
					    W new_length = mtc_unique (buff, buff, i);
					    if (new_length < i - 1) {
						    i = new_length;
					    }
				    }
			    }
		    } else if (cc >= 0xff80 || cc == (0xff00|TR_VOBJ)) {
			    /* ĹȤɤФ */

		    /* ʸϳϡʸϽλϡ̤ݡȤˤϤʤ */
			    cc &= 0x00ff;
			    if (cc != TS_INFO && cc != TS_TEXT && cc != TS_TEXTEND)
				    nosupport = TRUE;

		    /* ȤĹʬåפ */
			    if ((seglen = rbuff[pos++]) == 0xffff) {
				    seglen = *((UW*)&rbuff[pos]); pos += 2;
			    }
			    seglen /= 2;
			    if (pos + seglen > len) {
				    remain = seglen + pos - len;
				    break;
			    } else {
				    pos += seglen;
			    }
		    } else {		/* ¾ΣХȥ */
			    nosupport = TRUE;
		    }
	    }
	    if (multi_tlang) {
		    /* 뤷ʤʣХȸ꤬ä */
		    *multi_tlang = TNULL;
		    i = multi_tlang - buff;
		    nosupport = TRUE;
	    }
	}
	if (i > 0) {	/* ƥȥǡʤäϹʤ */
		W pid = wpinfo[ix].pid[pno];
		W max = maxtxsz[ix][tno];

		buff[i] = TNULL;

		er = cins_txt (pid, pnt, buff);
		if (er == EX_PAR) {
			/* ʸʤäcins_txt  EX_PAR ֤Τ̵ */
			er = cget_val (pid, 0, 0);
			goto EEXIT;
		}
		if (er > 0) {
			er = cget_val (pid, max, (VP) tbufp [ix] [tno]);
			if (er > 0) {
				if (ix == ADR_WIN && tno == 0 ) {
					/* ֤ߡפѹ줿ϿΥ */
					chg_adr_yomi();
				}
				if ( ix != SRC_WIN ) {
					modified = TRUE; /* Խ줿 */
				}
				er = i;		/* ɤ߹ʸ֤ */
			}
		}
	}

EEXIT:
	fin_poptray();
	return er;
}
