/*
	search.c	ŻҼĢ : 

	(C) Copyright 1997-98 by Personal Media Corporation
*/

#include "sched.h"
#include <tlang.h>
#include <mtstring.h>
#include <wtstring.h>

#define	MAXLEN	MAX_TBLEN	/* ʸ */

#define	isLOWER(c)	(((c) & 0xffe0) == 0x2360)	/* Ѿʸ */
#define	isHIRA(c)	(((c) & 0xff80) == 0x2400)	/* Ҥ餬ʡ */
#define	isLGREEK(c)	(((c) & 0xffe0) == 0x2640)	/* ꥷ㾮ʸ */
#define	isLRUSSIAN(c)	((((c)-0x10) & 0xffc0) == 0x2740)	/* ʸ */

/*
 * ɸʸѴ
 *	ѾʸʸѴ
 *	Ҥ餬ʤϥʤѴ
 */
LOCAL	TC	std_ch( TC c)
{
	if ( isLOWER(c)    ) c = c - 0x0020;
	if ( isHIRA(c)	   ) c = c + 0x0100;
	if ( isLGREEK(c)   ) c = c - 0x0020;
	if ( isLRUSSIAN(c) ) c = c - 0x0030;
	return c;
}

/*
 * ɸʸؤѴ
 */
LOCAL	W	to_std(WTC *dst, TC *src, W dst_length)
{
	W script = TSC_SYS;
	W bad_script = 0;
	W code;
	WTC* begin = dst;
	WTC* end = dst + dst_length;
	TC* cur = src;

	while (dst < end && *cur != TNULL) {
		code = isTLANG (cur, 0, &cur);
		if (code > 0) {
			script = code;
			bad_script = 0;
		} else if (code == 0 && !bad_script) {
			TC ch = *cur++;
			if (script == TSC_SYS) {
				if (tc_isspace (ch)) {
					continue;
				}
				ch = std_ch (ch);
			}
			*dst++ = towtc (ch < TK_KSP ? 0 : script, ch);
		} else {
			bad_script = 1;
		}
	}
	*dst = towtc (0, 0);
	return dst - begin;
}

/*
 *	
 */
LOCAL	W	strsch(WTC *s1, WTC *s2)
{
	W n, l, m;
	W found = -1;

	for (n = 0; s1 [n] != 0; n++) {
		if (s1 [n] == s2 [0]) {
			l = n + 1;
			m = 1;
			while (s1 [l] != 0 && s2 [m] != 0 && s1 [l++] == s2 [m]) {
				m++;
			}
			if (s2 [m] == 0) {
				found = 0;
				break;
			}
		}
	}
	return found;
}

/*
 * ʸθ
 */
LOCAL	BOOL	search_str(TC *s1,WTC *s2)
/* s1 : ɸʸ */
/* s2 : ɸʸ(ʸ) */
{
	WTC	s[MAXLEN+1];

	/* ɸʸѴ */
	to_std(s, s1, MAXLEN);

	/*  */
	return ( strsch(s, s2) >= 0L );
}

/* ------------------------------------------------------------------------ */

/*
 * ͽɽθ
 */
LOCAL	W	search_sch(TC *str,W mode)
{
	SCH_NODE	*np;
	W		i;
	WTC wstr [MAXLEN+1];

	if ( sch_data == NULL ) return -1; /* ǡʤ */

	/* ϰ֤ */
	if ( mode == 0 ) {
		/* ǽΥڡ */
		np = sch_data;
	} else {
		/* Υڡ */
		np = cur_sch->next;
		if ( np == sch_data ) return -1; /* ΥڡϤʤ */
	}

	/* 渡ԤˡɸʸѴ */
	to_std (wstr, str, MAXLEN);

	do {
		for ( i = 0; i < MAX_SCH; ++i ) {
			if ( search_str(np->data[i], wstr) ) {
				/* ĤäȰѹ */
				cur_sch = np;
				return i;
			}
		}
	} while ( (np = np->next) != sch_data );

	return -1; /* Ĥʤä */
}

/* ------------------------------------------------------------------------ */

/* ե̾ꥹȤι¤ */
typedef	struct {
	UW		fmask;		/* ޥ */
	TC		key[1];		/* ե̾ (ʸǤդʸ) */
} FIELD_NAME;

LOCAL	W		*field_names;	/* ե̾Υꥹ */

#define	FLD_SEP		(0x2127)	/* ֡ץեɻζڤʸ */

/*
 * ե̾ΥꥹȤǡܥåɤ߽Ф
 */
EXPORT	BOOL	get_field_names(void)
{
	field_names = (W*)getdbox(FLD_NAMES);

	return ( field_names != NULL );
}

/*
 * եɤλĴ٤
 *	λʸʬ str ʤ
 */
LOCAL	UW	get_adr_field(TC **str)
{
	FIELD_NAME	*fp;
	TC		*s = *str;
	W		len;
	W		n;
	W		i = 0;

	while ( (n = field_names[i++]) != 0 ) {
		fp = (FIELD_NAME*)ptrdbox(n);

		/* եɻΥå */
		len = tc_strlen(fp->key);
		if ( tc_strncmp(s, fp->key, len) == 0 && s[len] == FLD_SEP ) {
			*str += len + 1;
			return fp->fmask; /* եɻꤢ */
		}
	}

	/* եɻ꤬ʤΤǡեɤ򸡺 */
	return 0xffff;
}

/*
 * եɤθ
 */
LOCAL	W	search_adr_data( ADR_DATA *dp, WTC *str, UW field)
{
	if ( (field & 0x0001) != 0 && search_str(dp->yomi,  str) ) return 0;
	if ( (field & 0x0002) != 0 && search_str(dp->yubin, str) ) return 1;
	if ( (field & 0x0004) != 0 && search_str(dp->addr1, str) ) return 2;
	if ( (field & 0x0008) != 0 && search_str(dp->addr2, str) ) return 3;
	if ( (field & 0x0010) != 0 && search_str(dp->addr3, str) ) return 4;
	if ( (field & 0x0020) != 0 && search_str(dp->name,  str) ) return 5;
	if ( (field & 0x0040) != 0 && search_str(dp->tel,   str) ) return 6;
	if ( (field & 0x0080) != 0 && search_str(dp->fax,   str) ) return 7;
	if ( (field & 0x0100) != 0 && search_str(dp->memo1, str) ) return 8;
	if ( (field & 0x0200) != 0 && search_str(dp->memo2, str) ) return 9;
	return -1;
}

/*
 * Ͽθ
 */
LOCAL	W	search_adr(TC *str, W mode)
{
	ADR_NODE	*np;
	W		i, n;
	UW		field;
	WTC wstr [MAXLEN+1];

	/* եɤγǧ */
	field = get_adr_field(&str);
	to_std (wstr, str, MAXLEN);

	if ( mode == 0 ) {
		/* ǽΥڡ鸡 */
		np = adr_data;
		i  = 0;
	} else {
		/* Υڡ鸡 */
		np = cur_adr;
		i  = cur_adr_ofs+1;
	}
	if ( np == NULL ) return -1; /* ǡʤ */

	do {
		while ( i < MAX_ADR ) {
			if ( np->data[i] != NULL ) {
				/*  */
				n = search_adr_data(np->data[i], wstr, field);
				if ( n >= 0 ) {
					/* ĤäȰѹ */
					cur_adr     = np;
					cur_adr_ofs = i;
					calc_adr_page(); /* ڡֹƷ׻ */
					return n;
				}
			}
			++i;
		}
		i = 0;
	} while ( (np = np->next) != adr_data );

	return -1; /* Ĥʤä */
}

/* ------------------------------------------------------------------------ */

/*
 * ǽ
 *	Ԥ줿ȤˤϡĤեɤֹ()֤
 *	Ĥʤäꡢ¹ԤǤʤäȤˤ֤
 */
EXPORT	W	sc_search(W ix,TC *str,W mode)
/* оݥǡμ (SCH_WIN|ADR_WIN) */
/* ʸ */
/* ǽΥڡ鸡Υڡ鸡 */
{
	if ( str[0] == TNULL ) return -1; /* ʸ󤬤ʤ */

	switch ( ix ) {
	  case SCH_WIN:	return search_sch(str, mode);
	  case ADR_WIN:	return search_adr(str, mode);
	}
	return -1;
}
