/*
 *	@(#)accept.c (rsdrv)
 *
 *	RS ɥ饤	ǥХ׵ν
 *	(C) Copyright 1995-98 by Personal Media Corporation
 */

#include "rsdrv.h"

/*
 * ɥ쥹֤ȥå
 */
LOCAL ERR setAndCheckTaskSpace( DevReq *devReq )
{
	ERR	err;

	if ( devReq->cmd.adcnv == 0 || devReq->datacnt <= 0 ) return ER_OK;

	/* ɥ쥹֤ */
	err = SetTaskSpace(devReq->taskid);
	if ( err != ER_OK ) {
		DEBUG_PRINT(("SetTaskSpace err = %d\n", err));
		return err;
	}

	/* ɥ쥹֤Υå */
	if ( devReq->cmd.cmd == DC_READ ) {
		err = CheckSpaceRW(devReq->memptr, devReq->datacnt);
	} else {
		err = CheckSpaceR(devReq->memptr, devReq->datacnt);
	}
	if ( err != ER_OK ) {
		DEBUG_PRINT(("CheckSpace err = %d\n", err));
		return err;
	}

	return ER_OK;
}

/*
 * ǡȤΥå
 *	return < 0 : 顼
 *	       > 0 : devReq->datacnt;
 */
EXPORT WERR CheckDataCnt( DevReq *devReq, W datasz)
{
	W	reqcnt = devReq->datacnt;

	if ( reqcnt < datasz ) {
		if ( reqcnt != 0 ) return toERR(EC_PAR, ED_DATACNT);
	}
	return reqcnt;
}

/*
 * ǡ
 */
LOCAL WERR receiveData( RsInfo *rsInfo, DevReq *devReq, W *alen )
{
	W	tmout;
	ERR	err;

	/* ॢ */
	if ( devReq->cmd.nowait == 0 ) {
		/* WAIT ⡼ */
		tmout = rsInfo->rcv_tmout;
		if ( tmout == 0 ) tmout = -1;
	} else {
		/* NOWAIT ⡼ */
		tmout = 0;
	}

	/* ǡ */
	err = serial_in(rsInfo->port, devReq->memptr, devReq->datacnt,
							alen, tmout);
	if ( err < ER_OK ) goto err_ret;

	return *alen;

err_ret:
	DEBUG_PRINT(("receiveData err = %d\n", err));
	return err;
}

/*
 * ǡ
 */
LOCAL WERR sendData( RsInfo *rsInfo, DevReq *devReq, W *alen )
{
	W	tmout;
	ERR	err;

	/* ॢ */
	tmout = rsInfo->snd_tmout;
	if ( tmout == 0 ) tmout = -1;

	/* ǡ */
	err = serial_out(rsInfo->port, devReq->memptr, devReq->datacnt,
							alen, tmout);
	if ( err < ER_OK ) goto err_ret;

	return *alen;

err_ret:
	DEBUG_PRINT(("sendData err = %d\n", err));
	return err;
}

/*
 * ֥졼
 */
LOCAL WERR sendBreak( RsInfo *rsInfo, DevReq *devReq )
{
	UW	brk_time;
	ERR	err;

	if ((err = CheckDataCnt(devReq, sizeof(UW))) < 0) goto err_ret;
	if (err == 0) return sizeof(UW);

	brk_time = *(UW*)devReq->memptr;
	if ( brk_time > 0 ) {
		/* ֥졼 */
		err = serial_ctl(rsInfo->port, DN_RSBREAK, &brk_time);
		if ( err < ER_OK ) goto err_ret;
	}

	return sizeof(UW);

err_ret:
	DEBUG_PRINT(("sendBreak err = %d\n", err));
	return err;
}

#if	0
/*
 * ղõǽ
 */
LOCAL WERR setAddIn( RsInfo *rsInfo, DevReq *devReq )
{
	RsAddIn	addin;
	ERR	err;

	if ((err = CheckDataCnt(devReq, sizeof(RsAddIn))) < 0) goto err_ret;
	if (err == 0) return sizeof(RsAddIn);

	addin = *(RsAddIn*)devReq->memptr;

	if ( rsInfo->addin != RSAD_NONE ) {
		/* ưղõǽɥ饤Сλ */
		err = kpInit(rsInfo, rsInfo->addin, False);
		if ( err < ER_OK ) goto err_ret;
	}

	if ( addin != RSAD_NONE ) {
		/* ղõǽɥ饤Сư */
		err = kpInit(rsInfo, addin, True);
		if ( err < ER_OK ) goto err_ret;
	}

	return sizeof(RsAddIn);

err_ret:
	DEBUG_PRINT(("setAddIn err = %d\n", err));
	return err;
}
#endif

/*
 * ѥ᡼꡿
 *	dn > 0	    dn < 0 
 */
LOCAL WERR set_getCtlParam( RsInfo *rsInfo, DevReq *devReq, W dn, W sz )
{
	ERR	err;

	if ((err = CheckDataCnt(devReq, sz)) < 0) goto err_ret;
	if (err == 0) return sz;

	/* ѥ᡼꡿ */
	err = serial_ctl(rsInfo->port, dn, devReq->memptr);
	if ( err < ER_OK ) goto err_ret;

	return sz;

err_ret:
	DEBUG_PRINT(("set_getCtlParam err = %d\n", err));
	return err;
}

/*
 * W ѥ᡼
 */
LOCAL WERR getParamW( DevReq *devReq, UW *param )
{
	ERR	err;

	if ((err = CheckDataCnt(devReq, sizeof(UW))) < 0) goto err_ret;
	if (err == 0) return sizeof(UW);

	*(UW*)devReq->memptr = *param;
	return sizeof(UW);

err_ret:
	DEBUG_PRINT(("getParamW err = %d\n", err));
	return err;
}

/*
 * W ѥ᡼
 */
LOCAL WERR setParamW( DevReq *devReq, UW *param )
{
	ERR	err;

	if ((err = CheckDataCnt(devReq, sizeof(UW))) < 0) goto err_ret;
	if (err == 0) return sizeof(UW);

	*param = *(UW*)devReq->memptr;
	return sizeof(UW);

err_ret:
	DEBUG_PRINT(("setParamW err = %d\n", err));
	return err;
}

/*
 * ǡɤ߽Ф
 */
LOCAL ERR readData( RsInfo *rsInfo, DevRsp *devRsp, DevReq *devReq )
{
	ERR	err;

	/* ѥ᡼å */
	if ( devReq->datacnt < 0 )
		{ err = toERR(EC_PAR, ED_DATACNT); goto err_ret; }

	/* ɥ쥹֤ȥå */
	err = setAndCheckTaskSpace(devReq);
	if ( err < ER_OK ) goto err_ret;

	switch ( devReq->datano ) {
	  case 0:		/* ǡ */
		err = receiveData(rsInfo, devReq, &devRsp->datacnt);
		break;

	  case DN_PCMCIAINFO:	/* R : PC ɾ */
		err = rsGetCardInfo(rsInfo, devReq);
		break;

	  case DN_RSMODE:	/* RW: ̿⡼ */
		err = set_getCtlParam(rsInfo,
				devReq, -DN_RSMODE, sizeof(RsMode));
		break;

	  case DN_RSFLOW:	/* RW: ե */
		err = set_getCtlParam(rsInfo,
				devReq, -DN_RSFLOW, sizeof(RsFlow));
		break;

	  case DN_RSSTAT:	/* R :  */
		err = set_getCtlParam(rsInfo,
				devReq, -DN_RSSTAT, sizeof(RsStat));
		break;

	  case DN_RSSNDTMO:	/* RW: ॢ */
		err = getParamW(devReq, &rsInfo->snd_tmout);
		break;

	  case DN_RSRCVTMO:	/* RW: ॢ */
		err = getParamW(devReq, &rsInfo->rcv_tmout);
		break;

#if	0
	  case DN_RSADDIN:	/* RW: ղõǽ */
		err = getParamW(devReq, (UW*)&rsInfo->addin);
		break;
#endif

	  case DN_RS16450:	/* RW: ϡɥ (16450) */
		err = set_getCtlParam(rsInfo,
				devReq, -DN_RS16450, sizeof(RsHwConf_16450));
		break;

	  case DN_RSBREAK:	/*  W: BREAK  */
		/* ɤ߽ФԲ (񤭹) */
		err = toERR(EC_PAR, ED_DATANO);
		break;

	  default:
#if	0
		if (rsInfo->addin != RSAD_NONE && kpInfo.rwparam != NULL) {
			/* addin ǽͭΥѥ᡼ */
			err = (*kpInfo.rwparam)(rsInfo, devReq, False);
		} else		/* ǡֹ楨顼 */
#endif
			err = toERR(EC_PAR, ED_DATANO);
	}
	if ( err < ER_OK ) goto err_ret;

	devRsp->datacnt = (W)err;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("readData err = %d\n", err));
	return err;
}

/*
 * ǡ񤭹
 */
LOCAL ERR writeData( RsInfo *rsInfo, DevRsp *devRsp, DevReq *devReq )
{
	ERR	err;

	/* ѥ᡼å */
	if ( devReq->datacnt < 0 )
		{ err = toERR(EC_PAR, ED_DATACNT); goto err_ret; }

	/* ɥ쥹֤ȥå */
	err = setAndCheckTaskSpace(devReq);
	if ( err < ER_OK ) goto err_ret;

	switch ( devReq->datano ) {
	  case 0:		/* ǡ */
		err = sendData(rsInfo, devReq, &devRsp->datacnt);
		break;

	  case DN_RSMODE:	/* RW: ̿⡼ */
		err = set_getCtlParam(rsInfo,
				devReq, DN_RSMODE, sizeof(RsMode));
		break;

	  case DN_RSFLOW:	/* RW: ե */
		err = set_getCtlParam(rsInfo,
				devReq, DN_RSFLOW, sizeof(RsFlow));
		break;

	  case DN_RSBREAK:	/*  W: BREAK  */
		err = sendBreak(rsInfo, devReq);
		break;

	  case DN_RSSNDTMO:	/* RW: ॢ */
		err = setParamW(devReq, &rsInfo->snd_tmout);
		break;

	  case DN_RSRCVTMO:	/* RW: ॢ */
		err = setParamW(devReq, &rsInfo->rcv_tmout);
		break;

#if	0
	  case DN_RSADDIN:	/* RW: ղõǽ */
		err = setAddIn(rsInfo, devReq);
		break;
#endif

	  case DN_RS16450:	/* RW: ϡɥ (16450) */
		err = set_getCtlParam(rsInfo,
				devReq, DN_RS16450, sizeof(RsHwConf_16450));
		break;

	  case DN_PCMCIAINFO:	/* R : PC ɾ */
	  case DN_RSSTAT:	/* R :  */
		/* 񤭹Բ (ɤ߽Ф) */
		err = toERR(EC_PAR, ED_DATANO);
		break;

	  default:
#if	0
		if (rsInfo->addin != RSAD_NONE && kpInfo.rwparam != NULL) {
			/* addin ǽͭΥѥ᡼ */
			err = (*kpInfo.rwparam)(rsInfo, devReq, True);
		} else		/* ǡֹ楨顼 */
#endif
			err = toERR(EC_PAR, ED_DATANO);
	}
	if ( err < ER_OK ) goto err_ret;

	devRsp->datacnt = (W)err;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("writeData err = %d\n", err));
	return err;
}

/*
 * ץ׵ν
 */
LOCAL ERR openDevice( RsInfo *rsInfo, ID devid )
{
	ERR	err;

	/* ղõǽɥ饤С(֥˥å)ϡ
	   ǥХ˥åȤΥץ϶ػ */
	if ( devid == rsInfo->devID && rsInfo->opened )
				{ err = ER_BUSY; goto err_ret1; }

	/* Ǥ˥ץ֤ʤ顢ץ */
	if ( !rsInfo->opened ) {

		if ( rsInfo->cardid == 0 )
			{ err = ER_NOMDA; goto err_ret1; }  /* ̤ */

		if ( rsInfo->cardid > 0 ) {
			/* ɡꥸ塼 */
			err = rsCardResume(rsInfo, True);
			if ( err < ER_OK ) goto err_ret1;
		}

		/* ٥ɥ饤Сꥸ塼 */
		err = serial_ctl(rsInfo->port, RS_RESUME, NULL);
		if ( err < ER_OK ) goto err_ret2;
	}

	rsInfo->opened = True;
	return ER_OK;

err_ret2:
	if ( rsInfo->cardid > 0 ) rsCardSuspend(rsInfo, True);
err_ret1:
	DEBUG_PRINT(("openDevice err = %d\n", err));
	return err;
}

/*
 * ׵ν
 */
LOCAL ERR closeDevice( RsInfo *rsInfo )
{
	ERR	err, error = ER_OK;

#if	0
	/* ղõǽɥ饤СϡԤʤ */
	if ( rsInfo->addin != RSAD_NONE ) return ER_OK;
#endif

	/* ٥ɥ饤Сڥ */
	err = serial_ctl(rsInfo->port, RS_SUSPEND, NULL);
	if ( err < ER_OK ) error = err;

	if ( rsInfo->cardid > 0 && cardParam.power) {
		/* ɡڥ */
		err = rsCardSuspend(rsInfo, True);
		if ( err < ER_OK ) error = err;
	}

	rsInfo->opened = False;

	if ( error < ER_OK ) DEBUG_PRINT(("closeDevice err = %d\n", error));
	return error;
}

/*
 * ܡ׵ν
 */
LOCAL ERR abortRequest( RsInfo *rsInfo, DevReq *devReq )
{
	ERR	err;

	/* ꤵ줿׵¹ʤ饢ܡȤ */
	if ( rsInfo->devReq != NULL ) {
		if ( rsInfo->devReq->taskid == devReq->taskid ) {
			/* ܡȼ¹ */
			err = serial_ctl(rsInfo->port, RS_ABORT, NULL);
			if ( err < ER_OK ) goto err_ret;
		}
	}

	return ER_OK;

err_ret:
	DEBUG_PRINT(("abortRequest err = %d\n", err));
	return err;
}

/*
 * ڥ׵ν
 *	ڥɻ˥ܡȤ줿׵ ER_MINTR ȤΤ§
 *	ꥢ̿Ǥϡڥ˼줿ǡϼƤޤᡢ
 *	ER_MINTR ֤Ƥ⤢ޤ̣ʤդˡץꥱ󤬤
 *	ʾ֤ˤʤäƤޤȤͤ롣äơER_MINTR ֤
 *	̾ΥܡȽƱ顼ɤ֤Ȥˤ롣
 */
LOCAL ERR suspendRequest( RsInfo *rsInfo )
{
	ERR	err, error = ER_OK;

#if	0
	if ( rsInfo->addin != RSAD_NONE ) {
		/* ղõǽɥ饤СΥڥɽ */
		err = kpSusRes(rsInfo, True);
		if ( err < ER_OK ) error = err;
	}
#endif

	/* ߽νХܡȤ */
	if ( rsInfo->devReq != NULL
#if	0
			|| rsInfo->addin != RSAD_NONE
#endif
							) {
		/* ܡȼ¹ */
		err = serial_ctl(rsInfo->port, RS_ABORT, NULL);
		if ( err < ER_OK ) error = err;
	}

	/* ڥɾ֤Ǥ뤳Ȥ򼨤 */
	Lock(&rsInfo->hwlock);

	if ( rsInfo->opened ) {
		/* ٥ɥ饤Сڥ */
		err = serial_ctl(rsInfo->port, RS_SUSPEND, NULL);
		if ( err < ER_OK ) error = err;
	}

	if ( rsInfo->cardid > 0 ) {
		/* ɡڥ */
		err = rsCardSuspend(rsInfo, False);
		if ( err < ER_OK ) error = err;
	}

	rsInfo->suspended = True;

	if ( error < ER_OK ) DEBUG_PRINT(("suspendRequest err = %d\n", error));
	return error;
}

/*
 * ꥸ塼׵ν
 */
LOCAL ERR resumeRequest( RsInfo *rsInfo )
{
	ERR	err = ER_OK;

	/* ڥɴʳ̵뤹 */
	if ( !rsInfo->suspended ) return ER_OK;

	if ( rsInfo->cardid > 0 ) {
		/* ɡꥸ塼 */
		err = rsCardResume(rsInfo, False);
		if ( err < ER_OK ) goto err_skip;
	}

	if ( rsInfo->opened ) {
		/* ٥ɥ饤Сꥸ塼 */
		err = serial_ctl(rsInfo->port, RS_RESUME, NULL);
		if ( err < ER_OK ) goto err_skip;
	}

#if	0
	if ( rsInfo->addin != RSAD_NONE ) {
		/* ղõǽɥ饤СΥꥸ塼 */
		err = kpSusRes(rsInfo, False);
		if ( err < ER_OK ) goto err_skip;
	}
#endif

err_skip:
	rsInfo->suspended = False;

	/* ڥɾ֤Ȥ򼨤 */
	Unlock(&rsInfo->hwlock);

	if ( err < ER_OK ) DEBUG_PRINT(("resumeRequest err = %d\n", err));
	return err;
}

/*
 * ǥХ׵μ¹
 *	devReq ׵̤ devRsp ֤
 */
LOCAL ERR execDeviceRequest( RsInfo *rsInfo, DevRsp *devRsp, DevReq *devReq )
{
	ERR	err;

	switch ( devReq->cmd.cmd ) {
	  case DC_OPEN:
		err = openDevice(rsInfo, devReq->devid);
		break;

	  case DC_CLOSE:
	  case DC_CLOSEALL:
		err = closeDevice(rsInfo);
		break;

	  case DC_READ:
		err = readData(rsInfo, devRsp, devReq);
		break;

	  case DC_WRITE:
		err = writeData(rsInfo, devRsp, devReq);
		break;

	  case DC_ABORT:
		err = abortRequest(rsInfo, devReq);
		break;

	  case DC_SUSPEND:
		err = suspendRequest(rsInfo);
		break;

	  case DC_RESUME:
		err = resumeRequest(rsInfo);
		break;

	  case DC_CARDEVENT:
		err = rsCardEvent(rsInfo, devRsp, devReq);
		break;

	  default:
		/* ޥɥ顼 */
		err = toERR(EC_PAR, ED_CMD);
		DEBUG_PRINT(("devReq command(%d) err\n", devReq->cmd.cmd));
	}

	return err;
}

/*
 * ǥХ׵
 *	̾׵ü׵ξѤ
 */
EXPORT ERR rsAcceptDeviceRequest( RsInfo *rsInfo, UW reqptn )
{
	DevReq	devReq;
	DevRsp	devRsp;
	UW	acpptn;
	RNO	rdvno;
	INT	size;
	ERR	err;

	for ( ;; ) {	/* ʬ齪λϤʤ */

		if ( rsInfo->suspended ) {
			/* ڥϡDC_RESUME ʳü׵
			   դߤ */
			acpptn = reqptn & (NormalReqPtn|D_CALPTN(DC_RESUME));
		} else {
			acpptn = reqptn;
		}

		/* ׵դ */
		err = acp_por(&rdvno, (VP)&devReq, &size,
					rsInfo->acceptPort, acpptn);
		if ( err < E_OK ) {
			DEBUG_PRINT(("acp_por er = %d\n", err));
			continue;
		}

		/* ѥåȤν */
		devRsp.devid	= devReq.devid;
		devRsp.cmd	= devReq.cmd;
		devRsp.datano	= devReq.datano;
		devRsp.datacnt	= 0;

		if ( size != sizeof(DevReq) ) {
			err = toERR(EC_PAR, ED_CMD);
			DEBUG_PRINT(("invalid devReq size (%d)\n", size));
			goto err_skip;
		}

		if ( (D_CALPTN(devReq.cmd.cmd) & NormalReqPtn) != 0 ) {
			/* ܡоݤȤʤ¹Ǥ뤳ȤϿ */
			rsInfo->devReq = &devReq;

			/*
			 * acp_por äƤ餳ޤǤδ֤ˡü׵
			 * ¹ԤƤϤʤΤᡢԤ
			 * 褦ʥƥॳȯԤƤϤʤ
			 */

			/* ü׵᤬׵ᤵƤˤϡͥ褹
			   褦˰ö¹Ը롣*/
			rot_rdq(TPRI_RUN);

			/* ̾׵νǤ뤳Ȥ򼨤 */
			Lock(&rsInfo->hwlock);
		}

		/* ¹ */
		err = execDeviceRequest(rsInfo, &devRsp, &devReq);

		if ( (D_CALPTN(devReq.cmd.cmd) & NormalReqPtn) != 0 ) {
			/* ̾׵νλ򼨤 */
			Unlock(&rsInfo->hwlock);

			/* ܡоݤȤʤλȤϿ */
			rsInfo->devReq = NULL;
		}

	err_skip:
		devRsp.error.err = err;

		/*  */
		err = rpl_rdv(rdvno, (VP)&devRsp, sizeof(DevRsp));
		if ( err < E_OK ) DEBUG_PRINT(("rpl_rdv er = %d\n", err));
	}

	return ER_SYS;	/* 뤳ȤϤʤϤ */
}
