/*
 *	@(#)card.c (rsdrv)
 *
 *	RS ɥ饤	PC ɤν
 *	(C) Copyright 1996-98 by Personal Media Corporation
 */

#include "rsdrv.h"

#include <driver/pcat/biosp.h>
#include <device/power.h>

/*
 * Card Configuration Status Register (CCSR) 
 */
#define	CCSR_NORM	0x18	/* ̾ꡧRing Indicate, Audio ͭ */
#define	CCSR_PWDN	0x04	/* ѥ⡼ */

/*
 * I/O ΥåȥåԤ (ߥ)
 */
#define	CARD_SETUP_TIME		(cardParam.wait)

/*
 * I/O Ÿ
 */
#define	CARD_POWER_CTL		(cardParam.power)

/*
 * ɤΥѥ⡼ɤ
 */
LOCAL void setPowerDownMode( RsInfo *rsInfo, UB mode )
{
	UB	ccsr;

	if ( (rsInfo->CCR_msk & 0x02) != 0 ) {
		ccsr = rsInfo->CCR[1] | mode;
		pcWriteMem(rsInfo->cardid, (rsInfo->CCR_adr + 2) >> 1, 1,
							CA_ATTRMEM, &ccsr);
	}
}

/*
 * PC ɾμ
 */
EXPORT ERR rsGetCardInfo( RsInfo *rsInfo, DevReq *devReq )
{
	PCMCIAInfo	*p = devReq->memptr;
	UB		tpl[MAX_TUPLESZ];
	W		i, n;
	ERR		err;

	if ( rsInfo->cardid <= 0 ) {
		err = ( rsInfo->cardid == 0 )?
				ER_NOMDA: toERR(EC_PAR, ED_DATANO);
		goto err_ret;
	}

	if ( devReq->datacnt < sizeof(PCMCIAInfo) ) {
		if ( devReq->datacnt == 0 ) return sizeof(PCMCIAInfo);
		err = toERR(EC_PAR, ED_DATACNT);
		goto err_ret;
	}

	/* ʾ󥿥ץ(0x15) */
	n = pcGetTuple(rsInfo->cardid, 0x15, 0, tpl);
	if ( n < 4 ) { err = ER_IO; goto err_ret; }
	n -= 4;
	n = min(n, sizeof(p->info)-1);

	p->major = tpl[2];
	p->minor = tpl[3];
	for ( i = 0; i < n; ++i ) {
		UB c = tpl[i+4];
		if ( c == 0xff ) break;
		p->info[i] = ( c == 0x00 )? ' ': c;
	}
	p->info[i] = '\0';

	return ER_OK;

err_ret:
	DEBUG_PRINT(("rsGetCardInfo err = %d\n", err));
	return err;
}

/*
 * PC ɤ
 */
LOCAL ERR defineCard( RsInfo *rsInfo, ID cid )
{
	RsHwConf_16450	DevCnf;
	T_DINT		dint;
	UB		tpl[MAX_TUPLESZ];
	W		i, n;
	ERR		err;

	DevCnf.iobase = 0;		/* IO ١Ǥ */
	err = ER_NOSPT;

	/* ɥåȤꤵƤȤåȤ㤦̵뤹 */
	if (rsInfo->cardslot < 2) {
		if (((rsInfo->cardslot ^ cid) & 0x3) != 0) goto err_ret1;
	}

	/* ե졼󥿥ץ(0x1a)
		 CCOR 쥸¸ߤɬ */
	n = pcGetTuple(cid, 0x1a, 0, tpl);
	if ( n < 3 ) goto err_ret1;

	i = (tpl[2] & 0x03) + 1;  /* TPCC-RASZ (CCR_adr ) */
	if ( n < 5+i ) goto err_ret1;

	rsInfo->CCR_msk = tpl[4+i];
	n = 0;
	while ( --i >= 0 ) {
		n <<= 8;
		n |= tpl[4+i];
	}
	rsInfo->CCR_adr = n;
	if ( (rsInfo->CCR_msk & 0x01) == 0 ) goto err_ret1;

	/* I/O ֤ */
	for ( i = 0;; ++i ) {
		/* ե졼󥨥ȥ꡼ץ(0x1b)μ */
		n = pcGetTuple(cid, 0x1b, i, tpl);
		if ( n <= 0 ) { err = ER_NOSPT; goto err_ret1; }

		/* I/O ־(TCPE-IO)õ */
		while ( --n >= 8 ) {
			if ( tpl[n] == 0x07 && tpl[n-3] == 0x60 ) break;
		}
		if ( n < 8 ) continue;
		DevCnf.iobase = (UH)tpl[n-1] << 8 | tpl[n-2];
		DevCnf.iostep = 1;

		/* I/O ޥåפԤ */
		err = pcMap(cid, DevCnf.iobase, 8, CA_IOMAP|CA_IOCS16,
							(VP*)&DevCnf.iobase);
		if ( err < ER_OK ) continue;
		rsInfo->mapid = err;

		/* ɥե졼ѥ᡼ */
		rsInfo->CCR[0] = (tpl[2] & 0x3f) | 0x40;
		rsInfo->CCR[1] = CCSR_NORM;

		break;
	}

	/* ߥ٥μ (I/O ) */
	dint.inthdr = NADR;
	err = pcDefInt(cid, &dint, 0, 0);
	if ( err < ER_OK ) goto err_ret2;
	DevCnf.intvec = err;

	/* ɥե졼 */
	n = ( (rsInfo->CCR_msk & 0x02) != 0 )? 2: 1;
	err = pcWriteMem(cid, rsInfo->CCR_adr >> 1, n,
					CA_ATTRMEM, &rsInfo->CCR);
	if ( err < ER_OK ) goto err_ret3;

	dly_tsk(CARD_SETUP_TIME);  /* Ԥ */

	/* ٥ɥ饤С */
	err = serial_ctl(rsInfo->port, DN_RS16450, (UW*)&DevCnf);
	if ( err < ER_OK ) goto err_ret3;

	return ER_OK;

err_ret3:
	pcDefInt(cid, NULL, 0, 0);
err_ret2:
	pcUnMap(rsInfo->mapid);

err_ret1:
	DEBUG_PRINT(("defineCard err = %d\n", err));
	return err;
}

/*
 * PC ɤ
 *	cid = 0  ꥸ塼β ( ID ϤǤ̵ˤʤäƤ)
 *	cid > 0  CE_EJECT β  ( ID ͭ)
 */
LOCAL ERR undefCard( RsInfo *rsInfo, ID cid )
{
	static const RsHwConf_16450 NoDevice = { 0, 0, 0 };
	ERR	err, error = ER_OK;

	/* ٥ɥ饤Сư */
	err = serial_ctl(rsInfo->port, DN_RS16450, (UW*)&NoDevice);
	if ( err < ER_OK ) error = err;

	if ( cid > 0 ) {
		/* ߲ */
		err = pcDefInt(cid, NULL, 0, 0);
		if ( err < ER_OK ) error = err;
	}

	/* I/O ޥåפβ */
	err = pcUnMap(rsInfo->mapid);
	if ( err < ER_OK ) error = err;
	rsInfo->mapid = 0;

	if ( error < ER_OK ) DEBUG_PRINT(("undefCard err = %d\n", error));
	return error;
}

/*
 * PC ɤΥڥ
 *	close	ΤȤ True
 */
EXPORT ERR rsCardSuspend( RsInfo *rsInfo, Bool close )
{
	UW	mode;
	ERR	err;

	/* 忮ꥸ塼ͭ */
	rsInfo->rires = ( ((PowerMode*)&biosp->pwmode)->ringrsm != 0 );

	mode =	( close )?				CP_POWEROFF:
		( rsInfo->opened && rsInfo->rires )?	CP_SUSRIRES:
							CP_SUSPEND;

	if ( mode == CP_SUSRIRES && CARD_POWER_CTL ) {
		/* ѥ⡼ɤ˰ܹ */
		setPowerDownMode(rsInfo, CCSR_PWDN);
	}

	/* Ÿ OFF */
	err = pcPowerCtl(rsInfo->cardid, mode);
	if ( err < ER_OK ) goto err_ret;

	return ER_OK;

err_ret:
	DEBUG_PRINT(("rsCardSuspend err = %d\n", err));
	return err;
}

/*
 * PC ɤΥꥸ塼
 *	open	ץΤȤ True
 */
EXPORT ERR rsCardResume( RsInfo *rsInfo, Bool open )
{
	T_DINT	dint;
	W	n;
	ERR	err;

	/* Ÿ ON */
	err = pcPowerCtl(rsInfo->cardid, ( open )? CP_POWERON: CP_RESUME);
	if ( err < ER_OK ) {
		if ( !open && err == ER_NODEV ) {
			/* ڥ˥ɤȴ줿 */
			undefCard(rsInfo, 0);
			rsInfo->cardid = 0;	/* ̤ */
		}
		goto err_ret1;
	}

	if ( !open && !rsInfo->opened ) {
		/* ץ󤵤ƤʤΤǡŸ OFF  */
		err = pcPowerCtl(rsInfo->cardid, CP_POWEROFF);
		if ( err < ER_OK ) goto err_ret1;

		return ER_OK;
	}

	if ( err == 0 ) {
		/* ڥ⥫ɤŸ ON ΤޤޤäΤǡ
		   ɤκ */

		/* ѥ⡼ɤ */
		setPowerDownMode(rsInfo, 0);
		return ER_OK;
	}

	/* I/O ƥޥå */
	err = pcReMap(rsInfo->cardid, rsInfo->mapid);
	if ( err < ER_OK ) goto err_ret2;

	/* ߥ٥Ƴ */
	dint.inthdr = NADR;
	err = pcDefInt(rsInfo->cardid, &dint, 0, 0);
	if ( err < ER_OK ) goto err_ret2;

	/* ɺƥե졼 */
	n = ( (rsInfo->CCR_msk & 0x02) != 0 )? 2: 1;
	err = pcWriteMem(rsInfo->cardid, rsInfo->CCR_adr >> 1, n,
					CA_ATTRMEM, &rsInfo->CCR);
	if ( err < ER_OK ) goto err_ret2;

	dly_tsk(CARD_SETUP_TIME);  /* Ԥ */

	return ER_OK;

err_ret2:
	pcPowerCtl(rsInfo->cardid, CP_POWEROFF);
err_ret1:
	DEBUG_PRINT(("rsCardResume err = %d\n", err));
	return err;
}

/*
 * 
 */
LOCAL ERR insertCard( RsInfo *rsInfo, ID cid )
{
	if ( rsInfo->cardid > 0 ) return CR_NONE;  /* Ǥ˥ɻ */

	/*  */
	if ( defineCard(rsInfo, cid) < ER_OK ) goto err_ret;

	Lock(&rsInfo->hwlock);

	rsInfo->cardid = cid;	/* ɻ */

	if ( rsInfo->opened ) {

		/* ٥ɥ饤Сꥸ塼 */
		serial_ctl(rsInfo->port, RS_RESUME, NULL);

#if	0
		if ( rsInfo->addin != RSAD_NONE ) {
			/* ղõǽɥ饤СƵư */
			kpSusRes(rsInfo, False);
		}
#endif

	} else if (CARD_POWER_CTL) {

		/* ץǤʤŸͭΤȤϰöڥɤ */

		/* ٥ɥ饤Сڥ */
		serial_ctl(rsInfo->port, RS_SUSPEND, NULL);

		/* ɡڥ */
		rsCardSuspend(rsInfo, True);
	}

	Unlock(&rsInfo->hwlock);

	return CR_OWN;

err_ret:
	DEBUG_PRINT(("insertCard, unsupported card\n"));
	return CR_NONE;
}

/*
 * ӽн
 */
LOCAL ERR ejectCard( RsInfo *rsInfo, ID cid )
{
	ERR	err, error = ER_OK;

	if ( rsInfo->cardid != cid ) return ER_OK;  /* оݥɤǤʤ */

#if	0
	if ( rsInfo->addin != RSAD_NONE ) {
		/* ղõǽɥ饤С򥵥ڥɾ֤ˤߤ */
		err = kpSusRes(rsInfo, True);
		if ( err < ER_OK ) error = err;
	}
#endif

	/* ߼¹νХܡȤ */
	if ( rsInfo->devReq != NULL
#if	0
			|| rsInfo->addin != RSAD_NONE
#endif
							) {
		/* ܡȼ¹ */
		err = serial_ctl(rsInfo->port, RS_ABORT, NULL);
		if ( err < ER_OK ) { error = err; goto err_ret; }
		dly_tsk(100);  /* ܡȽ¹Ԥ뤿ᾯԤ */
	}

	/* ̾׵ΥܡȴλԤ
	   θϥӽнޤ̾׵ϼդʤ */
	Lock(&rsInfo->hwlock);

	/* ɲ */
	err = undefCard(rsInfo, rsInfo->cardid);
	if ( err < ER_OK ) error = err;

	rsInfo->cardid = 0;	/* ̤ */

	Unlock(&rsInfo->hwlock);

err_ret:
	if ( error < ER_OK ) DEBUG_PRINT(("ejectCard err = %d\n", error));
	return error;
}

/*
 * PC ɥ٥Ȥν
 */
EXPORT ERR rsCardEvent( RsInfo *rsInfo, DevRsp *devRsp, DevReq *devReq )
{
	ID	cid = devReq->devid;
	ERR	err;

DEBUG_PRINT(("rsCardEvent cid=0x%08x, event=%d\n", cid, devReq->datano));

	switch ( devReq->datano ) {
	  case CE_INSERT:	/*  */
		err = insertCard(rsInfo, cid);
		break;

	  case CE_EJECT:	/* ӽ */
		err = ejectCard(rsInfo, cid);
		break;

	  case CE_BATTERY:	/* ɥХåƥٹ𡿰۾ */
		/* ȯʤϤ (̵) */
		err = CR_NONE;
		break;

	  default:
		DEBUG_PRINT(("rsCardEvent, unknown card event\n"));
		err = CR_NONE;
	}

	return err;
}
