/*
 *	@(#)main.C (rsdrv)
 *
 *	RS ɥ饤	
 *	(C) Copyright 1995-98 by Personal Media Corporation
 */

#include "rsdrv.h"
#include <bstring.h>
#include <tstring.h>
#include <tctype.h>

#include <driver/pcat/biosp.h>
#include <driver/hwres.h>

/*
 * RS ɥ饤 PC 润̥ѥ᡼
 */
EXPORT	CardParam	cardParam = {DefaultCardWait, DefaultCardPower};

/*
 * RS ɥ饤Хͥ
 */
LOCAL	PRI	taskPri = DefaultPriority;

/*
 * ǥХ PC ɥ饤ȤϿ
 *	Ͽ	reg = True
 *		reg = False
 */
LOCAL WERR registDevice( RsInfo *rsInfo, Bool reg )
{
	static const DevDef	def = {
		{ 0 },		/* attr */
		1,		/* subunits */
		{ L"" },	/* name */
		0		/* portid */
	};
	DevDef	devDef;
	ERR	err;

	/* Ͽ */
	devDef = def;
	devDef.attr.chardev = 1;
	devDef.attr.devinfo = (rsInfo->cardid < 0) ?
				0 : (rsInfo->cardslot | 0x0C);
	devDef.attr.nowait = 1;
	devDef.portid = ( reg )? rsInfo->acceptPort: InvalidID;
	devDef.name[2] += rsInfo->port;	/* 0:rsa, 1:rsb, 2:rsc ... */

	/* ǥХϿ */
	err = b_DefDevice(&devDef, NULL);
	if ( err < ER_OK ) goto err_ret;
	rsInfo->devID = (ID)err;

	if ( rsInfo->cardid >= 0 ) {
		/* PC ɥ饤Ͽ */
		pcRegClient(rsInfo->acceptPort, ( reg )? CK_SERIAL: CK_NONE);
	}

	return ER_OK;

err_ret:
	DEBUG_PRINT(("registDevice err = %d\n", err));
	return err;
}

/*
 * ü׵դ
 */
LOCAL void rsSpecificRequestTask( RsInfo *rsInfo )
{
	ERR	err;

	/* ǥХ׵դ */
	err = rsAcceptDeviceRequest(rsInfo, SpecificReqPtn);

	/*
	 * ǥХɥ饤С̾ｪλʤΤǡ
	 * 뤳ȤϤʤϤ
	 */

	DEBUG_PRINT(("rsSpecificRequestTask err = %d\n", err));
	exd_tsk();
}

/*
 *  RS ɥ饤Сᥤ󥿥
 * (̾׵դ)
 */
LOCAL void rsMainTask( RsInfo *rsInfo )
{
static	UB	nm[] = "rsa";
	T_CPOR	cpor;
	T_CTSK	ctsk;
	ID	tskid;
	ERR	err;

	nm[2] = 'a' + rsInfo->port;	/* nm = "rsa", "rsb" ... */

	/* å */
	err = CreateLockWN(&rsInfo->hwlock, nm);
	if ( err < ER_OK ) goto err_ret0;

	/* ǥХ׵դѥǥ֥ݡȤ */
	strncpy((B*)&cpor.exinf, nm, 4);
	cpor.poratr  = TA_NULL;
	cpor.maxcmsz = sizeof(DevReq);
	cpor.maxrmsz = sizeof(DevRsp);
	err = vcre_por(&cpor);
	if ( err < E_OK ) { err = toERR(EC_INNER, err); goto err_ret1; }
	rsInfo->acceptPort = (ID)err;

	/* ü׵դ */
	ctsk.exinf   = rsInfo;
	ctsk.task    = rsSpecificRequestTask;
	ctsk.itskpri = rsInfo->mypri;
	ctsk.stksz   = 2048;
	ctsk.tskatr  = TA_HLNG|TA_RNG0;

	err = vcre_tsk(&ctsk);
	if ( err < E_OK ) { err = toERR(EC_INNER, err); goto err_ret2; }
	tskid = (ID)err;

	err = sta_tsk(tskid, (INT)rsInfo);
	if ( err < E_OK ) { err = toERR(EC_INNER, err); goto err_ret3; }

	/* ǥХϿ */
	err = registDevice(rsInfo, True);
	if ( err < ER_OK ) goto err_ret4;

	/* ǥХ׵դ */
	err = rsAcceptDeviceRequest(rsInfo, NormalReqPtn);
	if ( err < ER_OK ) goto err_ret5;

	/*
	 * ǥХɥ饤С̾ｪλʤΤǡ
	 * 뤳ȤϤʤϤ
	 */

	/* λ */
err_ret5:
	registDevice(rsInfo, False);
err_ret4:
	ter_tsk(tskid);
err_ret3:
	del_tsk(tskid);
err_ret2:
	del_por(rsInfo->acceptPort);
err_ret1:
	DeleteLock(&rsInfo->hwlock);
err_ret0:
	Kfree((VB*)rsInfo);
	DEBUG_PRINT(("rsMainTask err = %d\n", err));
	exd_tsk();
}

/* ------------------------------------------------------------------------ */

/*
 *  RS ɥ饤СΤư
 */
LOCAL WERR startRsDriver( W port, PRI pri, W cardslot)
{
	RsInfo	*rp;
	T_CTSK	ctsk;
	ID	tskid;
	ERR	err;

	/*  RS ɥ饤Сν */
	rp = (RsInfo*)Kcalloc(1, sizeof(RsInfo));
	if ( rp == NULL ) { err = ER_NOMEM; goto err_ret0; }

	rp->port   = port;
	rp->mypri  = pri;
	rp->cardid = (cardslot != 0) ? 0 : -1;
	rp->cardslot = cardslot - 1;
	rp->rires  = True;  /* 忮ꥸ塼ͭ */

	/* ư */
	ctsk.exinf   = rp;
	ctsk.task    = rsMainTask;
	ctsk.itskpri = pri;
	ctsk.stksz   = 2048;
	ctsk.tskatr  = TA_HLNG|TA_RNG0;
	err = vcre_tsk(&ctsk);
	if ( err < E_OK ) { err = toERR(EC_INNER, err); goto err_ret1; }
	tskid = (ID)err;

	err = sta_tsk(tskid, (INT)rp);
	if ( err < E_OK ) { err = toERR(EC_INNER, err); goto err_ret2; }

	return tskid;

err_ret2:
	del_tsk(tskid);
err_ret1:
	Kfree((VB*)rp);
err_ret0:
	DEBUG_PRINT(("startRsDriver err = %d\n", err));
	return err;
}

/*
 * ѥ᡼Ф
 */
LOCAL ERR getParameter( TC *arg )
{
	while ( *arg != TNULL ) {

		if ( tc_isspace(*arg) ) {
			arg++;
			continue;
		}

		switch ( *arg++ ) {
		  case L'':	/* ͥ */
			taskPri = tc_strtol(arg, &arg, 0);
			break;

		  case L'':
			switch ( *arg++ ) {
			  case L'':	/* ɽԤ */
				cardParam.wait = tc_strtol(arg, &arg, 0);
				break;
			  default:
				return ER_PAR;
			}
			break;

		  default:
			return ER_PAR;
		}
	}

	return ER_OK;
}

/*
 *  RS ɥ饤
 */
EXPORT ERR main( Bool StartUp, TC *arg )
{
	W	port;
	ERR	err;
	W	v[L_DEVCONF_VAL];

	DO_DEBUG( _prLoadAddress(); )

	/* ɥ饤СϽλʤλ׵̵ */
	if ( !StartUp ) return ER_NOSPT;

	if ( arg != NULL ) {
		/* ѥ᡼Ф */
		err = getParameter(arg);
		if ( err < ER_OK ) return err;
	}

	/*  DEVCONF ͤμФ
		RSCARD_WAIT	wait_ms		Ԥ
		RSCARD_POWER	0 or 1		Ÿ (1 :  ON)
	*/
	if (GetDevConf("RSCARD_WAIT", v) > 0)
		cardParam.wait = v[0];
	if (GetDevConf("RSCARD_POWER", v) > 0)
		cardParam.power = (v[0] == 0) ? True : False;

	DEBUG_PRINT(("main: taskpri=%d, cardwait=%d, cardpower=%d\n",
				taskPri, cardParam.wait, cardParam.power));

#if	0
	/* ղõǽɥ饤Сεư */
	kpStartUp();
#endif

    {
	RsHwConf_16450	cnf;
	UW	iob, irq, dmy;
	W	empty_cnt, empty_map, cardslot, pcslot;

	/* ͭʥꥢݡȤФơǥХ˳դ */
	empty_map = empty_cnt = 0;
	for (port = 0; ; port++) {
		/* ꥢݡȤ HW ꥽μФ */
		if (getHwRes(HW_IO(HW_COM1 + port), &iob, &dmy, 1) <= 0 ||
		    getHwRes(HW_IRQ(HW_COM1 + port), &irq, &dmy, 1) <= 0) {
			iob = irq = 0;		/* ݡ	*/
		}
		/* ٥ɥ饤Ф */
		cnf.iobase = iob;
		cnf.iostep = (iob == 0) ? 0 : 1;
		cnf.intvec = INTVEC(irq);
		err = serial_ctl(port, DN_RS16450, (UW*)&cnf);
		if (err < ER_OK) break;			/*  */

DEBUG_PRINT(("port %d iob=%#x, irq=%d\n", port, iob, irq));

		/* ͭݡȤФ RS ɥ饤Τεư */
		if (iob != 0) {
			startRsDriver(port, taskPri, 0);
		} else {
			empty_map |= 1 << port;
			empty_cnt++;
		}
	}

	/* ͭ PC ɥåȤå */
	pcslot = 0;
	if (getHwRes(HW_IRQ(HW_PCSLT1), &irq, &dmy, 1) > 0) pcslot |= 0x1;
	if (getHwRes(HW_IRQ(HW_PCSLT2), &irq, &dmy, 1) > 0) pcslot |= 0x2;

	/* ݡȤФơPC ѤΥǥХս˳դ */
	cardslot = (empty_cnt > 1) ? 1 : 3;
	while (--port >= 0) {
		if ((empty_map & (1 << port)) == 0) continue;

		/* PC ɥåȤͭʾȤ */
		if ((pcslot & cardslot) == 0) continue;

		/* PC Ѥ RS ɥ饤СΤεư */
		startRsDriver(port, taskPri, cardslot);

DEBUG_PRINT(("port %d cardslot = %d\n", port, cardslot));

		if (++cardslot > 2) break;
	}
    }

	return ER_OK;
}
