/*
 *	@(#)rsdrv.h (rsdrv)
 *
 *	RS ɥ饤	
 *	(C) Copyright 1995-98 by Personal Media Corporation
 */

#define	DEBUG_MODULE	"(rsdrv)"

#include <basic.h>
#include <inner.h>
#include <bstdlib.h>
#include <errcode.h>
#include <driver/driver.h>
#include <driver/rs.h>
#include <driver/pcmcia.h>
#include <kernel/util.h>
#include <bsys/util.h>
#include <bsys/cons_io.h>
#include <bsys/cio_svc.h>
#include <util/debug.h>

#define	InvalidID	(0)		/* ̵ID */
#define	InvalidDevID	(-1)		/* ̵ǥХID */

/*
 * 顼ɴϢ
 */
#define	EC_MASK			(0xffff0000)
#define	ED_MASK			(0x0000ffff)
#define	toERR(class,detail)	((ERR)((class) << 16 | (UH)(detail)))

/*
 * ¾
 */
#define	max(a,b)	(( (a) > (b) )? (a): (b))
#define	min(a,b)	(( (a) < (b) )? (a): (b))
#define	SWAP(type,x,y)	{ type z = (x); (x) = (y); (y) = z; }

/* ------------------------------------------------------------------------ */

/*
 * RS ɥ饤С
 */
typedef struct {
	W	port;		/* ꥢݡֹ */
	PRI	mypri;		/* ͥ */
	ID	devID;		/* ǥХ ID */
	ID	acceptPort;	/* ǥХ׵դѥǥ֥ݡ */
	ID	cardid;		/*  ID
				 *	< 0	PC ɤǤʤݡ
				 *	= 0	PC ̤
				 *	> 0	PC ɻ (ID)
				 */
	ID	mapid;		/*  ޥå ID */
	W	cardslot;	/* ɥåֹ
				 *	>= 0	ꥹå(0-3)
				 *	< 0	Ǥեå
				 */
	FastLock hwlock;	/* ϡɥ¾ */

	Bool	opened:1;	/* ץ True */
	Bool	suspended:1;	/* ڥɴ True */
	Bool	rires:1;	/* 忮ꥸ塼ͭΤȤ True */

	DevReq	*devReq;	/* ¹׵ (ܡоݤȤʤ׵) */

	/* ɥե졼 */
	UW	CCR_adr;	/* CCR ١ɥ쥹 */
	UB	CCR_msk;	/* CCR ¸ߥޥ */
	UB	CCR[2];		/* CCR  */

	/* ° */
	UW	snd_tmout;	/* ॢ (ms) */
	UW	rcv_tmout;	/* ॢ (ms) */

#if	0
	/* ղõǽɥ饤С */
	RsAddIn	addin;		/* ղõǽ */
	KpInfo	kpinfo;		/* KB/PD ɥ饤СϢξ */
#endif
} RsInfo;

/*
 * RS ɥ饤Сإ뤿Υ١ݥ
 *	RS ɥ饤СϡƱ쥳ɤ򥷥ꥢݡʣȤƼ¹
 *	뤿ꥨȥȤǤʤФʤʤäơƥꥢݡ
 *	˶ͭǡ RsInfo ˤ٤ƼᡢΥ١ݥ󥿤ˤ
 *	ꥢ롣Υ١ݥ󥿤ϥγĥ(exinf)Ȥ¸
 *	Ƥ롣
 *	̾١ݥ󥿤ϳƴؿΰȤƽ˼Ϥ뤬GetRsInfo()
 *	ˤľ뤳ȤǽǤ롣
 */
Inline RsInfo* GetRsInfo( ID tskid )
{
	T_RTSK	rtsk;
	ref_tsk(&rtsk, tskid);
	return (RsInfo*)rtsk.exinf;
}

/* ------------------------------------------------------------------------ */

/*
 * RS ɥ饤 PC 润̥ѥ᡼
 */
typedef struct {
	UW	wait;		/* PC ɽԤ (msec)	*/
	Bool	power:1;	/* PC Ÿ			*/
} CardParam;
IMPORT CardParam	cardParam;

/*
 * PC ɡǥեȽԤ (msec)
 */
#define	DefaultCardWait		500

/*
 * PC ɡǥեŸ
 */
#define	DefaultCardPower	True

/*
 * RS ɥ饤Сǥեȥͥ
 */
#define	DefaultPriority		25

/*
 * ǥХ׵դѥ
 */
#define	NormalReqPtn	D_NORM_PTN	/* ̾׵ */
#define	SpecificReqPtn	D_ABORT_PTN	/* ü׵ */

IMPORT WERR CheckDataCnt( DevReq *devReq, W datasz);
IMPORT ERR rsAcceptDeviceRequest( RsInfo *rsInfo, UW reqptn );

IMPORT ERR rsGetCardInfo( RsInfo *rsInfo, DevReq *devReq );
IMPORT ERR rsCardSuspend( RsInfo *rsInfo, Bool close );
IMPORT ERR rsCardResume( RsInfo *rsInfo, Bool open );
IMPORT ERR rsCardEvent( RsInfo *rsInfo, DevRsp *devRsp, DevReq *devReq );
