/*
	bctype.h	ʸ饹إå

	(C) Copyright 1995-99 by Personal Media Corporation
*/

#ifndef	__CTYPE_H__
#define __CTYPE_H__
#ifdef __cplusplus
extern "C" {
#endif

#define _U_	01
#define _L_	02
#define _N_	04
#define _S_	010
#define _P_	020
#define _C_	040
#define _X_	0100
#define _B_	0200

extern int	isalnum(int);
extern int	isalpha(int);
extern int	iscntrl(int);
extern int	isdigit(int);
extern int	isgraph(int);
extern int	islower(int);
extern int	isprint(int);
extern int	ispunct(int);
extern int	isspace(int);
extern int	isupper(int);
extern int	isxdigit(int);
extern int	tolower(int);
extern int	toupper(int);

extern int	isascii(int);
extern int	toascii(int);

extern	const	unsigned char	_bctype_[];

#define isalnum(c)	((_bctype_+1)[(c)&0377]&(_U_|_L_|_N_))
#define isalpha(c)	((_bctype_+1)[(c)&0377]&(_U_|_L_))
#define iscntrl(c)	((_bctype_+1)[(c)&0377]&_C_)
#define isdigit(c)	((_bctype_+1)[(c)&0377]&_N_)
#define isgraph(c)	((_bctype_+1)[(c)&0377]&(_P_|_U_|_L_|_N_))
#define islower(c)	((_bctype_+1)[(c)&0377]&_L_)
#define isprint(c)	((_bctype_+1)[(c)&0377]&(_P_|_U_|_L_|_N_|_B_))
#define ispunct(c)	((_bctype_+1)[(c)&0377]&_P_)
#define isspace(c)	((_bctype_+1)[(c)&0377]&_S_)
#define isupper(c)	((_bctype_+1)[(c)&0377]&_U_)
#define isxdigit(c)	((_bctype_+1)[(c)&0377]&_X_)
#define tolower(c)	((_bctype_+258)[(c)&0377])
#define toupper(c)	((_bctype_+515)[(c)&0377])

#define isascii(c)	(!((c)&~0177))
#define toascii(c)	((c)&0177)
#define _tolower(c)	tolower (c)
#define _toupper(c)	toupper (c)

#ifdef __cplusplus
}
#endif
#endif /* __CTYPE_H__ */
