/*
 *	@(#)bmath.h 00-10-21
 *
 *	ͱ黻饤֥إå
 *	(C) Copyright 1995-2000 by Personal Media Corporation
 */

#ifndef _BMATH_H_
#define _BMATH_H_

#ifdef __cplusplus
extern "C" {
#endif

#if 1
#include <berrno.h>
#else
/*
 * Error return values.
 */
#define EBON	0		/* Succesful */
#define	EDOM	10		/* Domain error */
#define	ERANGE	11		/* Result too large */
#define	EINVAL	12

/*
 * Status from routines.
 */
extern	int	errno;
#endif

/*
 * 
 */
#define	FLT_RADIX	( 2 )
#define	FLT_ROUNDS	( 1 )	/* ͼθ */

#define	FLT_DIG		( 6 )
#define	FLT_EPSILON	( 1.19209290e-07F )
#define	FLT_MANT_DIG	( 24 )
#define	FLT_MAX		( 3.40282347e+38F )
#define	FLT_MAX_EXP	( 128 )
#define	FLT_MAX_10_EXP	( 38 )
#define	FLT_MIN		( 1.17549435e-38F )
#define	FLT_MIN_EXP	( -125 )
#define	FLT_MIN_10_EXP	( -37 )

#define	DBL_DIG		( 15 )
#define	DBL_EPSILON	( 2.2204460492503131e-16 )
#define	DBL_MANT_DIG	( 53 )
#define	DBL_MAX		( 1.7976931348623157e+308 )
#define	DBL_MAX_EXP	( 1024 )
#define	DBL_MAX_10_EXP	( 308 )
#define	DBL_MIN		( 2.2250738585072014e-308 )
#define	DBL_MIN_EXP	( -1021 )
#define	DBL_MIN_10_EXP	( -307 )

#define	LDBL_DIG	DBL_DIG
#define	LDBL_EPSILON	DBL_EPSILON
#define	LDBL_MANT_DIG	DBL_MANT_DIG
#define	LDBL_MAX	DBL_MAX
#define	LDBL_MAX_EXP	DBL_MAX_EXP
#define	LDBL_MAX_10_EXP	DBL_MAX_10_EXP
#define	LDBL_MIN	DBL_MIN
#define	LDBL_MIN_EXP	DBL_MIN_EXP
#define	LDBL_MIN_10_EXP	DBL_MIN_10_EXP

#define	HUGE_VAL	( __infinity() )

/*
 * Function definitions.
 */
extern	double	__infinity();
extern	double	acos(double);
extern	double	asin(double);
extern	double	atan(double);
extern	double	atan2(double, double);
/* extern	double	cabs(); */
extern	double	ceil(double);
extern	double	cos(double);
extern	double	cosh(double);
extern	double	exp(double);
extern	double	fabs(double);
extern	double	floor(double);
/* extern	double	flt(); */
extern	double	frexp(double, int *);
extern	double	hypot(double, double);
extern	double	j0(double);
extern	double	j1(double);
extern	double	jn(int, double);
extern	double	ldexp(double, int);
extern	double	log(double);
extern	double	log10(double);
extern	double	modf(double, double*);
extern	double	pow(double, double);
extern	double	sin(double);
extern	double	sinh(double);
extern	double	sqrt(double);
extern	double	tan(double);
extern	double	tanh(double);

#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*
 * 
 */
#define	PI		( 3.14159265358979323846 )
#define	SQRT2		( 1.41421356237309504880 )
#define	LOG2B10		( 0.30102999566398119e+00 )
#define	LOG10BE		( 0.23025850929940456e+01 )
#define	LOG10B2		( 0.33219280948873623e+01 )
#define	LOGEB2		( 1.4426950408889634074 )

/*
 * TRON ĥʬ
 */
extern	double	tc_atof(TC *tc);
extern	double	tc_strtod(TC *tc, TC **ptr);

#ifdef __cplusplus
}
#endif

#endif
