/*
	bstdio.h	ɸɣإå

	(C) Copyright 1995-2000 by Personal Media Corporation
*/

#ifdef UNIX

#include	<stdio.h>

#else

#ifndef	_STDIO_H_
#define	_STDIO_H_

#include	"bstdarg.h"

#ifdef __cplusplus
extern "C" {
#endif

/*	ANSI 
			FILE, fpos_t
ޥ		_IOFBF, _IOLBF, _IONBF, BUFSIZ, EOF,
			FILENAME_MAX, FOPEN_MAX, TMP_MAX, L_tmpnam,
			SEEK_CUR, SEEK_END, SEEK_SET,
			stderr, stdin, stdout
顼		clearerr, feof, ferror, perror
ե륢	fclose, fflush, fopen, freopen, setbuf, setvbuf
ե		remove, rename, tmpfile, tmpnam
եֻꡧ	fgetpos, fseek, fsetpos, ftell, rewind
ʸϡ		fgetc, fgets, fputs, fputs, getc, getchar, gets,
			putc, putchar, puts, ungetc
ľϡ		fread, fwrite
եޥå:	fprintf, fscanf, printf, scanf, sprintf, sscanf,
			vfprintf, vprintf, vsprintf
*/

/* ʲΤߥݡ */

#define	EOF	(-1)

/* ٥ʸ */
extern	int	_GetChar(void);
extern	int	_PutChar(int c);
extern	int	_GetString(char *s);
extern	int	_PutString(char *s);

/* ʸ */
#define	getchar()	_GetChar()
#define	putchar(c)	_PutChar(c)
extern	char	*gets(char *s);
extern	int	puts(char *s);

/* եޥåȽ */
extern	int	printf(const char *format, ...);
extern	int	sprintf(char *sp, const char *format, ...);
extern	int	vprintf(const char *format, va_list ap);
extern	int	vsprintf(char *buf, const char *format, va_list ap);

/* 顼 */
extern	void	panic(const char *prompt);
extern	void	perror(const char *prompt);

#ifdef __cplusplus
}
#endif
#endif	/* _STDIO_H_ */

#endif
