/*
	bstdlib.h	ɸå饤֥إå

	(C) Copyright 1995-2000 by Personal Media Corporation
*/

#ifndef	_STDLIB_H_
#define	_STDLIB_H_

#ifndef UNIX

#include "bstddef.h"

#ifdef __cplusplus
extern "C" {
#endif

/*  */
typedef	struct {
	int	quot, rem;
} div_t;

typedef	struct {
	long	quot, rem;
} ldiv_t;

/* ̤ݡȥޥ
	#define EXIT_FAILURE
	#define EXIT_SUCCESS
	#define MB_CUR_MAX
	#define MB_CUR_MAX
	#define RAND_MAX
*/

/* ץཪλ */
extern	void	exit(int status);
extern	void	abort(void);
extern	int	atexit(void (*func)(void));

/* 黻 */
#ifdef __cplusplus
inline int		abs(int n)	{ return ( n >= 0 )? n: -n; }
inline long		labs(long n)	{ return ( n >= 0 )? n: -n; }
#else
static __inline__ int	abs(int n)	{ return ( n >= 0 )? n: -n; }
static __inline__ long	labs(long n)	{ return ( n >= 0 )? n: -n; }
#endif
extern	div_t	div(int num, int den);
extern	ldiv_t	ldiv(long int num, long int den);

/* ʸѴ */
extern	int	atoi(const char *str);
extern	long	atol(const char *str);
extern	long	strtol(const char *str, char **tail, int base);

#define	strtoul(s,p,b)	(unsigned long)strtol((s),(p),(b))
extern	double	atof(const char *str);
extern	double	strtod(const char *str, char **tail);

#ifndef BKERNEL

/*  */
extern	void *	calloc(size_t nmemb, size_t size);
extern	void	free(void *ptr);
extern	void *	malloc(size_t size);
extern	void *	realloc(void *ptr, size_t size);

/* malloc debug ѡ
	mode = 0	̾⡼
	mode = 1	ǥХå⡼
	mode = -1	Ѿ
	mode = -2	Ѿܺ٥	*/
extern	void	malloctest(int mode);
extern	Bool	malloccheck(void *ptr);

/* ͭ꡼ (ANSIͳ) */
extern	void *	Scalloc(size_t nmemb, size_t size);
extern	void	Sfree(void *ptr);
extern	void *	Smalloc(size_t size);
extern	void *	Srealloc(void *ptr, size_t size);
extern	void	Smalloctest(int mode);
extern	Bool	Smalloccheck(void *ptr);

#endif

/*  */
	/* ̤ݡȡ
	extern	char *	bsearch(const void *key, const void *base, size_t nmem,
		    size_t size, int (*compar)(const void *, const void *));
	extern	int	qsort(void *base, size_t nmemb, size_t size,
				int (*compar)(const void *, const void *));
	*/

/* ƥĶ */
	/* ̤ݡȡ
	extern	char *	getenv(const char *name);
	extern		system(const char *prog);
	*/

/*  */
#define	RAND_MAX	32767
extern	int	rand(void);
extern	void	srand(unsigned int seed);

/* Wide / Multi-byte ʸ */
	/* ̤ݡȡ
	#define mblen(s, n)	mbtowc((wchar_t *)0,(s),(n))
	extern	size_t mbstowcs(wchar_t *pwcs, const char *s, size_t n);
	extern	int    mbtowc(wchar_t *pwc, const char *s, size_t n);
	extern	int    wctomb(char *s, wchar_t wchar);
	extern	size_t wcstombs(char *s, const wchar_t *pwcs, size_t n);
	*/

#ifdef __cplusplus
}
#endif

#else	/* UNIX */

#include <stdlib.h>

#ifdef __cplusplus
extern "C" {
#endif

/*  */
typedef	struct {
	int	quot, rem;
} div_t;

typedef	struct {
	long	quot, rem;
} ldiv_t;

/* 黻 */
extern	div_t	div(int num, int den);
extern	ldiv_t	ldiv(long int num, long int den);

#ifdef __cplusplus
}
#endif

#endif	/* UNIX */

#endif	/* _STDLIB_H_ */
