/*
	bitop.h		ӥå (inline)

	(C) Copyright 1995-97 by Personal Media Corporation
*/
#ifndef	__BITOP_H__
#define	__BITOP_H__
#ifdef __cplusplus
extern "C" {
#endif

/*
	ӥåȤΥꥢ:		base + offset ӥå
*/
Inline	VOID	BCLR(VP base, W offset)
{
	((UB*)base)[offset >> 3] &= ~(0x80 >> (offset & 7));
}

/*
	ӥåȤΥåȡ	base  + offset ӥå
*/
Inline	void	BSET(VP base, W offset)
{
	((UB*)base)[offset >> 3] |= (0x80 >> (offset & 7));
}

/*
	ӥåȤȿž		base  + offset ӥå
*/
Inline	void	BNOT(VP base, W offset)
{
	((UB*)base)[offset >> 3] ^= (0x80 >> (offset & 7));
}

/*
	ӥåȤΥƥȡ	base  + offset ӥå
*/
Inline	W	BTST(VP base, W offset)
{
	return ((UB*)base)[offset >> 3] & (0x80 >> (offset & 7));
}

/*
	ӥåȣΥ	base  + offset ӥå  bitwidth ʬ
*/
Inline	W	BVSCH0(VP base, W offset, W bitwidth)
{
	W	i;

	for (i = offset; i < offset + bitwidth; i++) {
		if ( BTST(base, i) == 0 ) return i - offset;
	}
	return -1;
}

/*
	ӥåȣΥ	base  + offset ӥå  bitwidth ʬ
*/
Inline	W	BVSCH1(VP base, W offset, W bitwidth)
{
	W	i;

	for (i = offset; i < offset + bitwidth; i++) {
		if ( BTST(base, i) != 0 ) return i - offset;
	}
	return -1;
}

/*
	ӥåΥꥢ:	base + offset ӥå  bitwidth
*/
Inline	VOID	BVCLR(VP base, W offset, W bitwidth)
{
	while (--bitwidth >= 0) {
		BCLR(base, offset++);
	}
}

/*
	ӥåΥåȡ	base  + offset ӥå  bitwidth
*/
Inline	void	BVSET(VP base, W offset, W bitwidth)
{
	while (--bitwidth >= 0) {
		BSET(base, offset++);
	}
}

#ifdef __cplusplus
}
#endif
#endif	/*__BITOP_H__*/
