/*
	cons_io.h	󥽡ɣ

	(C) Copyright 1995-2001 by Personal Media Corporation
*/
#ifndef	__CONS_IO_H__
#define	__CONS_IO_H__
#ifdef __cplusplus
extern "C" {
#endif

/*
	󥽡ɡ
*/
#ifndef __STDIO_H__
extern  int     _GetChar(void);
extern  int     _PutChar(int c);
extern  int     _GetString(char *s);
extern  int     _PutString(char *s);
#endif
extern	int     cons_ioctl(int req, int arg);

/*
	ңӥݡȣɡ
*/
extern	int     RS_putchar(int c);
extern	int     RS_getchar();
extern	int     RS_ioctl(int req, int arg);

/*
	ü쥳󥽡ɡϡʥХåեϡե졼
*/
extern	W	cons_put(W port, B *buf, UW len, W tmout);
extern	W	cons_get(W port, B *buf, UW len, W tmout);
extern	W	cons_conf(W req, UW *arg);

/*
	cons_ioctl() ꥯȥ
*/
#define GETCTL		0x100	/* Ф
				   INIT ʳȤ OR Ǹߤͤؿ
				   ȤƼФ(GETCTL | ECHO), etc */

#define ECHO		1	/* ̵ͭ (0:̵1:ͭ)		*/
#define INPUT		2	/* ϥ⡼ (RAW, etc)		*/
#define NEWLINE 	3	/* LF  CR, LF Ѵ
					(0:Ѵʤ,1: Ѵ)	*/
#define FLOWC		4	/* ե (0: ̵, IXON, etc)	*/

#define SNDTMO		0x81	/* ॢ(ߥ) -1: ʤ	*/
#define RCVTMO		0x82	/* ॢ(ߥ) -1: ʤ	*/

#define	RCVBUFSZ	0x83	/* ϥХåեGET Τ		*/
#define	SNDBUFSZ	0x84	/* ϥХåեGET Τ		*/

/* ϥ⡼ */
#define RAW		1	/* ʸĤ			*/
#define CANONICAL	3	/* ϡCR  LF Ѵ)		*/
#define EDIT		5	/* Խ				*/

/* ե */
#define	IXON		0x01	/* XON/XOFF ϥե		*/
#define IXANY		0x02	/* IXON ǤʸμǽϤƳ  */
#define IXOFF		0x04	/* XON/XOFF ϥե		*/

/*
	cons_conf() ꥯȥ
*/
#define	CS_CREATE	0x11	/* 󥽡ݡȤ		*/
				/* arg[0] = ݡֹ		    OUT	*/
				/* arg[1] = ե졼    IN	*/
				/* arg[2] = ϥХåե	    IN	*/
				/* arg[3] = ϥХåե	    IN	*/

#define	CS_DELETE	0x12	/* 󥽡ݡȤκ		*/
				/* arg[0] = ݡֹ		    IN	*/

#define	CS_SETCONF	0x13	/* 󥽡빽			*/
				/* arg[0] = ݡֹ		    IN	*/
				/* arg[1] = ե졼    IN	*/
				/* arg[2] = ϥХåե	    IN	*/
				/* arg[3] = ϥХåե	    IN	*/

#define	CS_GETCONF	0x14	/* 󥽡빽μФ		*/
				/* arg[0] = ݡֹ		    IN	*/
				/* arg[1] = ե졼    OUT	*/
				/* arg[2] = ϥХåե	    OUT	*/
				/* arg[3] = ϥХåե	    OUT */

#define	CS_GETPORT	0x21	/* ɸॳ󥽡ݡȤμФ	*/
				/* arg[0] = ݡֹ		    OUT	*/

#define	CS_SETPORT	0x22	/* ɸॳ󥽡ݡȤ		*/
				/* arg[0] = ݡֹ		    IN	*/

#define	CS_SRCHPORT	0x23	/* 󥽡ݡȤΥ		*/
				/* arg[0] = ݡֹ		 IN/OUT	*/
				/* arg[1] = ե졼    IN	*/

/* ե졼 */
#define	CONF_SERIAL_0	(0)	/* ꥢݡȡ			*/
#define	CONF_SERIAL(n)	(n)	/* ꥢݡȡ			*/
#define	CONF_SELF	(-1)	/* ե󥽡			*/
#define	CONF_BUFIO	(-2)	/* Хåեɣ				*/

/*
	serial_ctl() ꥯȥ
*/
typedef enum {
	RS_ABORT	= 0,
	RS_SUSPEND	= -200,
	RS_RESUME	= -201,
	RS_RCVBUFSZ	= -202,
	RS_LINECTL	= -203,

	RS_EXTFUNC	= -9999	/* () ͳü쵡ǽ */
} SerialControlNo;

/*  ON/OFF ѥ᡼ */
#define	RSCTL_DTR	0x00000001	/* DTR  */
#define	RSCTL_RTS	0x00000002	/* RTS  */
#define	RSCTL_SET	0x00000000	/*  */
#define	RSCTL_ON	0xc0000000	/* 꿮 ON */
#define	RSCTL_OFF	0x80000000	/* 꿮 OFF */

#ifdef __cplusplus
}
#endif
#endif	/*__CONS_IO_H__*/
