/*
 *	@(#)memalloc.h (libker/libmain) 01-10-12
 *
 *	꡼ƥ饤֥
 *	(C) Copyright 1995-2001 by Personal Media Corporation
 *
 *	malloc,Smalloc,Kmalloc,Vmalloc 
 */

#ifndef _SYS_MEMALLOC_H_
#define _SYS_MEMALLOC_H_

#include <bsys/queue.h>

#ifdef __cplusplus
extern "C" {
#endif

/*
 * ꡼ƴ
 *	&areaque ΰ֤Хñ̤˥饤Ȥ줿ɥ쥹Ǥʤ
 *	ʤʤ(̣ӥåȤǤʤФʤʤ)
 *	ΤΥɥ쥹ԤΰȤ nouse Ѥ롣nouse 
 *	񤭹ळȤϽʤ
 */
typedef struct MemoryAllocateControlBlock {
	const QUEUE	nouse;		/* 饤ȹ碌Τΰ */

	/* ݤڡʬ䤷ΰ³륨ꥢ塼
	   ڡǤϥɥ쥹ξ¤֡ڡ֤ϽƱȤʤ롣 */
	QUEUE		areaque;
	/* ݤڡ̤Ѥΰ³ե꡼塼
	   ΰΥ¤٤롣 */
	QUEUE		freeque;

	UW		pagesz;		/* ڡ (Хȿ) */
	UW		mematr;		/* ꡼° */
	int		testmode;	/* ƥȥ⡼ */
} MACB;

/*
 * &areaque ΰ֤򣸥Хȶ˥饤Ȥ뤿
 */
#define	AlignMACB(macb)		( (MACB*)((UW)macb & ~7) )

extern ERR   _mem_init( UW mematr, MACB *macb );
extern void* _mem_malloc( size_t size, MACB *macb );
extern void* _mem_calloc( size_t nmemb, size_t size, MACB *macb );
extern void* _mem_realloc( void *ptr, size_t size, MACB *macb );
extern void  _mem_free( void *ptr, MACB *macb );
extern void  _mem_malloctest( int mode, MACB *macb );
extern Bool  _mem_malloccheck( void *ptr, MACB *macb );

/*
 * ץꡧǾե饰ȥ
 *	sizeof(QUEUE) * 2 ʾΥǤʤФʤʤ
 */
extern size_t _mem_minfragment;

#ifdef __cplusplus
}
#endif
#endif
