/*
	queue.h		塼inline)

	(C) Copyright 1995-96 by Personal Media Corporation
*/
#ifndef	__QUEUE_H__
#define	__QUEUE_H__
#ifdef __cplusplus
extern "C" {
#endif

/*
	塼ι¤ GMICRO Υ塼̿᤬
		֥󥯥塼ʥ󥰡
*/
typedef struct queue {
	struct	queue	*next;
	struct	queue	*prev;
} QUEUE;

/*
	塼Υå
*/
Inline	Bool	isQueEmpty(QUEUE *que)
{
	return que->next == que ? True : False;
}

/*
	塼ν
*/
Inline	VOID	QueInit(QUEUE *que)
{
	que->prev = que->next = que;
}

/*
	塼ؤΥȥ
		que ľ(que λľƱ) entry 
*/
Inline	VOID	QueInsert(QUEUE *entry, QUEUE *que)
{
	entry->prev = que->prev;
	entry->next = que;
	que->prev->next = entry;
	que->prev = entry;
}

/*
	塼Υȥ:
		entry 򥭥塼entry ()λϤʤˤ⤷ʤ
*/
Inline	VOID	QueRemove(QUEUE *entry)
{
	if (entry->next != entry) {
		entry->prev->next = entry->next;
		entry->next->prev = entry->prev;
	}
}

/*
	塼ƬΥȥФ
		que ľΥȥ򥭥塼ȥ᤹
		que ()λ NULL ᤹
*/
Inline QUEUE	*QueRemoveNext(QUEUE *que)
{
	QUEUE	*entry;

	if (que->next == que) return (QUEUE*)0;
	entry = que->next;
	que->next = entry->next;
	entry->next->prev = que;
	return entry;
}

/*
	塼ȥΥţ
		start->next 顢end->prev ޤǡoffset ֤  val 
		ȥ򥵡ơΥȥ᤹
		start  end Υȥϥоݤ˴ޤޤʤ
		륨ȥ꤬ʤ end ᤹
*/
Inline	QUEUE	*QueSearch(QUEUE *start, QUEUE *end, W val, W offset)
{
	QUEUE	*que;

	for (que = start->next; que != end; que = que->next) {
		if (*((W *)(((VB *)que) + offset)) == val) break;
	}
	return que;
}

Inline	QUEUE	*QueSearchH(QUEUE *start, QUEUE *end, H val, W offset)
{
	QUEUE	*que;

	for (que = start->next; que != end; que = que->next) {
		if (*((H *)(((VB *)que) + offset)) == val) break;
	}
	return que;
}

/*
	塼ȥΥ Σ
		start->next 顢end->prev ޤǡoffset ֤  val 
		ȥ򥵡ơΥȥ᤹
		start  end Υȥϥоݤ˴ޤޤʤ
		륨ȥ꤬ʤ end ᤹
*/
Inline	QUEUE	*QueSearchNE(QUEUE *start, QUEUE *end, W val, W offset)
{
	QUEUE	*que;

	for (que = start->next; que != end; que = que->next) {
		if (*((W *)(((VB *)que) + offset)) != val) break;
	}
	return que;
}

Inline	QUEUE	*QueSearchNEH(QUEUE *start, QUEUE *end, H val, W offset)
{
	QUEUE	*que;

	for (que = start->next; que != end; que = que->next) {
		if (*((H *)(((VB *)que) + offset)) != val) break;
	}
	return que;
}

/*
	塼ȥΥ ǣ
*/
Inline	QUEUE	*QueSearchGE(QUEUE *start, QUEUE *end, W val, W offset)
{
	QUEUE	*que;

	for (que = start->next; que != end; que = que->next) {
		if (*((W *)(((VB *)que) + offset)) >= val) break;
	}
	return que;
}

/*
	塼ȥΥ ǣţ
*/
Inline	QUEUE	*QueSearchGEU(QUEUE *start, QUEUE *end, W val, W offset)
{
	QUEUE	*que;

	for (que = start->next; que != end; que = que->next) {
		if (*((UW *)(((VB *)que) + offset)) >= (UW)val) break;
	}
	return que;
}


/*
	塼ȥΥ ң̣ԣ
*/
Inline	QUEUE	*QueSearchRevLTU(QUEUE *start, QUEUE *end, W val, W offset)
{
	QUEUE	*que;

	for (que = start->prev; que != end; que = que->prev) {
		if (*((UW *)(((VB *)que) + offset)) < (UW)val) break;
	}
	return que;
}

#ifdef __cplusplus
}
#endif
#endif	/*__QUEUE_H__*/
